/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.sonogram;

import edu.geophys.commons.ui.sonogram.AbstractSonogramComponent;
import edu.geophys.commons.ui.sonogram.ArraySonogramModel;
import edu.geophys.commons.util.LogUtil;
import java.awt.image.BufferedImage;

public class JStationSonogram
extends AbstractSonogramComponent {
    private static final long serialVersionUID = 3881994964333318427L;
    private ArraySonogramModel arraySonogramModel;

    public final ArraySonogramModel getModel() {
        return this.arraySonogramModel;
    }

    public final void setModel(ArraySonogramModel arraySonogramModel) {
        if (arraySonogramModel != null && arraySonogramModel.isHealthy()) {
            if (this.arraySonogramModel != arraySonogramModel) {
                this.arraySonogramModel = arraySonogramModel;
                this.setRenderedSonogramModel(new AbstractSonogramComponent.RenderedSonogramModel(this.arraySonogramModel, this.renderSonogram()));
            }
        } else {
            this.arraySonogramModel = null;
        }
    }

    private final BufferedImage renderSonogram() {
        if (this.arraySonogramModel.getTimeWidth() <= 0 || this.arraySonogramModel.getFrequencyWidth() <= 0) {
            LogUtil.error(this.getClass(), "Sonogram width (" + this.arraySonogramModel.getTimeWidth() + ") and height (" + this.arraySonogramModel.getFrequencyWidth() + ") cannot be <= 0", false);
            return new BufferedImage(1, 1, 1);
        }
        BufferedImage bufferedImage = new BufferedImage(this.arraySonogramModel.getTimeWidth() * 2, this.arraySonogramModel.getFrequencyWidth() * 2, 1);
        int n = 0;
        int n2 = 0;
        while (n < this.arraySonogramModel.getTimeWidth()) {
            int n3 = 0;
            int n4 = 0;
            while (n3 < this.arraySonogramModel.getFrequencyWidth()) {
                bufferedImage.setRGB(n2, n4, this.getRGBForValue(this.arraySonogramModel.getWest().getValue(n, n3)));
                bufferedImage.setRGB(n2 + 1, n4, this.getRGBForValue(this.arraySonogramModel.getNorth().getValue(n, n3)));
                bufferedImage.setRGB(n2, n4 + 1, this.getRGBForValue(this.arraySonogramModel.getCenter().getValue(n, n3)));
                bufferedImage.setRGB(n2 + 1, n4 + 1, this.getRGBForValue(this.arraySonogramModel.getEast().getValue(n, n3)));
                ++n3;
                n4 += 2;
            }
            ++n;
            n2 += 2;
        }
        return bufferedImage;
    }
}

