/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.trace;

import edu.geophys.commons.ui.AbstractTraceRenderer;
import edu.geophys.commons.ui.Algorithms;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

@Deprecated
public class PlotRenderer
extends AbstractTraceRenderer {
    private boolean positivePlot = false;
    private boolean splineInterpolation = false;
    private Color _foregroundColor = Color.BLACK;
    private Color _NaNForegroundColor = Color.RED;
    private Color _axisColor = Color.LIGHT_GRAY;
    private Color _NaNBackgroundColor = new Color(0xF0C0C0);
    private Stroke _middleAxisStroke = new BasicStroke(1.0f, 1, 1, 1.0f);
    private Stroke _plotStroke = new BasicStroke(1.0f, 0, 2);
    protected static int INITIAL_BUFFER_LENGTH = 2000;
    private double externalScale = 1.0;
    boolean[] _nanBuffer = new boolean[INITIAL_BUFFER_LENGTH];
    float[] _minBuffer = new float[INITIAL_BUFFER_LENGTH];
    float[] _maxBuffer = new float[INITIAL_BUFFER_LENGTH];
    private double _yScale;
    public int _bufferLength;

    public PlotRenderer() {
    }

    public PlotRenderer(boolean bl) {
        this.positivePlot = bl;
    }

    public PlotRenderer(boolean bl, boolean bl2) {
        this.positivePlot = bl;
        this.splineInterpolation = bl2;
    }

    @Override
    public void revalidate() {
        if (this.isInvalid()) {
            this._fillBuffer();
        }
        super.revalidate();
    }

    @Override
    public void setPaintingArea(Rectangle2D rectangle2D) {
        super.setPaintingArea(rectangle2D);
        this._yScale = !this.positivePlot ? Math.floor((double)(this._height - 1) / 2.0) : (double)(this._height - 1);
        if (this._bufferLength != this._width) {
            if (this._bufferLength < this._width) {
                this._nanBuffer = new boolean[this._width];
                this._minBuffer = new float[this._width];
                this._maxBuffer = new float[this._width];
            }
            this._bufferLength = this._width;
            this.invalidate();
        }
    }

    public final Color getAxisColor() {
        return this._axisColor;
    }

    public final void setAxisColor(Color color) {
        this._axisColor = color;
    }

    public final Color getForegroundColor() {
        return this._foregroundColor;
    }

    public final void setForegroundColor(Color color) {
        this._foregroundColor = color;
    }

    public final Color getNaNBackgroundColor() {
        return this._NaNBackgroundColor;
    }

    public final void setNaNBackgroundColor(Color color) {
        this._NaNBackgroundColor = color;
    }

    public final Color getNaNForegroundColor() {
        return this._NaNForegroundColor;
    }

    public final void setNaNForegroundColor(Color color) {
        this._NaNForegroundColor = color;
    }

    public final void setExternalScale(double d) {
        this.externalScale = d;
    }

    public final double getExternalScale() {
        return this.externalScale;
    }

    void _fillBuffer() {
        if (this._seismogram.length > 0) {
            Algorithms.MinMax(this._seismogram, this._startSample, this._endSample, this._bufferLength, this._maxBuffer, this._minBuffer, this._nanBuffer, this.splineInterpolation);
        }
    }

    @Override
    protected void _draw(Graphics2D graphics2D) {
        if (this._seismogram == null || this._seismogram.length == 0) {
            graphics2D.setColor(this._NaNForegroundColor);
            graphics2D.fillRect(this._minX, this._minY, this._width, this._height);
            graphics2D.setColor(this._foregroundColor);
            return;
        }
        this.revalidate();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setStroke(this._plotStroke);
        if (this._axisColor != null) {
            graphics2D.setColor(this._axisColor);
            graphics2D.setStroke(this._middleAxisStroke);
            graphics2D.drawLine(0, (int)this._yScale, this._width, (int)this._yScale);
            graphics2D.setStroke(this._plotStroke);
        }
        graphics2D.setColor(this._foregroundColor);
        graphics2D.translate(0.0, this._yScale);
        this._drawPlot(graphics2D);
        graphics2D.translate(0.0, -this._yScale);
        graphics2D.setColor(this._NaNForegroundColor);
        this._drawPlotNaN(graphics2D);
        graphics2D.setComposite(AlphaComposite.DstOver);
        graphics2D.setColor(this._NaNBackgroundColor);
        this._drawPlotNaN(graphics2D);
    }

    private void _drawPlot(Graphics2D graphics2D) {
        Line2D.Float float_ = new Line2D.Float();
        double d = -this._yScale * this.externalScale;
        for (int i = 0; i < this._bufferLength; ++i) {
            int n = (int)Math.rint((double)this._maxBuffer[i] * d);
            int n2 = (int)Math.rint((double)this._minBuffer[i] * d);
            float_.setLine(i, n, i, n2);
            graphics2D.draw(float_);
        }
    }

    private void _drawPlotNaN(Graphics2D graphics2D) {
        int n = -1;
        for (int i = 0; i < this._bufferLength; ++i) {
            if (this._nanBuffer[i] && n == -1) {
                n = i;
                continue;
            }
            if (this._nanBuffer[i] || n == -1) continue;
            graphics2D.fillRect(n, 0, i - n, this._height);
            n = -1;
        }
        if (n != -1) {
            graphics2D.fillRect(n, 0, this._bufferLength - n, this._height);
        }
    }
}

