/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.CoordinateTransform;
import org.osgeo.proj4j.CoordinateTransformFactory;
import org.osgeo.proj4j.ProjCoordinate;

public class CoordinateUtil {
    private static final double conversionFactor = 111.3199;
    private static final CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();
    private static final CRSFactory csFactory = new CRSFactory();
    private static final double RAD = Math.PI / 180;

    public static AbsoluteResult convertRelativeToAbsolute(double d, double d2, double d3, double d4) {
        CoordinateReferenceSystem coordinateReferenceSystem = csFactory.createFromParameters("WGS84", "+title=long/lat:WGS84 +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees");
        int n = CoordinateUtil.getUtmZoneFromLatLon(d, d2);
        String string = "+title=long/lat:UTM +proj=utm +zone=" + n + " +ellps=WGS84 +datum=WGS84 +units=km +no_defs";
        if (d < 0.0) {
            string = string + " +south";
        }
        CoordinateReferenceSystem coordinateReferenceSystem2 = csFactory.createFromParameters("UTM", string);
        CoordinateTransform coordinateTransform = ctFactory.createTransform(coordinateReferenceSystem, coordinateReferenceSystem2);
        CoordinateTransform coordinateTransform2 = ctFactory.createTransform(coordinateReferenceSystem2, coordinateReferenceSystem);
        ProjCoordinate projCoordinate = new ProjCoordinate(d2, d);
        ProjCoordinate projCoordinate2 = new ProjCoordinate();
        coordinateTransform.transform(projCoordinate, projCoordinate2);
        projCoordinate2.x += d3;
        projCoordinate2.y += d4;
        ProjCoordinate projCoordinate3 = new ProjCoordinate();
        coordinateTransform2.transform(projCoordinate2, projCoordinate3);
        return new AbsoluteResult(projCoordinate3.y, projCoordinate3.x);
    }

    public static double kmToLat(double d) {
        return d / 111.3199;
    }

    public static double degToKm(double d) {
        return d * 111.3199;
    }

    public static double kmToLon(double d, double d2) {
        double d3 = StrictMath.cos(d2 * (Math.PI / 180));
        return d / (111.3199 * d3);
    }

    public static RelativeResult convertAbsoluteToRelative(double d, double d2, double d3, double d4) {
        int n;
        CoordinateReferenceSystem coordinateReferenceSystem = csFactory.createFromParameters("WGS84", "+title=long/lat:WGS84 +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees");
        int n2 = CoordinateUtil.getUtmZoneFromLatLon(d, d2);
        if (n2 != (n = CoordinateUtil.getUtmZoneFromLatLon(d3, d4))) {
            LogUtil.warn(CoordinateUtil.class, "Calculating relative offset of two WGS coordinates in different UTM zones can lead to large errors!");
        }
        String string = "+title=long/lat:UTM +proj=utm +zone=" + n2 + " +ellps=WGS84 +datum=WGS84 +units=km +no_defs";
        if (d < 0.0) {
            string = string + " +south";
        }
        CoordinateReferenceSystem coordinateReferenceSystem2 = csFactory.createFromParameters("UTM", string);
        CoordinateTransform coordinateTransform = ctFactory.createTransform(coordinateReferenceSystem, coordinateReferenceSystem2);
        ProjCoordinate projCoordinate = new ProjCoordinate(d2, d);
        ProjCoordinate projCoordinate2 = new ProjCoordinate(d4, d3);
        ProjCoordinate projCoordinate3 = new ProjCoordinate();
        ProjCoordinate projCoordinate4 = new ProjCoordinate();
        coordinateTransform.transform(projCoordinate, projCoordinate3);
        coordinateTransform.transform(projCoordinate2, projCoordinate4);
        double d5 = projCoordinate4.x - projCoordinate3.x;
        double d6 = projCoordinate4.y - projCoordinate3.y;
        return new RelativeResult(d5, d6);
    }

    public static RelativeResult convertBackazimuthToRelative(double d, double d2, double d3, double d4) {
        double d5 = d2 * StrictMath.sin(d / 180.0 * Math.PI);
        double d6 = d2 * StrictMath.cos(d / 180.0 * Math.PI);
        return new RelativeResult(d5 += d3, d6 += d4);
    }

    public static BackazimuthResult convertRelativeToBackazimuth(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = StrictMath.sqrt(d5 * d5 + d6 * d6);
        double d8 = (1.5707963267948966 - Math.atan2(d6, d5)) * 180.0 / Math.PI;
        return new BackazimuthResult(d8, d7);
    }

    public static RelativeResult convertLatLonToUTM(double d, double d2) {
        int n = CoordinateUtil.getUtmZoneFromLatLon(d, d2);
        return CoordinateUtil.convertLatLonToUTM(d, d2, n);
    }

    public static RelativeResult convertLatLonToUTM(double d, double d2, int n) {
        CoordinateReferenceSystem coordinateReferenceSystem = csFactory.createFromParameters("WGS84", "+title=long/lat:WGS84 +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees");
        String string = "+title=long/lat:UTM +proj=utm +zone=" + n + " +ellps=WGS84 +datum=WGS84 +units=m +no_defs";
        if (d < 0.0) {
            string = string + " +south";
        }
        CoordinateReferenceSystem coordinateReferenceSystem2 = csFactory.createFromParameters("UTM", string);
        CoordinateTransform coordinateTransform = ctFactory.createTransform(coordinateReferenceSystem, coordinateReferenceSystem2);
        ProjCoordinate projCoordinate = new ProjCoordinate(d2, d);
        ProjCoordinate projCoordinate2 = new ProjCoordinate();
        coordinateTransform.transform(projCoordinate, projCoordinate2);
        return new RelativeResult(projCoordinate2.x, projCoordinate2.y);
    }

    public static int getUtmZoneFromLatLon(double d, double d2) {
        int n = (int)Math.floor((d2 + 180.0) / 6.0) + 1;
        if (d >= 56.0 && d < 64.0 && d2 >= 3.0 && d2 < 12.0) {
            n = 32;
        }
        if (d >= 72.0 && d < 84.0) {
            if (d2 >= 0.0 && d2 < 9.0) {
                n = 31;
            } else if (d2 >= 9.0 && d2 < 21.0) {
                n = 33;
            } else if (d2 >= 21.0 && d2 < 33.0) {
                n = 35;
            } else if (d2 >= 33.0 && d2 < 42.0) {
                n = 37;
            }
        }
        return n;
    }

    @Deprecated
    public static double getKmHaversine(double d, double d2, double d3, double d4) {
        double d5 = 6371.0;
        double d6 = Math.toRadians(d3 - d);
        double d7 = Math.toRadians(d4 - d2);
        d = Math.toRadians(d);
        d3 = Math.toRadians(d3);
        double d8 = Math.sin(d6 / 2.0) * Math.sin(d6 / 2.0) + Math.sin(d7 / 2.0) * Math.sin(d7 / 2.0) * Math.cos(d) * Math.cos(d3);
        double d9 = 2.0 * Math.atan2(Math.sqrt(d8), Math.sqrt(1.0 - d8));
        double d10 = d5 * d9;
        return d10;
    }

    public static AbsoluteResult shoot(double d, double d2, double d3, double d4) {
        double d5 = d2 * Math.PI / 180.0;
        double d6 = d * Math.PI / 180.0;
        double d7 = d4 / 1.852;
        double d8 = d3 * Math.PI / 180.0;
        double d9 = 5.0E-11;
        if (Math.abs(Math.cos(d5)) < d9 && !(Math.abs(Math.sin(d8)) < d9)) {
            System.out.println("Only N-S courses are meaningful, starting at a pole!");
        }
        double d10 = 3443.914686825054;
        double d11 = 0.0033528106647474805;
        double d12 = 1.0 - d11;
        double d13 = d12 * Math.tan(d5);
        double d14 = Math.sin(d8);
        double d15 = Math.cos(d8);
        double d16 = d15 == 0.0 ? 0.0 : 2.0 * Math.atan2(d13, d15);
        double d17 = 1.0 / Math.sqrt(1.0 + d13 * d13);
        double d18 = d13 * d17;
        double d19 = d17 * d14;
        double d20 = 1.0 - d19 * d19;
        double d21 = 1.0 + Math.sqrt(1.0 + d20 * (1.0 / (d12 * d12) - 1.0));
        d21 = (d21 - 2.0) / d21;
        double d22 = 1.0 - d21;
        d22 = (d21 * d21 / 4.0 + 1.0) / d22;
        double d23 = (0.375 * d21 * d21 - 1.0) * d21;
        double d24 = d13 = d7 / (d12 * d10 * d22);
        d22 = d24 + 1.0;
        double d25 = 0.0;
        double d26 = 0.0;
        double d27 = 0.0;
        double d28 = 0.0;
        while (Math.abs(d24 - d22) > d9) {
            d25 = Math.sin(d24);
            d26 = Math.cos(d24);
            d27 = Math.cos(d16 + d24);
            d28 = 2.0 * d27 * d27 - 1.0;
            d22 = d24;
            d21 = d28 * d26;
            d24 = d28 + d28 - 1.0;
            d24 = (((d25 * d25 * 4.0 - 3.0) * d24 * d27 * d23 / 6.0 + d21) * d23 / 4.0 - d27) * d25 * d23 + d13;
        }
        d16 = d17 * d26 * d15 - d18 * d25;
        d22 = d12 * Math.sqrt(d19 * d19 + d16 * d16);
        d23 = d18 * d26 + d17 * d25 * d15;
        double d29 = (Math.atan2(d23, d22) + Math.PI) % (Math.PI * 2) - Math.PI;
        d22 = d17 * d26 - d18 * d25 * d15;
        d21 = Math.atan2(d25 * d14, d22);
        d22 = ((-3.0 * d20 + 4.0) * d11 + 4.0) * d20 * d11 / 16.0;
        d23 = ((d28 * d26 * d22 + d27) * d25 * d22 + d24) * d19;
        double d30 = (d6 + d21 - (1.0 - d22) * d23 * d11 + Math.PI) % (Math.PI * 2) - Math.PI;
        double d31 = (Math.atan2(d19, d16) + Math.PI) % (Math.PI * 2);
        d31 *= 57.29577951308232;
        AbsoluteResult absoluteResult = new AbsoluteResult(d29 *= 57.29577951308232, d30 *= 57.29577951308232);
        return absoluteResult;
    }

    @Deprecated
    public static AbsoluteResult convertRelativeToAbsoluteOld(double d, double d2, double d3, double d4) {
        double d5 = StrictMath.cos(d * (Math.PI / 180));
        double d6 = d + d4 / 111.3199;
        double d7 = d2 + d3 / (111.3199 * d5);
        if (d7 > 180.0) {
            d7 -= 360.0;
        }
        if (d7 <= -180.0) {
            d7 += 360.0;
        }
        return new AbsoluteResult(d6, d7);
    }

    @Deprecated
    public static RelativeResult convertAbsoluteToRelativeOld(double d, double d2, double d3, double d4) {
        double d5 = StrictMath.cos((d + d3) / 2.0 * (Math.PI / 180));
        double d6 = (d4 - d2) * (111.3199 * d5);
        double d7 = (d3 - d) * 111.3199;
        return new RelativeResult(d6, d7);
    }

    public static class AbsoluteResult {
        public final double latitude;
        public final double longitude;

        public AbsoluteResult(double d, double d2) {
            this.latitude = d;
            this.longitude = d2;
        }

        public String toString() {
            return "Lat: " + this.latitude + " Lon: " + this.longitude;
        }
    }

    public static class RelativeResult {
        public final double xOffset;
        public final double yOffset;

        public RelativeResult(double d, double d2) {
            this.xOffset = d;
            this.yOffset = d2;
        }

        public String toString() {
            return "X: " + this.xOffset + " Y: " + this.yOffset;
        }
    }

    public static class BackazimuthResult {
        public double backazimuth;
        public double distance;

        private BackazimuthResult(double d, double d2) {
            this.backazimuth = d;
            this.distance = d2;
        }

        public String toString() {
            return "Bazi: " + MathUtil.format2Digits(this.backazimuth) + " dist: " + MathUtil.format2Digits(this.distance);
        }
    }
}

