/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CsvReader {
    private String separator = "\\s*,\\s*|\\s+";
    private String quote = "\"|'";
    private String comment = "#|//";
    private boolean trimFields = true;
    private Pattern pattern;
    private Pattern quotePattern;

    private void compilePattern() {
        this.pattern = !this.quote.isEmpty() ? Pattern.compile("(" + this.separator + ")|(" + this.quote + ")") : Pattern.compile(this.separator);
        this.quotePattern = Pattern.compile(this.quote);
    }

    public String[] parse(String string) {
        if (this.pattern == null) {
            this.compilePattern();
        }
        String string2 = !this.getComment().isEmpty() ? string.split(this.comment, 2)[0] : string;
        Matcher matcher = this.pattern.matcher(string2);
        class MatchResult {
            public String match;
            public int start;
            public int end;

            public MatchResult(Matcher matcher) {
                this.match = matcher.group();
                this.start = matcher.start();
                this.end = matcher.end();
            }
        }
        ArrayList<MatchResult> arrayList = new ArrayList<MatchResult>();
        while (matcher.find()) {
            arrayList.add(new MatchResult(matcher));
        }
        ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>();
        int n = 0;
        String string3 = null;
        Object object = "";
        for (MatchResult matchResult : arrayList) {
            if (!this.quote.isEmpty() && this.quotePattern.matcher(matchResult.match).matches()) {
                if (string3 == null) {
                    string3 = matchResult.match;
                    object = (String)object + string2.substring(n, matchResult.start);
                    n = matchResult.end;
                } else if (string3.equals(matchResult.match)) {
                    string3 = null;
                    object = (String)object + string2.substring(n, matchResult.start);
                    n = matchResult.end;
                    continue;
                }
            }
            if (string3 == null) {
                arrayList2.add((CallSite)((Object)((String)object + string2.substring(n, matchResult.start))));
                object = "";
                n = matchResult.end;
                continue;
            }
            object = (String)object + string2.substring(n, matchResult.end);
            n = matchResult.end;
        }
        if (string3 != null) {
            arrayList2.add((CallSite)((Object)((String)object + string2.substring(n))));
        }
        String[] stringArray = arrayList2.toArray(new String[0]);
        if (this.isTrimFields()) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        return stringArray;
    }

    public String parseComment(String string) {
        if (this.getComment().isEmpty()) {
            return "";
        }
        String[] stringArray = string.split(this.comment, 2);
        String string2 = stringArray.length > 1 ? stringArray[1] : "";
        return this.isTrimFields() ? string2.trim() : string2;
    }

    public boolean isTrimFields() {
        return this.trimFields;
    }

    public void setTrimFields(boolean bl) {
        this.trimFields = bl;
        this.pattern = null;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        this.separator = string;
        this.pattern = null;
    }

    public String getQuote() {
        return this.quote;
    }

    public void setQuote(String string) {
        this.quote = string;
        this.pattern = null;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
        this.pattern = null;
    }
}

