/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import edu.geophys.commons.model.tracefiles.AbstractTraceFile;
import edu.geophys.commons.model.tracefiles.TraceFileMetadata;
import edu.geophys.commons.model.tracefiles.converters.HeaderLine;
import edu.geophys.commons.model.tracefiles.converters.MiniSeedToCSS;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

public final class DynamicHeaderEntryUtil {
    static final MiniSeedToCSS miniseedReader = new MiniSeedToCSS();
    private static HashMap<String, SimpleDateFormat> identifiers = new HashMap();

    public static final File firstMatch(File file) {
        Object var1_1 = null;
        String string = file.getAbsolutePath();
        for (String arrayList2 : identifiers.keySet()) {
            string = string.split(arrayList2)[0];
        }
        string = string.substring(0, string.lastIndexOf(File.separator));
        Object object = file.getAbsolutePath();
        for (String string2 : identifiers.keySet()) {
            object = ((String)object).replace(string2, "*");
        }
        final ArrayList arrayList = new ArrayList();
        try {
            final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + (String)object);
            SimpleFileVisitor<Path> simpleFileVisitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path path2 = path.toAbsolutePath();
                    if (pathMatcher.matches(path2)) {
                        arrayList.add(path2.toFile());
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            Files.walkFileTree(Paths.get(string, new String[0]), (FileVisitor<? super Path>)simpleFileVisitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return (File)arrayList.get(0);
    }

    public static final AbstractTraceFile firstMatch(AbstractTraceFile abstractTraceFile) {
        File file = DynamicHeaderEntryUtil.firstMatch(abstractTraceFile.getTraceDataFile());
        List<HeaderLine> list = miniseedReader.probeFile(file);
        return DynamicHeaderEntryUtil.createEntry(abstractTraceFile, list.get(0));
    }

    public static final List<AbstractTraceFile> defineFullEntries(AbstractTraceFile abstractTraceFile, double d, double d2) {
        int n;
        LinkedList<AbstractTraceFile> linkedList = new LinkedList<AbstractTraceFile>();
        Calendar calendar = DateTimeUtil.epochToCalendar(d);
        TraceFileMetadata.DynamicEntryType dynamicEntryType = abstractTraceFile.getDynamic();
        switch (dynamicEntryType) {
            case HOUR: {
                n = 3600000;
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case DAY: {
                n = 86400000;
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            default: {
                return linkedList;
            }
        }
        long l = DateTimeUtil.doubleSecondsToLongMilliseconds(d2);
        File file = abstractTraceFile.getTraceDataFile();
        for (long i = DateTimeUtil.doubleSecondsToLongMilliseconds(DateTimeUtil.calendarToEpoch(calendar)); i <= l; i += (long)n) {
            String string = file.getAbsolutePath();
            for (String string2 : identifiers.keySet()) {
                SimpleDateFormat simpleDateFormat = identifiers.get(string2);
                string = string.replace(string2, simpleDateFormat.format(i));
            }
            File file2 = new File(string);
            if (!file2.exists()) continue;
            List<HeaderLine> list = miniseedReader.probeFile(file2);
            for (HeaderLine headerLine : list) {
                linkedList.add(DynamicHeaderEntryUtil.createEntry(abstractTraceFile, headerLine));
            }
        }
        return linkedList;
    }

    private static final AbstractTraceFile createEntry(AbstractTraceFile abstractTraceFile, HeaderLine headerLine) {
        TraceFileMetadata traceFileMetadata = new TraceFileMetadata();
        File file = Paths.get(headerLine.getDirectory(), headerLine.getFilename()).toAbsolutePath().toFile();
        traceFileMetadata.setStationName(abstractTraceFile.getStationName());
        traceFileMetadata.setStationChannel(abstractTraceFile.getStationChannel());
        traceFileMetadata.setStartEpochTime(headerLine.getEpoch());
        traceFileMetadata.setLength((int)headerLine.getNsamp());
        traceFileMetadata.setSamplerate(headerLine.getSamprate());
        traceFileMetadata.setCalibration(abstractTraceFile.getCalibration());
        traceFileMetadata.setOriginalSamplerate(traceFileMetadata.getSamplerate());
        traceFileMetadata.setOriginalLength(traceFileMetadata.getLength());
        traceFileMetadata.setTraceDataFile(file);
        traceFileMetadata.setByteOffset(headerLine.getByteOffset());
        try {
            traceFileMetadata.setDataType(headerLine.getDattyp());
        }
        catch (Exception exception) {
            LogUtil.error(DynamicHeaderEntryUtil.class, "Problem reading header file: " + exception.getMessage());
            exception.printStackTrace();
        }
        return traceFileMetadata.createNativeFileInstance();
    }

    static {
        identifiers.put("%Y", new SimpleDateFormat("yyyy"));
        identifiers.put("%y", new SimpleDateFormat("yy"));
        identifiers.put("%j", new SimpleDateFormat("DDD"));
        identifiers.put("%H", new SimpleDateFormat("HH"));
        for (SimpleDateFormat simpleDateFormat : identifiers.values()) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }
}

