/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import edu.geophys.commons.util.MathUtil;
import java.awt.geom.Point2D;
import obspy.FiltUtil;

public class LocalMagnitude {
    private float[] origSamples;
    private float dist;
    private float samprate;
    private float[] waSamples;
    private float ampmy;
    private float ml;
    private int maxPPPos = 0;
    private int minPPPos = 0;
    private static final float[] RANGE_LIMITS_KM = new float[]{3.0f, 100.0f};
    public static final float FL = 1.3f;

    public LocalMagnitude() {
    }

    public LocalMagnitude(float[] fArray, float f, float f2) {
        this.origSamples = fArray;
        this.dist = f2;
        this.samprate = f;
    }

    public void woodAnderson() {
        int n;
        this.waSamples = MathUtil.subMeanZeroNaN(this.origSamples);
        FiltUtil.spr_hp_fast_bworth((float[])this.waSamples, (int)this.waSamples.length, (float)(1.0f / this.samprate), (float)1.3f, (int)2, (boolean)false);
        for (n = 1; n < this.waSamples.length; ++n) {
            int n2 = n;
            this.waSamples[n2] = this.waSamples[n2] + this.waSamples[n - 1];
        }
        if (this.waSamples.length > 1) {
            this.waSamples[0] = this.waSamples[1];
        }
        n = 1;
        while (n < this.waSamples.length) {
            int n3 = n++;
            this.waSamples[n3] = this.waSamples[n3] / this.samprate;
        }
    }

    public float calcMlPPSI(Point2D.Double double_) {
        return this.calcMl((float)(double_.x * 0.001), (float)(double_.y * 500000.0));
    }

    public float calcMlPPSI(double d, double d2) {
        return this.calcMl((float)(d * 0.001), (float)(d2 * 500000.0));
    }

    public float calcMl(float f, float f2) {
        this.ml = f < RANGE_LIMITS_KM[0] ? (float)(Math.log10(f2) + 1.0 * Math.log10(f) + 0.7) : (f < RANGE_LIMITS_KM[1] ? (float)(Math.log10(f2) + 1.5 * Math.log10(f) + 0.45) : (float)(Math.log10(f2) + 2.56 * Math.log10(f) - 1.67));
        this.ml = (float)Math.round(this.ml * 10.0f) / 10.0f;
        return this.ml;
    }

    public static void main(String[] stringArray) {
        LocalMagnitude localMagnitude = new LocalMagnitude();
        System.out.println(Math.log10(700.0) + 1.11 * Math.log10(100.0) + 0.189 - 2.09);
        System.out.println(Math.log10(0.7) + 2.76 * Math.log10(100.0) - 2.48);
        System.out.println(localMagnitude.calcMl(3.0f, 65.0f));
        System.out.println(localMagnitude.calcAmplitude(3.0f, 3.0f));
        System.out.println(localMagnitude.calcMl(99.9f, 0.7f));
        System.out.println(localMagnitude.calcAmplitude(99.9f, 3.0f));
        System.out.println(localMagnitude.calcMl(100.0f, 0.7f));
        System.out.println(localMagnitude.calcAmplitude(100.0f, 3.0f));
    }

    public double calcAmplitudePPSI(double d, float f) {
        return 2.0E-9 * (double)this.calcAmplitude((float)(d * 0.001), f);
    }

    public float calcAmplitude(float f, float f2) {
        float f3 = 0.0f;
        if (f2 < -9.8f || f < 1.0E-5f) {
            return -1.0f;
        }
        if (f < RANGE_LIMITS_KM[0]) {
            f3 = (float)Math.pow(10.0, f2 + 2.3f);
            f3 *= (float)Math.pow(f, -1.0);
        } else if (f < RANGE_LIMITS_KM[1]) {
            f3 = (float)Math.pow(10.0, f2 + 2.55f);
            f3 *= (float)Math.pow(f, -1.5);
        } else {
            f3 = (float)Math.pow(10.0, f2 + 4.67f);
            f3 *= (float)Math.pow(f, -2.56);
        }
        return f3;
    }

    public void peak2peak(float[] fArray) {
        if (fArray.length > 2) {
            boolean bl = fArray[2] >= fArray[1];
            float f = fArray[1];
            int n = 0;
            float f2 = fArray[1];
            int n2 = 0;
            float f3 = -3.4028235E38f;
            float[] fArray2 = new float[fArray.length];
            for (int i = 3; i < fArray.length; ++i) {
                float f4;
                if (bl && fArray[i] <= fArray[i - 1]) {
                    f = fArray[i - 1];
                    n = i - 1;
                    bl = false;
                    fArray2[i] = 100.0f;
                }
                if (!bl && fArray[i] >= fArray[i - 1]) {
                    f2 = fArray[i - 1];
                    n2 = i - 1;
                    bl = true;
                    fArray2[i] = -100.0f;
                }
                if (!((f4 = Math.abs(f - f2)) > f3)) continue;
                f3 = f4;
                this.maxPPPos = n;
                this.minPPPos = n2;
            }
            fArray2[this.maxPPPos] = 200.0f;
            fArray2[this.minPPPos] = -200.0f;
            this.ampmy = f3 / 1000.0f / 2.0f;
        }
    }

    public float getMl() {
        return this.ml;
    }

    public void setMl(float f) {
        this.ml = f;
    }

    public float getDist() {
        return this.dist;
    }

    public void setDist(float f) {
        this.dist = f;
    }

    public float[] getOrigSamples() {
        return this.origSamples;
    }

    public void setOrigSamples(float[] fArray) {
        this.origSamples = fArray;
    }

    public float[] getWaSamples() {
        return this.waSamples;
    }

    public void setWaSamples(float[] fArray) {
        this.waSamples = fArray;
    }

    public float getAmpmy() {
        return this.ampmy;
    }

    public void setAmpmy(float f) {
        this.ampmy = f;
    }

    public int getMaxPPPos() {
        return this.maxPPPos;
    }

    public void setMaxPPPos(int n) {
        this.maxPPPos = n;
    }

    public int getMinPPPos() {
        return this.minPPPos;
    }

    public void setMinPPPos(int n) {
        this.minPPPos = n;
    }

    public static float[] getRangeLimitsKm() {
        return RANGE_LIMITS_KM;
    }
}

