/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import Jama.SingularValueDecomposition;
import edu.geophys.commons.util.LogUtil;

public class PCACalc {
    private PcaMode pcaMode;
    private int numEigen;
    private double[][] pcs;
    private double[] evs;

    public PCACalc(PcaMode pcaMode, int n) {
        this.pcaMode = pcaMode;
        this.numEigen = n;
    }

    public void calcPCA(Matrix matrix) {
        int n = matrix.getRowDimension();
        switch (this.pcaMode) {
            default: {
                LogUtil.debug(PCACalc.class, "Doing SVD PCA");
                SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(matrix);
                Matrix matrix2 = singularValueDecomposition.getV();
                this.pcs = matrix2.getMatrix(0, matrix2.getRowDimension() - 1, 0, this.numEigen - 1).getArray();
                this.evs = singularValueDecomposition.getSingularValues();
                break;
            }
            case Normal: {
                LogUtil.debug(PCACalc.class, "Doing normal PCA");
                Matrix matrix3 = matrix.transpose().times(matrix).times(1.0 / (double)n);
                LogUtil.debug(PCACalc.class, "Cov: " + matrix3.getRowDimension() + " " + matrix3.getColumnDimension());
                EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix3);
                double[] dArray = eigenvalueDecomposition.getRealEigenvalues();
                double[][] dArray2 = eigenvalueDecomposition.getV().getArray();
                this.evs = dArray;
                this.dataSort(dArray, dArray2);
                double[][] dArray3 = new double[dArray2.length][dArray2[0].length];
                for (int i = 0; i < dArray2.length; ++i) {
                    for (int j = 0; j < dArray2[0].length; ++j) {
                        dArray3[i][dArray2[0].length - j - 1] = dArray2[i][j];
                    }
                }
                Matrix matrix4 = new Matrix(dArray3);
                this.pcs = matrix4.getMatrix(0, matrix4.getRowDimension() - 1, 0, this.numEigen - 1).getArray();
                break;
            }
            case Transposed: {
                int n2;
                int n3;
                LogUtil.debug(PCACalc.class, "Doing transposed PCA");
                Matrix matrix5 = matrix.times(matrix.transpose()).times(1.0 / (double)n);
                LogUtil.debug(PCACalc.class, "Cov: " + matrix5.getRowDimension() + " " + matrix5.getColumnDimension());
                EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix5);
                double[][] dArray = eigenvalueDecomposition.getV().getArray();
                double[] dArray4 = eigenvalueDecomposition.getRealEigenvalues();
                this.evs = dArray4;
                this.dataSort(dArray4, dArray);
                double[][] dArray5 = new double[dArray.length][dArray[0].length];
                for (int i = 0; i < dArray.length; ++i) {
                    for (int j = 0; j < dArray[0].length; ++j) {
                        dArray5[i][dArray[0].length - j - 1] = dArray[i][j];
                    }
                }
                Matrix matrix6 = matrix.transpose().times(new Matrix(dArray5));
                double[] dArray6 = new double[matrix6.getColumnDimension()];
                for (n3 = 0; n3 < matrix6.getColumnDimension(); ++n3) {
                    for (n2 = 0; n2 < matrix6.getRowDimension(); ++n2) {
                        int n4 = n3;
                        dArray6[n4] = dArray6[n4] + matrix6.get(n2, n3) * matrix6.get(n2, n3);
                    }
                    dArray6[n3] = Math.sqrt(dArray6[n3]);
                }
                for (n3 = 0; n3 < matrix6.getColumnDimension(); ++n3) {
                    for (n2 = 0; n2 < matrix6.getRowDimension(); ++n2) {
                        matrix6.set(n2, n3, matrix6.get(n2, n3) / dArray6[n3]);
                    }
                }
                this.pcs = matrix6.getMatrix(0, matrix6.getRowDimension() - 1, 0, this.numEigen - 1).getArray();
            }
        }
    }

    public void dataSort(double[] dArray, double[] ... dArray2) {
        if (dArray.length != dArray2[0].length) {
            throw new IllegalArgumentException("The group vector and rows of the covariate matrix must have the same length.");
        }
        for (int i = 1; i < dArray.length; ++i) {
            int n = i;
            while (dArray[n] < dArray[n - 1]) {
                double d = dArray[n];
                dArray[n] = dArray[n - 1];
                dArray[n - 1] = d;
                for (int j = 0; j < dArray2.length; ++j) {
                    d = dArray2[j][n];
                    dArray2[j][n] = dArray2[j][n - 1];
                    dArray2[j][n - 1] = d;
                }
                if (--n != 0) continue;
            }
        }
    }

    public double[][] getPcs() {
        return this.pcs;
    }

    public void setPcs(double[][] dArray) {
        this.pcs = dArray;
    }

    public double[] getEvs() {
        return this.evs;
    }

    public void setEvs(double[] dArray) {
        this.evs = dArray;
    }

    public static enum PcaMode {
        Normal,
        Transposed,
        SVD;

    }
}

