/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import Jama.Matrix;
import edu.geophys.commons.util.FileUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.commons.util.PCAHelper;

public class PolarizationAnalysis {
    private double rectilinearity;
    private double planarity;
    private double pAzimuth;
    private double pIncidence;
    private final int minSamplesForCut = 5;

    public PolarizationAnalysis(float[] fArray, float[] fArray2, float[] fArray3, float f) {
        this(fArray, fArray2, fArray3, f, false);
    }

    public PolarizationAnalysis(float[] fArray, float[] fArray2, float[] fArray3, float f, boolean bl) {
        Object[] objectArray;
        Object object;
        if (bl && fArray.length > 5) {
            int n = fArray.length;
            for (int i = 5; i < fArray.length; ++i) {
                if (Math.signum(fArray[i - 1]) == Math.signum(fArray[i])) continue;
                n = i;
                break;
            }
            object = new float[n];
            objectArray = new float[n];
            float[] fArray4 = new float[n];
            for (int i = 0; i < n; ++i) {
                object[i] = fArray[i];
                objectArray[i] = fArray2[i];
                fArray4[i] = fArray3[i];
            }
            fArray = object;
            fArray2 = objectArray;
            fArray3 = fArray4;
        }
        PCAHelper pCAHelper = new PCAHelper();
        pCAHelper.do3dPca(fArray, fArray2, fArray3);
        object = new Matrix(pCAHelper.getPcs()).transpose().getArray();
        objectArray = pCAHelper.getEvs();
        this.rectilinearity = 1.0 - (objectArray[1] + objectArray[0]) / (2.0 * objectArray[2]);
        this.planarity = 1.0 - 2.0 * objectArray[0] / (objectArray[2] + objectArray[1]);
        double d = Math.sqrt((double)(object[0][0] * object[0][0] + object[0][1] * object[0][1] + object[0][2] * object[0][2]));
        double[] dArray = new double[]{object[0][0] / d, object[0][1] / d, object[0][2] / d};
        double d2 = Math.signum(dArray[0]);
        this.pAzimuth = Math.atan2(dArray[1], dArray[2]);
        this.pAzimuth = Math.toDegrees(this.pAzimuth);
        this.pAzimuth = MathUtil.convertMathAngleToAzimuth(this.pAzimuth);
        if (d2 > 0.0) {
            this.pAzimuth += 180.0;
            this.pAzimuth %= 360.0;
        }
        this.pIncidence = 90.0 - Math.toDegrees(Math.acos(Math.abs(dArray[0])));
    }

    public double getRectilinearity() {
        return this.rectilinearity;
    }

    public double getPlanarity() {
        return this.planarity;
    }

    public double getpAzimuth() {
        return this.pAzimuth;
    }

    public double getpIncidence() {
        return this.pIncidence;
    }

    public static float[] getDisplacementFilter(float[] fArray, float f) {
        int n;
        float[] fArray2 = MathUtil.subMeanZeroNaN(fArray);
        for (n = 1; n < fArray2.length; ++n) {
            int n2 = n;
            fArray2[n2] = fArray2[n2] + fArray2[n - 1];
        }
        if (fArray2.length > 0) {
            fArray2[0] = 0.0f;
        }
        n = 1;
        while (n < fArray2.length) {
            int n3 = n++;
            fArray2[n3] = fArray2[n3] / f;
        }
        return fArray2;
    }

    public static double getAzimuth(double d, double d2) {
        double d3 = 90.0 - Math.atan2(d2, d) * 180.0 / Math.PI;
        if (d3 < 0.0) {
            d3 += 360.0;
        }
        return d3;
    }

    public static void main(String[] stringArray) {
        float[] fArray = FileUtil.getFloatSamplesFromASCII("/home/sick/geophys/knowbases/PISCO_3comp/knowbase/pattern/19940214005039600-zoom_trace_A04-HHZ.dat", 0);
        float[] fArray2 = FileUtil.getFloatSamplesFromASCII("/home/sick/geophys/knowbases/PISCO_3comp/knowbase/pattern/19940214005039600-zoom_trace_A04-HHE.dat", 0);
        float[] fArray3 = FileUtil.getFloatSamplesFromASCII("/home/sick/geophys/knowbases/PISCO_3comp/knowbase/pattern/19940214005039600-zoom_trace_A04-HHN.dat", 0);
        PolarizationAnalysis polarizationAnalysis = new PolarizationAnalysis(fArray, fArray3, fArray2, 100.0f);
        System.out.println(polarizationAnalysis.getRectilinearity());
        System.out.println(polarizationAnalysis.getPlanarity());
    }
}

