/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JComponent;

public class PrintUtils {
    public static void exportBufferedImageAsPDF(BufferedImage bufferedImage, File file) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        try {
            Document document = new Document(new Rectangle((float)n, (float)n2));
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            PdfTemplate pdfTemplate = pdfContentByte.createTemplate((float)n, (float)n2);
            Graphics2D graphics2D = pdfTemplate.createGraphics((float)n, (float)n2);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
            document.close();
            pdfWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }

    public static void exportJComponentAsPDF(JComponent jComponent, File file, Dimension dimension) {
        jComponent.setSize(dimension);
        jComponent.addNotify();
        jComponent.validate();
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        try {
            Document document = new Document(new Rectangle((float)n, (float)n2));
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            PdfTemplate pdfTemplate = pdfContentByte.createTemplate((float)n, (float)n2);
            Graphics2D graphics2D = pdfTemplate.createGraphics((float)n, (float)n2);
            jComponent.paint(graphics2D);
            graphics2D.dispose();
            pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
            document.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }
}

