/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.PlatformUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.MessageDigest;

public class ProjectDirectories {
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final int HASH_CUTOFF = 12;
    private static final String USER_RO_DIRECTORY_NAME = "ro_projects";
    private static final String EXPORTS_DIRECTORY_NAME = "Exports";
    private final ProjectMode mode;
    private final File headerDirectory;
    private final File workingDirectory;
    private final File exportsDirectory;

    public ProjectDirectories(File file) {
        this.headerDirectory = PlatformUtil.getSafeCanonicalPath(file.getParentFile());
        this.mode = ProjectDirectories.chooseModeForHeader(this.headerDirectory);
        switch (this.mode) {
            case DEFAULT: {
                this.workingDirectory = this.headerDirectory;
                break;
            }
            case RO: {
                this.workingDirectory = new File(PlatformUtil.getUserConfPath() + PlatformUtil.getSeparator() + USER_RO_DIRECTORY_NAME + PlatformUtil.getSeparator() + ProjectDirectories.determineProjectDirnameRO(this.headerDirectory));
                break;
            }
            default: {
                this.workingDirectory = this.headerDirectory;
            }
        }
        this.exportsDirectory = new File(this.workingDirectory, EXPORTS_DIRECTORY_NAME);
        PlatformUtil.initializeDirectory(this.headerDirectory);
        PlatformUtil.initializeDirectory(this.workingDirectory);
        PlatformUtil.initializeDirectory(this.exportsDirectory);
    }

    private static ProjectMode chooseModeForHeader(File file) {
        File file2;
        if (Files.exists(Paths.get(file.getAbsolutePath(), "DEBUG_FORCE_RO"), new LinkOption[0])) {
            LogUtil.warn(ProjectDirectories.class, "DEBUG_FORCE_RO exists in header directory. Force read only mode!");
            return ProjectMode.RO;
        }
        File file3 = PlatformUtil.getApplicationDir();
        String string = file3.getAbsolutePath();
        for (file2 = PlatformUtil.getSafeCanonicalPath(file); file2 != null && !string.contentEquals(file2.getAbsolutePath()); file2 = file2.getParentFile()) {
        }
        if (file2 != null) {
            return ProjectMode.RO;
        }
        return ProjectMode.DEFAULT;
    }

    private static String determineProjectDirnameRO(File file) {
        Object object;
        block3: {
            String string = file.getAbsolutePath().replaceAll("[^a-zA-Z0-9]+", "&");
            object = "";
            try {
                byte[] byArray;
                MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
                for (byte by : byArray = messageDigest.digest(string.getBytes(StandardCharsets.UTF_8))) {
                    object = (String)object + String.format("%02x", by);
                }
                object = ((String)object).substring(0, 12);
            }
            catch (Exception exception) {
                object = file.getAbsolutePath().replaceAll("[^a-zA-Z0-9]+", "_");
                if (((String)object).length() <= 12) break block3;
                object = ((String)object).substring(((String)object).length() - 12);
            }
        }
        return file.getName() + "." + (String)object;
    }

    public File getHeaderDirectory() {
        return this.headerDirectory;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public File getExportsDirectory() {
        return this.exportsDirectory;
    }

    public ProjectMode getMode() {
        return this.mode;
    }

    public File getDocumentationFile() {
        for (File file : this.getHeaderDirectory().listFiles()) {
            if (!file.getName().toLowerCase().matches(".*doc.*\\.pdf")) continue;
            return file;
        }
        return null;
    }

    public static enum ProjectMode {
        DEFAULT,
        RO;

    }
}

