/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import java.util.Arrays;

public class ScaleCalc {
    private static final double[] SNAP = new double[]{1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 7.5, 10.0};

    public static float getRoundedScale(float f) {
        if (f > Float.MIN_VALUE && f < Float.MAX_VALUE) {
            double d;
            int n = 0;
            if (f > 1.0f) {
                while (Math.pow(10.0, n) < (double)f) {
                    ++n;
                }
                d = Math.ceil((double)f / Math.pow(10.0, n - 1)) * Math.pow(10.0, n - 1);
            } else {
                while (Math.pow(10.0, n) > (double)f) {
                    --n;
                }
                d = Math.ceil((double)f / Math.pow(10.0, n)) * Math.pow(10.0, n);
            }
            float f2 = (float)d;
            if (f2 <= Float.MIN_VALUE) {
                f2 = 1.0f;
            } else if (f2 >= Float.MAX_VALUE) {
                f2 = 1.0f;
            }
            return f2;
        }
        return -1.0f;
    }

    public static double mapScale(double d) {
        double d2;
        int n;
        if ((n = Arrays.binarySearch(SNAP, d /= (d2 = Math.pow(10.0, (int)Math.floor(Math.log10(d)))))) < 0 && (n ^= 0xFFFFFFFF) > 0) {
            --n;
        }
        d = SNAP[n] * d2;
        return d;
    }
}

