/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Outputs;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PierceTableModel
extends AbstractTableModel {
    private int selectedIndex = 0;
    private List<Arrival> arrivals = new ArrayList<Arrival>();

    @Override
    public int getRowCount() {
        if (this.arrivals.size() != 0) {
            return this.arrivals.get(this.selectedIndex).getNumPiercePoints();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                double dist = this.arrivals.get(this.selectedIndex).getPiercePoint(row).getDistDeg();
                if (this.arrivals.get(this.selectedIndex).getDistDeg() % 360.0 > 180.0 && dist != 0.0) {
                    dist *= -1.0;
                }
                return Outputs.formatDistance(dist);
            }
            case 1: {
                return Outputs.formatDepth(this.arrivals.get(this.selectedIndex).getPiercePoint(row).getDepth());
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Dist";
            }
            case 1: {
                return "Depth";
            }
        }
        return "";
    }

    public void setArrivals(List<Arrival> arrivals) {
        this.arrivals = arrivals;
        this.setSelectedIndex(0);
        this.fireTableDataChanged();
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
        this.fireTableDataChanged();
    }
}

