/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Pierce;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.ToolRun;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class TauP_Path
extends TauP_Pierce {
    protected String mapWidthUnit = "i";
    protected float mapWidth = 6.0f;
    protected boolean gmtScript = false;
    protected boolean withTime = false;
    protected String psFile;
    protected float maxPathTime = Float.MAX_VALUE;
    protected static double maxPathInc = 1.0;
    public static final String SVG = "svg";

    protected TauP_Path() {
        this.setOutFileBase("taup_path");
    }

    public TauP_Path(TauModel tMod) throws TauModelException {
        super(tMod);
        this.setOutFileBase("taup_path");
    }

    public TauP_Path(String modelName) throws TauModelException {
        super(modelName);
        this.setOutFileBase("taup_path");
    }

    public TauP_Path(TauModel tMod, String outFileBase) throws TauModelException {
        super(tMod);
        this.setOutFileBase(outFileBase);
    }

    public TauP_Path(String modelName, String outFileBase) throws TauModelException {
        super(modelName);
        this.setOutFileBase(outFileBase);
    }

    @Override
    public String getOutFileExtension() {
        String extention = "gmt";
        if (this.outputFormat.equals(SVG)) {
            extention = SVG;
        }
        return extention;
    }

    public void setMapWidth(float mapWidth) {
        this.mapWidth = mapWidth;
    }

    public float getMapWidth() {
        return this.mapWidth;
    }

    public String getMapWidthUnit() {
        return this.mapWidthUnit;
    }

    public void setMapWidthUnit(String mapWidthUnit) {
        this.mapWidthUnit = mapWidthUnit;
    }

    public float getMaxPathTime() {
        return this.maxPathTime;
    }

    public void setMaxPathTime(float maxPathTime) {
        this.maxPathTime = maxPathTime;
    }

    public boolean isGmtScript() {
        return this.gmtScript;
    }

    public void setGmtScript(boolean gmtScript) {
        this.gmtScript = gmtScript;
    }

    public static double getMaxPathInc() {
        return maxPathInc;
    }

    public static void setMaxPathInc(double max) {
        maxPathInc = max;
    }

    @Override
    public void calculate(double degrees) throws TauModelException {
        super.calculate(degrees);
        for (Arrival arrival : this.getArrivals()) {
            arrival.getPath();
        }
    }

    @Override
    public void printResult(PrintWriter out) throws IOException {
        Arrival currArrival;
        int i;
        boolean doPrintTime;
        boolean bl = doPrintTime = this.withTime && !this.outputFormat.equals(SVG);
        if (this.gmtScript) {
            out.write("gmt psxy -P -R -K -O -JP -m -A >> " + this.psFile + " <<END\n");
        }
        double radiusOfEarth = this.getTauModelDepthCorrected().getRadiusOfEarth();
        for (i = 0; i < this.arrivals.size(); ++i) {
            currArrival = (Arrival)this.arrivals.get(i);
            if (this.outputFormat.equals("json")) {
                throw new RuntimeException("JSON output for TauP_Path not yet supported.");
            }
            if (this.outputFormat.equals(SVG)) {
                out.println("<!-- " + this.getCommentLine(currArrival));
                out.println(" -->");
                out.println("<polyline points=\"");
            } else {
                out.println(this.getCommentLine(currArrival));
            }
            boolean longWayRound = false;
            if (currArrival.getDistDeg() % 360.0 > 180.0) {
                longWayRound = true;
            }
            double calcTime = 0.0;
            double calcDist = 0.0;
            TimeDist prevTimeDist = new TimeDist(0.0, 0.0, 0.0, 0.0);
            double calcDepth = currArrival.getSourceDepth();
            TimeDist[] path = currArrival.getPath();
            for (int j = 0; j < path.length; ++j) {
                if (path[j].getDistRadian() < prevTimeDist.getDistRadian()) {
                    throw new RuntimeException("ray path is backtracking, not possible: " + j + " (" + path[j] + ") < (" + prevTimeDist + ")");
                }
                calcTime = path[j].getTime();
                double prevDepth = calcDepth = path[j].getDepth();
                calcDist = path[j].getDistDeg();
                if (calcTime > (double)this.maxPathTime) {
                    if (j == 0 || !(path[j - 1].getTime() < (double)this.maxPathTime)) break;
                    calcDist = TauP_Path.linearInterp(path[j - 1].getTime(), path[j - 1].getDistDeg(), path[j].getTime(), path[j].getDistDeg(), this.maxPathTime);
                    prevDepth = calcDepth = TauP_Path.linearInterp(path[j - 1].getTime(), path[j - 1].getDepth(), path[j].getTime(), path[j].getDepth(), this.maxPathTime);
                    calcTime = this.maxPathTime;
                }
                if (longWayRound && calcDist != 0.0) {
                    calcDist = -1.0 * calcDist;
                }
                this.printDistRadius(out, calcDist, radiusOfEarth - calcDepth);
                if (doPrintTime) {
                    out.write("  " + Outputs.formatTime(calcTime));
                }
                if (!this.gmtScript && !this.outputFormat.equals(SVG)) {
                    this.printLatLon(out, calcDist);
                }
                out.write("\n");
                if (calcTime >= (double)this.maxPathTime) break;
                if (j < path.length - 1 && currArrival.getRayParam() != 0.0 && path[j + 1].getDistDeg() - path[j].getDistDeg() > maxPathInc) {
                    int maxInterpNum = (int)Math.ceil((path[j + 1].getDistDeg() - path[j].getDistDeg()) / maxPathInc);
                    for (int interpNum = 1; interpNum < maxInterpNum && calcTime < (double)this.maxPathTime && !((calcTime += (path[j + 1].getTime() - path[j].getTime()) / (double)maxInterpNum) > (double)this.maxPathTime); ++interpNum) {
                        calcDist = longWayRound ? (calcDist -= (path[j + 1].getDistDeg() - path[j].getDistDeg()) / (double)maxInterpNum) : (calcDist += (path[j + 1].getDistDeg() - path[j].getDistDeg()) / (double)maxInterpNum);
                        calcDepth = prevDepth + (double)interpNum * (path[j + 1].getDepth() - prevDepth) / (double)maxInterpNum;
                        this.printDistRadius(out, calcDist, radiusOfEarth - calcDepth);
                        if (doPrintTime) {
                            out.write("  " + Outputs.formatTime(calcTime));
                        }
                        if (!this.gmtScript && !this.outputFormat.equals(SVG)) {
                            this.printLatLon(out, calcDist);
                        }
                        out.write("\n");
                    }
                }
                prevDepth = path[j].getDepth();
            }
            if (!this.outputFormat.equals(SVG)) continue;
            out.println("\" />");
        }
        if (this.gmtScript) {
            out.write("END\n");
        }
        if (this.gmtScript) {
            out.write("gmt pstext -JP -P -R  -O -K >> " + this.psFile + " <<ENDLABELS\n");
        } else if (this.outputFormat.contentEquals(SVG)) {
            out.println("<g class=\"phasename\">");
        }
        if (this.gmtScript || this.outputFormat.contentEquals(SVG)) {
            for (i = 0; i < this.arrivals.size(); ++i) {
                currArrival = (Arrival)this.arrivals.get(i);
                TimeDist[] path = currArrival.getPath();
                int midSample = path.length / 2;
                double calcDepth = path[midSample].getDepth();
                double calcDist = path[midSample].getDistDeg();
                double radius = radiusOfEarth - calcDepth;
                if (this.gmtScript) {
                    this.printDistRadius(out, calcDist, radius);
                    out.write(" 10 0 0 9 " + currArrival.getName() + "\n");
                    continue;
                }
                if (!this.outputFormat.equals(SVG)) continue;
                double radian = (calcDist - 90.0) * Math.PI / 180.0;
                double x = radius * Math.cos(radian);
                double y = radius * Math.sin(radian);
                out.println("<text x=\"" + Outputs.formatDistance(x) + "\" y=\"" + Outputs.formatDistance(y) + "\">" + currArrival.getName() + "</text>");
            }
        }
        if (this.gmtScript) {
            out.write("ENDLABELS\n");
        } else if (this.outputFormat.contentEquals(SVG)) {
            out.println("</g> <!-- end labels -->");
        }
        if (this.gmtScript) {
            out.println("# end postscript");
            out.println("gmt psxy -P -R -O -JP -m -A -T  >> " + this.psFile);
            out.println("# convert ps to pdf, clean up .ps file");
            out.println("gmt psconvert -P -Tf  " + this.psFile + " && rm " + this.psFile);
            out.println("# clean up after gmt...");
            out.println("rm gmt.history");
        } else if (this.outputFormat.equals(SVG)) {
            out.println("</g> <!-- end translate -->");
            out.println("</svg>");
        }
    }

    protected void printDistRadius(Writer out, double calcDist, double radius) throws IOException {
        if (this.outputFormat.equals("json")) {
            throw new RuntimeException("JSON output for TauP_Path not yet supported.");
        }
        if (this.outputFormat.equals(SVG)) {
            double radian = (calcDist - 90.0) * Math.PI / 180.0;
            double x = radius * Math.cos(radian);
            double y = radius * Math.sin(radian);
            out.write(Outputs.formatDistance(x) + "  " + Outputs.formatDistance(y));
        } else {
            out.write(Outputs.formatDistance(calcDist) + "  " + Outputs.formatDepth(radius));
        }
    }

    protected void printLatLon(Writer out, double calcDist) throws IOException {
        if (this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE && this.azimuth != Double.MAX_VALUE) {
            double lat = SphericalCoords.latFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            double lon = SphericalCoords.lonFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            out.write("  " + Outputs.formatLatLon(lat) + "  " + Outputs.formatLatLon(lon));
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.backAzimuth != Double.MAX_VALUE) {
            double lat = SphericalCoords.latFor(this.stationLat, this.stationLon, this.degrees - calcDist, this.backAzimuth);
            double lon = SphericalCoords.lonFor(this.stationLat, this.stationLon, this.degrees - calcDist, this.backAzimuth);
            out.write("  " + Outputs.formatLatLon(lat) + "  " + Outputs.formatLatLon(lon));
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE) {
            this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
            this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
            double lat = SphericalCoords.latFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            double lon = SphericalCoords.lonFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            out.write("  " + Outputs.formatLatLon(lat) + "  " + Outputs.formatLatLon(lon));
        }
    }

    @Override
    public void printScriptBeginning(PrintWriter out) throws IOException {
        if (this.outputFormat.equals("json")) {
            throw new RuntimeException("JSON output for TauP_Path not yet supported.");
        }
        if (this.outputFormat.equals(SVG)) {
            this.printScriptBeginningSVG(out);
        } else if (this.gmtScript) {
            this.psFile = this.getOutFileBase().equals("stdout") ? "taup_path.ps" : (this.getOutFile().endsWith(".gmt") ? this.getOutFile().substring(0, this.getOutFile().length() - 4) + ".ps" : this.getOutFile() + ".ps");
            this.printScriptBeginning(out, this.psFile);
        } else {
            return;
        }
    }

    public void printScriptBeginningSVG(PrintWriter out) throws IOException {
        float R = (float)this.getTauModel().getRadiusOfEarth();
        float plotSize = R * 1.2f;
        int fontSize = (int)(plotSize / 20.0f);
        out.println("<svg version=\"1.1\" baseProfile=\"full\" xmlns=\"http://www.w3.org/2000/svg\" width=\"600\" height=\"600\" viewBox=\"0 0 " + 2.0f * plotSize + " " + 2.0f * plotSize + "\">");
        out.println("<!--\n This script will plot ray paths generated by TauP using SVG. -->");
        out.println("<defs>");
        out.println("    <style type=\"text/css\"><![CDATA[");
        out.println("        circle {");
        out.println("            vector-effect: non-scaling-stroke;");
        out.println("            stroke: grey;");
        out.println("            fill: none;");
        out.println("        }");
        out.println("        polyline {");
        out.println("            vector-effect: non-scaling-stroke;");
        out.println("            stroke: black;");
        out.println("            fill: none;");
        out.println("        }");
        out.println("        text.label {");
        out.println("            font: bold ;");
        out.println("            font-size: " + fontSize + "px;");
        out.println("            fill: black;");
        out.println("            fill: black;");
        out.println("        }");
        out.println("        g.phasename text {");
        out.println("            font: bold ;");
        out.println("            font-size: " + fontSize + "px;");
        out.println("            fill: black;");
        out.println("        }");
        out.println("    ]]></style>");
        out.println("</defs>");
        out.println("<g transform=\"translate(" + plotSize + "," + plotSize + ")\" >");
        out.println("<!-- draw surface and label distances.-->");
        int step = 30;
        out.println("<!-- tick marks every " + step + " degrees.-->");
        for (int i = 0; i < 360; i += step) {
            out.print("  <polyline points=\"");
            this.printDistRadius(out, i, R);
            out.print(", ");
            this.printDistRadius(out, i, (double)R * 1.05);
            out.println("\" />");
            double radian = (double)(i - 90) * Math.PI / 180.0;
            double x = (double)R * 1.055 * Math.cos(radian);
            double y = (double)R * 1.055 * Math.sin(radian);
            String anchor = "start";
            anchor = i < 45 ? "middle" : (i < 135 ? "start" : (i < 225 ? "middle" : (i < 335 ? "end" : "middle")));
            String alignBaseline = "baseline";
            alignBaseline = i < 60 ? "baseline" : (i <= 120 ? "middle" : (i < 240 ? "hanging" : (i < 300 ? "middle" : "baseline")));
            out.write(Outputs.formatDistance(x) + "  " + Outputs.formatDistance(y));
            out.println("  <text dominant-baseline=\"" + alignBaseline + "\" text-anchor=\"" + anchor + "\" class=\"label\" x=\"" + Outputs.formatDistance(x).strip() + "\" y=\"" + Outputs.formatDistance(y).strip() + "\">" + i + "</text>");
        }
        out.println("  <circle cx=\"0.0\" cy=\"0.0\" r=\"" + R + "\" />");
        double[] branchDepths = this.tMod.getBranchDepths();
        for (int i = 0; i < branchDepths.length; ++i) {
            out.println("  <circle cx=\"0.0\" cy=\"0.0\" r=\"" + ((double)R - branchDepths[i]) + "\" />");
        }
        out.println("<!-- draw paths, coordinates are x,y not degree,radius due to SVG using only cartesian -->");
    }

    public void printScriptBeginning(PrintWriter out, String psFile) throws IOException {
        out.println("#!/bin/sh");
        out.println("#\n# This script will plot ray paths using GMT. If you want to\n#use this as a data file for psxy in another script, delete these\n# first lines, to the last psxy, as well as the last line.\n#");
        out.println("/bin/rm -f " + psFile);
        out.println("# draw surface and label distances.\ngmt psbasemap -K -P -R0/360/0/" + this.getTauModel().getRadiusOfEarth() + " -JP" + this.mapWidth + this.mapWidthUnit + " -Bx30  > " + psFile);
        out.println("# draw circles for branches, note these are scaled for a \n# map using -JP" + this.mapWidth + this.mapWidthUnit + "\ngmt psxy -K -O -P -R -JP -Sc -A >> " + psFile + " <<ENDLAYERS");
        out.println("0.0 0.0 " + this.mapWidth + this.mapWidthUnit);
        double[] branchDepths = this.tMod.getBranchDepths();
        for (int i = 0; i < branchDepths.length; ++i) {
            out.println("0.0 0.0 " + (float)((this.getTauModel().getRadiusOfEarth() - branchDepths[i]) * (double)this.mapWidth / this.getTauModel().getRadiusOfEarth()) + this.mapWidthUnit);
        }
        out.println("ENDLAYERS\n");
        out.println("# draw paths");
    }

    @Override
    public void printUsage() {
        this.printStdUsage();
        System.out.println("--withtime        -- include time for each path point");
        System.out.println("--gmt             -- outputs path as a complete GMT script.");
        System.out.println("--svg             -- outputs path as a complete SVG file.");
        System.out.println("--mapwidth        -- sets map width for GMT script.");
        TauP_Path.printStdUsageTail();
    }

    @Override
    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int numNoComprendoArgs = 0;
        String[] leftOverArgs = super.parseCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        for (int i = 0; i < leftOverArgs.length; ++i) {
            if (TauP_Path.dashEquals("gmt", leftOverArgs[i])) {
                this.gmtScript = true;
                continue;
            }
            if (TauP_Path.dashEquals(SVG, leftOverArgs[i])) {
                this.outputFormat = SVG;
                continue;
            }
            if (TauP_Path.dashEquals("mapwidth", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setMapWidth(Float.parseFloat(leftOverArgs[i + 1]));
                ++i;
                continue;
            }
            if (TauP_Path.dashEquals("maxPathTime", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setMaxPathTime(Float.parseFloat(leftOverArgs[i + 1]));
                ++i;
                continue;
            }
            if (TauP_Path.dashEquals("withtime", leftOverArgs[i])) {
                this.withTime = true;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = TauP_Path.dashEquals("help", leftOverArgs[i]) ? leftOverArgs[i] : leftOverArgs[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    public void start() throws IOException, TauModelException, TauPException {
        super.start();
    }

    public static void main(String[] args) throws IOException {
        ToolRun.legacyRunTool(ToolRun.PATH, args);
    }
}

