/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.BuildVersion;
import edu.sc.seis.TauP.TauP_Create;
import edu.sc.seis.TauP.TauP_Curve;
import edu.sc.seis.TauP.TauP_GUI;
import edu.sc.seis.TauP.TauP_Path;
import edu.sc.seis.TauP.TauP_PhaseDescribe;
import edu.sc.seis.TauP.TauP_Pierce;
import edu.sc.seis.TauP.TauP_SetSac;
import edu.sc.seis.TauP.TauP_SlownessPlot;
import edu.sc.seis.TauP.TauP_Table;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.TauP_VelocityMerge;
import edu.sc.seis.TauP.TauP_VelocityPlot;
import edu.sc.seis.TauP.TauP_Wavefront;
import java.io.IOException;
import java.util.Arrays;

public class ToolRun {
    public static boolean DEBUG = false;
    public static boolean VERBOSE = false;
    public static String PHASE = "phase";
    public static String TIME = "time";
    public static String PIERCE = "pierce";
    public static String PATH = "path";
    public static String CURVE = "curve";
    public static String CREATE = "create";
    public static String GUI = "gui";
    public static String SETSAC = "setsac";
    public static String SPLOT = "slowplot";
    public static String TABLE = "table";
    public static String VPLOT = "velplot";
    public static String VELMERGE = "velmerge";
    public static String WAVEFRONT = "wavefront";
    static String[] toolnames = new String[]{GUI, CREATE, CURVE, PATH, PHASE, PIERCE, SETSAC, SPLOT, TABLE, TIME, VPLOT, VELMERGE, WAVEFRONT};

    public static void printUsage() {
        System.out.println("Usage: taup <tool> <options>");
        System.out.println(" where tool is one of " + Arrays.deepToString(toolnames));
        System.out.println(" taup <tool> --help");
        System.out.println(" for help with a particular tool.");
    }

    protected static String[] parseCommonCmdLineArgs(String[] args) {
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (ToolRun.dashEquals("verbose", args[i])) {
                VERBOSE = true;
                continue;
            }
            if (ToolRun.dashEquals("debug", args[i])) {
                VERBOSE = true;
                DEBUG = true;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static boolean dashEquals(String argName, String arg) {
        return arg.equalsIgnoreCase("-" + argName) || arg.equalsIgnoreCase("--" + argName);
    }

    public static void main(String[] args) throws IOException {
        String toolToRun;
        String[] restOfArgs = new String[]{};
        if (args.length == 0) {
            toolToRun = GUI;
        } else {
            toolToRun = args[0];
            restOfArgs = Arrays.copyOfRange(args, 1, args.length);
        }
        TauP_Tool tool = null;
        try {
            if (toolToRun.contentEquals(GUI)) {
                TauP_GUI t = new TauP_GUI();
                t.setQuitExits(true);
                t.show();
                return;
            }
            if (toolToRun.contentEquals(CREATE)) {
                tool = new TauP_Create();
            } else if (toolToRun.contentEquals(CURVE)) {
                tool = new TauP_Curve();
            } else if (toolToRun.contentEquals(PATH)) {
                tool = new TauP_Path();
            } else if (toolToRun.contentEquals(PHASE)) {
                tool = new TauP_PhaseDescribe();
            } else if (toolToRun.contentEquals(PIERCE)) {
                tool = new TauP_Pierce();
            } else if (toolToRun.contentEquals(SETSAC)) {
                tool = new TauP_SetSac();
            } else if (toolToRun.contentEquals(SPLOT)) {
                tool = new TauP_SlownessPlot();
            } else if (toolToRun.contentEquals(TABLE)) {
                tool = new TauP_Table();
            } else if (toolToRun.contentEquals(TIME)) {
                tool = new TauP_Time();
            } else if (toolToRun.contentEquals(VPLOT)) {
                tool = new TauP_VelocityPlot();
            } else if (toolToRun.contentEquals(VELMERGE)) {
                tool = new TauP_VelocityMerge();
            } else if (toolToRun.contentEquals(WAVEFRONT)) {
                tool = new TauP_Wavefront();
            } else {
                if (TauP_Tool.dashEquals("help", toolToRun) || toolToRun.equals("help")) {
                    ToolRun.printUsage();
                    return;
                }
                if (ToolRun.dashEquals("version", toolToRun) || toolToRun.equals("version")) {
                    Alert.info(BuildVersion.getDetailedVersion());
                    return;
                }
                System.err.println("Tool " + toolToRun + " not recognized.");
                ToolRun.printUsage();
                return;
            }
            String[] noComprendoArgs = tool.parseCmdLineArgs(restOfArgs);
            TauP_Tool.printNoComprendoArgs(noComprendoArgs);
            if (noComprendoArgs.length != 0) {
                return;
            }
            tool.init();
            tool.start();
            tool.destroy();
            if (tool.verbose) {
                System.out.println("Done with " + toolToRun);
            }
        }
        catch (Exception e) {
            System.err.println("Error starting tool: " + args[0] + " " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    static void legacyRunTool(String toolname, String[] args) throws IOException {
        String[] argsPlusName = new String[args.length + 1];
        argsPlusName[0] = toolname;
        System.arraycopy(args, 0, argsPlusName, 1, args.length);
        ToolRun.main(argsPlusName);
    }
}

