/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.range.RangeDataEvent;
import edu.geophys.commons.suite.EventWindowModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.DefaultBoundedLongRangeModel;
import edu.geophys.commons.ui.FramePositionHelper;
import edu.geophys.commons.ui.range.JTimeRangeInteractive;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.hypoline.HypoLineConfiguration;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.legacy.ArrayPositionWrapper;
import edu.geophys.hypoline.ui.singlewindow.SingleWindowFrame;
import edu.geophys.hypoline.ui.trace.SiteModel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HypoLineApplication {
    private SingleWindowFrame mainFrame;
    private EventWindowModel ewm;
    private BoundedLongRangeModel rangeModel;
    private JTimeRangeInteractive timeSelection;
    private HypoLineConfiguration config;
    private final CampaignKnowledge ck = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
    private final StationsKnowledge sk = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge();
    private final long maxTimeRange = 86400000L;
    private boolean isRunning = true;
    private PropertyChangeListener ewmChange = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (HypoLineApplication.this.config.isAutomaticSync()) {
                long l;
                long l2;
                long l3 = HypoLineApplication.this.ewm.getStartEpochTimeMs();
                if (l3 < HypoLineApplication.this.ck.getCampaignEpochStart() || l3 > HypoLineApplication.this.ck.getCampaignEpochEnd()) {
                    l3 = HypoLineApplication.this.ck.getCampaignEpochStart();
                }
                if ((l2 = l3 - HypoLineApplication.this.ck.getCampaignEpochStart()) > 43200000L) {
                    l2 = 43200000L;
                }
                if ((l = l3 + 86400000L - l2) > HypoLineApplication.this.ck.getCampaignEpochEnd()) {
                    l = HypoLineApplication.this.ck.getCampaignEpochEnd();
                }
                HypoLineApplication.this.rangeModel.setRangeProperties(l3, HypoLineApplication.this.ewm.getLength(), l3 - l2, l, HypoLineApplication.this.rangeModel.getIncrement(), true);
                HypoLineApplication.this.mainFrame.getArraySelectionView().updateView();
            }
        }
    };
    private ChangeListener rangeModelChange = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (HypoLineApplication.this.config.isAutomaticSync()) {
                if (Math.abs(HypoLineApplication.this.rangeModel.getValue() - HypoLineApplication.this.ewm.getStartEpochTimeMs()) > 1L) {
                    HypoLineApplication.this.ewm.setStartEpochTimeMs(HypoLineApplication.this.rangeModel.getValue());
                }
                HypoLineApplication.this.ewm.setLength(HypoLineApplication.this.rangeModel.getExtent());
            }
            HypoLineApplication.this.updateSonogramWindow();
            HypoLineApplication.this.mainFrame.getStationView().setStart((double)HypoLineApplication.this.rangeModel.getValue() / 1000.0);
            HypoLineApplication.this.mainFrame.getStationView().setLength((double)HypoLineApplication.this.rangeModel.getExtent() / 1000.0);
            HypoLineApplication.this.mainFrame.getStationView().updateModel(true);
            HypoLineApplication.this.mainFrame.getStationZoomView().updateModel(new RangeDataEvent((Object)this, "ALL_CHANGED", null));
        }
    };
    private PropertyChangeListener configChange = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("hypoLineMode")) {
                LogUtil.debug(this.getClass(), (String)"hypoLineMode");
                HypoLineApplication.this.mainFrame.update();
            }
        }
    };

    public HypoLineApplication() {
        long l;
        long l2;
        new HypoLineManager();
        HypoLineManager.INSTANCE.setHlApp(this);
        this.config = new HypoLineConfiguration();
        this.config.load();
        HypoLineManager.INSTANCE.setConfig(this.config);
        this.ewm = SuiteManager.INSTANCE.getGlobalEventWindowModel();
        if (this.config.getActiveSNS() >= this.sk.getAllActiveSNS().length) {
            this.config.setActiveSNS(-1);
        }
        double d = -1.7976931348623157E308;
        for (SNS sNS : this.sk.getAllActiveSNS()) {
            for (Site site : sNS.getAllSites()) {
                HypoLineManager.INSTANCE.getSites().add(new SiteModel(site, true, sNS));
                if (!(site.getZOffsetKm() > d)) continue;
                d = site.getZOffsetKm();
            }
        }
        HypoLineManager.INSTANCE.getEpiMapDb().getEpiDepth().setMaxZ(d);
        HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(this.config.getLayerModelName());
        this.config.addPropertyChangeListener(this.configChange);
        long l3 = this.ewm.getStartEpochTimeMs();
        if (l3 < this.ck.getCampaignEpochStart() || l3 > this.ck.getCampaignEpochEnd()) {
            l3 = this.ck.getCampaignEpochStart();
        }
        if ((l2 = l3 - this.ck.getCampaignEpochStart()) > 43200000L) {
            l2 = 43200000L;
        }
        if ((l = l3 + 86400000L - l2) > this.ck.getCampaignEpochEnd()) {
            l = this.ck.getCampaignEpochEnd();
        }
        this.rangeModel = new DefaultBoundedLongRangeModel(l3, this.ewm.getLength(), l3 - l2, l, 1L);
        this.rangeModel.addChangeListener(this.rangeModelChange);
        this.ewm.addPropertyChangeListener(this.ewmChange);
        this.mainFrame = new SingleWindowFrame("HypoLine");
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.setSize(this.config.getHypoLineFrameSize());
        this.mainFrame.setLocation(this.config.getHypoLineFramePosition());
        FramePositionHelper.ensureFrameOnScreen((JFrame)this.mainFrame);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HypoLineApplication.this.exit();
            }
        });
        this.timeSelection = this.mainFrame.getTimeSelection();
        this.timeSelection.setModel(this.rangeModel);
        this.mainFrame.setVisible(true);
        this.mainFrame.getStationView().getMarkerModel().setMarker("1a", 0.3, null);
        this.mainFrame.getFilterView().update();
        HypoLineManager.INSTANCE.getMagnitudePanel().update();
        HypoLineManager.INSTANCE.getEpiMapDb().initApertureDistances();
        HypoLineManager.INSTANCE.getEpiMapDb().paintAllStations();
        HypoLineManager.INSTANCE.getEpiMapDb().getEpiDepth().repaintArea();
        this.mainFrame.getStationView().setStart((double)this.ewm.getStartEpochTimeMs() / 1000.0);
        this.mainFrame.getStationView().setLength((double)this.ewm.getLength() / 1000.0);
        this.mainFrame.getStationView().updateModel(true);
        this.mainFrame.getStationZoomView().updateModel(new RangeDataEvent((Object)this, "ALL_CHANGED", null));
        HypoLineManager.INSTANCE.getProtFileManager().load();
        if (this.ewm.getStartEpochTimeMs() < this.ck.getCampaignEpochStart() || this.ewm.getStartEpochTimeMs() + this.ewm.getLength() > this.ck.getCampaignEpochEnd()) {
            this.ewm.setStartEpochTimeMs(this.ck.getCampaignEpochStart());
        }
        this.updateSonogramWindow();
        this.config.firePropertyChange("hypoLineMode", (Object)HypoLineConfiguration.HypoLineMode.NETWORK, (Object)this.config.getHypoLineMode());
    }

    private int checkSNSNotNullNo() {
        int n = 0;
        ArrayPositionWrapper arrayPositionWrapper = HypoLineManager.INSTANCE.getArrayPositionWrapper();
        for (SNS sNS : new SNS[]{arrayPositionWrapper.getNorthWestArray(), arrayPositionWrapper.getNorthEastArray(), arrayPositionWrapper.getCenterArray(), arrayPositionWrapper.getSouthWestArray(), arrayPositionWrapper.getSouthArray(), arrayPositionWrapper.getSouthEastArray()}) {
            if (sNS == null) continue;
            ++n;
        }
        return n;
    }

    private void updateSonogramWindow() {
        long l = this.ewm.getStartEpochTimeMs() - this.ewm.getLength();
        long l2 = this.ewm.getLength() * 3L;
        ArrayPositionWrapper arrayPositionWrapper = HypoLineManager.INSTANCE.getArrayPositionWrapper();
    }

    public void exit() {
        this.isRunning = false;
        HypoLineManager.INSTANCE = null;
        this.rangeModel.removeChangeListener(this.rangeModelChange);
        this.ewm.removePropertyChangeListener(this.ewmChange);
        this.config.setHypoLineFramePosition(this.mainFrame.getLocation());
        this.config.setHypoLineFrameSize(this.mainFrame.getSize());
        this.config.store();
        this.config.removePropertyChangeListener(this.configChange);
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
    }

    public SingleWindowFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(SingleWindowFrame singleWindowFrame) {
        this.mainFrame = singleWindowFrame;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

