/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ccode;

import edu.geophys.commons.model.layer.Layer;
import edu.geophys.commons.model.layer.LayerModel;
import edu.geophys.commons.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class CHypoLineRoutines56 {
    private static final int STMAX = 60;
    private static final int LAYMAX = 10;
    private final int zMax;
    private final int zclassmax;
    private static final int TTDIM = 450;
    private final double[] psimul = new double[60];
    private final double[] ssimul = new double[60];
    private final double[] pgsimul = new double[60];
    private final double[] lgsimul = new double[60];
    private final int[] slocreg = new int[60];
    private boolean debugOutput = false;
    private int[] stationlayer;
    private float[] dupstation;
    private float[][] ttabp;
    private float[][] xtabp;
    private float[][] ptabp;
    private float[][] ttabs;
    private float[][] xtabs;
    private float[][] ptabs;
    private float[][] ttabpsimul;
    private float[][] xtabpsimul;
    private float[][] ptabpsimul;
    private float[][] ttabssimul;
    private float[][] xtabssimul;
    private float[][] ptabssimul;
    private float[][][] xptabpsimul;
    private float[][][] xptabl;
    private float[][][] xptabssimul;
    private final int[][] lfolinkp;
    private final int[] lrupp;
    private final int[][] lfolinks;
    private final int[] lrups;
    private final int[][] lfolinkpsimul;
    private final int[] lruppsimul;
    private final int[][] lfolinkssimul;
    private final int[] lrupssimul;
    private final float[] x0 = new float[10];
    private final float[] t0 = new float[10];
    private final float[] xc = new float[10];
    private final float[] tc = new float[10];
    private final float[][] prp;
    private final float[][] x0p;
    private final float[][] t0p;
    private final float[][] xcp;
    private final float[][] tcp;
    private final float[][] trp;
    private final float[][] prs;
    private final float[][] x0s;
    private final float[][] t0s;
    private final float[][] xcs;
    private final float[][] tcs;
    private final float[][] trs;
    private final float[][] prpsimul;
    private final float[][] x0psimul;
    private final float[][] t0psimul;
    private final float[][] trpsimul;
    private final float[][] xcpsimul;
    private final float[][] tcpsimul;
    private final float[][] prssimul;
    private final float[][] x0ssimul;
    private final float[][] t0ssimul;
    private final float[][] xcssimul;
    private final float[][] tcssimul;
    private final float[][] trssimul;
    private final float[] pupp;
    private final float[] x0upp;
    private final float[] t0upp;
    private final float[] pups;
    private final float[] x0ups;
    private final float[] t0ups;
    private final float[] puppsimul;
    private final float[] x0uppsimul;
    private final float[] t0uppsimul;
    private final float[] pupssimul;
    private final float[] x0upssimul;
    private final float[] t0upssimul;
    private final float[][][] xpathsP;
    private final float[][][] zpathsP;
    private final float[][][] xpathsS;
    private final float[][][] zpathsS;
    private final float[][][] xpathsPsimul;
    private final float[][][] zpathsPsimul;
    private final float[][][] xpathsSsimul;
    private final float[][][] zpathsSsimul;
    private final float[][] xpguidedpsimul;
    private final float[][] xpguidedl;
    private final float[][] xpguidedssimul;
    private final float[] zclassdepth;
    private IntPtr sourceforcelayer = new IntPtr();
    private IntPtr sourcesimullayer = new IntPtr();
    private FloatPtr dupsourcesimul = new FloatPtr();
    private FloatPtr dupsourceforce = new FloatPtr();
    private int pnlayer = -1;
    private int pglayer = -1;
    private int locreg = 0;
    private float vp2vs;
    private final int nlayer;
    private final int nstatlist;
    private final float[] statlocx;
    private final float[] statlocy;
    private final int[] zclass;
    private final float elevationOffset;
    private ArrayList<double[]> masterEventVectors = new ArrayList();
    private double epix_simul;
    private double epiy_simul;
    private double epiz_simul;
    private double depth_simul = Double.MAX_VALUE;
    private double epiz_force;
    private double depth_force = Double.MAX_VALUE;
    private float[] vp_layer = new float[10];
    private float[] vs_layer = new float[10];
    private float[] d_layer = new float[10];
    private final FloatPtr _hyperbolae_r1 = new FloatPtr();
    private final FloatPtr _hyperbolae_r2 = new FloatPtr();
    private final FloatPtr _hyperbolae_td1 = new FloatPtr();
    private final FloatPtr _hyperbolae_td2 = new FloatPtr();
    private final FloatPtr _hypermatch_r1 = new FloatPtr();
    private final FloatPtr _hypermatch_t1 = new FloatPtr();
    private final FloatPtr _hypermatch_r2 = new FloatPtr();
    private final FloatPtr _hypermatch_t2 = new FloatPtr();
    private float xprsd_me;
    private float yprsd_me;
    private float recti_me;
    private final FloatPtr _hypolocme_t1 = new FloatPtr();
    private final FloatPtr _hypolocme_t2 = new FloatPtr();
    private final FloatPtr _hypolocme_r = new FloatPtr();
    private final FloatPtr _hypolocme_xa1 = new FloatPtr();
    private final FloatPtr _hypolocme_xa2 = new FloatPtr();
    private final FloatPtr _hypolocme_xb1 = new FloatPtr();
    private final FloatPtr _hypolocme_xb2 = new FloatPtr();
    private final FloatPtr _hypolocme_ya1 = new FloatPtr();
    private final FloatPtr _hypolocme_ya2 = new FloatPtr();
    private final FloatPtr _hypolocme_yb1 = new FloatPtr();
    private final FloatPtr _hypolocme_yb2 = new FloatPtr();
    private final FloatPtr _calcRadius_td = new FloatPtr();
    private final FloatPtr _calcRadius_radius = new FloatPtr();
    private double sp_td = Double.NaN;
    private float sp_radius = Float.NaN;
    private boolean layerModelValid;

    private void spReset() {
        this.sp_td = Double.NaN;
        this.sp_radius = Float.NaN;
    }

    public float getSPradius() {
        return this.sp_radius;
    }

    public double getSPtd() {
        return this.sp_td;
    }

    public CHypoLineRoutines56(LayerModel layerModel, double d, double d2, float[] fArray, float[] fArray2, int[] nArray, float[] fArray3) {
        boolean bl;
        this.layerModelValid = layerModel.isValid();
        this.statlocx = fArray;
        this.statlocy = fArray2;
        this.nstatlist = fArray.length;
        this.elevationOffset = (float)d;
        float f = -3.4028235E38f;
        float[] fArray4 = fArray3;
        int n = fArray4.length;
        for (int i = 0; i < n; ++i) {
            float f2 = fArray4[i];
            f = Math.max(f, f2);
        }
        boolean bl2 = bl = this.elevationOffset > f;
        if (bl) {
            this.zMax = fArray3.length + 1;
            this.zclassdepth = new float[this.zMax];
            for (n = 1; n < this.zMax; ++n) {
                this.zclassdepth[n] = this.elevationOffset - fArray3[n - 1];
            }
            this.zclassdepth[0] = 0.0f;
            this.zclass = new int[this.nstatlist];
            for (n = 0; n < this.nstatlist; ++n) {
                this.zclass[n] = nArray[n] + 1;
            }
        } else {
            this.zMax = fArray3.length;
            this.zclassdepth = new float[this.zMax];
            for (n = 0; n < this.zMax; ++n) {
                this.zclassdepth[n] = this.elevationOffset - fArray3[n];
            }
            this.zclassdepth[0] = 0.0f;
            this.zclass = nArray;
        }
        this.zclassmax = this.zMax - 1;
        this.nlayer = layerModel.getLayers().size();
        if (this.nlayer > 10) {
            LogUtil.error(this.getClass(), (String)"Layermodel contains too many layer, only up to 10 layers possible at the moment.");
            throw new ArrayIndexOutOfBoundsException("Layermodel contains too many layer, only up to 10 layers possible");
        }
        this.vp2vs = (float)layerModel.getVp2vs();
        for (n = 0; n < this.nlayer; ++n) {
            Layer layer = (Layer)layerModel.getLayers().get(n);
            this.vp_layer[n] = (float)layer.getVp();
            this.vs_layer[n] = this.vp2vs >= 1.0f ? Float.NaN : (float)layer.getVs();
            this.d_layer[n] = (float)(n == 0 ? d2 : layer.getD());
            if (this.d_layer[n] < 0.0f || n == this.nlayer - 1) {
                this.d_layer[n] = 999.9f;
            }
            if (((Layer)layerModel.getLayers().get(n)).getWavetype().equals((Object)Layer.WaveType.Pg)) {
                this.pglayer = n;
            }
            if (!((Layer)layerModel.getLayers().get(n)).getWavetype().equals((Object)Layer.WaveType.Pn)) continue;
            this.pnlayer = n;
        }
        this.stationlayer = new int[this.zMax];
        this.dupstation = new float[this.zMax];
        this.ttabp = new float[this.zMax][450];
        this.xtabp = new float[this.zMax][450];
        this.ptabp = new float[this.zMax][450];
        this.ttabs = new float[this.zMax][450];
        this.xtabs = new float[this.zMax][450];
        this.ptabs = new float[this.zMax][450];
        this.ttabpsimul = new float[this.zMax][450];
        this.xtabpsimul = new float[this.zMax][450];
        this.ptabpsimul = new float[this.zMax][450];
        this.ttabssimul = new float[this.zMax][450];
        this.xtabssimul = new float[this.zMax][450];
        this.ptabssimul = new float[this.zMax][450];
        this.xptabpsimul = new float[this.zMax][450][10];
        this.xptabl = new float[this.zMax][450][10];
        this.xptabssimul = new float[this.zMax][450][10];
        this.lfolinkp = new int[this.zMax][10];
        this.lrupp = new int[this.zMax];
        this.lfolinks = new int[this.zMax][10];
        this.lrups = new int[this.zMax];
        this.lfolinkpsimul = new int[this.zMax][10];
        this.lruppsimul = new int[this.zMax];
        this.lfolinkssimul = new int[this.zMax][10];
        this.lrupssimul = new int[this.zMax];
        this.prp = new float[this.zMax][10];
        this.x0p = new float[this.zMax][10];
        this.t0p = new float[this.zMax][10];
        this.xcp = new float[this.zMax][10];
        this.tcp = new float[this.zMax][10];
        this.trp = new float[this.zMax][10];
        this.prs = new float[this.zMax][10];
        this.x0s = new float[this.zMax][10];
        this.t0s = new float[this.zMax][10];
        this.xcs = new float[this.zMax][10];
        this.tcs = new float[this.zMax][10];
        this.trs = new float[this.zMax][10];
        this.prpsimul = new float[this.zMax][10];
        this.x0psimul = new float[this.zMax][10];
        this.t0psimul = new float[this.zMax][10];
        this.trpsimul = new float[this.zMax][10];
        this.xcpsimul = new float[this.zMax][10];
        this.tcpsimul = new float[this.zMax][10];
        this.prssimul = new float[this.zMax][10];
        this.x0ssimul = new float[this.zMax][10];
        this.t0ssimul = new float[this.zMax][10];
        this.xcssimul = new float[this.zMax][10];
        this.tcssimul = new float[this.zMax][10];
        this.trssimul = new float[this.zMax][10];
        this.pupp = new float[this.zMax];
        this.x0upp = new float[this.zMax];
        this.t0upp = new float[this.zMax];
        this.pups = new float[this.zMax];
        this.x0ups = new float[this.zMax];
        this.t0ups = new float[this.zMax];
        this.puppsimul = new float[this.zMax];
        this.x0uppsimul = new float[this.zMax];
        this.t0uppsimul = new float[this.zMax];
        this.pupssimul = new float[this.zMax];
        this.x0upssimul = new float[this.zMax];
        this.t0upssimul = new float[this.zMax];
        this.xpathsP = new float[this.zMax][10][20];
        this.zpathsP = new float[this.zMax][10][20];
        this.xpathsS = new float[this.zMax][10][20];
        this.zpathsS = new float[this.zMax][10][20];
        this.xpathsPsimul = new float[this.zMax][10][20];
        this.zpathsPsimul = new float[this.zMax][10][20];
        this.xpathsSsimul = new float[this.zMax][10][20];
        this.zpathsSsimul = new float[this.zMax][10][20];
        this.xpguidedpsimul = new float[this.zMax][10];
        this.xpguidedl = new float[this.zMax][10];
        this.xpguidedssimul = new float[this.zMax][10];
    }

    private void cinterpolate(float[][] fArray, float[][] fArray2, int n, float[] fArray3, int n2, int[] nArray, float[][] fArray4, float[][] fArray5, FloatPtr floatPtr, FloatPtr floatPtr2, float f, float f2, float f3, int n3) {
        if (fArray4[n3][n2] > 1.0E20f || fArray5[n3][n2] > 1.0E20f) {
            floatPtr.val = 1.1E20f;
            floatPtr2.val = 1.1E20f;
            return;
        }
        int n4 = -1;
        for (int i = 1; i < n; ++i) {
            float f4;
            float f5;
            if (!(fArray[n3][i] > fArray4[n3][n2])) continue;
            if (n4 == -1) {
                n4 = i;
            }
            if (!((f5 = fArray5[n3][n2] + (fArray[n3][i] - fArray4[n3][n2]) / fArray3[n2]) <= fArray2[n3][i])) continue;
            if (i == n4) {
                f4 = fArray4[n3][n2];
                f5 = fArray5[n3][n2];
            } else {
                float f6 = f5 - fArray2[n3][i - 1];
                f4 = f6 > 0.0f ? fArray[n3][i - 1] + f6 / (fArray2[n3][i] - fArray2[n3][i - 1]) * (fArray[n3][i] - fArray[n3][i - 1]) : fArray[n3][i];
            }
            floatPtr2.val = f5;
            floatPtr.val = f4;
            return;
        }
        if (fArray3[n2] < fArray3[nArray[n3]]) {
            floatPtr.val = 1.1E20f;
            floatPtr2.val = 1.1E20f;
            return;
        }
        if (fArray[n3][n - 1] > f * 5.0f) {
            float f7 = (fArray3[n2] * fArray3[nArray[n3]] * (fArray5[n3][n2] - f2) + fArray3[n2] * f - fArray3[nArray[n3]] * fArray4[n3][n2]) / (fArray3[n2] - fArray3[nArray[n3]]);
            float f8 = fArray[n3][n - 1] - f;
            float f9 = fArray4[n3][n2] - fArray[n3][n - 1];
            float f10 = f8 + f9;
            float f11 = (float)(Math.sqrt(f8 * f8 + f3 * f3) + (double)f9 - Math.sqrt(f10 * f10 + f3 * f3));
            float f12 = f2 - f11 / fArray3[nArray[n3]];
            floatPtr.val = (fArray3[n2] * fArray3[nArray[n3]] * (fArray5[n3][n2] - f12) + fArray3[n2] * f - fArray3[nArray[n3]] * fArray4[n3][n2]) / (fArray3[n2] - fArray3[nArray[n3]]);
            floatPtr2.val = fArray5[n3][n2] + (floatPtr.val - fArray4[n3][n2]) / fArray3[n2];
        } else {
            float f13 = fArray[n3][n - 1] - fArray[n3][n - n / 5];
            float f14 = fArray2[n3][n - 1] - fArray2[n3][n - n / 5];
            float f15 = f13 / f14;
            floatPtr.val = (fArray3[n2] * f15 * (fArray5[n3][n2] - fArray2[n3][n - 1]) + fArray3[n2] * fArray[n3][n - 1] - f15 * fArray4[n3][n2]) / (fArray3[n2] - f15);
            floatPtr2.val = fArray5[n3][n2] + (floatPtr.val - fArray4[n3][n2]) / fArray3[n2];
        }
        if (floatPtr.val < fArray4[n3][n2] || floatPtr2.val < fArray5[n3][n2]) {
            floatPtr.val = fArray4[n3][n2];
            floatPtr2.val = fArray5[n3][n2];
        }
        if (floatPtr.val < fArray[n3][n - 1] || floatPtr2.val < fArray2[n3][n - 1]) {
            floatPtr.val = fArray[n3][n - 1];
            floatPtr2.val = fArray2[n3][n - 1];
        }
    }

    private int ttsetup(float[] fArray, float[] fArray2, int n, float f, float[] fArray3, IntPtr intPtr, FloatPtr floatPtr, int[] nArray, float[] fArray4, float[][] fArray5, float[][] fArray6, float[][] fArray7, float[][] fArray8, float[][] fArray9, float[][] fArray10, int[][] nArray2, float[][] fArray11, float[][] fArray12, float[][] fArray13, int n2, float[] fArray14, float[] fArray15, float[] fArray16, int[] nArray3, float[][][] fArray17, float[][][] fArray18, float[][][] fArray19, float[][] fArray20, int n3) {
        float f2;
        int n4;
        int n5;
        FloatPtr floatPtr2 = new FloatPtr(Float.NaN);
        FloatPtr floatPtr3 = new FloatPtr(Float.NaN);
        double d = 0.0;
        int n6 = -2147483647;
        float f3 = Float.NaN;
        float f4 = Float.NaN;
        float f5 = Float.NaN;
        double d2 = 100.0;
        if (!this.layerModelValid) {
            return -10;
        }
        if (n > 10) {
            return -1;
        }
        for (n5 = 0; n5 < n; ++n5) {
            for (n4 = 0; n4 < 20; ++n4) {
                fArray17[n3][n5][n4] = -1.0f;
                fArray18[n3][n5][n4] = -1.0f;
            }
        }
        float f6 = 0.0f;
        for (n5 = 0; n5 < n - 1; ++n5) {
            f6 += fArray2[n5];
        }
        if (f6 < 1.0E-10f) {
            f6 = 10.0f;
        }
        float f7 = 0.0f;
        for (n5 = 0; n5 < n; ++n5) {
            if (fArray3[n3] == 0.0f && n5 == 0 || f7 < fArray3[n3] && (fArray3[n3] <= f7 + fArray2[n5] || n5 == n - 1)) {
                nArray[n3] = n5;
                fArray4[n3] = fArray3[n3] - f7;
                if (n5 == n - 1) {
                    f4 = 1.1E20f;
                    break;
                }
                f4 = fArray2[n5] - fArray4[n3];
                break;
            }
            f7 += fArray2[n5];
        }
        f7 = 0.0f;
        for (n5 = 0; n5 < n; ++n5) {
            if (f7 <= f && (f < f7 + fArray2[n5] || n5 == n - 1)) {
                intPtr.val = n5;
                floatPtr.val = f - f7;
                if (n5 > 0) {
                    if (n5 == n - 1) {
                        if (floatPtr.val < f7 * 0.002f) {
                            floatPtr.val = f7 * 0.002f;
                        }
                    } else if (floatPtr.val < fArray2[n5] * 0.01f) {
                        floatPtr.val = fArray2[n5] * 0.01f;
                    }
                }
                if (n5 == n - 1) {
                    f5 = 1.1E20f;
                    break;
                }
                f5 = fArray2[n5] - floatPtr.val;
                break;
            }
            f7 += fArray2[n5];
        }
        nArray3[n3] = -1;
        for (n5 = 0; n5 < n; ++n5) {
            double d3;
            boolean bl;
            float f8;
            float f9;
            float f10;
            fArray17[n3][n5][0] = 0.0f;
            fArray18[n3][n5][0] = f;
            this.debugPrint(n5, intPtr, nArray[n3], "Find raypath");
            if (n5 < intPtr.val) {
                this.debugPrint(n5, intPtr, nArray[n3], "Case A: Layer above source");
                if (n5 < nArray[n3]) {
                    this.debugPrint(n5, intPtr, nArray[n3], "Case A1: Layer above station");
                    if (fArray[intPtr.val] >= fArray[n5]) {
                        this.debugPrintNan(n3, n5);
                        fArray6[n3][n5] = 1.1E20f;
                        fArray7[n3][n5] = 1.1E20f;
                        fArray8[n3][n5] = 1.1E20f;
                        fArray5[n3][n5] = 1.1E20f;
                        fArray17[n3][n5][1] = -1.0f;
                        fArray18[n3][n5][1] = -1.0f;
                        continue;
                    }
                    fArray6[n3][n5] = 1.0f / fArray[n5];
                    f10 = 0.0f;
                    f9 = 0.0f;
                    f8 = 0.0f;
                    bl = true;
                    if (fArray[intPtr.val] > fArray[n5]) {
                        bl = false;
                    } else {
                        d3 = Math.asin(fArray[intPtr.val] * fArray6[n3][n5]);
                        f10 = (float)((double)f10 + (double)floatPtr.val * Math.tan(d3));
                        f9 = (float)((double)f9 + (double)floatPtr.val / Math.cos(d3) / (double)fArray[intPtr.val]);
                        f8 += floatPtr.val / fArray[intPtr.val];
                        n6 = 1;
                        fArray17[n3][n5][n6] = f10;
                        fArray18[n3][n5][n6] = fArray18[n3][n5][n6 - 1] - floatPtr.val;
                    }
                    for (n4 = intPtr.val - 1; n4 > n5; --n4) {
                        if (fArray[n4] > fArray[n5] || !bl) {
                            bl = false;
                            continue;
                        }
                        d3 = Math.asin(fArray[n4] * fArray6[n3][n5]);
                        f10 = (float)((double)f10 + (double)fArray2[n4] * Math.tan(d3));
                        f9 = (float)((double)f9 + (double)fArray2[n4] / Math.cos(d3) / (double)fArray[n4]);
                        f8 += fArray2[n4] / fArray[n4];
                        fArray17[n3][n5][++n6] = f10;
                        fArray18[n3][n5][n6] = fArray18[n3][n5][n6 - 1] - fArray2[n4];
                    }
                    if (bl) {
                        f3 = fArray2[n5] * 0.01f;
                        float[] fArray21 = fArray18[n3][n5];
                        int n7 = n6++;
                        fArray21[n7] = fArray21[n7] - f3;
                        fArray17[n5][n6] = fArray17[n5][n6 - 1];
                        fArray18[n5][n6] = fArray18[n5][n6 - 1];
                    }
                    for (n4 = n5 + 1; n4 < nArray[n3]; ++n4) {
                        if (fArray[n4] > fArray[n5] || !bl) {
                            bl = false;
                            continue;
                        }
                        d3 = Math.asin(fArray[n4] * fArray6[n3][n5]);
                        f10 = (float)((double)f10 + (double)fArray2[n4] * Math.tan(d3));
                        f9 = (float)((double)f9 + (double)fArray2[n4] / Math.cos(d3) / (double)fArray[n4]);
                        f8 += fArray2[n4] / fArray[n4];
                        fArray17[n3][n5][++n6] = f10;
                        fArray18[n3][n5][n6] = fArray18[n3][n5][n6 - 1] + fArray2[n4];
                        if (n4 != n5 + 1) continue;
                        float[] fArray22 = fArray18[n3][n5];
                        int n8 = n6;
                        fArray22[n8] = fArray22[n8] + f3;
                    }
                    if (fArray[nArray[n3]] > fArray[n5] || !bl) {
                        bl = false;
                    } else {
                        d3 = Math.asin(fArray[nArray[n3]] * fArray6[n3][n5]);
                        f10 = (float)((double)f10 + (double)fArray4[n3] * Math.tan(d3));
                        f9 = (float)((double)f9 + (double)fArray4[n3] / Math.cos(d3) / (double)fArray[nArray[n3]]);
                        f8 += fArray4[n3] / fArray[nArray[n3]];
                        fArray17[n3][n5][++n6] = f10;
                        fArray18[n3][n5][n6] = fArray3[n3];
                        if (++n6 < 20) {
                            fArray17[n3][n5][n6] = -1.0f;
                            fArray18[n3][n5][n6] = -1.0f;
                        }
                    }
                    if (bl) {
                        fArray7[n3][n5] = f10;
                        fArray8[n3][n5] = f9;
                        fArray5[n3][n5] = f8;
                        continue;
                    }
                    this.debugPrint("Invalid");
                    this.debugPrintNan(n3, n5);
                    fArray7[n3][n5] = 1.1E20f;
                    fArray8[n3][n5] = 1.1E20f;
                    fArray5[n3][n5] = 1.1E20f;
                    fArray17[n3][n5][1] = -1.0f;
                    fArray18[n3][n5][1] = -1.0f;
                    continue;
                }
                if (n5 == nArray[n3]) {
                    this.debugPrint(n5, intPtr, nArray[n3], "Case A2: layer with station");
                    this.debugPrintNan(n3, n5);
                    fArray6[n3][n5] = 1.1E20f;
                    fArray7[n3][n5] = 1.1E20f;
                    fArray8[n3][n5] = 1.1E20f;
                    fArray5[n3][n5] = 1.1E20f;
                    fArray17[n3][n5][1] = -1.0f;
                    fArray18[n3][n5][1] = -1.0f;
                    continue;
                }
                this.debugPrint(n5, intPtr, nArray[n3], "Case A3: layer below station");
                this.debugPrintNan(n3, n5);
                fArray6[n3][n5] = 1.1E20f;
                fArray7[n3][n5] = 1.1E20f;
                fArray8[n3][n5] = 1.1E20f;
                fArray5[n3][n5] = 1.1E20f;
                fArray17[n3][n5][1] = -1.0f;
                fArray18[n3][n5][1] = -1.0f;
                continue;
            }
            if (n5 == intPtr.val) {
                float f11;
                float f12;
                int n9;
                float f13;
                float f14;
                float f15;
                double d4;
                this.debugPrint(n5, intPtr, nArray[n3], "Case B layer includes source");
                fArray7[n3][intPtr.val] = 0.0f;
                fArray8[n3][intPtr.val] = 0.0f;
                fArray5[n3][intPtr.val] = 0.0f;
                if (intPtr.val == nArray[n3]) {
                    this.debugPrint(n5, intPtr, nArray[n3], "Case B1: station also in source");
                    f2 = Math.abs(floatPtr.val - fArray4[n3]);
                    fArray13[n3][0] = f2 / fArray[intPtr.val];
                    fArray12[n3][0] = 0.0f;
                    fArray11[n3][0] = 1.0E-4f;
                    fArray17[n3][intPtr.val][1] = 1.0f;
                    fArray18[n3][intPtr.val][1] = fArray3[n3];
                    fArray17[n3][intPtr.val][2] = -1.0f;
                    fArray18[n3][intPtr.val][2] = -1.0f;
                    d4 = d2 / Math.pow(n2, 1.5);
                    for (n4 = 1; n4 < n2; ++n4) {
                        d3 = Math.atan(d4 * Math.pow(n4, 1.5));
                        fArray11[n3][n4] = (float)(Math.sin(d3) / (double)fArray[intPtr.val]);
                        if (f2 < 0.001f) {
                            fArray12[n3][n4] = (float)((double)0.001f * Math.tan(d3));
                            fArray13[n3][n4] = (float)((double)0.001f / Math.cos(d3) / (double)fArray[intPtr.val]);
                        } else {
                            fArray12[n3][n4] = (float)((double)f2 * Math.tan(d3));
                            fArray13[n3][n4] = (float)((double)f2 / Math.cos(d3) / (double)fArray[intPtr.val]);
                        }
                        if (!(floatPtr.val - fArray4[n3] > 0.0f)) continue;
                        fArray11[n3][n4] = -fArray11[n3][n4];
                    }
                    fArray14[n3] = 1.0f / fArray[intPtr.val];
                    fArray15[n3] = 0.0f;
                    fArray16[n3] = 0.0f;
                    nArray3[n3] = intPtr.val;
                    if (floatPtr.val - fArray4[n3] > 0.0f) {
                        fArray14[n3] = -fArray14[n3];
                    }
                    fArray8[n3][intPtr.val] = fArray13[n3][0];
                    fArray5[n3][intPtr.val] = fArray13[n3][0];
                    fArray6[n3][intPtr.val] = 1.0f / fArray[intPtr.val];
                    continue;
                }
                if (intPtr.val > nArray[n3]) {
                    this.debugPrint(n5, intPtr, nArray[n3], "Case B2:station above source");
                    fArray19[n3][0][0] = 0.0f;
                    n6 = 1;
                    f9 = floatPtr.val / fArray[intPtr.val];
                    fArray19[n3][0][n6] = 0.0f;
                    fArray17[n3][intPtr.val][n6] = 0.0f;
                    fArray18[n3][intPtr.val][n6] = fArray18[n3][intPtr.val][n6 - 1] - floatPtr.val;
                    for (n4 = intPtr.val - 1; n4 > nArray[n3]; --n4) {
                        f9 += fArray2[n4] / fArray[n4];
                        fArray19[n3][0][++n6] = 0.0f;
                        fArray17[n3][intPtr.val][n6] = 0.0f;
                        fArray18[n3][intPtr.val][n6] = fArray18[n3][intPtr.val][n6 - 1] - fArray2[n4];
                    }
                    f9 += f4 / fArray[nArray[n3]];
                    fArray19[n3][0][++n6] = 0.0f;
                    fArray17[n3][intPtr.val][n6] = 0.0f;
                    fArray18[n3][intPtr.val][n6] = fArray18[n3][intPtr.val][n6 - 1] - f4;
                    if (++n6 < 10) {
                        fArray19[n3][0][n6] = -1.0f;
                    }
                    if (n6 < 20) {
                        fArray17[n3][intPtr.val][n6] = -1.0f;
                        fArray18[n3][intPtr.val][n6] = -1.0f;
                    }
                    fArray8[n3][intPtr.val] = f9;
                    fArray5[n3][intPtr.val] = f9;
                    fArray6[n3][intPtr.val] = 1.0f / fArray[intPtr.val];
                    fArray13[n3][0] = f9;
                    fArray12[n3][0] = 0.0f;
                    fArray11[n3][0] = 0.0f;
                    nArray3[n3] = intPtr.val;
                    fArray14[n3] = 1.0f / fArray[intPtr.val];
                    d4 = d2 / Math.pow(n2, 1.5);
                    for (n4 = intPtr.val - 1; n4 >= nArray[n3]; --n4) {
                        if (!(fArray[n4] > fArray[nArray3[n3]])) continue;
                        nArray3[n3] = n4;
                    }
                    if (nArray3[n3] != intPtr.val) {
                        fArray14[n3] = 1.0f / fArray[nArray3[n3]];
                        d = Math.asin(fArray[intPtr.val] * fArray14[n3]);
                        d4 = Math.tan(d) / Math.pow(n2, 1.5);
                    }
                    d3 = Math.atan(d4);
                    f15 = (float)(Math.sin(d3) / (double)fArray[intPtr.val]);
                    f10 = (float)((double)floatPtr.val * Math.tan(d3));
                    for (n4 = intPtr.val - 1; n4 > nArray[n3]; --n4) {
                        d3 = Math.asin(fArray[n4] * f15);
                        f10 = (float)((double)f10 + (double)fArray2[n4] * Math.tan(d3));
                    }
                    d3 = Math.asin(fArray[nArray[n3]] * f15);
                    f10 = (float)((double)f10 + (double)f4 * Math.tan(d3));
                    if (f > 10.0f && f10 > f / 200.0f) {
                        d4 *= (double)(f / 200.0f / f10);
                    }
                    d3 = Math.atan(d4 * Math.pow(n2 - 1, 1.5));
                    f15 = (float)(Math.sin(d3) / (double)fArray[intPtr.val]);
                    f10 = (float)((double)floatPtr.val * Math.tan(d3));
                    for (n4 = intPtr.val - 1; n4 > nArray[n3]; --n4) {
                        d3 = Math.asin(fArray[n4] * f15);
                        f10 = (float)((double)f10 + (double)fArray2[n4] * Math.tan(d3));
                    }
                    d3 = Math.asin(fArray[nArray[n3]] * f15);
                    if ((f10 = (float)((double)f10 + (double)f4 * Math.tan(d3))) < 3.0f * f6) {
                        d4 = nArray3[n3] != intPtr.val ? Math.tan(d) / Math.pow((double)n2 - 0.5, 1.5) : 3.0 * d2 / Math.pow(n2, 1.5);
                    }
                    f14 = 0.0f;
                    f13 = 0.0f;
                    fArray20[n3][0] = 0.0f;
                    for (n4 = 1; n4 < n2; ++n4) {
                        fArray19[n3][n4][0] = 0.0f;
                        n6 = 1;
                        d3 = Math.atan(d4 * Math.pow(n4, 1.5));
                        fArray11[n3][n4] = (float)(Math.sin(d3) / (double)fArray[intPtr.val]);
                        f10 = (float)((double)floatPtr.val * Math.tan(d3));
                        f9 = (float)((double)floatPtr.val / Math.cos(d3) / (double)fArray[intPtr.val]);
                        fArray19[n3][n4][n6] = f10;
                        if (n4 == n2 - 1) {
                            if (intPtr.val != nArray3[n3]) {
                                f14 = f10;
                                f13 = f9;
                            }
                            fArray20[n3][n6] = f14;
                        }
                        for (n9 = intPtr.val - 1; n9 > nArray[n3]; --n9) {
                            d3 = Math.asin(fArray[n9] * fArray11[n3][n4]);
                            f12 = (float)((double)fArray2[n9] * Math.tan(d3));
                            f11 = (float)((double)fArray2[n9] / Math.cos(d3) / (double)fArray[n9]);
                            f9 += f11;
                            fArray19[n3][n4][++n6] = f10 += f12;
                            if (n4 != n2 - 1) continue;
                            if (n9 != nArray3[n3]) {
                                f14 += f12;
                                f13 += f11;
                            }
                            fArray20[n3][n6] = f14;
                        }
                        d3 = Math.asin(fArray[nArray[n3]] * fArray11[n3][n4]);
                        f12 = (float)((double)f4 * Math.tan(d3));
                        f11 = (float)((double)f4 / Math.cos(d3) / (double)fArray[nArray[n3]]);
                        f9 += f11;
                        fArray19[n3][n4][++n6] = f10 += f12;
                        if (n4 == n2 - 1) {
                            if (nArray[n3] != nArray3[n3]) {
                                f14 += f12;
                                f13 += f11;
                            }
                            fArray20[n3][n6] = f14;
                        }
                        if (++n6 < 10) {
                            fArray19[n3][n4][n6] = -1.0f;
                        }
                        fArray13[n3][n4] = f9;
                        fArray12[n3][n4] = f10;
                        fArray11[n3][n4] = -fArray11[n3][n4];
                    }
                    if (n6 < 10) {
                        fArray20[n3][n6] = -1.0f;
                    }
                    fArray15[n3] = f14;
                    fArray16[n3] = f13;
                    fArray14[n3] = -fArray14[n3];
                    continue;
                }
                this.debugPrint(n5, intPtr, nArray[n3], "Case B3:station below source");
                fArray19[n3][0][0] = 0.0f;
                n6 = 1;
                f9 = f5 / fArray[intPtr.val];
                fArray19[n3][0][n6] = 0.0f;
                fArray17[n3][intPtr.val][n6] = 0.0f;
                fArray18[n3][intPtr.val][n6] = fArray18[n3][intPtr.val][n6 - 1] + f5;
                for (n4 = intPtr.val + 1; n4 < nArray[n3]; ++n4) {
                    f9 += fArray2[n4] / fArray[n4];
                    fArray19[n3][0][++n6] = 0.0f;
                    fArray17[n3][intPtr.val][n6] = 0.0f;
                    fArray18[n3][intPtr.val][n6] = fArray18[n3][intPtr.val][n6 - 1] + fArray2[n4];
                }
                f9 += fArray4[n3] / fArray[nArray[n3]];
                fArray19[n3][0][++n6] = 0.0f;
                fArray17[n3][intPtr.val][n6] = 0.0f;
                fArray18[n3][intPtr.val][n6] = fArray18[n3][intPtr.val][n6 - 1] + fArray4[n3];
                if (++n6 < 10) {
                    fArray19[n3][0][n6] = -1.0f;
                }
                if (n6 < 20) {
                    fArray17[n3][intPtr.val][n6] = -1.0f;
                    fArray18[n3][intPtr.val][n6] = -1.0f;
                }
                fArray8[n3][intPtr.val] = f9;
                fArray5[n3][intPtr.val] = f9;
                fArray6[n3][intPtr.val] = 1.0f / fArray[intPtr.val];
                fArray13[n3][0] = f9;
                fArray12[n3][0] = 0.0f;
                fArray11[n3][0] = 0.0f;
                nArray3[n3] = intPtr.val;
                fArray14[n3] = 1.0f / fArray[nArray3[n3]];
                d4 = d2 / Math.pow(n2, 1.5);
                for (n4 = intPtr.val + 1; n4 <= nArray[n3]; ++n4) {
                    if (!(fArray[n4] > fArray[nArray3[n3]])) continue;
                    nArray3[n3] = n4;
                }
                if (nArray3[n3] != intPtr.val) {
                    fArray14[n3] = 1.0f / fArray[nArray3[n3]];
                    d = Math.asin(fArray[intPtr.val] * fArray14[n3]);
                    d4 = Math.tan(d) / Math.pow(n2, 1.5);
                }
                d3 = Math.atan(d4);
                f15 = (float)(Math.sin(d3) / (double)fArray[intPtr.val]);
                f10 = (float)((double)f5 * Math.tan(d3));
                for (n4 = intPtr.val + 1; n4 < nArray[n3]; ++n4) {
                    d3 = Math.asin(fArray[n4] * f15);
                    f10 = (float)((double)f10 + (double)fArray2[n4] * Math.tan(d3));
                }
                d3 = Math.asin(fArray[nArray[n3]] * f15);
                f10 = (float)((double)f10 + (double)fArray4[n3] * Math.tan(d3));
                if (f > 10.0f && f10 > f / 200.0f) {
                    d4 *= (double)(f / 200.0f / f10);
                }
                d3 = Math.atan(d4 * Math.pow(n2 - 1, 1.5));
                f15 = (float)(Math.sin(d3) / (double)fArray[intPtr.val]);
                f10 = (float)((double)f5 * Math.tan(d3));
                for (n4 = intPtr.val + 1; n4 < nArray[n3]; ++n4) {
                    d3 = Math.asin(fArray[n4] * f15);
                    f10 = (float)((double)f10 + (double)fArray2[n4] * Math.tan(d3));
                }
                d3 = Math.asin(fArray[nArray[n3]] * f15);
                if ((f10 = (float)((double)f10 + (double)fArray4[n3] * Math.tan(d3))) < 3.0f * f6) {
                    if (nArray3[n3] != intPtr.val) {
                        fArray14[n3] = 1.0f / fArray[nArray3[n3]];
                        d = Math.asin(fArray[intPtr.val] * fArray14[n3]);
                        d4 = Math.tan(d) / Math.pow((double)n2 - 0.9, 1.5);
                    } else {
                        d4 = 3.0 * d2 / Math.pow(n2, 1.5);
                    }
                }
                f14 = 0.0f;
                f13 = 0.0f;
                fArray20[n3][0] = 0.0f;
                for (n4 = 1; n4 < n2; ++n4) {
                    fArray19[n3][n4][0] = 0.0f;
                    n6 = 1;
                    d3 = Math.atan(d4 * Math.pow(n4, 1.5));
                    fArray11[n3][n4] = (float)(Math.sin(d3) / (double)fArray[intPtr.val]);
                    f10 = (float)((double)f5 * Math.tan(d3));
                    f9 = (float)((double)f5 / Math.cos(d3) / (double)fArray[intPtr.val]);
                    fArray19[n3][n4][n6] = f10;
                    if (n4 == n2 - 1) {
                        if (intPtr.val != nArray3[n3]) {
                            f14 = f10;
                            f13 = f9;
                        }
                        fArray20[n3][n6] = f14;
                    }
                    for (n9 = intPtr.val + 1; n9 < nArray[n3]; ++n9) {
                        d3 = Math.asin(fArray[n9] * fArray11[n3][n4]);
                        f12 = (float)((double)fArray2[n9] * Math.tan(d3));
                        f11 = (float)((double)fArray2[n9] / Math.cos(d3) / (double)fArray[n9]);
                        f9 += f11;
                        fArray19[n3][n4][++n6] = f10 += f12;
                        if (n4 != n2 - 1) continue;
                        if (n9 != nArray3[n3]) {
                            f14 += f12;
                            f13 += f11;
                        }
                        fArray20[n3][n6] = f14;
                    }
                    d3 = Math.asin(fArray[nArray[n3]] * fArray11[n3][n4]);
                    f12 = (float)((double)fArray4[n3] * Math.tan(d3));
                    f11 = (float)((double)fArray4[n3] / Math.cos(d3) / (double)fArray[nArray[n3]]);
                    f9 += f11;
                    fArray19[n3][n4][++n6] = f10 += f12;
                    if (n4 == n2 - 1) {
                        if (nArray[n3] != nArray3[n3]) {
                            f14 += f12;
                            f13 += f11;
                        }
                        fArray20[n3][n6] = f14;
                    }
                    if (++n6 < 10) {
                        fArray19[n3][n4][n6] = -1.0f;
                    }
                    fArray13[n3][n4] = f9;
                    fArray12[n3][n4] = f10;
                }
                if (n6 < 10) {
                    fArray20[n3][n6] = -1.0f;
                }
                fArray15[n3] = f14;
                fArray16[n3] = f13;
                continue;
            }
            this.debugPrint(n5, intPtr, nArray[n3], "Case C: layer below source");
            if (n5 > nArray[n3]) {
                this.debugPrint(n5, intPtr, nArray[n3], "Case C1:layer below station");
                if (fArray[intPtr.val] >= fArray[n5]) {
                    this.debugPrintNan(n3, n5);
                    fArray6[n3][n5] = 1.1E20f;
                    fArray7[n3][n5] = 1.1E20f;
                    fArray8[n3][n5] = 1.1E20f;
                    fArray5[n3][n5] = 1.1E20f;
                    fArray17[n3][n5][1] = -1.0f;
                    fArray18[n3][n5][1] = -1.0f;
                    continue;
                }
                fArray6[n3][n5] = 1.0f / fArray[n5];
                f10 = 0.0f;
                f9 = 0.0f;
                f8 = 0.0f;
                bl = true;
                if (fArray[intPtr.val] > fArray[n5]) {
                    bl = false;
                } else {
                    d3 = Math.asin(fArray[intPtr.val] * fArray6[n3][n5]);
                    f10 = (float)((double)f10 + (double)f5 * Math.tan(d3));
                    f9 = (float)((double)f9 + (double)f5 / Math.cos(d3) / (double)fArray[intPtr.val]);
                    f8 += f5 / fArray[intPtr.val];
                    n6 = 1;
                    fArray17[n3][n5][n6] = f10;
                    fArray18[n3][n5][n6] = fArray18[n3][n5][n6 - 1] + f5;
                }
                for (n4 = intPtr.val + 1; n4 < n5; ++n4) {
                    if (fArray[n4] > fArray[n5] || !bl) {
                        bl = false;
                        continue;
                    }
                    d3 = Math.asin(fArray[n4] * fArray6[n3][n5]);
                    f10 = (float)((double)f10 + (double)fArray2[n4] * Math.tan(d3));
                    f9 = (float)((double)f9 + (double)fArray2[n4] / Math.cos(d3) / (double)fArray[n4]);
                    f8 += fArray2[n4] / fArray[n4];
                    fArray17[n3][n5][++n6] = f10;
                    fArray18[n3][n5][n6] = fArray18[n3][n5][n6 - 1] + fArray2[n4];
                }
                if (bl) {
                    f3 = n5 < n - 1 ? fArray2[n5] * 0.01f : fArray2[n5 - 1] * 0.01f;
                    float[] fArray23 = fArray18[n3][n5];
                    int n10 = n6++;
                    fArray23[n10] = fArray23[n10] + f3;
                    fArray17[n3][n5][n6] = fArray17[n3][n5][n6 - 1];
                    fArray18[n3][n5][n6] = fArray18[n3][n5][n6 - 1];
                }
                for (n4 = n5 - 1; n4 > nArray[n3]; --n4) {
                    if (fArray[n4] > fArray[n5] || !bl) {
                        bl = false;
                        continue;
                    }
                    d3 = Math.asin(fArray[n4] * fArray6[n3][n5]);
                    f10 = (float)((double)f10 + (double)fArray2[n4] * Math.tan(d3));
                    f9 = (float)((double)f9 + (double)fArray2[n4] / Math.cos(d3) / (double)fArray[n4]);
                    f8 += fArray2[n4] / fArray[n4];
                    fArray17[n3][n5][++n6] = f10;
                    fArray18[n3][n5][n6] = fArray18[n3][n5][n6 - 1] - fArray2[n4];
                    if (n4 != n5 - 1) continue;
                    float[] fArray24 = fArray18[n3][n5];
                    int n11 = n6;
                    fArray24[n11] = fArray24[n11] - f3;
                }
                if (fArray[nArray[n3]] > fArray[n5] || !bl) {
                    bl = false;
                } else {
                    d3 = Math.asin(fArray[nArray[n3]] * fArray6[n3][n5]);
                    f10 = (float)((double)f10 + (double)f4 * Math.tan(d3));
                    f9 = (float)((double)f9 + (double)f4 / Math.cos(d3) / (double)fArray[nArray[n3]]);
                    f8 += f4 / fArray[nArray[n3]];
                    fArray17[n3][n5][++n6] = f10;
                    float f16 = fArray3[n3];
                    if (f16 < 0.01f) {
                        f16 = 0.01f;
                    }
                    fArray18[n3][n5][n6] = f16;
                    if (++n6 < 20) {
                        fArray17[n3][n5][n6] = -1.0f;
                        fArray18[n3][n5][n6] = -1.0f;
                    }
                }
                if (bl) {
                    fArray7[n3][n5] = f10;
                    fArray8[n3][n5] = f9;
                    fArray5[n3][n5] = f8;
                    continue;
                }
                this.debugPrint("invalid");
                this.debugPrintNan(n3, n5);
                fArray7[n3][n5] = 1.1E20f;
                fArray8[n3][n5] = 1.1E20f;
                fArray5[n3][n5] = 1.1E20f;
                fArray17[n3][n5][1] = -1.0f;
                fArray18[n3][n5][1] = -1.0f;
                continue;
            }
            if (n5 == nArray[n3]) {
                this.debugPrint(n5, intPtr, nArray[n3], "Case C2:layer with station");
                this.debugPrintNan(n3, n5);
                fArray6[n3][n5] = 1.1E20f;
                fArray7[n3][n5] = 1.1E20f;
                fArray8[n3][n5] = 1.1E20f;
                fArray5[n3][n5] = 1.1E20f;
                fArray17[n3][n5][1] = -1.0f;
                fArray18[n3][n5][1] = -1.0f;
                continue;
            }
            this.debugPrint(n5, intPtr, nArray[n3], "Case C3:layer above station");
            this.debugPrintNan(n3, n5);
            fArray6[n3][n5] = 1.1E20f;
            fArray7[n3][n5] = 1.1E20f;
            fArray8[n3][n5] = 1.1E20f;
            fArray5[n3][n5] = 1.1E20f;
            fArray17[n3][n5][1] = -1.0f;
            fArray18[n3][n5][1] = -1.0f;
        }
        this.debugPrint("Raypath finished");
        if (n == 1) {
            fArray9[0] = fArray7[0];
            fArray10[0] = fArray8[0];
            nArray2[n3][0] = -1;
            return 0;
        }
        for (n5 = 0; n5 < n; ++n5) {
            fArray9[n3][n5] = 1.1E20f;
            fArray10[n3][n5] = 1.1E20f;
            nArray2[n3][n5] = -2;
        }
        fArray9[n3][intPtr.val] = 0.0f;
        fArray10[n3][intPtr.val] = fArray8[n3][intPtr.val];
        nArray2[n3][intPtr.val] = -1;
        float f17 = 1.1E20f;
        float f18 = 1.1E20f;
        for (n5 = 0; n5 < n; ++n5) {
            if (n5 == intPtr.val || !(fArray7[n3][n5] < 1.0E20f)) continue;
            if (nArray[n3] == intPtr.val) {
                f2 = floatPtr.val - fArray4[n3];
                float f19 = this.vp_layer[intPtr.val];
                float f20 = this.vp_layer[n5];
                float f21 = fArray7[n3][n5];
                float f22 = fArray8[n3][n5];
                float f23 = f2;
                float f24 = f19 * f19 - f20 * f20;
                float f25 = f19 * f19 * f20 * f22 - f21 * f19 * f19;
                float f26 = -f21 * f21 * f19 * f19 + 2.0f * f21 * f19 * f19 * f20 * f22 - f22 * f22 * f19 * f19 * f20 * f20 + f23 * f23 * f20 * f20;
                float f27 = f26 / f24 + f25 * f25 / (f24 * f24);
                floatPtr2.val = (float)((double)(-f25 / f24) + Math.sqrt(f27));
                floatPtr3.val = (floatPtr2.val - f21) / f20 + f22;
            } else {
                f2 = nArray3[n3] == intPtr.val ? (fArray14[n3] < 0.0f ? floatPtr.val : f5) : (nArray3[n3] == nArray[n3] ? (fArray14[n3] < 0.0f ? f4 : fArray4[n3]) : fArray2[nArray3[n3]]);
                this.cinterpolate(fArray12, fArray13, n2, fArray, n5, nArray3, fArray7, fArray8, floatPtr2, floatPtr3, fArray15[n3], fArray16[n3], f2, n3);
            }
            if (!(f17 > floatPtr2.val)) continue;
            f17 = floatPtr2.val;
            f18 = floatPtr3.val;
            nArray2[n3][intPtr.val] = n5;
        }
        if (nArray2[n3][intPtr.val] > -1) {
            n5 = nArray2[n3][intPtr.val];
            fArray9[n3][n5] = f17;
            fArray10[n3][n5] = f18;
            nArray2[n3][n5] = -1;
        }
        n5 = nArray2[n3][intPtr.val];
        while (n5 > -1) {
            int n12;
            f17 = 1.1E20f;
            f18 = 1.1E20f;
            for (n12 = 0; n12 < n; ++n12) {
                if (n12 == intPtr.val || n12 == n5 || !(fArray7[n3][n12] < 1.0E20f) || !(fArray[n5] < fArray[n12])) continue;
                floatPtr2.val = (fArray[n12] * fArray[n5] * (fArray8[n3][n12] - fArray8[n3][n5]) + fArray[n12] * fArray7[n3][n5] - fArray[n5] * fArray7[n3][n12]) / (fArray[n12] - fArray[n5]);
                floatPtr3.val = fArray8[n3][n12] + (floatPtr2.val - fArray7[n3][n12]) / fArray[n12];
                if (!(f17 > floatPtr2.val)) continue;
                f17 = floatPtr2.val;
                f18 = floatPtr3.val;
                nArray2[n3][n5] = n12;
            }
            n12 = nArray2[n3][n5];
            if (n12 > -1) {
                fArray9[n3][n12] = f17;
                fArray10[n3][n12] = f18;
                nArray2[n3][n12] = -1;
            }
            n5 = nArray2[n3][n5];
        }
        return 0;
    }

    private int ttlookup(float[][] fArray, float[][] fArray2, int n, float f, float f2, int n2, int n3) {
        int n4 = n;
        int n5 = 0;
        if (n2 == 1) {
            while (n4 > 1) {
                if (!(fArray[n3][n5 + (n4 /= 2)] < f)) continue;
                n5 += n4;
            }
            ++n5;
        } else {
            while (n4 > 1) {
                if (!(fArray2[n3][n5 + (n4 /= 2)] < f2)) continue;
                n5 += n4;
            }
            ++n5;
        }
        return n5;
    }

    private float dist2tt(float f, int n, float[] fArray, float[][] fArray2, float[][] fArray3, float[][] fArray4, float[][] fArray5, int n2, float[][] fArray6, float[][] fArray7, float[][] fArray8, int n3, float f2, float f3, float f4, int n4, int[][] nArray, int n5, float f5, int n6, float f6, FloatPtr floatPtr, int n7) {
        float f7;
        int n8;
        if (n < 1) {
            n8 = n5;
            int n9 = nArray[n7][n5];
            while (n9 > -1 && !(fArray4[n7][n9] > f)) {
                n8 = n9;
                n9 = nArray[n7][n8];
            }
        } else {
            n8 = n - 1;
            if (fArray2[n7][n8] > 1.0E20f) {
                return -1.0f;
            }
        }
        if (n8 == n5) {
            if (n8 == n6) {
                float f8 = f;
                float f9 = f5 - f6;
                f7 = (float)Math.sqrt(f8 * f8 + f9 * f9) / fArray[n5];
                double d = Math.atan2(f8, f9);
                floatPtr.val = (float)((double)(1.0f / this.vp_layer[n5]) * Math.sin(d));
            } else {
                int n10 = this.ttlookup(fArray7, fArray6, n3, -1.0f, f, 0, n7);
                if (n10 < n3 - 1) {
                    f7 = fArray7[n7][n10] + (f - fArray6[n7][n10]) / (fArray6[n7][n10 + 1] - fArray6[n7][n10]) * (fArray7[n7][n10 + 1] - fArray7[n7][n10]);
                    floatPtr.val = fArray8[n7][n10] + (f - fArray6[n7][n10]) / (fArray6[n7][n10 + 1] - fArray6[n7][n10]) * (fArray8[n7][n10 + 1] - fArray8[n7][n10]);
                } else {
                    f7 = (f - f3) / fArray[n4] + f4;
                    floatPtr.val = f2;
                }
            }
        } else {
            f7 = (f - fArray4[n7][n8]) / fArray[n8] + fArray5[n7][n8];
            floatPtr.val = 1.0f / fArray[n8];
        }
        return f7;
    }

    private int ttsimul(FloatPtr floatPtr, int n, int n2, int n3, FloatPtr floatPtr2, FloatPtr floatPtr3) {
        if (this.nlayer > 10) {
            return -1;
        }
        if (n3 < 0 || n3 > this.zclassmax) {
            return -2;
        }
        if (this.epiz_simul > (double)1.0E20f) {
            return 0;
        }
        if (Math.abs(this.epiz_simul - this.depth_simul) > 1.0E-6) {
            for (int i = 0; i < this.zclassmax + 1; ++i) {
                this.debugPrint("enter ttsetup");
                int n4 = this.ttsetup(this.vp_layer, this.d_layer, this.nlayer, (float)this.epiz_simul, this.zclassdepth, this.sourcesimullayer, this.dupsourcesimul, this.stationlayer, this.dupstation, this.trpsimul, this.prpsimul, this.x0psimul, this.t0psimul, this.xcpsimul, this.tcpsimul, this.lfolinkpsimul, this.ptabpsimul, this.xtabpsimul, this.ttabpsimul, 450, this.puppsimul, this.x0uppsimul, this.t0uppsimul, this.lruppsimul, this.xpathsPsimul, this.zpathsPsimul, this.xptabpsimul, this.xpguidedpsimul, i);
                if (n4 != 0) {
                    return n4;
                }
                if (this.vp2vs < 1.0f) {
                    this.debugPrint("enter ttsetup");
                    n4 = this.ttsetup(this.vs_layer, this.d_layer, this.nlayer, (float)this.epiz_simul, this.zclassdepth, this.sourcesimullayer, this.dupsourcesimul, this.stationlayer, this.dupstation, this.trssimul, this.prssimul, this.x0ssimul, this.t0ssimul, this.xcssimul, this.tcssimul, this.lfolinkssimul, this.ptabssimul, this.xtabssimul, this.ttabssimul, 450, this.pupssimul, this.x0upssimul, this.t0upssimul, this.lrupssimul, this.xpathsSsimul, this.zpathsSsimul, this.xptabssimul, this.xpguidedssimul, i);
                    if (n4 == 0) continue;
                    return n4;
                }
                for (n4 = 0; n4 < 10; ++n4) {
                    this.prssimul[i][n4] = this.prpsimul[i][n4] * this.vp2vs;
                    this.x0ssimul[i][n4] = this.x0psimul[i][n4];
                    this.t0ssimul[i][n4] = this.t0psimul[i][n4] * this.vp2vs;
                    this.xcssimul[i][n4] = this.xcpsimul[i][n4];
                    this.tcssimul[i][n4] = this.tcpsimul[i][n4] * this.vp2vs;
                    this.trssimul[i][n4] = this.trpsimul[i][n4] * this.vp2vs;
                    this.lfolinkssimul[i][n4] = this.lfolinkpsimul[i][n4];
                }
                for (n4 = 0; n4 < 450; ++n4) {
                    this.ptabssimul[i][n4] = this.ptabpsimul[i][n4] * this.vp2vs;
                    this.xtabssimul[i][n4] = this.xtabpsimul[i][n4];
                    this.ttabssimul[i][n4] = this.ttabpsimul[i][n4] * this.vp2vs;
                }
                this.pupssimul[i] = this.puppsimul[i] * this.vp2vs;
                this.x0upssimul[i] = this.x0uppsimul[i];
                this.t0upssimul[i] = this.t0uppsimul[i] * this.vp2vs;
                this.lrupssimul[i] = this.lruppsimul[i];
                for (n4 = 0; n4 < 10; ++n4) {
                    for (int j = 0; j < 20; ++j) {
                        this.xpathsSsimul[i][n4][j] = this.xpathsPsimul[i][n4][j];
                        this.zpathsSsimul[i][n4][j] = this.zpathsPsimul[i][n4][j];
                    }
                }
            }
            this.depth_simul = this.epiz_simul;
        }
        if (n > this.nlayer) {
            return -4;
        }
        if (n2 == 0 || this.vp2vs >= 1.0f) {
            floatPtr2.val = this.dist2tt(floatPtr.val, n, this.vp_layer, this.x0psimul, this.t0psimul, this.xcpsimul, this.tcpsimul, this.nlayer, this.xtabpsimul, this.ttabpsimul, this.ptabpsimul, 450, this.puppsimul[n3], this.x0uppsimul[n3], this.t0uppsimul[n3], this.lruppsimul[n3], this.lfolinkpsimul, this.sourcesimullayer.val, this.dupsourcesimul.val, this.stationlayer[n3], this.dupstation[n3], floatPtr3, n3);
            if (n2 == 1) {
                floatPtr2.val *= this.vp2vs;
            }
        } else {
            floatPtr2.val = this.dist2tt(floatPtr.val, n, this.vs_layer, this.x0ssimul, this.t0ssimul, this.xcssimul, this.tcssimul, this.nlayer, this.xtabssimul, this.ttabssimul, this.ptabssimul, 450, this.pupssimul[n3], this.x0upssimul[n3], this.t0upssimul[n3], this.lrupssimul[n3], this.lfolinkssimul, this.sourcesimullayer.val, this.dupsourcesimul.val, this.stationlayer[n3], this.dupstation[n3], floatPtr3, n3);
        }
        return 0;
    }

    void erase() {
        for (int i = 0; i < this.nstatlist; ++i) {
            this.psimul[i] = 0.0;
            this.ssimul[i] = 0.0;
            this.pgsimul[i] = 0.0;
            this.lgsimul[i] = 0.0;
        }
    }

    public void episimul(int n, float f, float f2, float f3, float f4, int n2) {
        LogUtil.info(this.getClass(), (String)("Start Simulation for epidepth_simul=" + f4));
        if (!this.layerModelValid) {
            return;
        }
        this.epix_simul = f2;
        this.epiy_simul = f3;
        this.epiz_simul = f4;
        if (this.epiz_simul < 0.0) {
            LogUtil.warn(this.getClass(), (String)"Source depth is above highest zClass! Source moved down for simulation.");
        }
        this.epiz_simul = Math.max(this.epiz_simul, (double)1.4E-45f);
        FloatPtr floatPtr = new FloatPtr(1.0f);
        FloatPtr floatPtr2 = new FloatPtr();
        FloatPtr floatPtr3 = new FloatPtr();
        if (this.epix_simul > (double)1.0E20f && this.epiy_simul > (double)1.0E20f) {
            this.erase();
            return;
        }
        this.debugPrint("enter ttsimul");
        this.ttsimul(floatPtr, -1, 0, 0, floatPtr2, floatPtr3);
        for (int i = 0; i < this.nstatlist; ++i) {
            double d;
            double d2 = this.epix_simul - (double)this.statlocx[i];
            d2 *= d2;
            double d3 = this.epiy_simul - (double)this.statlocy[i];
            d3 *= d3;
            floatPtr.val = (float)Math.sqrt(d2 + d3);
            if (this.pnlayer == -1) {
                this.locreg = 0;
                this.slocreg[i] = 0;
            } else {
                this.slocreg[i] = this.locreg == 0 ? (floatPtr.val > this.xcpsimul[this.zclass[i]][this.pnlayer - 1] && this.pnlayer - 1 > this.sourcesimullayer.val ? 1 : -1) : (floatPtr.val <= this.xcpsimul[this.zclass[i]][this.pnlayer - 1] || this.pnlayer - 1 <= this.sourcesimullayer.val ? 0 : -1);
            }
            if (this.locreg == 0 && this.slocreg[i] == -1 || this.slocreg[i] == 0) {
                this.debugPrint("enter ttsimul");
                this.ttsimul(floatPtr, -1, 0, this.zclass[i], floatPtr2, floatPtr3);
                this.psimul[i] = d = Math.floor((double)floatPtr2.val * (double)f + 0.5) / (double)f;
                if (this.vp2vs >= 1.0f) {
                    floatPtr2.val *= this.vp2vs;
                } else {
                    this.debugPrint("enter ttsimul");
                    this.ttsimul(floatPtr, -1, 1, this.zclass[i], floatPtr2, floatPtr3);
                }
                this.ssimul[i] = d = Math.floor((double)floatPtr2.val * (double)f + 0.5) / (double)f;
                this.pgsimul[i] = 0.0;
                this.lgsimul[i] = 0.0;
                continue;
            }
            this.debugPrint("enter ttsimul");
            this.ttsimul(floatPtr, this.pnlayer, 0, this.zclass[i], floatPtr2, floatPtr3);
            if (floatPtr2.val >= 0.0f) {
                this.psimul[i] = d = Math.floor((double)floatPtr2.val * (double)f + 0.5) / (double)f;
                if (this.vp2vs >= 1.0f) {
                    floatPtr2.val *= this.vp2vs;
                } else {
                    this.debugPrint("enter ttsimul");
                    this.ttsimul(floatPtr, this.pnlayer, 1, this.zclass[i], floatPtr2, floatPtr3);
                }
                this.ssimul[i] = d = Math.floor((double)floatPtr2.val * (double)f + 0.5) / (double)f;
                floatPtr2.val *= 1.08f;
                this.lgsimul[i] = d = Math.floor((double)floatPtr2.val * (double)f + 0.5) / (double)f;
            } else {
                this.psimul[i] = 0.0;
                this.ssimul[i] = 0.0;
                this.lgsimul[i] = 0.0;
            }
            this.debugPrint("enter ttsimul");
            this.ttsimul(floatPtr, this.pglayer, 0, this.zclass[i], floatPtr2, floatPtr3);
            if (!(floatPtr2.val >= 0.0f)) continue;
            this.pgsimul[i] = d = Math.floor((double)floatPtr2.val * (double)f + 0.5) / (double)f;
            if (!(this.lgsimul[i] < 1.0E-20)) continue;
            if (this.vp2vs >= 1.0f) {
                floatPtr2.val *= this.vp2vs;
            } else {
                this.debugPrint("enter ttsimul");
                this.ttsimul(floatPtr, this.pglayer, 1, this.zclass[i], floatPtr2, floatPtr3);
            }
            floatPtr2.val *= 1.08f;
            this.lgsimul[i] = d = Math.floor((double)floatPtr2.val * (double)f + 0.5) / (double)f;
        }
        if (n2 > -1 && (this.locreg == 0 && this.slocreg[n2] == -1 || this.slocreg[n2] == 0 || n == 0 || n == 1) && this.psimul[n2] < 1.0E-20) {
            this.erase();
            return;
        }
    }

    private float tt2dist(float f, int n, float[] fArray, float[][] fArray2, float[][] fArray3, float[][] fArray4, float[][] fArray5, int n2, float[][] fArray6, float[][] fArray7, int n3, float f2, float f3, int n4, int[][] nArray, int n5, float f4, int n6, float f5, int n7) {
        int n8;
        float f6 = -1.0f;
        if (n < 1) {
            n8 = n5;
            int n9 = nArray[n7][n5];
            while (n9 > -1 && !(fArray5[n7][n9] > f)) {
                n8 = n9;
                n9 = nArray[n7][n8];
            }
        } else {
            n8 = n - 1;
            if (fArray3[n7][n8] > 1.0E20f) {
                return -1.0f;
            }
        }
        if (n8 == n5) {
            if (n8 == n6) {
                float f7 = f * fArray[n5];
                float f8 = f4 - f5;
                f6 = (f7 *= f7) >= (f8 *= f8) ? (float)Math.sqrt(f7 - f8) : -1.0f;
            } else {
                int n10 = this.ttlookup(fArray7, fArray6, n3, f, -1.0f, 1, n7);
                f6 = n10 < n3 - 1 ? fArray6[n7][n10] + (f - fArray7[n7][n10]) / (fArray7[n7][n10 + 1] - fArray7[n7][n10]) * (fArray6[n7][n10 + 1] - fArray6[n7][n10]) : (f - f3) * fArray[n4] + f2;
            }
        } else {
            f6 = (f - fArray5[n7][n8]) * fArray[n8] + fArray4[n7][n8];
        }
        return f6;
    }

    private int ttcalc(FloatPtr floatPtr, int n, int n2, int n3, int n4, FloatPtr floatPtr2) {
        int n5;
        int n6;
        FloatPtr floatPtr3 = new FloatPtr();
        if (this.nlayer > 10) {
            return -1;
        }
        if (n4 < 0 || n4 > this.zclassmax) {
            return -2;
        }
        if (Math.abs(this.epiz_force - this.depth_force) > 1.0E-6) {
            for (n6 = 0; n6 < this.zclassmax + 1; ++n6) {
                this.debugPrint("enter ttsetup");
                int n7 = this.ttsetup(this.vp_layer, this.d_layer, this.nlayer, (float)this.epiz_force, this.zclassdepth, this.sourceforcelayer, this.dupsourceforce, this.stationlayer, this.dupstation, this.trp, this.prp, this.x0p, this.t0p, this.xcp, this.tcp, this.lfolinkp, this.ptabp, this.xtabp, this.ttabp, 450, this.pupp, this.x0upp, this.t0upp, this.lrupp, this.xpathsP, this.zpathsP, this.xptabl, this.xpguidedl, n6);
                if (n7 != 0) {
                    return n7;
                }
                if (this.vp2vs < 1.0f) {
                    this.debugPrint("enter ttsetup");
                    n7 = this.ttsetup(this.vs_layer, this.d_layer, this.nlayer, (float)this.epiz_force, this.zclassdepth, this.sourceforcelayer, this.dupsourceforce, this.stationlayer, this.dupstation, this.trs, this.prs, this.x0s, this.t0s, this.xcs, this.tcs, this.lfolinks, this.ptabs, this.xtabs, this.ttabs, 450, this.pups, this.x0ups, this.t0ups, this.lrups, this.xpathsS, this.zpathsS, this.xptabl, this.xpguidedl, n6);
                    if (n7 == 0) continue;
                    return n7;
                }
                for (n5 = 0; n5 < 10; ++n5) {
                    this.prs[n6][n5] = this.prp[n6][n5] * this.vp2vs;
                    this.x0s[n6][n5] = this.x0p[n6][n5];
                    this.t0s[n6][n5] = this.t0p[n6][n5] * this.vp2vs;
                    this.xcs[n6][n5] = this.xcp[n6][n5];
                    this.tcs[n6][n5] = this.tcp[n6][n5] * this.vp2vs;
                    this.trs[n6][n5] = this.trp[n6][n5] * this.vp2vs;
                    this.lfolinks[n6][n5] = this.lfolinkp[n6][n5];
                }
                for (n5 = 0; n5 < 450; ++n5) {
                    this.ptabs[n6][n5] = this.ptabp[n6][n5] * this.vp2vs;
                    this.xtabs[n6][n5] = this.xtabp[n6][n5];
                    this.ttabs[n6][n5] = this.ttabp[n6][n5] * this.vp2vs;
                }
                this.pups[n6] = this.pupp[n6] * this.vp2vs;
                this.x0ups[n6] = this.x0upp[n6];
                this.t0ups[n6] = this.t0upp[n6] * this.vp2vs;
                this.lrups[n6] = this.lrupp[n6];
                for (n5 = 0; n5 < 10; ++n5) {
                    for (int i = 0; i < 20; ++i) {
                        this.xpathsS[n6][n5][i] = this.xpathsP[n6][n5][i];
                        this.zpathsS[n6][n5][i] = this.zpathsP[n6][n5][i];
                    }
                }
            }
            this.depth_force = this.epiz_force;
            for (n6 = 0; n6 < 10; ++n6) {
                this.x0[n6] = this.x0p[0][n6];
                this.t0[n6] = this.t0p[0][n6];
                this.xc[n6] = this.xcp[0][n6];
                this.tc[n6] = this.tcp[0][n6];
            }
        }
        if (n > this.nlayer) {
            return -4;
        }
        if (n3 == 0) {
            if (n2 == 0 || this.vp2vs >= 1.0f) {
                floatPtr2.val = this.dist2tt(floatPtr.val, n, this.vp_layer, this.x0p, this.t0p, this.xcp, this.tcp, this.nlayer, this.xtabp, this.ttabp, this.ptabp, 450, this.pupp[n4], this.x0upp[n4], this.t0upp[n4], this.lrupp[n4], this.lfolinkp, this.sourceforcelayer.val, this.dupsourceforce.val, this.stationlayer[n4], this.dupstation[n4], floatPtr3, n4);
                if (n2 == 1) {
                    floatPtr2.val *= this.vp2vs;
                }
            } else {
                floatPtr2.val = this.dist2tt(floatPtr.val, n, this.vs_layer, this.x0s, this.t0s, this.xcs, this.tcs, this.nlayer, this.xtabs, this.ttabs, this.ptabs, 450, this.pups[n4], this.x0ups[n4], this.t0ups[n4], this.lrups[n4], this.lfolinks, this.sourceforcelayer.val, this.dupsourceforce.val, this.stationlayer[n4], this.dupstation[n4], floatPtr3, n4);
            }
        } else if (n3 == 1) {
            float f = floatPtr2.val;
            if (f <= 0.0f) {
                floatPtr.val = -1.0f;
                return 0;
            }
            if (n2 == 0 || this.vp2vs >= 1.0f) {
                if (n2 == 1) {
                    f /= this.vp2vs;
                }
                floatPtr.val = this.tt2dist(f, n, this.vp_layer, this.x0p, this.t0p, this.xcp, this.tcp, this.nlayer, this.xtabp, this.ttabp, 450, this.x0upp[n4], this.t0upp[n4], this.lrupp[n4], this.lfolinkp, this.sourceforcelayer.val, this.dupsourceforce.val, this.stationlayer[n4], this.dupstation[n4], n4);
            } else {
                floatPtr.val = this.tt2dist(f, n, this.vs_layer, this.x0s, this.t0s, this.xcs, this.tcs, this.nlayer, this.xtabs, this.ttabs, 450, this.x0ups[n4], this.t0ups[n4], this.lrups[n4], this.lfolinks, this.sourceforcelayer.val, this.dupsourceforce.val, this.stationlayer[n4], this.dupstation[n4], n4);
            }
        } else if (n3 == 2) {
            if (this.vp2vs > 1.0f) {
                float f = floatPtr2.val / (this.vp2vs - 1.0f);
                if (f <= 0.0f) {
                    floatPtr.val = -1.0f;
                    return 0;
                }
                floatPtr.val = this.tt2dist(f, n, this.vp_layer, this.x0p, this.t0p, this.xcp, this.tcp, this.nlayer, this.xtabp, this.ttabp, 450, this.x0upp[n4], this.t0upp[n4], this.lrupp[n4], this.lfolinkp, this.sourceforcelayer.val, this.dupsourceforce.val, this.stationlayer[n4], this.dupstation[n4], n4);
            } else {
                float f = floatPtr2.val / 0.78f;
                if (f <= 0.0f) {
                    floatPtr.val = -1.0f;
                    return 0;
                }
                float f2 = this.tt2dist(f, n, this.vp_layer, this.x0p, this.t0p, this.xcp, this.tcp, this.nlayer, this.xtabp, this.ttabp, 450, this.x0upp[n4], this.t0upp[n4], this.lrupp[n4], this.lfolinkp, this.sourceforcelayer.val, this.dupsourceforce.val, this.stationlayer[n4], this.dupstation[n4], n4);
                n6 = 0;
                for (n5 = 0; n5 < 100; ++n5) {
                    float f3 = this.dist2tt(f2, n, this.vp_layer, this.x0p, this.t0p, this.xcp, this.tcp, this.nlayer, this.xtabp, this.ttabp, this.ptabp, 450, this.pupp[n4], this.x0upp[n4], this.t0upp[n4], this.lrupp[n4], this.lfolinkp, this.sourceforcelayer.val, this.dupsourceforce.val, this.stationlayer[n4], this.dupstation[n4], floatPtr3, n4);
                    float f4 = this.dist2tt(f2, n, this.vs_layer, this.x0s, this.t0s, this.xcs, this.tcs, this.nlayer, this.xtabs, this.ttabs, this.ptabs, 450, this.pups[n4], this.x0ups[n4], this.t0ups[n4], this.lrups[n4], this.lfolinks, this.sourceforcelayer.val, this.dupsourceforce.val, this.stationlayer[n4], this.dupstation[n4], floatPtr3, n4);
                    float f5 = floatPtr2.val - (f4 - f3);
                    if (Math.abs(f5) < floatPtr2.val * 0.02f) {
                        n6 = 1;
                        break;
                    }
                    float f6 = Math.abs(f5) / 0.79999995f * 3.0f;
                    if (f5 < 0.0f) {
                        f2 -= f6;
                        continue;
                    }
                    f2 += f6;
                }
                if (n6 == 0) {
                    // empty if block
                }
                floatPtr.val = f2;
            }
        } else if (n3 != 3) {
            return -5;
        }
        return 0;
    }

    public int hyperbola(float f, float f2, int n, float f3, float f4, int n2, float[] fArray, float[] fArray2, int n3, double d, double d2, float f5, float f6) {
        if (!this.layerModelValid) {
            return -10;
        }
        int n4 = 0;
        FloatPtr floatPtr = this._hyperbolae_r1;
        FloatPtr floatPtr2 = this._hyperbolae_r2;
        FloatPtr floatPtr3 = this._hyperbolae_td1;
        FloatPtr floatPtr4 = this._hyperbolae_td2;
        if (n3 % 2 != 0) {
            return 0;
        }
        if ((double)Math.abs(f - f3) < 1.0E-10 && (double)Math.abs(f2 - f4) < 1.0E-10) {
            return 0;
        }
        int n5 = n3 / 2;
        double d3 = ((double)f5 - (double)f6) / (double)n5;
        float f7 = f3 - f;
        float f8 = f4 - f2;
        double d4 = d < d2 ? d : d2;
        int n6 = 0;
        int n7 = 0;
        double d5 = d4 - (double)f6 - d3 * (double)(n7 + 1);
        while (n7 < n5 && n6 < n5) {
            floatPtr3.val = (float)(d - d5);
            floatPtr4.val = (float)(d2 - d5);
            this.ttcalc(floatPtr, -1, 0, 1, n, floatPtr3);
            this.ttcalc(floatPtr2, -1, 0, 1, n2, floatPtr4);
            if (floatPtr.val > 0.0f && floatPtr2.val > 0.0f) {
                floatPtr.val *= floatPtr.val;
                floatPtr2.val *= floatPtr2.val;
                float f9 = f7 * f7 + f8 * f8;
                float f10 = (floatPtr.val - floatPtr2.val) / f9;
                float f11 = (f10 - 1.0f) / 2.0f;
                float f12 = 0.0f;
                float f13 = (floatPtr2.val - f11 * f11 * f9 - f12) / f9;
                if (f13 > 0.0f) {
                    if (n4 == 0) {
                        if ((d5 += 0.9 * d3) >= d4 - (double)f6) {
                            d5 = d4 - (double)f6 - 0.1 * d3;
                        }
                        n4 = 1;
                        continue;
                    }
                    f13 = (float)Math.sqrt(f13);
                    fArray[n5 - 1 - n6] = f3 + f11 * f7 + f13 * f8;
                    fArray2[n5 - 1 - n6] = f4 + f11 * f8 - f13 * f7;
                    fArray[n5 + n6] = f3 + f11 * f7 - f13 * f8;
                    fArray2[n5 + n6] = f4 + f11 * f8 + f13 * f7;
                    ++n6;
                    if (n4 < 9) {
                        ++n4;
                    }
                }
            }
            if (n4 < 9) {
                if ((d5 -= 0.1 * d3) <= d4 - (double)f6 - d3 * (double)(n7 + 2)) {
                    ++n7;
                }
                if (n7 < n5 / 4) continue;
            }
            d5 = d4 - (double)f6 - d3 * (double)(++n7 + 1);
        }
        return n6;
    }

    public int calcRadius(int n, double d, double d2, double d3) {
        if (!this.layerModelValid) {
            return -10;
        }
        if (n < 0 || n >= this.nstatlist) {
            this.spReset();
            return -1;
        }
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            this.spReset();
            return -2;
        }
        int n2 = n;
        this._calcRadius_td.val = (float)(d2 - d);
        this.ttcalc(this._calcRadius_radius, -1, 0, 2, this.zclass[n2], this._calcRadius_td);
        if (this._calcRadius_radius.val > 0.0f) {
            this.ttcalc(this._calcRadius_radius, -1, 0, 0, this.zclass[n2], this._calcRadius_td);
            this.sp_radius = this._calcRadius_radius.val;
            this.sp_td = Math.floor((double)this._calcRadius_td.val * d3 + 0.5) / d3;
            return 0;
        }
        this.spReset();
        return -3;
    }

    public int circle(float f, float f2, float[] fArray, float[] fArray2, int n, float f3) {
        if (f3 < 0.01f) {
            return 0;
        }
        int n2 = f3 < 10.0f ? n / 4 : (f3 < 50.0f ? n / 2 : n);
        double d = 0.0;
        double d2 = Math.PI * 2 / (double)n2;
        for (int i = 0; i < n2; ++i) {
            fArray[i] = f + f3 * (float)Math.cos(d);
            fArray2[i] = f2 + f3 * (float)Math.sin(d);
            d += d2;
        }
        return n2;
    }

    void updateradius(int n) {
        throw new UnsupportedOperationException("public double[] getPrays() is not implementeds");
    }

    private int layerstack(double d, double d2, double d3, float f) {
        throw new UnsupportedOperationException("public double[] getPrays() is not implementeds");
    }

    public double[] getPsimul() {
        return this.psimul;
    }

    public double[] getPrays() {
        throw new UnsupportedOperationException("public double[] getPrays() is not implementeds");
    }

    public double[] getSsimul() {
        return this.ssimul;
    }

    public String printLayer(int n, String string) {
        return "printLayer not implemented";
    }

    private boolean hypermatch(float f, float f2, int n, float f3, float f4, int n2, FloatPtr floatPtr, FloatPtr floatPtr2, float f5, float f6, float f7, float f8) {
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        this._hypermatch_t1.val = f5;
        this._hypermatch_t2.val = f6;
        float f14 = f3 - f;
        float f15 = f4 - f2;
        this.ttcalc(this._hypermatch_r1, -1, 0, 1, n, this._hypermatch_t1);
        this.ttcalc(this._hypermatch_r2, -1, 0, 1, n2, this._hypermatch_t2);
        float f16 = this._hypermatch_r1.val;
        float f17 = this._hypermatch_r2.val;
        if (f16 > 0.0f && f17 > 0.0f && (f13 = ((f17 *= f17) - (f12 = ((f11 = ((f16 *= f16) - f17) / (f10 = f14 * f14 + f15 * f15)) - 1.0f) / 2.0f) * f12 * f10 - (f9 = 0.0f)) / f10) > 0.0f) {
            int n3;
            f13 = (float)Math.sqrt(f13);
            if (f14 != 0.0f) {
                float f18 = f15 / f14;
                float f19 = f2 - f18 * f;
                n3 = f18 * f7 + f19 - f8 > 0.0f ? 1 : -1;
                if (f14 < 0.0f) {
                    n3 *= -1;
                }
            } else {
                n3 = f15 > 0.0f && f7 >= f || f15 < 0.0f && f7 <= f ? 1 : -1;
            }
            if (n3 == 1) {
                floatPtr.val = f3 + f12 * f14 + f13 * f15;
                floatPtr2.val = f4 + f12 * f15 - f13 * f14;
            } else {
                floatPtr.val = f3 + f12 * f14 - f13 * f15;
                floatPtr2.val = f4 + f12 * f15 + f13 * f14;
            }
            return false;
        }
        return true;
    }

    public float hypolocme(int n, double[] dArray, double[] dArray2, float f, float f2, float f3, double d) {
        if (!this.layerModelValid) {
            return -10.0f;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.0f;
        float f19 = 0.0f;
        float f20 = 0.0f;
        this._hypolocme_t1.val = 0.0f;
        this._hypolocme_t2.val = 0.0f;
        f20 = 0.0f;
        f14 = (float)this.epiz_force;
        for (n6 = 0; n6 < this.nlayer; ++n6) {
            if (f14 > this.d_layer[n6]) {
                f20 += this.d_layer[n6] / this.vp_layer[n6];
                f14 -= this.d_layer[n6];
                continue;
            }
            f20 += f14 / this.vp_layer[n6];
            break;
        }
        this.xprsd_me = 0.0f;
        this.yprsd_me = 0.0f;
        this.recti_me = -1.0f;
        for (n2 = 1; n2 <= this.nstatlist; ++n2) {
            n3 = n2;
            if (n3 < 0 || n3 >= this.nstatlist) {
                return Float.NaN;
            }
            for (n4 = n2 + 1; n4 <= this.nstatlist; ++n4) {
                n5 = n4;
                if (!(dArray2[n3] > 1.0E-20) || !(dArray2[n5] > 1.0E-20) || !(dArray[n3] > 1.0E-20) || !(dArray[n5] > 1.0E-20) || !(d > 1.0E-20)) continue;
                f4 = f - this.statlocx[n3];
                f5 = f2 - this.statlocy[n3];
                this._hypolocme_r.val = (float)Math.sqrt(f4 * f4 + f5 * f5);
                this.ttcalc(this._hypolocme_r, -1, 0, 0, this.zclass[n3], this._hypolocme_t1);
                this._hypolocme_t1.val += f20;
                f4 = f - this.statlocx[n5];
                f5 = f2 - this.statlocy[n5];
                this._hypolocme_r.val = (float)Math.sqrt(f4 * f4 + f5 * f5);
                this.ttcalc(this._hypolocme_r, -1, 0, 0, this.zclass[n5], this._hypolocme_t2);
                this._hypolocme_t2.val += f20;
                f18 = (float)(dArray2[n5] - dArray2[n3]);
                f19 = (float)(dArray[n5] - dArray[n3]);
                f18 = f18 >= 0.0f ? (float)((int)(f18 * f3 + 0.5f)) / f3 : (float)((int)(f18 * f3 - 0.5f)) / f3;
                f19 = f19 >= 0.0f ? (float)((int)(f19 * f3 + 0.5f)) / f3 : (float)((int)(f19 * f3 - 0.5f)) / f3;
                if (this.hypermatch(this.statlocx[n3], this.statlocy[n3], this.zclass[n3], this.statlocx[n5], this.statlocy[n5], this.zclass[n5], this._hypolocme_xa1, this._hypolocme_ya1, this._hypolocme_t1.val, this._hypolocme_t1.val + f19, f, f2) || this.hypermatch(this.statlocx[n3], this.statlocy[n3], this.zclass[n3], this.statlocx[n5], this.statlocy[n5], this.zclass[n5], this._hypolocme_xa2, this._hypolocme_ya2, this._hypolocme_t1.val, this._hypolocme_t1.val + f18, f, f2) || this.hypermatch(this.statlocx[n3], this.statlocy[n3], this.zclass[n3], this.statlocx[n5], this.statlocy[n5], this.zclass[n5], this._hypolocme_xb1, this._hypolocme_yb1, this._hypolocme_t2.val - f19, this._hypolocme_t2.val, f, f2) || this.hypermatch(this.statlocx[n3], this.statlocy[n3], this.zclass[n3], this.statlocx[n5], this.statlocy[n5], this.zclass[n5], this._hypolocme_xb2, this._hypolocme_yb2, this._hypolocme_t2.val - f18, this._hypolocme_t2.val, f, f2)) continue;
                f15 = (f7 - f6 + (f9 - f8)) / 2.0f;
                f16 = (f11 - f10 + (f13 - f12)) / 2.0f;
                this.masterEventVectors.add(new double[]{f15, f16});
                this.xprsd_me += f15;
                this.yprsd_me += f16;
                f17 += (float)Math.sqrt(f15 * f15 + f16 * f16);
                ++n7;
            }
        }
        if (n7 > 1) {
            this.xprsd_me /= (float)n7;
            this.yprsd_me /= (float)n7;
            if ((f17 /= (float)n7) > 0.001f) {
                this.recti_me = (float)Math.sqrt(this.xprsd_me * this.xprsd_me + this.yprsd_me * this.yprsd_me) / f17 * 100.0f;
            }
        }
        return this.recti_me;
    }

    public double getEpiz_simul() {
        return this.epiz_simul;
    }

    public void setEpiz_simul(double d) {
        this.epiz_simul = d;
    }

    public double getEpiz_force() {
        return this.epiz_force;
    }

    public void setEpiz_force(double d) {
        this.epiz_force = d;
    }

    public List<double[]> getMasterEventVectors() {
        return this.masterEventVectors;
    }

    public double ttcalc_sourceScanning(double d) {
        if (!this.layerModelValid) {
            return Double.NaN;
        }
        FloatPtr floatPtr = new FloatPtr((float)d);
        FloatPtr floatPtr2 = new FloatPtr();
        this.ttcalc(floatPtr, -1, 0, 0, 0, floatPtr2);
        return floatPtr2.val;
    }

    private void debugPrint(int n, IntPtr intPtr, int n2, String string) {
        if (!this.debugOutput) {
            return;
        }
        String string2 = String.format("layer i=%d, src:%d -> sta:%d, %s", n, intPtr.val, n2, string);
        this.debugPrint(string2);
    }

    public int getTurnLayer(double d, double d2, int n) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return -1;
        }
        float f = this.statlocx[n];
        float f2 = this.statlocy[n];
        int n2 = this.zclass[n];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n3 = -1;
        d3 = d - (double)f;
        d4 = d2 - (double)f2;
        d5 = Math.sqrt(d3 * d3 + d4 * d4);
        for (int i = this.nlayer - 1; i >= this.sourcesimullayer.val; --i) {
            if (!(d5 >= (double)this.xcpsimul[n2][i])) continue;
            if (i == this.sourcesimullayer.val && i > 0) {
                n3 = 0;
                break;
            }
            n3 = i;
            break;
        }
        return n3;
    }

    private void debugPrintNan(int n, int n2) {
        this.debugPrint(String.format("Set raypath NaN for: zClass=%d, layer =%d", n, n2));
    }

    private void debugPrint(String string) {
        if (!this.debugOutput) {
            return;
        }
        String string2 = this.getClass().getSimpleName();
        int n = ((StackWalker.StackFrame)StackWalker.getInstance(StackWalker.Option.SHOW_HIDDEN_FRAMES).walk(stream -> stream.skip(1L).findFirst()).get()).getLineNumber();
        System.out.println("DBG:" + string2 + ":" + n + ": " + string);
    }

    public void setDebugOutput(boolean bl) {
        this.debugOutput = bl;
    }

    public void debugPrintModel() {
        if (!this.debugOutput) {
            return;
        }
        Object object = "Raytracer model:\n";
        object = (String)object + this.debugInfoCSV();
        System.out.println((String)object);
    }

    double elevation2depth(double d) {
        return (double)this.elevationOffset - d;
    }

    double depth2elevation(double d) {
        return -(d + (double)this.elevationOffset);
    }

    public String debugInfoCSV() {
        int n;
        Object object = String.format("nstatlist = %d\n", this.nstatlist);
        object = (String)object + String.format("\n%d ZClasses:\n", this.zclassdepth.length);
        for (n = 0; n < this.zclassdepth.length; ++n) {
            object = (String)object + String.format("%2d: %5.3f km\n", n, Float.valueOf(this.zclassdepth[n]));
        }
        object = (String)object + "\nSites:\n";
        object = (String)object + String.format("%3s, %7s, %7s, %3s, %6s\n", "idx", "x km", "y km", "zcl", "dep km");
        for (n = 0; n < this.statlocx.length; ++n) {
            object = (String)object + String.format("%3d, %7.3f, %7.3f, %3d, %6.3f\n", n, Float.valueOf(this.statlocx[n]), Float.valueOf(this.statlocy[n]), this.zclass[n], Float.valueOf(this.zclassdepth[this.zclass[n]]));
        }
        object = (String)object + String.format("layerModelValid = " + this.layerModelValid + "\n", new Object[0]);
        object = (String)object + String.format("nlayer = %d\n", this.nlayer);
        object = (String)object + String.format("elevationOffset = %.3f\n", Float.valueOf(this.elevationOffset));
        object = (String)object + String.format("vp2vs = %.3f\n", Float.valueOf(this.vp2vs));
        object = (String)object + "\nLayers:\n";
        object = (String)object + String.format("%3s, %7s, %7s, %7s\n", "idx", "d km", "vp km/s", "vs km/s");
        for (n = 0; n < this.nlayer; ++n) {
            object = (String)object + String.format("%3d, %7.3f, %7.3f, %7.3f\n", n, Float.valueOf(this.d_layer[n]), Float.valueOf(this.vp_layer[n]), Float.valueOf(this.vs_layer[n]));
        }
        return object;
    }

    private class IntPtr {
        public int val = Integer.MIN_VALUE;

        public String toString() {
            return Integer.toString(this.val);
        }
    }

    private class FloatPtr {
        public float val;

        public FloatPtr() {
            this.val = Float.NaN;
        }

        public FloatPtr(float f) {
            this.val = f;
        }

        public String toString() {
            return Float.toString(this.val);
        }
    }
}

