/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.themes.SuiteTheme;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.AbstractBufferedPainter;
import edu.geophys.commons.ui.PolyModel;
import edu.geophys.commons.ui.PolyPainter;
import edu.geophys.commons.util.SwingUtil;
import edu.geophys.hypoline.epimap.HypolinesModel;
import java.awt.Color;
import java.awt.Graphics2D;

public class HypolinesPainter
extends AbstractBufferedPainter<HypolinesModel> {
    private boolean onlyCircles = false;
    private PolyPainter polyPainter = new PolyPainter();

    public void setRenderQuality(SwingUtil.RenderQuality renderQuality) {
        super.setRenderQuality(renderQuality);
    }

    protected void doPaint(Graphics2D graphics2D, int n, int n2) {
        HypolinesModel hypolinesModel = (HypolinesModel)this.getModel();
        if (hypolinesModel == null) {
            return;
        }
        SuiteTheme suiteTheme = ThemeManager.getInstance().getTheme();
        Color color = ThemeManager.getInstance().getTheme().getHypolineRed();
        for (PolyModel polyModel : hypolinesModel.hypolines) {
            if (this.onlyCircles && !polyModel.getStation1().equals("") && !polyModel.getStation2().equals("")) continue;
            if (polyModel.getLineColor() != color) {
                switch (polyModel.getType()) {
                    case PP_HYPERBOLA: {
                        polyModel.setLineColor(suiteTheme.getHypolineBlue());
                        break;
                    }
                    case SP_CIRCLE: {
                        polyModel.setLineColor(suiteTheme.getHypolineGreen());
                        break;
                    }
                    default: {
                        polyModel.setLineColor(Color.PINK);
                    }
                }
            }
            this.polyPainter.paint(graphics2D, 0, 0, n, n2, (Object)polyModel);
        }
    }

    public boolean isOnlyCircles() {
        return this.onlyCircles;
    }

    public void setOnlyCircles(boolean bl) {
        this.onlyCircles = bl;
    }
}

