/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.AbstractPainter;
import edu.geophys.hypoline.epimap.BeamPainter;
import edu.geophys.hypoline.epimap.MapStationsModel;
import java.awt.Graphics2D;

public class MapBeamPainter
extends AbstractPainter<MapStationsModel> {
    private final BeamPainter beamPainter = new BeamPainter();

    protected void doPaint(Graphics2D graphics2D, int n, int n2) {
        if (this.getModel() == null) {
            return;
        }
        for (MapStationsModel.Station station : ((MapStationsModel)this.getModel()).values()) {
            if (station.getBeam1() != null) {
                if (station.getBeam1().isActiveBeam()) {
                    graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGold());
                } else {
                    graphics2D.setColor(ThemeManager.getInstance().getTheme().getUIBorderColor());
                }
                this.beamPainter.paint(graphics2D, 0, 0, n, n2, station.getBeam1());
            }
            if (station.getBeam2() == null) continue;
            if (station.getBeam2().isActiveBeam()) {
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGold());
            } else {
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getUIBorderColor());
            }
            this.beamPainter.paint(graphics2D, 0, 0, n, n2, station.getBeam2());
        }
    }
}

