/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.themes.ColorProvider;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.AbstractPainter;
import edu.geophys.hypoline.epimap.MapCursorModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

public class MapCursorPainter
extends AbstractPainter<MapCursorModel> {
    private final ColorProvider innerCrossColor;
    private int innerCrossRadius = 5;
    private int innerCrossLineWidth = 3;
    private final ColorProvider activeStationLineColor;
    private int activeStationLineWidth = 1;
    private final ColorProvider outerCrossColor;
    private int outerCrossRadius = 59;
    private int outerCrossLineWidth = 1;
    private int outerCrossCircleDiameter = 6;
    private boolean paintOuterCross = false;
    private boolean depthCursor = false;

    public MapCursorPainter(final ColorProvider colorProvider) {
        this.innerCrossColor = colorProvider;
        this.activeStationLineColor = colorProvider;
        this.outerCrossColor = new ColorProvider(){

            public Color get() {
                return ThemeManager.getInstance().getTheme().getAlteredInverse(colorProvider.get());
            }
        };
    }

    public MapCursorPainter() {
        this.innerCrossColor = new ColorProvider(){

            public Color get() {
                return ThemeManager.getInstance().getTheme().getHypolineGold();
            }
        };
        this.activeStationLineColor = new ColorProvider(){

            public Color get() {
                return ThemeManager.getInstance().getTheme().getHypolineGold();
            }
        };
        this.outerCrossColor = new ColorProvider(){

            public Color get() {
                return ThemeManager.getInstance().getTheme().getHypolineGold();
            }
        };
    }

    public final boolean isPaintOuterCross() {
        return this.paintOuterCross;
    }

    public final void setPaintOuterCross(boolean bl) {
        this.paintOuterCross = bl;
    }

    protected void doPaint(Graphics2D graphics2D, int n, int n2) {
        MapCursorModel mapCursorModel = (MapCursorModel)this.getModel();
        if (mapCursorModel == null || Double.isNaN(mapCursorModel.getY())) {
            return;
        }
        if (!this.isDepthCursor() && Double.isNaN(mapCursorModel.getX())) {
            return;
        }
        Point point = mapCursorModel.getAbsolutePoint(n, n2);
        if (!this.isDepthCursor()) {
            this.paintInnerCross(graphics2D, point);
            if (this.paintOuterCross) {
                this.paintOuterCross(graphics2D, point);
            }
        } else {
            if (!Double.isNaN(mapCursorModel.getX())) {
                this.paintInnerCross(graphics2D, point);
            }
            this.paintHLine(graphics2D, point);
        }
    }

    private void paintHLine(Graphics2D graphics2D, Point point) {
        graphics2D.setColor(this.outerCrossColor.get());
        graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
        graphics2D.drawLine(0, point.y, 400, point.y);
    }

    private void paintLine2Station(Graphics2D graphics2D, Point point, Point point2) {
        graphics2D.setColor(this.activeStationLineColor.get());
        graphics2D.setStroke(new BasicStroke(this.activeStationLineWidth, 1, 1, 1.0f, new float[]{4.0f, 4.0f}, 2.0f));
        graphics2D.drawLine(point2.x, point2.y, point.x, point.y);
    }

    private void paintInnerCross(Graphics2D graphics2D, Point point) {
        graphics2D.setColor(this.innerCrossColor.get());
        graphics2D.setStroke(new BasicStroke(this.innerCrossLineWidth, 1, 1));
        graphics2D.drawLine(point.x - this.innerCrossRadius, point.y - this.innerCrossRadius, point.x + this.innerCrossRadius, point.y + this.innerCrossRadius);
        graphics2D.drawLine(point.x - this.innerCrossRadius, point.y + this.innerCrossRadius, point.x + this.innerCrossRadius, point.y - this.innerCrossRadius);
    }

    private void paintOuterCross(Graphics2D graphics2D, Point point) {
        graphics2D.setColor(this.outerCrossColor.get());
        graphics2D.setStroke(new BasicStroke(this.outerCrossLineWidth, 1, 1));
        graphics2D.drawLine(point.x - this.outerCrossRadius, point.y, point.x + this.outerCrossRadius, point.y);
        graphics2D.drawLine(point.x, point.y - this.outerCrossRadius, point.x, point.y + this.outerCrossRadius);
        graphics2D.fillOval(point.x - this.outerCrossCircleDiameter / 2, point.y - this.outerCrossRadius - this.outerCrossCircleDiameter, this.outerCrossCircleDiameter, this.outerCrossCircleDiameter);
        graphics2D.fillOval(point.x + this.outerCrossRadius, point.y - this.outerCrossCircleDiameter / 2, this.outerCrossCircleDiameter, this.outerCrossCircleDiameter);
        graphics2D.fillOval(point.x - this.outerCrossCircleDiameter / 2, point.y + this.outerCrossRadius, this.outerCrossCircleDiameter, this.outerCrossCircleDiameter);
        graphics2D.fillOval(point.x - this.outerCrossRadius - this.outerCrossCircleDiameter, point.y - this.outerCrossCircleDiameter / 2, this.outerCrossCircleDiameter, this.outerCrossCircleDiameter);
    }

    public boolean isDepthCursor() {
        return this.depthCursor;
    }

    public void setDepthCursor(boolean bl) {
        this.depthCursor = bl;
    }
}

