/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap.gisexport;

import edu.geophys.hypoline.epimap.gisexport.KMLBase;
import edu.geophys.hypoline.epimap.gisexport.KMLCoordinate;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.PrintWriter;

@XmlType(name="tZoomMap", propOrder={"halfAxis"})
class KMLZoomMap
extends KMLCoordinate
implements KMLBase {
    private static final String zoomMapTemplate = "<Placemark><name>KMLZoomMap</name><description>Hypoline Window on GoogleEarth</description><styleUrl>#hypoBox</styleUrl><LineString><tessellate>1</tessellate><coordinates>%f,%f,0 %f,%f,0 %f,%f,0 %f,%f,0 %f,%f,0</coordinates></LineString></Placemark>";
    private double halfAxis = 0.0;

    KMLZoomMap() {
    }

    @XmlElement(name="halfaxis", required=true, nillable=false)
    public double getHalfAxis() {
        return this.halfAxis;
    }

    public void setHalfAxis(double d) {
        this.halfAxis = d;
    }

    @Override
    public void writeKML(PrintWriter printWriter) {
        double d = this.getLongitude() - this.getHalfAxis();
        double d2 = this.getLongitude() + this.getHalfAxis();
        double d3 = this.getLatitude() - this.getHalfAxis();
        double d4 = this.getLatitude() + this.getHalfAxis();
        printWriter.printf(zoomMapTemplate, d, d4, d2, d4, d2, d3, d, d3, d, d4);
    }
}

