/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.legacy;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.LogUtil;
import java.util.HashMap;
import java.util.Map;

public class ArrayPositionWrapper {
    private Map<SNS.HypolinePosition, SNS> hypolinePositions = null;

    private void init() {
        SNS[] sNSArray = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().getAllActiveSNS();
        this.hypolinePositions = new HashMap<SNS.HypolinePosition, SNS>();
        for (SNS sNS : sNSArray) {
            SNS.HypolinePosition hypolinePosition = sNS.getHypolinePosition();
            if (hypolinePosition == SNS.HypolinePosition.UNDEFINED) continue;
            if (!this.hypolinePositions.containsKey(hypolinePosition)) {
                if (this.hypolinePositions.size() > 8) {
                    LogUtil.error(this.getClass(), (String)"HypoLine does not support more than 8 active stations. Additional active stations will not be shown.", (boolean)true);
                    break;
                }
                this.hypolinePositions.put(hypolinePosition, sNS);
                continue;
            }
            LogUtil.error(this.getClass(), (String)("Hypoline Position " + hypolinePosition.toString() + " declared twice. Check stations.xml."), (boolean)true);
        }
        if (sNSArray.length > 0 && this.hypolinePositions.isEmpty()) {
            LogUtil.error(this.getClass(), (String)"Hypoline Positions not set in stations.xml. Array Selection will be ordered numerically", (boolean)true);
            int n = 0;
            for (SNS.HypolinePosition hypolinePosition : SNS.HypolinePosition.values()) {
                if (hypolinePosition == SNS.HypolinePosition.UNDEFINED) continue;
                if (n >= sNSArray.length) break;
                if (this.hypolinePositions.size() >= 8) {
                    LogUtil.error(this.getClass(), (String)"HypoLine does not support more than 8 active stations. Additional active stations will not be shown.", (boolean)true);
                    break;
                }
                this.hypolinePositions.put(hypolinePosition, sNSArray[n]);
                ++n;
            }
        }
    }

    public final SNS getCenterArray() {
        if (this.hypolinePositions == null) {
            this.init();
        }
        return this.hypolinePositions.get(SNS.HypolinePosition.CENTER);
    }

    public final SNS getNorthArray() {
        if (this.hypolinePositions == null) {
            this.init();
        }
        return this.hypolinePositions.get(SNS.HypolinePosition.NORTH);
    }

    public final SNS getNorthEastArray() {
        if (this.hypolinePositions == null) {
            this.init();
        }
        return this.hypolinePositions.get(SNS.HypolinePosition.NORTHEAST);
    }

    public final SNS getEastArray() {
        if (this.hypolinePositions == null) {
            this.init();
        }
        return this.hypolinePositions.get(SNS.HypolinePosition.EAST);
    }

    public final SNS getSouthEastArray() {
        if (this.hypolinePositions == null) {
            this.init();
        }
        return this.hypolinePositions.get(SNS.HypolinePosition.SOUTHEAST);
    }

    public final SNS getSouthArray() {
        if (this.hypolinePositions == null) {
            this.init();
        }
        return this.hypolinePositions.get(SNS.HypolinePosition.SOUTH);
    }

    public final SNS getSouthWestArray() {
        if (this.hypolinePositions == null) {
            this.init();
        }
        return this.hypolinePositions.get(SNS.HypolinePosition.SOUTHWEST);
    }

    public final SNS getWestArray() {
        if (this.hypolinePositions == null) {
            this.init();
        }
        return this.hypolinePositions.get(SNS.HypolinePosition.WEST);
    }

    public final SNS getNorthWestArray() {
        if (this.hypolinePositions == null) {
            this.init();
        }
        return this.hypolinePositions.get(SNS.HypolinePosition.NORTHWEST);
    }

    public final PositionMatrixElement[] getPositionMatrix() {
        if (this.hypolinePositions == null) {
            this.init();
        }
        PositionMatrixElement[] positionMatrixElementArray = new PositionMatrixElement[]{new PositionMatrixElement(this.getNorthWestArray(), 0, 0), new PositionMatrixElement(this.getNorthArray(), 1, 0), new PositionMatrixElement(this.getNorthEastArray(), 2, 0), new PositionMatrixElement(this.getWestArray(), 0, 1), new PositionMatrixElement(this.getCenterArray(), 1, 1), new PositionMatrixElement(this.getEastArray(), 2, 1), new PositionMatrixElement(this.getSouthWestArray(), 0, 2), new PositionMatrixElement(this.getSouthArray(), 1, 2), new PositionMatrixElement(this.getSouthEastArray(), 2, 2)};
        return positionMatrixElementArray;
    }

    public SNS getAnyValidSNS() {
        SNS sNS = this.getCenterArray();
        if (sNS != null) {
            return sNS;
        }
        if (this.hypolinePositions.size() > 0) {
            return this.hypolinePositions.values().iterator().next();
        }
        return null;
    }

    public class PositionMatrixElement {
        public final SNS sns;
        public final int col;
        public final int row;

        public PositionMatrixElement(SNS sNS, int n, int n2) {
            this.sns = sNS;
            this.col = n;
            this.row = n2;
        }
    }
}

