/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.protocol;

import edu.geophys.commons.suite.EventWindowModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.hypoline.protocol.ProtEntry;
import edu.geophys.hypoline.protocol.ProtFileManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import layout.TableLayout;

public class ProtEntryList {
    private ProtFileManager protFileManager;
    private JTable protTable;
    private List<ProtEntry> protEntries;
    private static final int border = 2;
    Map<Integer, ProtEntry> allEntriesMap = null;
    int[] idList = null;
    private final EventWindowModel ewm = SuiteManager.INSTANCE.getGlobalEventWindowModel();

    public ProtEntryList(ProtFileManager protFileManager) {
        this.protFileManager = protFileManager;
        this.protEntries = protFileManager.getProtEntries();
    }

    private void initTable() {
        this.allEntriesMap = new HashMap<Integer, ProtEntry>();
        Object[] objectArray = new Object[]{"date", "lat", "lon", "d", "Ml", "comment"};
        Object[][] objectArray2 = new Object[this.protEntries.size()][objectArray.length];
        this.idList = new int[this.protEntries.size()];
        int n = 0;
        for (ProtEntry protEntry : this.protEntries) {
            ProtEntry.HypoX hypoX = protEntry.getHypoX();
            int n2 = protEntry.getEntry();
            this.allEntriesMap.put(n2, protEntry);
            this.idList[n] = n2;
            objectArray2[n][0] = DateTimeUtil.formatDateTimeISO((long)protEntry.getDate());
            objectArray2[n][1] = hypoX.getLat();
            objectArray2[n][2] = hypoX.getLon();
            objectArray2[n][3] = Float.valueOf(hypoX.getDepth());
            objectArray2[n][4] = Float.valueOf(hypoX.getMagnitude());
            objectArray2[n][5] = protEntry.getComment();
            ++n;
        }
        this.protTable.setModel(new DefaultTableModel(objectArray2, objectArray));
        this.protTable.setDefaultEditor(Object.class, null);
        this.protTable.setSelectionMode(0);
        this.protTable.setAutoCreateRowSorter(true);
        this.protTable.setAutoResizeMode(0);
        this.protTable.getColumnModel().getColumn(1).setCellRenderer(new DecimalFormatRenderer(1));
        this.protTable.getColumnModel().getColumn(2).setCellRenderer(new DecimalFormatRenderer(1));
        this.protTable.getColumnModel().getColumn(3).setCellRenderer(new DecimalFormatRenderer(1));
        this.protTable.getColumnModel().getColumn(4).setCellRenderer(new DecimalFormatRenderer(1));
        ProtEntryList.cellScaler(this.protTable);
    }

    public JPanel getView() {
        JPanel jPanel = new JPanel();
        this.protTable = new JTable();
        this.initTable();
        int n = ProtEntryList.cellScaler(this.protTable);
        jPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{2.0, -1.0, 2.0}, {2.0, -1.0, 2.0, 30.0, 2.0}}));
        jPanel.add((Component)new JScrollPane(this.protTable), "1, 1");
        JButton jButton = new JButton("Delete entry from database");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProtEntryList.this.onDeleteAction();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "1, 3");
        jPanel.setPreferredSize(new Dimension(n + 30, 600));
        return jPanel;
    }

    public ProtEntry getEntry() {
        ProtEntry protEntry = null;
        int n = this.protTable.convertRowIndexToModel(this.protTable.getSelectedRow());
        int n2 = this.idList[n];
        protEntry = this.allEntriesMap.get(n2);
        return protEntry;
    }

    static int cellScaler(JTable jTable) {
        int n = 0;
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            int n2 = tableColumn.getMinWidth();
            int n3 = tableColumn.getMaxWidth();
            for (int j = 0; j < jTable.getRowCount(); ++j) {
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(j, i);
                Component component = jTable.prepareRenderer(tableCellRenderer, j, i);
                int n4 = component.getPreferredSize().width + jTable.getIntercellSpacing().width + 5;
                n2 = Math.max(n2, n4);
            }
            n2 = Math.max(n2, 20);
            n += n2;
            tableColumn.setPreferredWidth(n2);
        }
        return n;
    }

    private void onDeleteAction() {
        ProtEntry protEntry = this.getEntry();
        this.protEntries.remove(protEntry);
        this.protFileManager.store();
        this.initTable();
    }

    static class DecimalFormatRenderer
    extends DefaultTableCellRenderer {
        private DecimalFormat formatter = null;

        public DecimalFormatRenderer(int n) {
            Object object = "#.";
            for (int i = 0; i < n; ++i) {
                object = (String)object + "0";
            }
            this.formatter = new DecimalFormat((String)object);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                object = object.toString().equals("NaN") ? "" : this.formatter.format((Number)object);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    static class RepRenderer
    extends DefaultTableCellRenderer {
        private String nanval = "";
        private String replace = "";

        public RepRenderer(String string, String string2) {
            this.nanval = string;
            this.replace = string2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null && object.toString().equals(this.nanval)) {
                object = this.replace;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

