/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.protocol;

import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.model.layer.Layer;
import edu.geophys.commons.model.layer.LayerModel;
import edu.geophys.commons.model.tracefiles.converters.TimeHelper;
import edu.geophys.commons.suite.EventWindowModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.JAXBSerializable;
import edu.geophys.commons.util.JAXBUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.epimap.EpiCenter;
import edu.geophys.hypoline.protocol.ProtEntry;
import edu.geophys.hypoline.protocol.ProtEntryList;
import edu.geophys.hypoline.protocol.UpdateOrNew;
import edu.geophys.hypoline.ui.trace.SiteModel;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

@XmlRootElement(name="ProtEntries")
public class ProtFileManager
implements JAXBSerializable {
    private boolean entriesUpdatedFromDb = false;
    private static final long serialVersionUID = 1L;
    private final File protFile;
    private final String protFileName = "hypoprot.xml";
    private List<ProtEntry> protEntries = new ArrayList<ProtEntry>();
    private final EventWindowModel ewm = SuiteManager.INSTANCE.getGlobalEventWindowModel();
    private int currentEntryId = -1;
    private long MILLI_SECONDS_TOLERANCE = 60000L;
    private Random rand = new Random();

    public ProtFileManager(File file) {
        this.protFile = new File(file.getAbsolutePath() + File.separator + "hypoprot.xml");
        if (!this.protFile.exists()) {
            try {
                this.protFile.createNewFile();
            }
            catch (IOException iOException) {
                LogUtil.error(this.getClass(), (String)("Can not create protocol file: " + this.protFile.getAbsolutePath()), (boolean)true);
                iOException.printStackTrace();
            }
        }
    }

    public ProtFileManager(String string) {
        this.protFile = new File(string);
        if (!this.protFile.exists()) {
            try {
                this.protFile.createNewFile();
            }
            catch (IOException iOException) {
                LogUtil.error(this.getClass(), (String)("Can not create protocol file: " + this.protFile.getAbsolutePath()), (boolean)true);
                iOException.printStackTrace();
            }
        }
    }

    public ProtFileManager() {
        this(SuiteManager.INSTANCE.getKnowledgebase().getTmpFolder());
    }

    public void saveToProtFile() {
        ProtEntry protEntry = new ProtEntry();
        protEntry.setDate(this.ewm.getStartEpochTimeMs());
        HashMap<Integer, ProtEntry> hashMap = new HashMap<Integer, ProtEntry>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (ProtEntry object32 : this.protEntries) {
            if (object32.getDate() < this.ewm.getStartEpochTimeMs() - this.MILLI_SECONDS_TOLERANCE || object32.getDate() > this.ewm.getStartEpochTimeMs() + this.ewm.getLength() + this.MILLI_SECONDS_TOLERANCE) continue;
            arrayList.add(object32.getEntry());
            hashMap.put(object32.getEntry(), object32);
        }
        Object[] objectArray = new Object[]{"Create new event", "Update existing event", "Cancel"};
        UpdateOrNew updateOrNew = new UpdateOrNew(protEntry, arrayList, hashMap);
        int n = JOptionPane.showOptionDialog(HypoLineManager.INSTANCE.getHlApp().getMainFrame(), updateOrNew.getView(), "Update existing or create new event", 1, 3, null, objectArray, objectArray[0]);
        if (n == 2) {
            return;
        }
        ProtEntry protEntry2 = updateOrNew.getSelectedEntry();
        boolean bl = n == 1 && protEntry2 != null;
        protEntry.setComment(updateOrNew.getComment());
        if (bl) {
            int epiCenter = 0;
            for (ProtEntry protEntry3 : this.protEntries) {
                if (protEntry3.getEntry() == protEntry2.getEntry()) {
                    this.protEntries.remove(epiCenter);
                    protEntry.setEntry(protEntry2.getEntry());
                    break;
                }
                ++epiCenter;
            }
        } else {
            protEntry.setEntry(this.rand.nextInt());
        }
        this.protEntries.add(protEntry);
        for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
            Object object;
            SiteModel siteModel2 = siteModel.getChild();
            ProtEntry.Pick pick = new ProtEntry.Pick(siteModel2.getId());
            boolean bl2 = false;
            if (!Double.isNaN(siteModel2.getpPick())) {
                bl2 = true;
            }
            if (!Double.isNaN(siteModel2.getsPick())) {
                bl2 = true;
            }
            if (!Double.isNaN(siteModel2.getpCorr())) {
                bl2 = true;
            }
            if (!Double.isNaN(siteModel2.getsCorr())) {
                bl2 = true;
            }
            pick.setP(siteModel2.getpPick());
            pick.setPuncert(siteModel2.getPUncertainty());
            pick.setS(siteModel2.getsPick());
            pick.setSuncert(siteModel2.getSUncertainty());
            pick.setpCorr(siteModel2.getpCorr());
            pick.setsCorr(siteModel2.getsCorr());
            if (bl2) {
                protEntry.getPicks().add(pick);
            }
            if (!Double.isNaN(siteModel2.getMagnitude1Pick()) && !Double.isNaN(siteModel2.getMagnitude2Pick())) {
                object = new ProtEntry.Ampl(siteModel2.getId());
                ((ProtEntry.Ampl)object).setStart(siteModel2.getMagnitude1Pick());
                ((ProtEntry.Ampl)object).setEnd(siteModel2.getMagnitude2Pick());
                ((ProtEntry.Ampl)object).setDiplacement(siteModel2.getMagnitudeAmpMy());
                protEntry.getAmpls().add((ProtEntry.Ampl)object);
            }
            object = new ProtEntry.View(siteModel2.getId());
            ((ProtEntry.View)object).setFl(siteModel2.getFl());
            ((ProtEntry.View)object).setFu(siteModel2.getFu());
            protEntry.getViews().add((ProtEntry.View)object);
            if (!siteModel2.getId().equals(siteModel2.getSns().getCenter().getId()) || (Double.isNaN(siteModel2.getpBeamAngle()) || Double.isNaN(siteModel2.getpBeamAppVelocity())) && (Double.isNaN(siteModel2.getsBeamAngle()) || Double.isNaN(siteModel2.getsBeamAppVelocity()))) continue;
            ProtEntry.Array array = new ProtEntry.Array(siteModel2.getId());
            array.setpBeamDegree(siteModel2.getpBeamAngle());
            array.setpBeamCertainty(siteModel2.getpBeamCertainty());
            array.setsBeamDegree(siteModel2.getsBeamAngle());
            array.setpBeamAppVelocity(siteModel2.getpBeamAppVelocity());
            array.setsBeamAppVelocity(siteModel2.getsBeamAppVelocity());
            array.setsBeamCertainty(siteModel2.getsBeamCertainty());
            protEntry.getArrays().add(array);
        }
        EpiCenter epiCenter = HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter();
        if (epiCenter.isEpiCenterSet() || epiCenter.getEpi_z() > 0.0f) {
            ProtEntry.HypoX hypoX = new ProtEntry.HypoX();
            hypoX.setLon(epiCenter.getLon());
            hypoX.setLat(epiCenter.getLat());
            hypoX.setX(epiCenter.getX());
            hypoX.setY(epiCenter.getY());
            hypoX.setDepth(epiCenter.getEpi_z() - (float)HypoLineManager.INSTANCE.getEpiMapDb().getEpiDepth().getMaxZ());
            hypoX.setMagnitude(HypoLineManager.INSTANCE.getMagnitudePanel().getMl());
            hypoX.settSource(epiCenter.getOnsetTime());
            protEntry.setHypoX(hypoX);
        }
        ProtEntry.Model model = new ProtEntry.Model();
        LayerModel layerModel = HypoLineManager.INSTANCE.getLayerModelController().getCurrentLayerModel();
        model.setLayerModel(layerModel.getName());
        if (layerModel.getLayers().size() > 0) {
            model.setVp1((float)((Layer)layerModel.getLayers().get(0)).getVp());
        }
        if (layerModel.getLayers().size() > 1) {
            model.setVp2((float)((Layer)layerModel.getLayers().get(1)).getVp());
        }
        protEntry.setModel(model);
        Collections.sort(this.protEntries);
        this.store();
    }

    public void loadFromProtFile() {
        this.loadFromProtFile(false);
    }

    @Deprecated
    public void loadFromProtFile(boolean bl) {
        Object object;
        this.load();
        CampaignKnowledge campaignKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
        HashMap<Object, ProtEntry> hashMap = new HashMap<Object, ProtEntry>();
        ArrayList<JComponent[]> arrayList = new ArrayList<JComponent[]>();
        ArrayList<ProtEntry> arrayList2 = new ArrayList<ProtEntry>();
        for (ProtEntry object22 : this.protEntries) {
            if (object22.getDate() < this.ewm.getStartEpochTimeMs() - this.MILLI_SECONDS_TOLERANCE || object22.getDate() > this.ewm.getStartEpochTimeMs() + this.ewm.getLength() + this.MILLI_SECONDS_TOLERANCE) continue;
            arrayList2.add(object22);
            object = ProtFileManager.ProtToString(object22);
            arrayList.add((JComponent[])object);
            hashMap.put(object, object22);
        }
        Object object3 = null;
        if (arrayList2.size() > 1 && !bl) {
            JComboBox<String> jComboBox = new JComboBox<String>(arrayList.toArray(new String[arrayList.size()]));
            object = new JComponent[]{new JLabel("Existing events:"), jComboBox};
            int n = JOptionPane.showConfirmDialog(HypoLineManager.INSTANCE.getHlApp().getMainFrame(), object, "Load event", 2, 1);
            if (n == 0) {
                object3 = (ProtEntry)hashMap.get((String)jComboBox.getSelectedItem());
            }
        } else if (arrayList2.size() == 1 && !bl) {
            object3 = (ProtEntry)arrayList2.get(0);
        } else {
            HashMap<String, ProtEntry> hashMap2 = new HashMap<String, ProtEntry>();
            object = new ArrayList();
            for (ProtEntry protEntry : this.protEntries) {
                String string = ProtFileManager.ProtToString(protEntry);
                hashMap2.put(string, protEntry);
                object.add(string);
            }
            JComboBox<String> jComboBox = new JComboBox<String>(object.toArray(new String[object.size()]));
            JComponent[] jComponentArray = new JComponent[]{new JLabel("No events found, showing all:"), jComboBox};
            int n = JOptionPane.showConfirmDialog(HypoLineManager.INSTANCE.getHlApp().getMainFrame(), jComponentArray, "Load event", 2, 1);
            if (n == 0) {
                object3 = (ProtEntry)hashMap2.get((String)jComboBox.getSelectedItem());
                this.ewm.setStartEpochTimeMs(((ProtEntry)object3).getDate());
            }
        }
        if (object3 != null) {
            this.currentEntryId = ((ProtEntry)object3).getEntry();
            HypoLineManager.INSTANCE.resetAll();
            ProtEntry.HypoX hypoX = ((ProtEntry)object3).getHypoX();
            if (!Double.isNaN(hypoX.getLat()) && !Double.isNaN(hypoX.getLon())) {
                HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter().setLatLon(hypoX.getLat(), hypoX.getLon(), true);
                HypoLineManager.INSTANCE.getEpiMapDb().updateEpiCenter();
            }
            for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
                SiteModel siteModel2 = siteModel.getChild();
                for (ProtEntry.Pick pick : ((ProtEntry)object3).getPicks()) {
                    if (!siteModel2.getId().equals(pick.getSiteId())) continue;
                    siteModel2.setpPick(pick.getP());
                    siteModel2.setPUncertainty(pick.getPuncert());
                    siteModel2.setsPick(pick.getS());
                    siteModel2.setSUncertainty(pick.getSuncert());
                    siteModel2.setpCorr(pick.getpCorr());
                    siteModel2.setsCorr(pick.getsCorr());
                }
                for (ProtEntry.Ampl ampl : ((ProtEntry)object3).getAmpls()) {
                    if (!siteModel2.getId().equals(ampl.getTrace())) continue;
                    siteModel2.setMagnitude1Pick(ampl.getStart());
                    siteModel2.setMagnitude2Pick(ampl.getEnd());
                    siteModel2.setMagnitudeAmpMy(ampl.getDiplacement());
                }
                for (ProtEntry.Array array : ((ProtEntry)object3).getArrays()) {
                    if (!siteModel2.getId().equals(array.getId())) continue;
                    siteModel2.setpBeamAngle(array.getpBeamDegree());
                    siteModel2.setpBeamAppVelocity(array.getpBeamAppVelocity());
                    siteModel2.setpBeamCertainty(array.getpBeamCertainty());
                    siteModel2.setsBeamAngle(array.getsBeamDegree());
                    siteModel2.setsBeamAppVelocity(array.getsBeamAppVelocity());
                    siteModel2.setsBeamCertainty(array.getsBeamCertainty());
                    HypoLineManager.INSTANCE.getpBeamView().updateBeamSolutionFromModel();
                    HypoLineManager.INSTANCE.getsBeamView().updateBeamSolutionFromModel();
                }
                for (ProtEntry.View view : ((ProtEntry)object3).getViews()) {
                    if (!siteModel2.getId().equals(view.getTrace())) continue;
                    siteModel2.setFlFu(view.getFl(), view.getFu());
                }
                siteModel2.updateRepaint();
            }
            boolean bl2 = false;
            ProtEntry.Model model = ((ProtEntry)object3).getModel();
            HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(model.getLayerModel());
            HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter().setOnsetTime(hypoX.gettSource());
            if (!Float.isNaN(hypoX.getDepth())) {
                HypoLineManager.INSTANCE.getEpiMapDb().updateDepth(hypoX.getDepth() + (float)HypoLineManager.INSTANCE.getEpiMapDb().getEpiDepth().getMaxZ());
                HypoLineManager.INSTANCE.getEpiMapDb().getEpiDepth().repaintArea();
            } else {
                HypoLineManager.INSTANCE.getEpiMapDb().updateDepth();
            }
            HypoLineManager.INSTANCE.getMagnitudePanel().setMl(hypoX.getMagnitude());
            HypoLineManager.INSTANCE.getMagnitudePanel().update();
            HypoLineManager.INSTANCE.getpBeamView().update();
            HypoLineManager.INSTANCE.getsBeamView().update();
        }
    }

    public void loadFromProtFileAdvanced() {
        boolean bl = true;
        this.load();
        CampaignKnowledge campaignKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
        ProtEntry protEntry = null;
        ProtEntryList protEntryList = new ProtEntryList(this);
        int n = JOptionPane.showConfirmDialog(HypoLineManager.INSTANCE.getHlApp().getMainFrame(), protEntryList.getView(), "Load event", 2, -1);
        if (n == 0) {
            protEntry = protEntryList.getEntry();
            this.ewm.setStartEpochTimeMs(protEntry.getDate());
        }
        if (protEntry != null) {
            this.currentEntryId = protEntry.getEntry();
            HypoLineManager.INSTANCE.resetAll();
            ProtEntry.HypoX hypoX = protEntry.getHypoX();
            if (!Double.isNaN(hypoX.getLat()) && !Double.isNaN(hypoX.getLon())) {
                HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter().setLatLon(hypoX.getLat(), hypoX.getLon(), true);
                HypoLineManager.INSTANCE.getEpiMapDb().updateEpiCenter();
            }
            for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
                SiteModel siteModel2 = siteModel.getChild();
                for (ProtEntry.Pick pick : protEntry.getPicks()) {
                    if (!siteModel2.getId().equals(pick.getSiteId())) continue;
                    siteModel2.setpPick(pick.getP());
                    siteModel2.setPUncertainty(pick.getPuncert());
                    siteModel2.setsPick(pick.getS());
                    siteModel2.setSUncertainty(pick.getSuncert());
                    siteModel2.setpCorr(pick.getpCorr());
                    siteModel2.setsCorr(pick.getsCorr());
                }
                for (ProtEntry.Ampl ampl : protEntry.getAmpls()) {
                    if (!siteModel2.getId().equals(ampl.getTrace())) continue;
                    siteModel2.setMagnitude1Pick(ampl.getStart());
                    siteModel2.setMagnitude2Pick(ampl.getEnd());
                    siteModel2.setMagnitudeAmpMy(ampl.getDiplacement());
                }
                for (ProtEntry.Array array : protEntry.getArrays()) {
                    if (!siteModel2.getId().equals(array.getId())) continue;
                    siteModel2.setpBeamAngle(array.getpBeamDegree());
                    siteModel2.setpBeamAppVelocity(array.getpBeamAppVelocity());
                    siteModel2.setpBeamCertainty(array.getpBeamCertainty());
                    siteModel2.setsBeamAngle(array.getsBeamDegree());
                    siteModel2.setsBeamAppVelocity(array.getsBeamAppVelocity());
                    siteModel2.setsBeamCertainty(array.getsBeamCertainty());
                    HypoLineManager.INSTANCE.getpBeamView().updateBeamSolutionFromModel();
                    HypoLineManager.INSTANCE.getsBeamView().updateBeamSolutionFromModel();
                }
                for (ProtEntry.View view : protEntry.getViews()) {
                    if (!siteModel2.getId().equals(view.getTrace())) continue;
                    siteModel2.setFlFu(view.getFl(), view.getFu());
                }
                siteModel2.updateRepaint();
            }
            ProtEntry.Model model = protEntry.getModel();
            HypoLineManager.INSTANCE.getLayerModelController().setCurrentLayerModel(model.getLayerModel());
            HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter().setOnsetTime(hypoX.gettSource());
            if (!Float.isNaN(hypoX.getDepth())) {
                HypoLineManager.INSTANCE.getEpiMapDb().updateDepth(hypoX.getDepth() + (float)HypoLineManager.INSTANCE.getEpiMapDb().getEpiDepth().getMaxZ());
                HypoLineManager.INSTANCE.getEpiMapDb().getEpiDepth().repaintArea();
            } else {
                HypoLineManager.INSTANCE.getEpiMapDb().updateDepth();
            }
            HypoLineManager.INSTANCE.getMagnitudePanel().setMl(hypoX.getMagnitude());
            HypoLineManager.INSTANCE.getMagnitudePanel().update();
            HypoLineManager.INSTANCE.getpBeamView().update();
            HypoLineManager.INSTANCE.getsBeamView().update();
        }
    }

    @XmlElement(name="ProtEntry", required=true)
    public List<ProtEntry> getProtEntries() {
        return this.protEntries;
    }

    public void setProtEntries(List<ProtEntry> list) {
        this.protEntries = list;
        Collections.sort(this.protEntries);
    }

    public void setValues(ProtFileManager protFileManager) {
        this.setProtEntries(protFileManager.getProtEntries());
    }

    public boolean load() {
        try {
            ProtFileManager protFileManager = (ProtFileManager)JAXBUtil.readXML((File)this.protFile, this.getClass());
            this.setValues(protFileManager);
        }
        catch (Exception exception) {
            LogUtil.info(this.getClass(), (String)exception.getMessage());
            return false;
        }
        return true;
    }

    public void store() {
        try {
            JAXBUtil.writeXML((JAXBSerializable)this, (File)this.protFile);
        }
        catch (Exception exception) {
            LogUtil.fatal(this.getClass(), (String)("Failed to store prot entries to file (" + this.protFile + ")"), (Throwable)exception);
        }
    }

    public File getProtFile() {
        return this.protFile;
    }

    public void readHypo34ProtFile() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("", Locale.ENGLISH);
        simpleDateFormat.setTimeZone(TimeHelper.TIMEZONE_UTC);
    }

    public int getCurrentEntryId() {
        return this.currentEntryId;
    }

    public void setCurrentEntryId(int n) {
        this.currentEntryId = n;
    }

    public static String ProtToString(ProtEntry protEntry) {
        return DateTimeUtil.formatDateTimeISO((long)protEntry.getDate()) + " " + protEntry.getComment();
    }
}

