/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.arraybeamprocessing;

public class BeamCalc {
    private float[] sx;
    private float[] sy;
    private float[] slow;
    private float[] bazi;
    private double[] simult;
    private int nstatsub;
    private int stationNo;

    public BeamCalc(int n) {
        this.stationNo = n;
        this.nstatsub = (int)((Math.pow(n, 3.0) - 3.0 * Math.pow(n, 2.0) + (double)(2 * n)) / 6.0);
        this.sx = new float[this.nstatsub];
        this.sy = new float[this.nstatsub];
        this.slow = new float[this.nstatsub];
        this.bazi = new float[this.nstatsub];
        this.simult = new double[n];
    }

    public void onset2beam(double[] dArray, float[] fArray, float[] fArray2, double d) {
        int n;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        double[] dArray2 = new double[3];
        for (n = 0; n < this.nstatsub; ++n) {
            this.sx[n] = 0.0f;
            this.sy[n] = 0.0f;
            this.slow[n] = 0.0f;
            this.bazi[n] = 0.0f;
        }
        n = 0;
        for (int i = 0; i < this.stationNo; ++i) {
            dArray2[0] = dArray[i];
            fArray3[0] = fArray[i];
            fArray4[0] = fArray2[i];
            for (int j = i + 1; j < this.stationNo; ++j) {
                dArray2[1] = dArray[j];
                fArray3[1] = fArray[j];
                fArray4[1] = fArray2[j];
                for (int k = j + 1; k < this.stationNo; ++k) {
                    dArray2[2] = dArray[k];
                    fArray3[2] = fArray[k];
                    fArray4[2] = fArray2[k];
                    if (!(Double.isNaN(dArray2[0]) || Double.isNaN(dArray2[1]) || Double.isNaN(dArray2[2]))) {
                        double d2 = 0.1 / d;
                        if (Math.abs(dArray2[0] - dArray2[1]) < d2 && Math.abs(dArray2[0] - dArray2[2]) < d2) {
                            this.sx[n] = 0.0010000999f;
                            this.sy[n] = 0.0010000999f;
                            this.slow[n] = 0.0010000999f;
                            this.bazi[n] = 0.0f;
                        } else {
                            this.beamcalc(dArray2, fArray3, fArray4, 3, 0, n);
                        }
                    }
                    ++n;
                }
            }
        }
    }

    public void beam2onset(float[] fArray, float[] fArray2, float f, float f2) {
        int n;
        for (n = 0; n < this.sx.length; ++n) {
            this.sx[n] = 0.0f;
            this.sy[n] = 0.0f;
        }
        this.sx[0] = f;
        this.sy[0] = f2;
        for (n = 0; n < this.simult.length; ++n) {
            this.simult[n] = 0.0;
        }
        this.beamcalc(this.simult, fArray, fArray2, fArray.length, 1, 0);
    }

    void beamcalc(double[] dArray, float[] fArray, float[] fArray2, int n, int n2, int n3) {
        int n4 = 0;
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 3.1415926;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (n2 == 0) {
            if (n > 3) {
                return;
            }
            for (n4 = 0; n4 < n - 1; ++n4) {
                dArray2[n4] = fArray[n4 + 1] - fArray[0];
                dArray3[n4] = fArray2[n4 + 1] - fArray2[0];
            }
            d2 = dArray[1] - dArray[0];
            d3 = dArray[2] - dArray[0];
            d = dArray3[1] * dArray2[0] - dArray3[0] * dArray2[1];
            if (-1.0E-30 < d && d < 1.0E-30) {
                return;
            }
            d6 = (dArray3[1] * d2 - dArray3[0] * d3) / d;
            d7 = (dArray2[0] * d3 - dArray2[1] * d2) / d;
            d6 = -d6;
            d7 = -d7;
            this.slow[n3] = (float)Math.sqrt(d6 * d6 + d7 * d7);
            if (this.slow[n3] < 0.0010000999f) {
                this.slow[n3] = 0.0010000999f;
                d6 = 0.001000100010001;
                d7 = 0.001000100010001;
            }
            this.sx[n3] = (float)d6;
            this.sy[n3] = (float)d7;
        } else {
            for (n4 = 0; n4 < n - 1; ++n4) {
                dArray2[n4] = fArray[n4 + 1] - fArray[0];
                dArray3[n4] = fArray2[n4 + 1] - fArray2[0];
            }
            d6 = -((double)this.sx[n3]);
            d7 = -((double)this.sy[n3]);
            dArray[0] = 0.0;
            for (n4 = 0; n4 < n - 1; ++n4) {
                dArray[n4 + 1] = dArray2[n4] * d6 + dArray3[n4] * d7;
            }
            d6 = -d6;
            d7 = -d7;
            this.slow[n3] = (float)Math.sqrt(d6 * d6 + d7 * d7);
            if (this.slow[n3] < 0.0010000999f) {
                this.slow[n3] = 0.0010000999f;
                d6 = 0.001000100010001;
                d7 = 0.001000100010001;
            }
        }
        if (-1.0E-5 < d7 && d7 < 1.0E-5) {
            d5 = d6 >= 0.0 ? d4 / 2.0 : d4 * 1.5;
        } else {
            d5 = Math.atan(d6 / d7);
            if (d6 < 0.0 && d7 < 0.0) {
                d5 += d4;
            } else if (d6 < 0.0 && d7 > 0.0) {
                d5 = d4 / 2.0 - Math.abs(d5) + 1.5 * d4;
            } else if (d6 >= 0.0 && d7 < 0.0) {
                d5 = d4 / 2.0 - Math.abs(d5) + 0.5 * d4;
            }
        }
        this.bazi[n3] = (float)(d5 * 180.0 / d4);
    }

    public float[] getSx() {
        return this.sx;
    }

    public void setSx(float[] fArray) {
        this.sx = fArray;
    }

    public float[] getSy() {
        return this.sy;
    }

    public void setSy(float[] fArray) {
        this.sy = fArray;
    }

    public float[] getSlow() {
        return this.slow;
    }

    public void setSlow(float[] fArray) {
        this.slow = fArray;
    }

    public float[] getBazi() {
        return this.bazi;
    }

    public void setBazi(float[] fArray) {
        this.bazi = fArray;
    }

    public double[] getSimult() {
        return this.simult;
    }

    public void setSimult(double[] dArray) {
        this.simult = dArray;
    }
}

