/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.arraybeamprocessing;

import edu.geophys.commons.model.Site;
import edu.geophys.commons.resources.Colors;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.commons.util.LoadHeaderUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.commons.util.SwingUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.Legend;
import edu.geophys.hypoline.ui.arraybeamprocessing.BeamCalc;
import edu.geophys.hypoline.ui.arraybeamprocessing.BeamCoordinateSystemModel;
import edu.geophys.hypoline.ui.arraybeamprocessing.BeamCoordinateSystemPainter;
import edu.geophys.hypoline.ui.arraybeamprocessing.BeamLocation;
import edu.geophys.hypoline.ui.arraybeamprocessing.BeamLocationPainter;
import edu.geophys.hypoline.ui.arraybeamprocessing.FKAnalysis;
import edu.geophys.hypoline.ui.trace.SiteModel;
import edu.geophys.hypoline.util.HypoLineFonts;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

public class BeamView
extends ActivateableComponent {
    private static final long serialVersionUID = 7862622465076941521L;
    private BeamCalc beam;
    private int textPadding = 3;
    private BeamCoordinateSystemPainter beamCoordinateSystemPainter;
    private BeamLocationPainter beamLocationPainter;
    private BeamLocation beamSelectionLocation;
    private Color beamColor;
    private SwingUtil.RenderQuality renderingQuality = SwingUtil.RenderQuality.HIGH;
    private BeamCoordinateSystemModel beamCoordinateSystemModel;
    private String currentBeamCaption = "-";
    private final String beamViewCaption;
    private DecimalFormat df = new DecimalFormat("#.##");
    private final boolean pOrSBeams;
    private List<SiteModel> sites = new ArrayList<SiteModel>();
    private SiteModel beamSiteModel;
    private int simulatedPOffset = 0;
    private int simulatedSOffset = 0;
    private Stroke simulPrayStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f}, 0.0f);
    private double meanSlow = 0.0;
    private double meanBazi = 0.0;
    private final int colorNo = Colors.SONOGRAM.length;
    private FKAnalysis fkAnalysis = null;
    private int arrayResponseFreq = 0;
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            double d = 0.01;
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    if (!keyEvent.isControlDown()) {
                        BeamView.this.beamSelectionLocation.setRelativePoint(BeamView.this.beamSelectionLocation.getRelativeX() - d, BeamView.this.beamSelectionLocation.getRelativeY());
                    } else if (BeamView.this.pOrSBeams) {
                        --BeamView.this.simulatedPOffset;
                    } else {
                        --BeamView.this.simulatedSOffset;
                    }
                    BeamView.this.updateBeamSelection();
                    break;
                }
                case 39: {
                    if (!keyEvent.isControlDown()) {
                        BeamView.this.beamSelectionLocation.setRelativePoint(BeamView.this.beamSelectionLocation.getRelativeX() + d, BeamView.this.beamSelectionLocation.getRelativeY());
                    } else if (BeamView.this.pOrSBeams) {
                        ++BeamView.this.simulatedPOffset;
                    } else {
                        ++BeamView.this.simulatedSOffset;
                    }
                    BeamView.this.updateBeamSelection();
                    break;
                }
                case 38: {
                    BeamView.this.beamSelectionLocation.setRelativePoint(BeamView.this.beamSelectionLocation.getRelativeX(), BeamView.this.beamSelectionLocation.getRelativeY() - d);
                    BeamView.this.updateBeamSelection();
                    break;
                }
                case 40: {
                    BeamView.this.beamSelectionLocation.setRelativePoint(BeamView.this.beamSelectionLocation.getRelativeX(), BeamView.this.beamSelectionLocation.getRelativeY() + d);
                    BeamView.this.updateBeamSelection();
                    break;
                }
                case 86: {
                    BeamView.this.verticalModel();
                    BeamView.this.updateBeamSolutionFromModel();
                    break;
                }
                case 84: {
                    BeamView.this.teleseismModel();
                    BeamView.this.updateBeamSolutionFromModel();
                    break;
                }
                case 82: {
                    BeamView.this.regionalModel();
                    BeamView.this.updateBeamSolutionFromModel();
                    break;
                }
                case 76: {
                    BeamView.this.localModel();
                    BeamView.this.updateBeamSolutionFromModel();
                    break;
                }
                case 78: {
                    BeamView.this.nearModel();
                    BeamView.this.updateBeamSolutionFromModel();
                    break;
                }
                case 65: {
                    BeamView.this.acousticModel();
                    BeamView.this.updateBeamSolutionFromModel();
                    break;
                }
                case 66: {
                    BeamView.this.automaticCalc();
                    BeamView.this.updateBeamSelection();
                    break;
                }
                case 70: {
                    if (BeamView.this.fkAnalysis == null) {
                        BeamView.this.fkAnalysis = new FKAnalysis();
                        break;
                    }
                    BeamView.this.fkAnalysis = null;
                    break;
                }
                case 67: {
                    BeamView.this.arrayResponseFreq = BeamView.this.arrayResponseFreq == 0 ? BeamView.this.getFreqFromDialog() : 0;
                    if (BeamView.this.arrayResponseFreq == 0) {
                        BeamView.this.fkAnalysis = null;
                        break;
                    }
                    BeamView.this.fkAnalysis = new FKAnalysis();
                    break;
                }
                case 83: {
                    BeamView.this.shallowModel();
                    BeamView.this.updateBeamSolutionFromModel();
                    break;
                }
                case 112: {
                    if (keyEvent.isAltDown()) {
                        Legend.legendf1(Legend.WindowName.MASTEREVENT);
                        break;
                    }
                    Legend.legendf1(Legend.WindowName.BEAM);
                }
            }
            BeamView.this.updateFK();
            BeamView.this.repaint();
        }
    };
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                BeamView.this.beamSelectionLocation.setAbsolutePoint(mouseEvent.getPoint(), BeamView.this.getWidth(), BeamView.this.getHeight());
                BeamView.this.updateBeamSelection();
            } else if (mouseEvent.getButton() == 3) {
                BeamView.this.reset();
                for (SiteModel siteModel : BeamView.this.getCurrentSitesDetail()) {
                    if (BeamView.this.pOrSBeams) {
                        siteModel.setSimulatedpCorr(Double.NaN);
                    } else {
                        siteModel.setSimulatedsCorr(Double.NaN);
                    }
                    siteModel.updateRepaint();
                }
            }
            BeamView.this.repaint();
        }
    };

    public void automaticCalc() {
        if (this.beam != null) {
            double[] dArray = new double[this.beam.getBazi().length];
            double[] dArray2 = new double[this.beam.getBazi().length];
            double[] dArray3 = new double[this.beam.getBazi().length];
            for (int i = 0; i < this.beam.getBazi().length; ++i) {
                dArray[i] = (double)this.beam.getSx()[i] * this.beamCoordinateSystemModel.maxValue;
                dArray2[i] = (double)(-this.beam.getSy()[i]) * this.beamCoordinateSystemModel.maxValue;
                dArray3[i] = this.beam.getSlow()[i];
            }
            Percentile percentile = new Percentile(50.0);
            this.meanSlow = percentile.evaluate(dArray3);
            this.meanBazi = Math.atan2(-percentile.evaluate(dArray2), percentile.evaluate(dArray));
            boolean bl = false;
            for (double d : dArray3) {
                double d2 = d / this.meanSlow;
                if (!(d2 > 10.0) && !(d2 < 0.1)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                for (int i = 0; i < dArray.length; ++i) {
                    double d;
                    double d3 = Math.toDegrees(Math.atan2(-dArray2[i], dArray[i]));
                    d = MathUtil.compareAngles((double)d3, (double)Math.toDegrees(this.meanBazi));
                    if (!(Math.abs(d) > 90.0)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                LogUtil.warn(((Object)((Object)this)).getClass(), (String)"Warning: Jack-knifing with back-azimuth and slowness median comparisons resulted in strong outliers.", (boolean)true);
            }
            double d = this.meanSlow * this.beamCoordinateSystemModel.maxValue;
            this.beamSelectionLocation.setRelativePoint(d * Math.cos(this.meanBazi), -d * Math.sin(this.meanBazi));
            this.meanBazi = 90.0 - Math.toDegrees(this.meanBazi);
            if (this.meanBazi < 0.0) {
                this.meanBazi += 360.0;
            }
        }
    }

    protected int getFreqFromDialog() {
        JSpinner jSpinner = new JSpinner();
        jSpinner.setModel(new SpinnerNumberModel((Number)20, Integer.valueOf(0), null, (Number)1));
        int n = JOptionPane.showConfirmDialog(HypoLineManager.INSTANCE.getHlApp().getMainFrame(), jSpinner, "Which frequency [Hz] to use for array response calculation?", 2, 3, null);
        if (n == 2) {
            return 0;
        }
        return (Integer)jSpinner.getValue();
    }

    public void reset() {
        if (this.beamSiteModel != null) {
            if (this.pOrSBeams) {
                this.beamSiteModel.setpBeamAngle(Double.NaN);
                this.beamSiteModel.setpBeamAppVelocity(Double.NaN);
            } else {
                this.beamSiteModel.setsBeamAngle(Double.NaN);
                this.beamSiteModel.setsBeamAppVelocity(Double.NaN);
            }
            this.beamSelectionLocation.setRelativePoint(0.0, 0.0);
        }
        this.update();
    }

    public SiteModel getCurrentSiteCenterDetail() {
        for (SiteModel siteModel : HypoLineManager.INSTANCE.getCurrentSitesDetail()) {
            if (siteModel.getSns() == null || !siteModel.getId().equals(siteModel.getSns().getCenter().getId())) continue;
            return siteModel;
        }
        return null;
    }

    public List<SiteModel> getCurrentSitesDetail() {
        ArrayList<SiteModel> arrayList = new ArrayList<SiteModel>();
        for (SiteModel siteModel : HypoLineManager.INSTANCE.getCurrentSitesDetail()) {
            if (siteModel.getSns() == null) continue;
            arrayList.add(siteModel);
        }
        return arrayList;
    }

    public void updateBeamSelection() {
        double d = 1.0 / this.beamSelectionLocation.getRelativeDistance() * this.beamCoordinateSystemModel.maxValue;
        if (HypoLineManager.INSTANCE != null) {
            if (this.pOrSBeams) {
                this.beamSiteModel.setpBeamAngle(this.beamSelectionLocation.getAngle());
                this.beamSiteModel.setpBeamAppVelocity(d);
            } else {
                this.beamSiteModel.setsBeamAngle(this.beamSelectionLocation.getAngle());
                this.beamSiteModel.setsBeamAppVelocity(d);
            }
        }
        List<SiteModel> list = this.getCurrentSitesDetail();
        float[] fArray = new float[list.size()];
        float[] fArray2 = new float[list.size()];
        float f = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
        int n = 0;
        for (SiteModel siteModel : list) {
            fArray[n] = (float)siteModel.getXOffsetKm();
            fArray2[n] = (float)siteModel.getYOffsetKm();
            ++n;
        }
        if (list.size() > 2) {
            int n2;
            BeamCalc beamCalc = new BeamCalc(list.size());
            beamCalc.beam2onset(fArray, fArray2, (float)(this.beamSelectionLocation.getRelativeX() / this.beamCoordinateSystemModel.maxValue), (float)(-this.beamSelectionLocation.getRelativeY() / this.beamCoordinateSystemModel.maxValue));
            double d2 = 0.0;
            double d3 = 0.0;
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                if (n3 == 0 || list.get(n2).isActiveTrace()) {
                    d2 = this.pOrSBeams ? list.get(n2).getpCorr() : list.get(n2).getsCorr();
                    d3 = beamCalc.getSimult()[n2];
                }
                ++n3;
            }
            for (n2 = 0; n2 < list.size(); ++n2) {
                LogUtil.info(((Object)((Object)this)).getClass(), (String)("Simulated onset " + list.get(n2).getId() + " " + beamCalc.getSimult()[n2]));
                if (this.pOrSBeams) {
                    list.get(n2).setSimulatedpCorr(d2 + (double)((float)this.simulatedPOffset / f) + beamCalc.getSimult()[n2] - d3);
                    list.get(n2).updateRepaint();
                    continue;
                }
                list.get(n2).setSimulatedsCorr(d2 + (double)((float)this.simulatedSOffset / f) + beamCalc.getSimult()[n2]);
                list.get(n2).updateRepaint();
            }
            this.currentBeamCaption = this.df.format(d) + " km/s " + this.df.format(this.beamSelectionLocation.getAngle()) + "\u00b0 bazi";
            LogUtil.info(((Object)((Object)this)).getClass(), (String)this.currentBeamCaption);
        }
    }

    public BeamView(boolean bl) {
        this.pOrSBeams = bl;
        this.addMouseListener(this.mouseListener);
        this.addKeyListener(this.keyListener);
        if (bl) {
            this.beamColor = ThemeManager.getInstance().getTheme().getHypolineBlue();
            this.beamViewCaption = "Pc beam";
        } else {
            this.beamColor = ThemeManager.getInstance().getTheme().getHypolineGreen();
            this.beamViewCaption = "Sc beam";
        }
        this.setBackground(ThemeManager.getInstance().getTheme().getMapBackgroundColor());
        this.init();
    }

    public void init() {
        this.setLayout(null);
        this.setFocusable(true);
        this.setOpaque(true);
        this.beamCoordinateSystemPainter = new BeamCoordinateSystemPainter();
        this.beamLocationPainter = new BeamLocationPainter();
        this.beamSelectionLocation = new BeamLocation();
        if (HypoLineManager.INSTANCE != null) {
            this.beamSiteModel = this.getCurrentSiteCenterDetail();
        }
        this.updateBeamSolutionFromModel();
        this.setRenderingQuality(SwingUtil.RenderQuality.HIGH);
        this.localModel();
    }

    public void updateBeamSolutionFromModel() {
        if (this.beamSiteModel != null && this.beamCoordinateSystemModel != null) {
            if (this.pOrSBeams && !Double.isNaN(this.beamSiteModel.getpBeamAngle()) && !Double.isNaN(this.beamSiteModel.getpBeamAppVelocity())) {
                double d = this.beamSiteModel.getpBeamAngle();
                double d2 = 1.0 / this.beamSiteModel.getpBeamAppVelocity() * this.beamCoordinateSystemModel.maxValue;
                this.beamSelectionLocation.setRelativePoint(d2 * Math.cos(Math.toRadians(d - 90.0)), d2 * Math.sin(Math.toRadians(d - 90.0)));
                this.updateBeamSelection();
                this.repaint();
            } else if (!(this.pOrSBeams || Double.isNaN(this.beamSiteModel.getsBeamAngle()) || Double.isNaN(this.beamSiteModel.getsBeamAppVelocity()))) {
                double d = this.beamSiteModel.getsBeamAngle();
                double d3 = 1.0 / this.beamSiteModel.getsBeamAppVelocity() * this.beamCoordinateSystemModel.maxValue;
                this.beamSelectionLocation.setRelativePoint(d3 * Math.cos(Math.toRadians(d - 90.0)), d3 * Math.sin(Math.toRadians(d - 90.0)));
                this.updateBeamSelection();
                this.repaint();
            }
        }
    }

    public void verticalModel() {
        this.beamCoordinateSystemModel = new BeamCoordinateSystemModel("Vertical", 10.0);
        this.beamCoordinateSystemModel.addCircle("50 km/s", 0.02);
        this.beamCoordinateSystemModel.addCircle("30 km/s", 0.03333333333333333);
        this.beamCoordinateSystemModel.addCircle("20 km/s", 0.05);
        this.beamCoordinateSystemModel.addCircle("13 km/s", 0.07692307692307693);
        this.beamCoordinateSystemPainter.setModel(this.beamCoordinateSystemModel);
    }

    public void teleseismModel() {
        this.beamCoordinateSystemModel = new BeamCoordinateSystemModel("Teleseism", 5.0);
        this.beamCoordinateSystemModel.addCircle("20 km/s ~ 80\u00b0", 0.05);
        this.beamCoordinateSystemModel.addCircle("14 km/s ~ 50\u00b0", 0.07142857142857142);
        this.beamCoordinateSystemModel.addCircle("10 km/s ~ 20\u00b0", 0.1);
        this.beamCoordinateSystemModel.addCircle("7 km/s", 0.14285714285714285);
        this.beamCoordinateSystemPainter.setModel(this.beamCoordinateSystemModel);
    }

    public void regionalModel() {
        this.beamCoordinateSystemModel = new BeamCoordinateSystemModel("Regional", 2.5);
        this.beamCoordinateSystemModel.addCircle("SnLg", 0.2857142857142857);
        this.beamCoordinateSystemModel.addCircle("Pg", 0.16666666666666666);
        this.beamCoordinateSystemModel.addCircle("Pn", 0.125);
        this.beamCoordinateSystemPainter.setModel(this.beamCoordinateSystemModel);
    }

    public void localModel() {
        this.beamCoordinateSystemModel = new BeamCoordinateSystemModel("Local", 1.4285714285714286);
        this.beamCoordinateSystemModel.addCircle("Rg", 0.5);
        this.beamCoordinateSystemModel.addCircle("S", 0.2857142857142857);
        this.beamCoordinateSystemModel.addCircle("P", 0.16666666666666666);
        this.beamCoordinateSystemPainter.setModel(this.beamCoordinateSystemModel);
    }

    public void nearModel() {
        this.beamCoordinateSystemModel = new BeamCoordinateSystemModel("Near", 0.6666666666666666);
        this.beamCoordinateSystemModel.addCircle("1.0 km/s", 1.0);
        this.beamCoordinateSystemModel.addCircle("Rg", 0.5);
        this.beamCoordinateSystemModel.addCircle("S", 0.2857142857142857);
        this.beamCoordinateSystemModel.addCircle("P", 0.16666666666666666);
        this.beamCoordinateSystemPainter.setModel(this.beamCoordinateSystemModel);
    }

    public void acousticModel() {
        this.beamCoordinateSystemModel = new BeamCoordinateSystemModel("Acoustic", 0.25);
        this.beamCoordinateSystemModel.addCircle("acoustic", 2.941176470588235);
        this.beamCoordinateSystemModel.addCircle("0.5 km/s", 2.0);
        this.beamCoordinateSystemModel.addCircle("1.0 km/s", 1.0);
        this.beamCoordinateSystemModel.addCircle("2 km/s", 0.5);
        this.beamCoordinateSystemPainter.setModel(this.beamCoordinateSystemModel);
    }

    public void shallowModel() {
        this.beamCoordinateSystemModel = new BeamCoordinateSystemModel("Shallow", 0.125);
        this.beamCoordinateSystemModel.addCircle("0.15 km/s", 6.666666666666667);
        this.beamCoordinateSystemModel.addCircle("0.25 km/s", 4.0);
        this.beamCoordinateSystemModel.addCircle("0.5 km/s", 2.0);
        this.beamCoordinateSystemModel.addCircle("1 km/s", 1.0);
        this.beamCoordinateSystemPainter.setModel(this.beamCoordinateSystemModel);
    }

    public void update() {
        this.beam = null;
        List<SiteModel> list = this.getCurrentSitesDetail();
        this.sites.clear();
        for (Object object : list) {
            if (this.pOrSBeams) {
                if (Double.isNaN(object.getpCorr())) continue;
                this.sites.add((SiteModel)((Object)object));
                continue;
            }
            if (Double.isNaN(object.getsCorr())) continue;
            this.sites.add((SiteModel)((Object)object));
        }
        if (this.sites.size() >= 3) {
            Object object;
            this.beam = new BeamCalc(this.sites.size());
            Object object2 = new float[this.sites.size()];
            object = new float[this.sites.size()];
            double[] dArray = new double[this.sites.size()];
            float f = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
            int n = 0;
            for (SiteModel siteModel : this.sites) {
                object2[n] = (float)siteModel.getXOffsetKm();
                object[n] = (SiteModel)((float)siteModel.getYOffsetKm());
                dArray[n] = this.pOrSBeams ? siteModel.getpCorr() : siteModel.getsCorr();
                LogUtil.debug(((Object)((Object)this)).getClass(), (String)("Offsets: " + siteModel.getXOffsetKm() + " " + siteModel.getYOffsetKm() + " " + dArray[n]));
                ++n;
            }
            this.beam.onset2beam(dArray, (float[])object2, (float[])object, f);
            for (int i = 0; i < this.beam.getBazi().length; ++i) {
                LogUtil.info(((Object)((Object)this)).getClass(), (String)("Beam " + MathUtil.format2Digits((double)this.beam.getBazi()[i])));
            }
        } else {
            this.beam = null;
        }
        this.updateFK();
        this.repaint();
    }

    private void updateFK() {
        if (this.pOrSBeams && this.fkAnalysis != null) {
            this.fkAnalysis.update(this.beamCoordinateSystemModel.maxValue, this.arrayResponseFreq);
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        Object object;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.pOrSBeams && this.fkAnalysis != null && this.fkAnalysis.getNormalizedMap() != null) {
            object = this.fkAnalysis.getNormalizedMap();
            n = (int)Math.ceil((double)this.getWidth() / (double)((double[][])object).length);
            int n2 = (int)Math.ceil((double)this.getHeight() / (double)object[0].length);
            for (int i = 0; i < ((double[][])object).length; ++i) {
                for (int j = 0; j < ((Object)object[i]).length; ++j) {
                    float f = (float)MathUtil.convertFromTo((double)object[i][((Object)object[i]).length - j - 1], (double)0.0, (double)1.0, (double)0.0, (double)(this.colorNo - 1));
                    graphics2D.setColor(Colors.SONOGRAM[(int)f]);
                    int n3 = (int)Math.floor(MathUtil.convertFromTo((double)i, (double)0.0, (double)((Object)object).length, (double)0.0, (double)this.getWidth()));
                    int n4 = (int)Math.floor(MathUtil.convertFromTo((double)j, (double)0.0, (double)((Object)object[i]).length, (double)0.0, (double)this.getHeight()));
                    graphics2D.fillRect(n3, n4, n, n2);
                }
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
            graphics2D.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
        }
        this.beamCoordinateSystemPainter.paint(graphics2D, 0, 0, this.getWidth(), this.getHeight());
        if (!Double.isNaN(this.beamSiteModel.getpRay())) {
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGold());
            object = graphics2D.getStroke();
            graphics2D.setStroke(this.simulPrayStroke);
            n = (int)(Math.abs(this.beamSiteModel.getpRay()) / this.beamCoordinateSystemModel.maxValue * (double)this.getWidth());
            graphics2D.drawOval(this.getWidth() / 2 - n, this.getHeight() / 2 - n, 2 * n, 2 * n);
            graphics2D.setStroke((Stroke)object);
        }
        graphics2D.setFont(HypoLineFonts.semiSmallMapFont);
        graphics2D.setColor(this.beamColor);
        object = graphics2D.getFontMetrics().getStringBounds(this.beamViewCaption, graphics2D);
        graphics2D.drawString(this.beamViewCaption, this.textPadding, (int)((double)this.textPadding + ((RectangularShape)object).getHeight()));
        if (this.beam != null) {
            for (n = 0; n < this.beam.getBazi().length; ++n) {
                double d;
                double d2;
                BeamLocation beamLocation = new BeamLocation();
                double d3 = (double)this.beam.getSx()[n] * this.beamCoordinateSystemModel.maxValue;
                double d4 = Math.sqrt(d3 * d3 + (d2 = (double)(-this.beam.getSy()[n]) * this.beamCoordinateSystemModel.maxValue) * d2);
                if (d4 > (d = Math.sqrt(2.0))) {
                    d3 = d3 / d4 * d;
                    d2 = d2 / d4 * d;
                }
                beamLocation.setRelativePoint(d3, d2);
                graphics2D.setColor(this.beamColor);
                this.beamLocationPainter.paint(graphics2D, 0, 0, this.getWidth(), this.getHeight(), beamLocation);
            }
        }
        SwingUtil.setRenderingQuality((Graphics2D)graphics2D, (SwingUtil.RenderQuality)this.renderingQuality);
        if (this.beamSelectionLocation != null) {
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGold());
            this.beamLocationPainter.paint(graphics2D, 0, 0, this.getWidth(), this.getHeight(), this.beamSelectionLocation);
        }
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(this.currentBeamCaption, graphics2D);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(this.textPadding, (int)((double)(this.getHeight() - this.textPadding) - rectangle2D.getHeight()), (int)rectangle2D.getWidth(), (int)(rectangle2D.getHeight() * 1.5));
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(this.currentBeamCaption, this.textPadding, this.getHeight() - this.textPadding);
    }

    public final SwingUtil.RenderQuality getRenderingQuality() {
        return this.renderingQuality;
    }

    public final void setRenderingQuality(SwingUtil.RenderQuality renderQuality) {
        this.renderingQuality = renderQuality;
        this.beamCoordinateSystemPainter.setRenderQuality(this.renderingQuality);
        this.repaint();
    }

    public static void main(String[] stringArray) {
        new BeamView(true).debug();
    }

    private void debug() {
        LoadHeaderUtil.loadHeader((File)new File("/home/sick/geophys/knowbases/Heumoeser_Hang/Felssturz/header.sht"));
        List list = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().getAllActiveSNS()[0].getAllSites();
        this.beam = new BeamCalc(list.size());
        float[] fArray = new float[list.size()];
        float[] fArray2 = new float[list.size()];
        double[] dArray = new double[list.size()];
        float f = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
        int n = 0;
        for (Site site : list) {
            fArray[n] = (float)site.getXOffsetKm();
            fArray2[n] = (float)site.getYOffsetKm();
            dArray[n] = (double)n / (double)f;
            ++n;
        }
        this.beam.onset2beam(dArray, fArray, fArray2, f);
        for (int i = 0; i < this.beam.getSlow().length; ++i) {
            LogUtil.info(((Object)((Object)this)).getClass(), (String)("Slowness: " + this.beam.getSlow()[i] + " 1/: " + 1.0 / (double)this.beam.getSlow()[i] + " Angle: " + this.beam.getBazi()[i] + " X: " + this.beam.getSx()[i] + " Y: " + this.beam.getSy()[i]));
        }
        this.beam.beam2onset(fArray, fArray2, this.beam.getSx()[1], this.beam.getSy()[1]);
        JFrame jFrame = new JFrame();
        jFrame.setSize(400, 400);
        jFrame.setDefaultCloseOperation(3);
        jFrame.add((Component)((Object)this));
        jFrame.setVisible(true);
    }

    public BeamCalc getBeam() {
        return this.beam;
    }

    public void setBeam(BeamCalc beamCalc) {
        this.beam = beamCalc;
    }

    public double getMeanSlow() {
        return this.meanSlow;
    }

    public void setMeanSlow(double d) {
        this.meanSlow = d;
    }

    public double getMeanBazi() {
        return this.meanBazi;
    }

    public void setMeanBazi(double d) {
        this.meanBazi = d;
    }

    public BeamCoordinateSystemModel getBeamCoordinateSystemModel() {
        return this.beamCoordinateSystemModel;
    }

    public void setBeamCoordinateSystemModel(BeamCoordinateSystemModel beamCoordinateSystemModel) {
        this.beamCoordinateSystemModel = beamCoordinateSystemModel;
    }
}

