/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.filter;

import edu.geophys.commons.range.DefaultRangeMarkerModel;
import edu.geophys.commons.range.RangeMarkerModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.SuiteTheme;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.hypoline.HypoLineConfiguration;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.Legend;
import edu.geophys.hypoline.ui.filter.FrequencyAxisRenderer;
import edu.geophys.hypoline.ui.filter.RangeSelectionBox;
import edu.geophys.hypoline.ui.trace.SiteModel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import layout.TableLayout;

public class FilterView
extends ActivateableComponent {
    private static final long serialVersionUID = 1L;
    private RangeMarkerModel<RangeSelectionBox> model = new DefaultRangeMarkerModel();
    private boolean changeInProgress = false;
    private static final int LR_MARGIN = 8;
    private static final int BORDER = 2;
    private static final int SCALE_HEIGHT = 20;
    List<RangeSelectionBox> rangeBoxes = new ArrayList<RangeSelectionBox>();
    private KeyListener keyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 49: {
                    FilterView.this.updateSiteModels(1.0f, 2.0f);
                    break;
                }
                case 50: {
                    FilterView.this.updateSiteModels(2.0f, 4.0f);
                    break;
                }
                case 52: {
                    FilterView.this.updateSiteModels(4.0f, 6.0f);
                    break;
                }
                case 54: {
                    FilterView.this.updateSiteModels(6.0f, 8.0f);
                    break;
                }
                case 56: {
                    FilterView.this.updateSiteModels(8.0f, 10.0f);
                    break;
                }
                case 65: {
                    FilterView.this.updateSiteModels(10.0f, 12.0f);
                    break;
                }
                case 66: {
                    FilterView.this.updateSiteModels(12.0f, 16.0f);
                    break;
                }
                case 67: {
                    FilterView.this.updateSiteModels(16.0f, 20.0f);
                    break;
                }
                case 68: {
                    FilterView.this.updateSiteModels(20.0f, 24.0f);
                    break;
                }
                case 69: {
                    FilterView.this.updateSiteModels(24.0f, 28.0f);
                    break;
                }
                case 70: {
                    FilterView.this.updateSiteModels(28.0f, 32.0f);
                    break;
                }
                case 88: {
                    FilterView.this.updateSiteModels(5.0f, 20.0f);
                    break;
                }
                case 89: {
                    FilterView.this.updateSiteModels(5.0f, 40.0f);
                    break;
                }
                case 81: {
                    FilterView.this.updateSiteModels(1.0f, 0.0f);
                    break;
                }
                case 87: {
                    FilterView.this.updateSiteModels(2.0f, 0.0f);
                    break;
                }
                case 72: {
                    FilterView.this.updateSiteModels(1.0f, 10.0f);
                    break;
                }
                case 74: {
                    FilterView.this.updateSiteModels(1.0f, 20.0f);
                    break;
                }
                case 75: {
                    FilterView.this.updateSiteModels(1.0f, 60.0f);
                    break;
                }
                case 76: {
                    FilterView.this.updateSiteModels(1.0f, 80.0f);
                    break;
                }
                case 73: {
                    FilterView.this.showInputWindow();
                    break;
                }
                case 84: {
                    HypoLineManager.INSTANCE.getConfig().setTieFilters(!HypoLineManager.INSTANCE.getConfig().isTieFilters());
                    if (HypoLineManager.INSTANCE.getCurrentSitesDetail().size() <= 0) break;
                    FilterView.this.updateSiteModels(HypoLineManager.INSTANCE.getCurrentSitesDetail().get(0).getFl(), HypoLineManager.INSTANCE.getCurrentSitesDetail().get(0).getFu());
                    break;
                }
                case 112: {
                    if (keyEvent.isAltDown()) {
                        Legend.legendf1(Legend.WindowName.MASTEREVENT);
                        break;
                    }
                    Legend.legendf1(Legend.WindowName.FILTER);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
                siteModel.getChild().setFlFu(0.0f, 0.0f);
            }
        }
    };

    public FilterView() {
        this.setMinimumSize(new Dimension(200, 100));
        this.setPreferredSize(new Dimension(200, 100));
        HypoLineManager.INSTANCE.getConfig().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("activeSNS")) {
                    FilterView.this.update();
                }
            }
        });
        this.addKeyListener(this.keyListener);
        this.addMouseListener(this.mouseListener);
    }

    public void update() {
        this.removeAll();
        TableLayout tableLayout = new TableLayout();
        tableLayout.insertColumn(0, 8.0);
        tableLayout.insertColumn(0, -1.0);
        tableLayout.insertColumn(0, 8.0);
        this.setLayout((LayoutManager)tableLayout);
        int n = 0;
        tableLayout.insertRow(n, 2.0);
        ++n;
        for (RangeSelectionBox rangeSelectionBox : this.rangeBoxes) {
            rangeSelectionBox.removeSiteListener();
        }
        this.rangeBoxes.clear();
        int n2 = HypoLineManager.INSTANCE.getCurrentSitesOverview().size();
        int n3 = (this.getHeight() - 4 - 20) / n2 - 2;
        int n4 = 0;
        for (SiteModel siteModel : HypoLineManager.INSTANCE.getCurrentSitesOverview()) {
            SiteModel siteModel2 = siteModel.getChild();
            RangeSelectionBox rangeSelectionBox = new RangeSelectionBox(siteModel2, this);
            SuiteTheme suiteTheme = ThemeManager.getInstance().getTheme();
            rangeSelectionBox.setForceSelectionBounds(true);
            rangeSelectionBox.setSelectionModel(this.model);
            rangeSelectionBox.setSelectionBorder(suiteTheme.getUIBorderColor());
            rangeSelectionBox.setSelectionFill(suiteTheme.getPlotForegroundColor());
            rangeSelectionBox.setSelectionBorderHighlighted(suiteTheme.getHypolineRed());
            rangeSelectionBox.setCursor(Cursor.getPredefinedCursor(11));
            rangeSelectionBox.setSelectionFillHighlighted(suiteTheme.getPlotForegroundColor());
            rangeSelectionBox.setBorder(BorderFactory.createLineBorder(suiteTheme.getUIBorderColor()));
            tableLayout.insertRow(n, (double)n3);
            this.add(rangeSelectionBox, "1, " + n);
            ++n;
            if (n4 < n2 - 1) {
                // empty if block
            }
            tableLayout.insertRow(n, 2.0);
            ++n;
            this.rangeBoxes.add(rangeSelectionBox);
            ++n4;
        }
        tableLayout.insertRow(n, 20.0);
        this.add(new FrequencyAxisRenderer(this.rangeBoxes, 0, (int)(SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate() / 2.0f)), "1, " + n);
        this.revalidate();
    }

    private void updateSiteModels(float f, float f2) {
        if (HypoLineManager.INSTANCE.getConfig().isTieFilters()) {
            for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
                siteModel.getChild().setFlFu(f, f2);
            }
        } else {
            for (SiteModel siteModel : HypoLineManager.INSTANCE.getCurrentSitesOverview()) {
                siteModel.getChild().setFlFu(f, f2);
            }
        }
        if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
            HypoLineManager.INSTANCE.getpBeamView().update();
            HypoLineManager.INSTANCE.getsBeamView().update();
        }
    }

    protected void showInputWindow() {
        TableLayout tableLayout = new TableLayout();
        JPanel jPanel = new JPanel((LayoutManager)tableLayout);
        tableLayout.insertColumn(0, -3.0);
        tableLayout.insertColumn(1, 150.0);
        tableLayout.insertColumn(0, -3.0);
        tableLayout.insertColumn(1, 150.0);
        int n = 0;
        final boolean bl = HypoLineManager.INSTANCE.getConfig().isTieFilters();
        List<SiteModel> list = HypoLineManager.INSTANCE.getCurrentSitesOverview();
        final JSpinner[] jSpinnerArray = new JSpinner[list.size()];
        final JSpinner[] jSpinnerArray2 = new JSpinner[list.size()];
        for (int i = 0; i < jSpinnerArray.length; ++i) {
            jSpinnerArray[i] = new JSpinner();
            jSpinnerArray2[i] = new JSpinner();
        }
        for (final SiteModel siteModel : list) {
            tableLayout.insertRow(n, -3.0);
            final int n2 = n;
            JLabel jLabel = new JLabel(siteModel.getId() + " fl [Hz]:");
            jSpinnerArray[n2].setModel(new SpinnerNumberModel(Float.valueOf(siteModel.getFl()), Float.valueOf(0.0f), null, Float.valueOf(1.0f)));
            jSpinnerArray[n2].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    float f = ((Float)jSpinnerArray[n2].getValue()).floatValue();
                    if (!bl) {
                        siteModel.getChild().setFl(f);
                    } else if (!FilterView.this.changeInProgress) {
                        FilterView.this.changeInProgress = true;
                        for (SiteModel siteModel2 : HypoLineManager.INSTANCE.getSites()) {
                            siteModel2.getChild().setFl(f);
                        }
                        for (JSpinner jSpinner : jSpinnerArray) {
                            if (jSpinner == jSpinnerArray[n2]) continue;
                            jSpinner.setValue(Float.valueOf(f));
                        }
                        FilterView.this.changeInProgress = false;
                    }
                }
            });
            jPanel.add((Component)jLabel, "0, " + n);
            jPanel.add((Component)jSpinnerArray[n2], "1, " + n);
            JLabel jLabel2 = new JLabel("fu [Hz]:");
            jSpinnerArray2[n2].setModel(new SpinnerNumberModel(Float.valueOf(siteModel.getFu()), Float.valueOf(0.0f), null, Float.valueOf(1.0f)));
            jSpinnerArray2[n2].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    float f = ((Float)jSpinnerArray2[n2].getValue()).floatValue();
                    if (!bl) {
                        siteModel.getChild().setFu(f);
                    } else if (!FilterView.this.changeInProgress) {
                        FilterView.this.changeInProgress = true;
                        for (SiteModel siteModel2 : HypoLineManager.INSTANCE.getSites()) {
                            siteModel2.getChild().setFu(f);
                        }
                        for (JSpinner jSpinner : jSpinnerArray2) {
                            if (jSpinner == jSpinnerArray2[n2]) continue;
                            jSpinner.setValue(Float.valueOf(f));
                        }
                        FilterView.this.changeInProgress = false;
                    }
                }
            });
            jPanel.add((Component)jLabel2, "2, " + n);
            jPanel.add((Component)jSpinnerArray2[n2], "3, " + n);
            ++n;
        }
        JOptionPane.showOptionDialog(HypoLineManager.INSTANCE.getHlApp().getMainFrame(), jPanel, "Select filter parameters", -1, -1, null, null, null);
    }

    public boolean isAnyHighlighted() {
        for (RangeSelectionBox rangeSelectionBox : this.rangeBoxes) {
            if (!rangeSelectionBox.isHighlighted()) continue;
            return true;
        }
        return false;
    }

    public void updateOtherRangeBoxes(RangeSelectionBox rangeSelectionBox) {
        for (RangeSelectionBox rangeSelectionBox2 : this.rangeBoxes) {
            if (rangeSelectionBox2 == rangeSelectionBox) continue;
            rangeSelectionBox2.repaint();
        }
    }
}

