/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.filter;

import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.filter.RangeSelectionBox;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JComponent;

public class FrequencyAxisRenderer
extends JComponent {
    private static final long serialVersionUID = 1L;
    private boolean _isSelected = false;
    int mineee = -1;
    final DecimalFormat OUTPUT_FORMAT = new DecimalFormat("#.#E0");
    private final List<RangeSelectionBox> rangeBoxes;
    final int start;
    final int end;
    private int nrSteps;
    private int minexp;
    private Font captionFont = new Font("Arial", 0, 11);
    private static final int AXIS_YPOS = 2;
    private static final int MAYOR_TICK_LEN = 4;
    MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            double d = MathUtil.convertToRelative((int)(mouseEvent.getX() - FrequencyAxisRenderer.this.getInsets().left), (int)(FrequencyAxisRenderer.this.getWidth() - (FrequencyAxisRenderer.this.getInsets().left + FrequencyAxisRenderer.this.getInsets().right)));
            if (HypoLineManager.INSTANCE.getConfig().isTieFilters()) {
                if (FrequencyAxisRenderer.this.rangeBoxes.size() > 0) {
                    RangeSelectionBox rangeSelectionBox = FrequencyAxisRenderer.this.rangeBoxes.get(0);
                    if (mouseEvent.getButton() == 1) {
                        rangeSelectionBox.updateSelection(d, rangeSelectionBox.getSelectionEnd(), true);
                    } else {
                        rangeSelectionBox.updateSelection(rangeSelectionBox.getSelectionStart(), d, true);
                    }
                }
            } else {
                for (RangeSelectionBox rangeSelectionBox : FrequencyAxisRenderer.this.rangeBoxes) {
                    if (mouseEvent.getButton() == 1) {
                        rangeSelectionBox.updateSelection(d, rangeSelectionBox.getSelectionEnd(), false);
                        continue;
                    }
                    rangeSelectionBox.updateSelection(rangeSelectionBox.getSelectionStart(), d, false);
                }
            }
        }
    };

    public FrequencyAxisRenderer(List<RangeSelectionBox> list, int n, int n2) {
        this.rangeBoxes = list;
        this.start = n;
        this.end = n2;
        int n3 = 0;
        if (n2 > 1) {
            while (Math.pow(10.0, n3) < (double)n2) {
                ++n3;
            }
        } else {
            while (Math.pow(10.0, n3) > (double)n2) {
                --n3;
            }
        }
        this.nrSteps = n3;
        this.minexp = 0;
        if (n > 0) {
            while (Math.pow(10.0, this.minexp) > (double)n) {
                --this.minexp;
            }
        }
        this.addMouseListener(this.mouseAdapter);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawLine(0, 2, this.getWidth(), 2);
        for (int i = this.mineee; i < this.nrSteps; ++i) {
            double d = Math.pow(10.0, i);
            int n = (int)((double)(i - this.mineee) / (Math.log10(this.end) - (double)this.mineee) * (double)this.getWidth());
            graphics2D.setFont(this.captionFont);
            graphics2D.drawLine(n, 2, n, 6);
            Object object = "";
            object = Math.abs(i) <= 3 ? MathUtil.format2Digits((double)d) + "Hz" : this.OUTPUT_FORMAT.format(d) + "Hz";
            if (i == this.mineee) {
                graphics2D.drawString((String)object, 2, this.getHeight() - 3);
                continue;
            }
            Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds((String)object, graphics);
            graphics2D.drawString((String)object, (int)((double)n - rectangle2D.getWidth() / 2.0), this.getHeight() - 3);
        }
    }

    public final boolean isSelected() {
        return this._isSelected;
    }

    public final void setSelected(boolean bl) {
        this._isSelected = bl;
    }
}

