/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.filter;

import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.range.DefaultRangeMarkerModel;
import edu.geophys.commons.range.RangeDataEvent;
import edu.geophys.commons.range.RangeDataListener;
import edu.geophys.commons.range.RangeMarkerModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.HypoLineConfiguration;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.filter.FilterView;
import edu.geophys.hypoline.ui.trace.SiteModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.UUID;
import javax.swing.JComponent;

public class RangeSelectionBox
extends JComponent
implements RangeDataListener {
    private static final long serialVersionUID = 1L;
    double minfreq = 0.1;
    private final FilterView filterView;
    private final CampaignKnowledge ck = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
    private final RangeSelectionBox thisRangeSelectionBox;
    private final Painter __painter = new Painter();
    private Color _selectionBorder = Color.BLUE;
    private Color _selectionFill = Color.GREEN;
    private Color _selectionBorderHighlighted = Color.MAGENTA;
    private Color _selectionFillHighlighted = Color.YELLOW;
    private RangeMarkerModel<?> _selectionModel = new DefaultRangeMarkerModel();
    private String _startMarkerId = "Start" + UUID.randomUUID();
    private String _endMarkerId = "End" + UUID.randomUUID();
    private boolean _forceSelectionBounds = true;
    private boolean _highlightable = true;
    private boolean _highlighted = false;
    private SiteModel siteModel;
    PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("fl") || propertyChangeEvent.getPropertyName().equals("fu") || propertyChangeEvent.getPropertyName().equals("flfu")) {
                LogUtil.debug(this.getClass(), (String)"range fl, fu");
                RangeSelectionBox.this.updateFlFu();
            }
        }
    };

    public void removeSiteListener() {
        this.siteModel.removePropertyChangeListener(this.pcl);
    }

    public RangeSelectionBox(SiteModel siteModel, final FilterView filterView) {
        this.filterView = filterView;
        this.siteModel = siteModel;
        this.thisRangeSelectionBox = this;
        this.updateFlFu();
        siteModel.addPropertyChangeListener(this.pcl);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                double d = MathUtil.convertToRelative((int)(mouseEvent.getX() - RangeSelectionBox.this.getInsets().left), (int)(RangeSelectionBox.this.getWidth() - (RangeSelectionBox.this.getInsets().left + RangeSelectionBox.this.getInsets().right)));
                if (mouseEvent.getButton() == 1) {
                    RangeSelectionBox.this.updateSelection(d, RangeSelectionBox.this.getSelectionEnd(), HypoLineManager.INSTANCE.getConfig().isTieFilters());
                } else if (mouseEvent.getButton() == 3) {
                    RangeSelectionBox.this.updateSelection(RangeSelectionBox.this.getSelectionStart(), d, HypoLineManager.INSTANCE.getConfig().isTieFilters());
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                double d = (double)mouseWheelEvent.getWheelRotation() / (double)(RangeSelectionBox.this.getWidth() - (RangeSelectionBox.this.getInsets().left + RangeSelectionBox.this.getInsets().right));
                RangeSelectionBox.this.updateSelection(RangeSelectionBox.this.getSelectionStart() - d, RangeSelectionBox.this.getSelectionEnd() - d, HypoLineManager.INSTANCE.getConfig().isTieFilters());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RangeSelectionBox.this.setHighlighted(false);
                if (HypoLineManager.INSTANCE.getConfig().isTieFilters()) {
                    filterView.updateOtherRangeBoxes(RangeSelectionBox.this.thisRangeSelectionBox);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RangeSelectionBox.this.setHighlighted(true);
                if (HypoLineManager.INSTANCE.getConfig().isTieFilters()) {
                    filterView.updateOtherRangeBoxes(RangeSelectionBox.this.thisRangeSelectionBox);
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseWheelListener(mouseAdapter);
    }

    private void forceFullRepaint() {
        this.repaint();
    }

    public void updateFlFu() {
        double d = (double)this.ck.getGlobalSamplerate() / 2.0;
        double d2 = Math.log10((double)this.siteModel.getFl() / this.minfreq) / Math.log10(d / this.minfreq);
        double d3 = Math.log10((double)this.siteModel.getFu() / this.minfreq) / Math.log10(d / this.minfreq);
        this._selectionModel.setAdjusting(true);
        this._selectionModel.setMarker(this._startMarkerId, d2, null);
        this._selectionModel.setMarker(this._endMarkerId, d3, null);
        this._selectionModel.setAdjusting(false);
        this._selectionModel.addMarkerDataListener((RangeDataListener)this);
        this.repaint();
    }

    public void updateSelection(double d, double d2, boolean bl) {
        double d3 = this.getSelectionStart();
        double d4 = this.getSelectionEnd();
        if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE) && this.siteModel.getThreeComp() != null) {
            LogUtil.warn(this.getClass(), (String)("Filter for 3c fixed for local magnitude: " + this.siteModel.getId()));
        }
        if (this.isForceSelectionBounds()) {
            d = d > 0.0 ? d : 0.0;
            double d5 = d2 = d2 < 1.0 && d2 > 0.0 ? d2 : 1.0;
        }
        if (d > d4 && MathUtil.isFinite((double)d) && MathUtil.isFinite((double)d3) && MathUtil.isFinite((double)d4)) {
            this._selectionModel.setAdjusting(false);
            this._selectionModel.setMarker(this._startMarkerId, d, null);
            this._selectionModel.setMarker(this._endMarkerId, d + (d4 - d3), null);
        } else if (d2 < d3 && MathUtil.isFinite((double)d2) && MathUtil.isFinite((double)d3) && MathUtil.isFinite((double)d4)) {
            this._selectionModel.setAdjusting(false);
            this._selectionModel.setMarker(this._startMarkerId, d2, null);
            this._selectionModel.setMarker(this._endMarkerId, d2 + (d4 - d3), null);
        } else if (d != d3 && d2 == d4 && MathUtil.isFinite((double)d)) {
            this._selectionModel.setMarker(this._startMarkerId, d, null);
        } else if (d == d3 && d2 != d4 && MathUtil.isFinite((double)d2)) {
            this._selectionModel.setMarker(this._endMarkerId, d2, null);
        } else {
            this._selectionModel.setAdjusting(true);
            this._selectionModel.setMarker(this._startMarkerId, d, null);
            this._selectionModel.setMarker(this._endMarkerId, d2, null);
        }
        double d6 = (double)this.ck.getGlobalSamplerate() / 2.0;
        double d7 = this._selectionModel.getMarker(this._startMarkerId).getPosition();
        double d8 = this._selectionModel.getMarker(this._endMarkerId).getPosition();
        float f = (float)(this.minfreq * Math.pow(10.0, d7 * Math.log10(d6 / this.minfreq)));
        float f2 = (float)(this.minfreq * Math.pow(10.0, d8 * Math.log10(d6 / this.minfreq)));
        if (!MathUtil.isFinite((float)f)) {
            f = 0.0f;
        }
        if (!MathUtil.isFinite((float)f2)) {
            f2 = (float)d6;
        }
        if (bl) {
            for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
                siteModel.getChild().setFlFu(f, f2);
            }
        } else {
            this.siteModel.setFlFu(f, f2);
        }
        if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
            for (SiteModel siteModel : HypoLineManager.INSTANCE.getCurrentSitesDetail()) {
                siteModel.update();
            }
        }
        this._selectionModel.setAdjusting(false);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getWidth() - (this.getInsets().left + this.getInsets().right);
        int n2 = this.getHeight() - (this.getInsets().top + this.getInsets().bottom);
        Graphics2D graphics2D = (Graphics2D)graphics.create(this.getInsets().left, this.getInsets().top, n, n2);
        this.__painter.doPaint(graphics2D, null, n, n2);
    }

    public final RangeMarkerModel<?> getSelectionModel() {
        return this._selectionModel;
    }

    public final void setSelectionModel(RangeMarkerModel<?> rangeMarkerModel) {
        this._selectionModel.removeMarkerDataListener((RangeDataListener)this);
        this._selectionModel.setAdjusting(true);
        rangeMarkerModel.setMarker(this._startMarkerId, this.getSelectionStart(), null);
        rangeMarkerModel.setMarker(this._endMarkerId, this.getSelectionEnd(), null);
        this._selectionModel.setAdjusting(false);
        this._selectionModel = rangeMarkerModel;
        this._selectionModel.addMarkerDataListener((RangeDataListener)this);
    }

    public double getSelectionStart() {
        return this._selectionModel.getMarker(this._startMarkerId).getPosition();
    }

    public double getSelectionEnd() {
        return this._selectionModel.getMarker(this._endMarkerId).getPosition();
    }

    public final String getStartMarkerId() {
        return this._startMarkerId;
    }

    public final void setStartMarkerId(String string) {
        this._startMarkerId = string;
        this.repaint();
    }

    public final String getEndMarkerId() {
        return this._endMarkerId;
    }

    public final void setEndMarkerId(String string) {
        this._endMarkerId = string;
        this.repaint();
    }

    public final Color getSelectionBorder() {
        return this._selectionBorder;
    }

    public final void setSelectionBorder(Color color) {
        this._selectionBorder = color;
        this.forceFullRepaint();
    }

    public final Color getSelectionFill() {
        return this._selectionFill;
    }

    public final void setSelectionFill(Color color) {
        this._selectionFill = color;
        this.forceFullRepaint();
    }

    public final Color getSelectionBorderHighlighted() {
        return this._selectionBorderHighlighted;
    }

    public final void setSelectionBorderHighlighted(Color color) {
        this._selectionBorderHighlighted = color;
        this.forceFullRepaint();
    }

    public final Color getSelectionFillHighlighted() {
        return this._selectionFillHighlighted;
    }

    public final void setSelectionFillHighlighted(Color color) {
        this._selectionFillHighlighted = color;
        this.forceFullRepaint();
    }

    public final boolean isHighlightable() {
        return this._highlightable;
    }

    public final void setHighlightable(boolean bl) {
        this._highlightable = bl;
    }

    public final boolean isHighlighted() {
        return this.isHighlightable() && this._highlighted;
    }

    public final void setHighlighted(boolean bl) {
        this._highlighted = bl;
        this.repaint();
    }

    public final boolean isForceSelectionBounds() {
        return this._forceSelectionBounds;
    }

    public final void setForceSelectionBounds(boolean bl) {
        this._forceSelectionBounds = bl;
    }

    public void markerAdded(RangeDataEvent rangeDataEvent) {
        if (this._startMarkerId.equals(rangeDataEvent.getMarker().getID()) || this._endMarkerId.equals(rangeDataEvent.getMarker().getID())) {
            this.repaint();
        }
    }

    public void markerRemoved(RangeDataEvent rangeDataEvent) {
        if (this._startMarkerId.equals(rangeDataEvent.getMarker().getID()) || this._endMarkerId.equals(rangeDataEvent.getMarker().getID())) {
            this.repaint();
        }
    }

    public void positionChanged(RangeDataEvent rangeDataEvent) {
        if (this._startMarkerId.equals(rangeDataEvent.getMarker().getID()) || this._endMarkerId.equals(rangeDataEvent.getMarker().getID())) {
            this.repaint();
        }
    }

    public void valueChanged(RangeDataEvent rangeDataEvent) {
    }

    public void allChanged(RangeDataEvent rangeDataEvent) {
        this.repaint();
    }

    private class Painter {
        private double _bufferStart;
        private double _bufferEnd;

        private Painter() {
        }

        protected void doPaint(Graphics2D graphics2D, Object object, int n, int n2) {
            this._bufferStart = RangeSelectionBox.this.getSelectionStart();
            this._bufferEnd = RangeSelectionBox.this.getSelectionEnd();
            int n3 = (int)Math.rint(this._bufferStart * (double)n);
            int n4 = (int)Math.rint((this._bufferEnd - this._bufferStart) * (double)n);
            boolean bl = RangeSelectionBox.this.isHighlighted() || HypoLineManager.INSTANCE.getConfig().isTieFilters() && RangeSelectionBox.this.filterView.isAnyHighlighted();
            graphics2D.setColor(bl ? RangeSelectionBox.this.getSelectionFillHighlighted() : RangeSelectionBox.this.getSelectionFill());
            graphics2D.fillRect(n3, 0, n4, n2);
        }
    }
}

