/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.threecomp;

import Jama.Matrix;
import edu.geophys.commons.resources.Colors;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.commons.util.PCAHelper;
import edu.geophys.commons.util.PolarizationAnalysis;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.epimap.EpiCenter;
import edu.geophys.hypoline.ui.Legend;
import edu.geophys.hypoline.ui.threecomp.BufferedImage3dView;
import edu.geophys.hypoline.ui.trace.SiteModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import layout.TableLayout;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.ChartLauncher;
import org.jzy3d.chart.controllers.camera.AbstractCameraController;
import org.jzy3d.chart.controllers.mouse.camera.CameraMouseController;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.rendering.canvas.Quality;

public class HodoPanel {
    private static final long serialVersionUID = 1L;
    private final int thickness = 5;
    private float[] data_z = new float[10];
    private float[] data_n = new float[10];
    private float[] data_e = new float[10];
    private float[] data_p_rot = new float[10];
    private float[] data_sv_rot = new float[10];
    private float[] data_sh_rot = new float[10];
    private JSlider aziSlider;
    private JSlider inclinationSlider;
    private Font defaultFont = new Font("Arial", 0, 10);
    private SiteModel normalModel;
    private SiteModel transModel;
    private SiteModel movingPCAModel;
    private float backAzimuth = 0.0f;
    private float inclination = 0.0f;
    private JPanel buttonPanel;
    private HodoPanelPainter[] origpainters = new HodoPanelPainter[3];
    private HodoPanelPainter[] transpainters = new HodoPanelPainter[3];
    private BufferedImage3dView bi3d = new BufferedImage3dView();
    private ActivateableComponent origHodo = new ActivateableComponent();
    private ActivateableComponent transHodo = new ActivateableComponent();
    private KeyListener origKeyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 51: {
                    HodoPanel.this.show3dView(false, true);
                    break;
                }
                case 66: {
                    HodoPanel.this.automaticCalc();
                    break;
                }
                case 112: {
                    if (keyEvent.isAltDown()) {
                        Legend.legendf1(Legend.WindowName.MASTEREVENT);
                        break;
                    }
                    Legend.legendf1(Legend.WindowName.HODOMAP);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    };
    private KeyListener transKeyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 51: {
                    HodoPanel.this.show3dView(true, true);
                    break;
                }
                case 66: {
                    HodoPanel.this.automaticCalc();
                    break;
                }
                case 112: {
                    if (keyEvent.isAltDown()) {
                        Legend.legendf1(Legend.WindowName.MASTEREVENT);
                        break;
                    }
                    Legend.legendf1(Legend.WindowName.HODOMAP);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    };

    public HodoPanel() {
        this.origHodo.addKeyListener(this.origKeyListener);
        this.transHodo.addKeyListener(this.transKeyListener);
        this.origHodo.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -1.0}, {-1.0, -1.0}}));
        this.transHodo.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -1.0}, {-1.0, -1.0}}));
        this.origpainters[0] = new HodoPanelPainter("E", "N");
        this.origpainters[1] = new HodoPanelPainter("E", "Z");
        this.origpainters[2] = new HodoPanelPainter("N", "Z");
        this.transpainters[0] = new HodoPanelPainter("K2", "K3");
        this.transpainters[1] = new HodoPanelPainter("K2", "K1");
        this.transpainters[2] = new HodoPanelPainter("K3", "K1");
        this.createButtonPanel();
        this.origHodo.add((Component)this.buttonPanel, (Object)"0, 0");
        this.origHodo.add((Component)this.origpainters[0], (Object)"1, 0");
        this.origHodo.add((Component)this.origpainters[1], (Object)"0, 1");
        this.origHodo.add((Component)this.origpainters[2], (Object)"1, 1");
        this.transHodo.add((Component)this.bi3d, (Object)"0, 0");
        this.transHodo.add((Component)this.transpainters[0], (Object)"1, 0");
        this.transHodo.add((Component)this.transpainters[1], (Object)"0, 1");
        this.transHodo.add((Component)this.transpainters[2], (Object)"1, 1");
    }

    public void update() {
        if (this.normalModel != null && this.normalModel.getTraceEW() != null && this.normalModel.getTraceNS() != null) {
            this.data_z = this.normalModel.getCurrentZoomZTrace().getSamples();
            this.data_n = this.normalModel.getCurrentZoomNTrace().getSamples();
            this.data_e = this.normalModel.getCurrentZoomETrace().getSamples();
        }
        if (this.data_z.length > 0 && this.data_n.length > 0 && this.data_e.length > 0) {
            this.updateAziOrInc();
        }
    }

    private void automaticCalc() {
        double d = 0.0;
        EpiCenter epiCenter = HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter();
        if (!Double.isNaN(epiCenter.getX()) && !Double.isNaN(epiCenter.getY())) {
            double d2 = epiCenter.getX() - this.normalModel.getXOffsetKm();
            double d3 = epiCenter.getY() - this.normalModel.getYOffsetKm();
            double d4 = epiCenter.getSimul_depth();
            double d5 = Math.sqrt(d2 * d2 + d3 * d3);
            this.backAzimuth = (float)PolarizationAnalysis.getAzimuth((double)d2, (double)d3);
            this.inclination = 90.0f - (float)PolarizationAnalysis.getAzimuth((double)d5, (double)d4);
            LogUtil.info(this.getClass(), (String)("Automatic back-azimuth: " + this.backAzimuth + " inclination: " + this.inclination + " based on hypocenter (no real wavepath included here)."));
        } else {
            PolarizationAnalysis polarizationAnalysis = new PolarizationAnalysis(this.data_z, this.data_n, this.data_e, SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate());
            this.backAzimuth = (float)polarizationAnalysis.getpAzimuth();
            this.inclination = (float)polarizationAnalysis.getpIncidence();
            LogUtil.info(this.getClass(), (String)("recti: " + polarizationAnalysis.getRectilinearity() + " plana: " + polarizationAnalysis.getPlanarity()));
            LogUtil.info(this.getClass(), (String)("pBackAzimuth: " + this.backAzimuth + " pIncidence: " + this.inclination));
        }
        this.aziSlider.setValue((int)this.backAzimuth);
        this.inclinationSlider.setValue((int)this.inclination);
    }

    private void updatePainters() {
        float f = Float.MIN_VALUE;
        for (float[] fArray : new float[][]{this.data_z, this.data_e, this.data_n}) {
            float fArray2 = MathUtil.calcAbsMaximum((float[])fArray);
            if (!(fArray2 > f)) continue;
            f = fArray2;
        }
        this.origpainters[0].update(this.data_e, this.data_n, f);
        this.origpainters[1].update(this.data_e, this.data_z, f);
        this.origpainters[2].update(this.data_n, this.data_z, f);
        if (this.transModel != null) {
            float f3 = Float.MIN_VALUE;
            float[][] object = new float[][]{this.data_p_rot, this.data_sh_rot, this.data_sv_rot};
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                float[] fArray = object[i];
                float f2 = MathUtil.calcAbsMaximum((float[])fArray);
                if (!(f2 > f3)) continue;
                f3 = f2;
            }
            this.transpainters[0].update(this.data_sh_rot, this.data_sv_rot, f3);
            this.transpainters[1].update(this.data_sh_rot, this.data_p_rot, f3);
            this.transpainters[2].update(this.data_sv_rot, this.data_p_rot, f3);
            if (this.transpainters[0].getWidth() > 0 && this.transpainters[0].getHeight() > 0 && this.transpainters[1].getWidth() > 0 && this.transpainters[1].getHeight() > 0 && this.transpainters[2].getWidth() > 0 && this.transpainters[2].getHeight() > 0) {
                BufferedImage[] bufferedImageArray = new BufferedImage[3];
                for (n = 0; n < 3; ++n) {
                    bufferedImageArray[n] = new BufferedImage(this.transpainters[n].getWidth(), this.transpainters[n].getHeight(), 2);
                    this.transpainters[n].paint(bufferedImageArray[n].getGraphics());
                }
                this.bi3d.update(bufferedImageArray[0], bufferedImageArray[1], bufferedImageArray[2]);
            }
        }
    }

    private Component show3dView(boolean bl, boolean bl2) {
        Point point;
        int n;
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        if (!bl) {
            fArray3 = this.data_e;
            fArray2 = this.data_n;
            fArray = this.data_z;
        } else {
            fArray3 = this.data_sh_rot;
            fArray2 = this.data_sv_rot;
            fArray = this.data_p_rot;
        }
        int n2 = fArray3.length;
        Coord3d[] coord3dArray = new Coord3d[n2];
        org.jzy3d.colors.Color[] colorArray = new org.jzy3d.colors.Color[n2];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < n2; ++n) {
            coord3dArray[n] = new Coord3d(fArray3[n], fArray2[n], fArray[n]);
            int n3 = (int)MathUtil.convertFromTo((double)n, (double)0.0, (double)fArray3.length, (double)5.0, (double)Colors.SONOGRAM.length);
            colorArray[n] = new org.jzy3d.colors.Color(Colors.SONOGRAM[n3]);
            point = new Point(coord3dArray[n], colorArray[n]);
            point.setWidth(5.0f);
            arrayList.add(point);
        }
        for (n = 0; n < colorArray.length - 1; ++n) {
            LineStrip lineStrip = new LineStrip();
            lineStrip.setWireframeColor(org.jzy3d.colors.Color.BLACK);
            point = new Point(coord3dArray[n], org.jzy3d.colors.Color.BLACK);
            lineStrip.add(point);
            Point point2 = new Point(coord3dArray[n + 1], org.jzy3d.colors.Color.BLACK);
            lineStrip.add(point2);
            arrayList.add(lineStrip);
        }
        PCAHelper pCAHelper = new PCAHelper();
        pCAHelper.do3dPca(fArray3, fArray2, fArray);
        double[][] dArray = new Matrix(pCAHelper.getPcs()).transpose().getArray();
        double d = MathUtil.calcMinimum((float[])fArray3);
        double d2 = MathUtil.calcMaximum((float[])fArray3);
        double d3 = MathUtil.calcMinimum((float[])fArray2);
        double d4 = MathUtil.calcMaximum((float[])fArray2);
        double d5 = MathUtil.calcMinimum((float[])fArray);
        double d6 = MathUtil.calcMaximum((float[])fArray);
        final double d7 = MathUtil.calcMaximum((double[])new double[]{d2, d4, d6});
        final double d8 = MathUtil.calcMinimum((double[])new double[]{d, d3, d5});
        Point point3 = new Point(new Coord3d(dArray[0][0] * d7, dArray[0][1] * d7, dArray[0][2] * d7));
        Point point4 = new Point(new Coord3d(dArray[1][0] * d7, dArray[1][1] * d7, dArray[1][2] * d7));
        Point point5 = new Point(new Coord3d(dArray[2][0] * d7, dArray[2][1] * d7, dArray[2][2] * d7));
        LineStrip lineStrip = new LineStrip();
        lineStrip.setWireframeColor(org.jzy3d.colors.Color.RED);
        lineStrip.add(new Point(new Coord3d(0.0f, 0.0f, 0.0f)));
        lineStrip.add(point3);
        arrayList.add(lineStrip);
        LineStrip lineStrip2 = new LineStrip();
        lineStrip2.setWireframeColor(org.jzy3d.colors.Color.GREEN);
        lineStrip2.add(new Point(new Coord3d(0.0f, 0.0f, 0.0f)));
        lineStrip2.add(point4);
        arrayList.add(lineStrip2);
        LineStrip lineStrip3 = new LineStrip();
        lineStrip3.setWireframeColor(org.jzy3d.colors.Color.BLUE);
        lineStrip3.add(new Point(new Coord3d(0.0f, 0.0f, 0.0f)));
        lineStrip3.add(point5);
        arrayList.add(lineStrip3);
        if (!bl) {
            double d9 = (double)this.backAzimuth / 180.0 * Math.PI;
            double d10 = (double)this.inclination / 180.0 * Math.PI;
            Matrix matrix = new Matrix((double[][])new double[][]{{Math.cos(d9), -Math.sin(d9), 0.0}, {Math.sin(d9), Math.cos(d9), 0.0}, {0.0, 0.0, 1.0}});
            Matrix matrix2 = new Matrix((double[][])new double[][]{{Math.cos(d10), 0.0, Math.sin(d10)}, {0.0, 1.0, 0.0}, {-Math.sin(d10), 0.0, Math.cos(d10)}});
            for (int i = 0; i < 3; ++i) {
                Matrix matrix3 = i == 0 ? new Matrix((double[][])new double[][]{{d7}, {0.0}, {0.0}}) : (i == 1 ? new Matrix((double[][])new double[][]{{0.0}, {d7}, {0.0}}) : new Matrix((double[][])new double[][]{{0.0}, {0.0}, {d7}}));
                double[][] dArray2 = matrix.times(matrix2).times(matrix3).getArray();
                float f = (float)dArray2[0][0];
                float f2 = (float)dArray2[1][0];
                float f3 = (float)dArray2[2][0];
                LineStrip lineStrip4 = new LineStrip();
                lineStrip4.setWireframeColor(org.jzy3d.colors.Color.GRAY);
                lineStrip4.add(new Point(new Coord3d(0.0f, 0.0f, 0.0f)));
                lineStrip4.add(new Point(new Coord3d(f, f2, f3)));
                arrayList.add(lineStrip4);
            }
        }
        final Chart chart = new Chart(Quality.Advanced);
        if (!bl) {
            chart.getAxeLayout().setZAxeLabel("Z");
            chart.getAxeLayout().setXAxeLabel("E");
            chart.getAxeLayout().setYAxeLabel("N");
        } else {
            chart.getAxeLayout().setZAxeLabel("k1");
            chart.getAxeLayout().setXAxeLabel("k2");
            chart.getAxeLayout().setYAxeLabel("k3");
        }
        CameraMouseController cameraMouseController = new CameraMouseController(){

            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                chart.getView().setBoundManual(new BoundingBox3d((float)d8, (float)d7, (float)d8, (float)d7, (float)d8, (float)d7));
            }
        };
        chart.addController((AbstractCameraController)cameraMouseController);
        chart.getScene().add(arrayList);
        Component component = null;
        if (bl2) {
            ChartLauncher.openChart((Chart)chart);
        } else {
            component = (Component)chart.getCanvas();
            chart.render();
        }
        return component;
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        TableLayout tableLayout = new TableLayout();
        this.buttonPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.insertColumn(0, -3.0);
        tableLayout.insertColumn(1, -1.0);
        tableLayout.insertRow(0, -3.0);
        tableLayout.insertRow(1, -3.0);
        final JLabel jLabel = new JLabel("Azi:" + (int)this.backAzimuth);
        this.aziSlider = new JSlider(0, 0, 360, 0);
        this.aziSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    HodoPanel.this.backAzimuth = jSlider.getValue();
                    jLabel.setText("Azi:" + (int)HodoPanel.this.backAzimuth);
                    HodoPanel.this.updateAziOrInc();
                }
            }
        });
        this.aziSlider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = mouseWheelEvent.getWheelRotation();
                if (n < 0) {
                    HodoPanel.this.aziSlider.setValue((int)HodoPanel.this.backAzimuth + 1);
                } else {
                    HodoPanel.this.aziSlider.setValue((int)HodoPanel.this.backAzimuth - 1);
                }
            }
        });
        this.aziSlider.setMajorTickSpacing(360);
        this.aziSlider.setMinorTickSpacing(90);
        this.aziSlider.setPaintTicks(true);
        this.aziSlider.setPaintLabels(true);
        final JLabel jLabel2 = new JLabel("Inc:" + (int)this.inclination);
        this.inclinationSlider = new JSlider(0, 0, 90, 0);
        this.inclinationSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    HodoPanel.this.inclination = jSlider.getValue();
                    jLabel2.setText("Inc:" + (int)HodoPanel.this.inclination);
                    HodoPanel.this.updateAziOrInc();
                }
            }
        });
        this.inclinationSlider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = mouseWheelEvent.getWheelRotation();
                if (n < 0) {
                    HodoPanel.this.inclinationSlider.setValue((int)HodoPanel.this.inclination + 1);
                } else {
                    HodoPanel.this.inclinationSlider.setValue((int)HodoPanel.this.inclination - 1);
                }
            }
        });
        this.inclinationSlider.setMajorTickSpacing(90);
        this.inclinationSlider.setMinorTickSpacing(30);
        this.inclinationSlider.setPaintTicks(true);
        this.inclinationSlider.setPaintLabels(true);
        this.buttonPanel.add((Component)jLabel, "0, 0");
        this.buttonPanel.add((Component)this.aziSlider, "1, 0");
        this.buttonPanel.add((Component)jLabel2, "0, 1");
        this.buttonPanel.add((Component)this.inclinationSlider, "1, 1");
    }

    private void updateAziOrInc() {
        if (this.transModel != null && this.data_z.length > 0) {
            float[][] fArray = MathUtil.rotateZNE((float)this.backAzimuth, (float)this.inclination, (float[])this.data_z, (float[])this.data_n, (float[])this.data_e, (boolean)true);
            this.data_p_rot = fArray[0];
            this.data_sv_rot = fArray[1];
            this.data_sh_rot = fArray[2];
        }
        this.transModel.update();
        if (this.movingPCAModel != null) {
            this.movingPCAModel.update();
        }
        this.updatePainters();
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setButtonPanel(JPanel jPanel) {
        this.buttonPanel = jPanel;
    }

    public ActivateableComponent getOrigHodo() {
        return this.origHodo;
    }

    public ActivateableComponent getTransHodo() {
        return this.transHodo;
    }

    public float[] getData_z_rot() {
        return this.data_p_rot;
    }

    public void setData_z_rot(float[] fArray) {
        this.data_p_rot = fArray;
    }

    public float[] getData_n_rot() {
        return this.data_sv_rot;
    }

    public void setData_n_rot(float[] fArray) {
        this.data_sv_rot = fArray;
    }

    public float[] getData_e_rot() {
        return this.data_sh_rot;
    }

    public void setData_e_rot(float[] fArray) {
        this.data_sh_rot = fArray;
    }

    public float[] getData_z() {
        return this.data_z;
    }

    public void setData_z(float[] fArray) {
        this.data_z = fArray;
    }

    public float[] getData_n() {
        return this.data_n;
    }

    public void setData_n(float[] fArray) {
        this.data_n = fArray;
    }

    public float[] getData_e() {
        return this.data_e;
    }

    public void setData_e(float[] fArray) {
        this.data_e = fArray;
    }

    public SiteModel getTransModel() {
        return this.transModel;
    }

    public void setTransModel(SiteModel siteModel) {
        this.transModel = siteModel;
    }

    public SiteModel getNormalModel() {
        return this.normalModel;
    }

    public void setNormalModel(SiteModel siteModel) {
        this.normalModel = siteModel;
    }

    public SiteModel getMovingPCAModel() {
        return this.movingPCAModel;
    }

    public void setMovingPCAModel(SiteModel siteModel) {
        this.movingPCAModel = siteModel;
    }

    class HodoPanelPainter
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private String xLabel;
        private String yLabel;
        private float[] data1;
        private float[] data2;
        private float max;
        private double[][] pcs;

        public HodoPanelPainter(String string, String string2) {
            this.xLabel = string;
            this.yLabel = string2;
        }

        public void update(float[] fArray, float[] fArray2, float f) {
            this.data1 = fArray;
            this.data2 = fArray2;
            this.max = f;
            this.pcs = new PCAHelper().doPCA(fArray, fArray2);
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = 20;
            graphics2D.drawRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setFont(new Font("Arial", 1, 10));
            graphics2D.drawString(this.xLabel, (int)((double)this.getWidth() - (double)n * 0.8), this.getHeight() / 2);
            graphics2D.drawString(this.yLabel, this.getWidth() / 2, (int)((double)n * 0.8));
            int n2 = this.getHeight() / 2;
            graphics2D.translate(0, n2);
            graphics2D.scale(1.0, -1.0);
            graphics2D.translate(0, -n2);
            graphics2D.translate(this.getWidth() / 2, this.getHeight() / 2);
            graphics2D.drawRect(-this.getWidth() / 2 + n, -this.getHeight() / 2 + n, this.getWidth() - 2 * n, this.getHeight() - 2 * n);
            graphics2D.drawLine(0, -this.getHeight() / 2, 0, this.getHeight() / 2);
            graphics2D.drawLine(-this.getWidth() / 2, 0, this.getWidth() / 2, 0);
            if (this.data1 != null && this.data2 != null) {
                double d;
                double d2;
                int n3;
                int n4;
                double d3 = 0.0;
                double d4 = 0.0;
                for (n4 = 0; n4 < this.data1.length; ++n4) {
                    n3 = (int)MathUtil.convertFromTo((double)n4, (double)0.0, (double)this.data1.length, (double)0.0, (double)Colors.SONOGRAM.length);
                    d2 = (int)((double)(this.data1[n4] / this.max) * ((double)this.getWidth() / 2.0 - (double)n));
                    d = (int)((double)(this.data2[n4] / this.max) * ((double)this.getHeight() / 2.0 - (double)n));
                    graphics2D.setColor(Colors.SONOGRAM[n3]);
                    graphics2D.fillOval((int)d2 - 2, (int)d - 2, 5, 5);
                    if (n4 != 0) {
                        graphics2D.setColor(Color.DARK_GRAY);
                        graphics2D.drawLine((int)d3, (int)d4, (int)d2, (int)d);
                    }
                    d3 = d2;
                    d4 = d;
                }
                if (this.pcs != null) {
                    graphics2D.setColor(Color.RED);
                    n4 = 0;
                    n3 = 0;
                    for (d2 = -1.0; d2 < 1.0; d2 += 0.001) {
                        d = this.pcs[0][1] / this.pcs[0][0] * d2;
                        int n5 = (int)(d2 * ((double)this.getWidth() / 2.0 - (double)n));
                        int n6 = (int)(d * ((double)this.getHeight() / 2.0 - (double)n));
                        if (d2 != (double)(-this.getWidth() / 2 + n)) {
                            graphics2D.drawLine(n4, n3, n5, n6);
                        }
                        n4 = n5;
                        n3 = n6;
                    }
                }
            }
        }
    }
}

