/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.trace;

import edu.geophys.commons.model.AbstractTrace;
import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.model.DefaultTraceMetadata;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.TraceMetadata;
import edu.geophys.commons.range.RangeMarkerModel;
import edu.geophys.commons.suite.EventWindowModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.suite.TraceProvider;
import edu.geophys.commons.themes.SuiteTheme;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.commons.ui.sonogram.JDetailSonogram;
import edu.geophys.commons.ui.trace.PlotRenderer;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LocalMagnitude;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.commons.util.PK_MBaer;
import edu.geophys.hypoline.HypoLineConfiguration;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ensemble.FilterPicker5;
import edu.geophys.hypoline.ui.MethodWarningFactory;
import edu.geophys.hypoline.ui.trace.AbstractRenderer;
import edu.geophys.hypoline.ui.trace.MouseRenderer;
import edu.geophys.hypoline.ui.trace.SiteModel;
import edu.geophys.hypoline.ui.trace.StationView;
import edu.geophys.hypoline.util.HypoLineUtils;
import edu.geophys.sonoview.DataManager;
import edu.geophys.sonoview.swing.FilteringTrace;
import edu.geophys.sonoview.swing.largesonogram.SonogramProvider;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.Transparency;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class TraceRenderer
extends AbstractRenderer {
    private static final long serialVersionUID = 1L;
    private static final int activeTraceFontSize = 11;
    protected TraceProvider traceProvider = SuiteManager.INSTANCE.getTraceProvider();
    protected DefaultTrace deftrace;
    protected HypoLineConfiguration config = HypoLineManager.INSTANCE.getConfig();
    private JDetailSonogram jDetail = new JDetailSonogram(new Dimension(1, 1));
    private final RangeMarkerModel<Object> markerModel;
    public final String CHILDS;
    public final String CHILDE;
    protected double mouse = 0.0;
    protected String time = "";
    protected StationView metaView;
    private final EventWindowModel ewm = SuiteManager.INSTANCE.getGlobalEventWindowModel();
    private double sampleLength;
    private LocalMagnitude ml;
    private PlotRenderer plotme = new PlotRenderer();
    private PlotRenderer splineplot = new PlotRenderer(false, true);
    private Stroke onsetTimeDrawingStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f}, 0.0f);
    private final String MOUSE = "MOUSE";
    private static final Stroke MARKER_STROKE = new BasicStroke(2.0f);
    private static final Stroke ARROW_STROKE = new BasicStroke(2.0f);
    private static final int ARROW_LEN = 10;
    private float samprate = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
    protected MouseAdapter mouseAdapter = new MouseAdapter(){
        long incTime;
        {
            this.incTime = TraceRenderer.this.ewm.getLength() / 10L;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            TraceRenderer.this.markerModel.setMarker("MOUSE", MathUtil.convertToRelative((int)mouseEvent.getX(), (int)TraceRenderer.this._minX, (int)TraceRenderer.this._maxX), null);
            TraceRenderer.this.mouse = MathUtil.convertToRelative((int)mouseEvent.getX(), (int)TraceRenderer.this._minX, (int)TraceRenderer.this._maxX);
            TraceRenderer.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TraceRenderer.this.model.setLastMouseClickTraceType(TraceRenderer.this.traceType);
            if (TraceRenderer.this.metaView == null) {
                double d = MathUtil.convertToRelative((int)mouseEvent.getX(), (int)TraceRenderer.this._minX, (int)TraceRenderer.this._maxX);
                double d2 = TraceRenderer.this.markerModel.getMarker(TraceRenderer.this.CHILDS).getPosition();
                double d3 = TraceRenderer.this.markerModel.getMarker(TraceRenderer.this.CHILDE).getPosition();
                if (mouseEvent.getButton() == 1) {
                    if (d > d3) {
                        TraceRenderer.this.markerModel.moveMarker(d - d2, new String[]{TraceRenderer.this.CHILDS, TraceRenderer.this.CHILDE});
                    } else {
                        TraceRenderer.this.markerModel.setMarker(TraceRenderer.this.CHILDS, d, null);
                    }
                } else if (mouseEvent.getButton() == 3) {
                    if (d < d2) {
                        TraceRenderer.this.markerModel.moveMarker(d - d3, new String[]{TraceRenderer.this.CHILDS, TraceRenderer.this.CHILDE});
                    } else {
                        TraceRenderer.this.markerModel.setMarker(TraceRenderer.this.CHILDE, d, null);
                    }
                }
            } else {
                if (TraceRenderer.this.traceType == TraceType.TRACE_Z && TraceRenderer.this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
                    MethodWarningFactory.showWarning(TraceRenderer.this.getRootPane(), MethodWarningFactory.WarningId.PICK_AMP_ON_Z);
                    return;
                }
                TraceRenderer.this.model.setActiveTrace(true);
                double d = MathUtil.convertToRelative((double)((double)mouseEvent.getX() + (double)(TraceRenderer.this._maxX - TraceRenderer.this._minX) / (TraceRenderer.this.sampleLength - 1.0) / 2.0), (double)TraceRenderer.this._minX, (double)TraceRenderer.this._maxX);
                double d4 = MathUtil.convertToAbsolute((double)d, (double)0.0, (double)(TraceRenderer.this.sampleLength - 1.0));
                d4 = d4 / (double)TraceRenderer.this.samprate + TraceRenderer.this.model.getStart();
                if (mouseEvent.getButton() == 1) {
                    TraceRenderer.this.model.setpOrSActive(true);
                    if (TraceRenderer.this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
                        if (TraceRenderer.this.model.getSiteRole().equals((Object)Site.SiteRole.SATELLITE)) {
                            MethodWarningFactory.showWarning((JComponent)((Object)TraceRenderer.this), MethodWarningFactory.WarningId.PICK_ON_SATELLITE);
                        }
                        TraceRenderer.this.model.setpPick(d4);
                        HypoLineManager.INSTANCE.getEpiMapDb().updateSimulation();
                        LogUtil.info(this.getClass(), (String)("pPick at time: " + DateTimeUtil.formatTimeHighPrecision((double)TraceRenderer.this.model.getpPick())));
                    } else if (TraceRenderer.this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
                        TraceRenderer.this.model.setMagnitude1Pick(d4, TraceRenderer.this.getDeftrace().getStationID());
                    } else if (TraceRenderer.this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
                        TraceRenderer.this.model.setpCorr(d4);
                    }
                    HypoLineManager.INSTANCE.getEpiMapDb().updateSimulation();
                } else if (mouseEvent.getButton() == 3) {
                    TraceRenderer.this.model.setpOrSActive(false);
                    if (TraceRenderer.this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
                        if (TraceRenderer.this.model.getSiteRole().equals((Object)Site.SiteRole.SATELLITE)) {
                            MethodWarningFactory.showWarning((JComponent)((Object)TraceRenderer.this), MethodWarningFactory.WarningId.PICK_ON_SATELLITE);
                        }
                        TraceRenderer.this.model.setsPick(d4);
                        LogUtil.info(this.getClass(), (String)("sPick at time: " + DateTimeUtil.formatTimeHighPrecision((double)TraceRenderer.this.model.getsPick())));
                    } else if (TraceRenderer.this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
                        TraceRenderer.this.model.setMagnitude2Pick(d4, TraceRenderer.this.getDeftrace().getStationID());
                    } else if (TraceRenderer.this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
                        TraceRenderer.this.model.setsCorr(d4);
                    }
                }
                ((StationView)TraceRenderer.this.parent).updateActiveTrace(TraceRenderer.this.getModel());
                ((StationView)TraceRenderer.this.parent).updateModel(false);
                TraceRenderer.this.repaint();
            }
        }
    };
    int repaintCount = 0;

    public TraceRenderer(SiteModel siteModel, MouseRenderer mouseRenderer, ActivateableComponent activateableComponent, RangeMarkerModel<Object> rangeMarkerModel, String string, String string2, StationView stationView) {
        super(siteModel, mouseRenderer, activateableComponent);
        this.markerModel = rangeMarkerModel;
        this.CHILDS = string;
        this.CHILDE = string2;
        this.metaView = stationView;
        this.plot.setAxisColor(null);
        this.addMouseMotionListener(this.mouseAdapter);
        this.addMouseListener(this.mouseAdapter);
    }

    public TraceRenderer(SiteModel siteModel, MouseRenderer mouseRenderer, ActivateableComponent activateableComponent, RangeMarkerModel<Object> rangeMarkerModel, String string, String string2, StationView stationView, TraceType traceType, boolean bl) {
        this(siteModel, mouseRenderer, activateableComponent, rangeMarkerModel, string, string2, stationView);
        this.traceType = traceType;
        if (bl) {
            this.horizontalPlots = new PlotRenderer[2];
        }
    }

    public void reloadTrace() {
        try {
            this.deftrace = this.traceProvider.requestTrace(this.model.getStart(), this.model.getStart() + this.model.getLength(), this.samprate, new String[]{this.model.getTraceName(this.traceType)})[0];
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogUtil.error(((Object)((Object)this)).getClass(), (String)illegalArgumentException.getMessage());
            DefaultTraceMetadata defaultTraceMetadata = new DefaultTraceMetadata();
            String string = this.model.getTraceZ();
            String[] stringArray = string.split("-");
            if (stringArray.length >= 2) {
                String string2 = stringArray[stringArray.length - 1];
                defaultTraceMetadata.setStationName(string.substring(0, string.length() - string2.length()));
                defaultTraceMetadata.setStationChannel(string2);
                defaultTraceMetadata.setCalibration(1.0f);
                defaultTraceMetadata.setSamplerate(SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate());
                defaultTraceMetadata.setOriginalSamplerate(defaultTraceMetadata.getSamplerate());
                defaultTraceMetadata.setStartEpochTime(this.model.getStart());
                defaultTraceMetadata.setLength((int)(this.model.getLength() * (double)defaultTraceMetadata.getSamplerate()) + 1);
                defaultTraceMetadata.setOriginalLength(defaultTraceMetadata.getLength());
            }
            this.deftrace = new DefaultTrace((TraceMetadata)defaultTraceMetadata);
            this.deftrace.setSamples(new float[defaultTraceMetadata.getLength()]);
        }
    }

    @Override
    public void update() {
        int n;
        Object object;
        this.reloadTrace();
        SonogramProvider sonogramProvider = DataManager.createSonogramProvider();
        try {
            this.jDetail.setModel(sonogramProvider.getSonogram(this.model.getStart(), this.model.getLength(), this.getModel().getTraceName(this.traceType)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.jDetail = new JDetailSonogram(new Dimension(1, 1));
        }
        this.sampleLength = this.deftrace.getSamples().length;
        if (this.model.getChild() == null && HypoLineManager.INSTANCE.getMasterEventManager().isInitialized() && (object = (Object)HypoLineManager.INSTANCE.getMasterEventManager().getMeTrace(this.model, this.traceType)) != null) {
            this.plotme.setModel((AbstractTrace)object);
            this.plotme.setExternalScale((double)(1.0f / this.model.getCurrentMaxValue()));
        }
        if (this.model.isPolarityFlip()) {
            object = this.deftrace.getSamples();
            for (n = 0; n < ((float[])object).length; ++n) {
                object[n] = -object[n];
            }
            this.deftrace.setSamples(object);
        }
        this.ml = null;
        if (!this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE) || this.model.getThreeComp() == null || this.model.getChild() != null) {
            this.deftrace.setSamples(MathUtil.subMeanZeroNaN((float[])this.deftrace.getSamples()));
            object = new FilteringTrace((AbstractTrace)this.deftrace);
            object.directFilter(this.model.getFl(), this.model.getFu());
            this.deftrace.setSamples(object.getSamples());
        } else {
            object = new LocalMagnitude(this.deftrace.getSamples(), this.samprate, 0.0f);
            object.woodAnderson();
            object.peak2peak(object.getWaSamples());
            this.deftrace.setSamples(object.getWaSamples());
            if (!this.traceType.equals((Object)TraceType.TRACE_Z)) {
                this.ml = (LocalMagnitude)object;
            }
        }
        this.plot.setModel((AbstractTrace)this.deftrace);
        if (this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
            int n2 = 0;
            n = 0;
            for (SiteModel stringArray : HypoLineManager.INSTANCE.getCurrentSitesDetail()) {
                if (((Object)((Object)stringArray)).equals((Object)this.model)) {
                    n = 1;
                    break;
                }
                ++n2;
            }
            if (n != 0) {
                Color color = this.traceColor = this.getModel().getSiteRole() == Site.SiteRole.CENTER ? ThemeManager.getInstance().getTheme().getZCenterColor() : ThemeManager.getInstance().getTheme().getPaletteColor(n2);
            }
        }
        if (this.model.getChild() == null && this.horizontalPlots == null && HypoLineManager.INSTANCE.getConfig().isSplineInterpolation()) {
            this.splineplot.setModel(this.plot.get_model());
            this.splineplot.setExternalScale(this.plot.getExternalScale());
        }
        LogUtil.debug(((Object)((Object)this)).getClass(), (String)(this.model.getId() + " " + this.traceType + " Length: " + this.model.getLength() + " samples: " + this.deftrace.getSamples().length + " " + this.model.getStart()));
        if (this.traceType.equals((Object)TraceType.TRACE_Z)) {
            this.model.setCurrentMaxValue(-3.4028235E38f);
        }
        int n3 = Math.max(this.deftrace.getSamples().length / 20, 1);
        float f = MathUtil.calcAbsMaximum((float[])this.deftrace.getSamples(), (int)n3);
        if (this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
            f = (float)((double)f * 1.1);
        }
        switch (this.traceType) {
            case TRACE_EW: {
                this.model.setCurrentZoomETrace(this.deftrace);
                this.model.setCurrentMaxEValue(f);
                if (f > this.model.getCurrentMaxValue()) {
                    this.model.setCurrentMaxValue(f);
                    this.model.updateRepaint();
                }
                this.plot.setExternalScale((double)(1.0f / this.model.getCurrentMaxValue()));
                break;
            }
            case TRACE_NS: {
                this.model.setCurrentZoomNTrace(this.deftrace);
                this.model.setCurrentMaxNValue(f);
                if (f > this.model.getCurrentMaxValue()) {
                    this.model.setCurrentMaxValue(f);
                    this.model.updateRepaint();
                }
                this.plot.setExternalScale((double)(1.0f / this.model.getCurrentMaxValue()));
                break;
            }
            default: {
                this.model.setCurrentZoomZTrace(this.deftrace);
                this.model.setCurrentMaxValue(f);
                this.model.updateRepaint();
                this.plot.setExternalScale((double)(1.0f / this.model.getCurrentMaxValue()));
            }
        }
        if (this.horizontalPlots != null) {
            int n4 = 0;
            for (String string : new String[]{this.model.getTraceEW(), this.model.getTraceNS()}) {
                if (string == null || !this.traceProvider.hasStation(new String[]{string})[0]) continue;
                DefaultTrace defaultTrace = this.traceProvider.requestTrace(this.model.getStart(), this.model.getStart() + this.model.getLength(), this.samprate, new String[]{string})[0];
                if (!this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE) || this.model.getChild() != null) {
                    defaultTrace.setSamples(MathUtil.subMeanZeroNaN((float[])defaultTrace.getSamples()));
                    var10_17 = new FilteringTrace((AbstractTrace)defaultTrace);
                    var10_17.directFilter(this.model.getFl(), this.model.getFu());
                    defaultTrace.setSamples(var10_17.getSamples());
                } else {
                    var10_17 = new LocalMagnitude(defaultTrace.getSamples(), defaultTrace.getSamplerate(), 0.0f);
                    var10_17.woodAnderson();
                    var10_17.peak2peak(var10_17.getWaSamples());
                    defaultTrace.setSamples(var10_17.getWaSamples());
                    if (this.ml == null || this.ml.getAmpmy() < var10_17.getAmpmy()) {
                        this.ml = var10_17;
                    }
                }
                this.horizontalPlots[n4] = new PlotRenderer();
                this.horizontalPlots[n4].setModel((AbstractTrace)defaultTrace);
                this.horizontalPlots[n4].setAxisColor(null);
                float f2 = MathUtil.calcAbsMaximum((float[])defaultTrace.getSamples());
                if (f2 > f) {
                    f = f2;
                }
                if (string.equals(this.model.getTraceNS())) {
                    this.model.setCurrentZoomNTrace(defaultTrace);
                    this.model.setCurrentMaxNValue(f2);
                } else {
                    this.model.setCurrentZoomETrace(defaultTrace);
                    this.model.setCurrentMaxEValue(f2);
                }
                ++n4;
                if (this.horizontalPlots[0] != null) {
                    this.horizontalPlots[0].setExternalScale((double)(1.0f / this.model.getCurrentMaxEValue()));
                }
                if (this.horizontalPlots[1] == null) continue;
                this.horizontalPlots[1].setExternalScale((double)(1.0f / this.model.getCurrentMaxNValue()));
            }
        }
        this.repaint();
    }

    @Override
    public void automaticCalc2() {
        if ((!this.traceType.equals((Object)TraceType.TRACE_Z) || this.horizontalPlots != null) && HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
            AbstractTrace[] abstractTraceArray;
            if (this.horizontalPlots == null) {
                abstractTraceArray = new AbstractTrace[]{this.deftrace};
            } else if (this.horizontalPlots.length == 1) {
                abstractTraceArray = new AbstractTrace[]{this.horizontalPlots[0].get_model()};
            } else if (this.horizontalPlots.length == 2) {
                abstractTraceArray = new AbstractTrace[]{this.horizontalPlots[0].get_model(), this.horizontalPlots[1].get_model()};
            } else {
                return;
            }
            for (AbstractTrace abstractTrace : abstractTraceArray) {
                PK_MBaer pK_MBaer = new PK_MBaer(abstractTrace.getSamples(), this.samprate);
                if (pK_MBaer.getSample_num() > pK_MBaer.getPkBaerLen()) {
                    double d = (double)((float)pK_MBaer.getSample_num() / this.samprate) + this.model.getStart();
                    LogUtil.info(((Object)((Object)this)).getClass(), (String)("PK_Baer pick: " + this.model.getId() + " " + this.traceType + " " + DateTimeUtil.formatDateTimeISOHighPrecision((double)d) + " " + pK_MBaer.getPickType()));
                    this.model.setsPick(d);
                    continue;
                }
                LogUtil.info(((Object)((Object)this)).getClass(), (String)(this.model.getId() + " " + this.traceType + " PK_Baer no valid S-pick found: " + pK_MBaer.getSample_num()));
            }
        }
        this.repaint();
    }

    @Override
    public void automaticCalc() {
        if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE) && this.ml != null && (!this.traceType.equals((Object)TraceType.TRACE_Z) || this.horizontalPlots != null)) {
            if (Float.isNaN(this.model.getMagnitudeAmpMy()) || this.ml.getAmpmy() > this.model.getMagnitudeAmpMy() || this.model.getMagnitude1Pick() < this.model.getStart() || this.model.getMagnitude1Pick() > this.model.getStart() + this.model.getLength() || this.model.getMagnitude2Pick() < this.model.getStart() || this.model.getMagnitude2Pick() > this.model.getStart() + this.model.getLength()) {
                this.model.setMagnitude1Pick((double)((float)this.ml.getMinPPPos() / this.samprate) + this.model.getStart(), this.model.getMagnitudePickTrace());
                this.model.setMagnitude2Pick((double)((float)this.ml.getMaxPPPos() / this.samprate) + this.model.getStart(), this.model.getMagnitudePickTrace());
                this.model.setMagnitudeAmpMy(this.ml.getAmpmy());
            }
        } else if (this.traceType.equals((Object)TraceType.TRACE_Z) && HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
            AbstractTrace[] abstractTraceArray;
            if (this.horizontalPlots == null) {
                abstractTraceArray = new AbstractTrace[]{this.deftrace};
            } else if (this.horizontalPlots.length == 1) {
                abstractTraceArray = new AbstractTrace[]{this.horizontalPlots[0].get_model()};
            } else if (this.horizontalPlots.length == 2) {
                abstractTraceArray = new AbstractTrace[]{this.horizontalPlots[0].get_model(), this.horizontalPlots[1].get_model()};
            } else {
                return;
            }
            double d = -1.7976931348623157E308;
            this.model.setpPick(Double.NaN);
            this.model.setsPick(Double.NaN);
            int n = 0;
            for (AbstractTrace abstractTrace : abstractTraceArray) {
                FilterPicker5.PickData[] pickDataArray;
                FilterPicker5 filterPicker5 = new FilterPicker5();
                double d2 = filterPicker5.threshold1;
                for (double d3 = filterPicker5.threshold2; filterPicker5.triggerPickData.size() < 2 && d2 > 3.0 && d3 > 3.0; d2 -= 0.1, d3 -= 0.1) {
                    filterPicker5 = new FilterPicker5();
                    filterPicker5.threshold1 = d2;
                    filterPicker5.threshold2 = d3;
                    filterPicker5.apply(1.0 / (double)this.samprate, abstractTrace.getSamples(), 0);
                    LogUtil.info(((Object)((Object)this)).getClass(), (String)("Automatic picking on " + abstractTrace.getStationID() + " with threshold1 " + d2 + " threshold2 " + d3 + " number of picks " + filterPicker5.triggerPickData.size()));
                }
                if (filterPicker5.triggerPickData.size() <= 2) {
                    pickDataArray = filterPicker5.triggerPickData.toArray(new FilterPicker5.PickData[filterPicker5.triggerPickData.size()]);
                } else {
                    pickDataArray = new FilterPicker5.PickData[2];
                    double d4 = -1.7976931348623157E308;
                    for (int i = 0; i < filterPicker5.triggerPickData.size(); ++i) {
                        if (!(filterPicker5.triggerPickData.get((int)i).amplitude > d4)) continue;
                        d4 = filterPicker5.triggerPickData.get((int)i).amplitude;
                        pickDataArray[0] = filterPicker5.triggerPickData.get(i);
                    }
                    double d5 = -1.7976931348623157E308;
                    for (int i = 0; i < filterPicker5.triggerPickData.size(); ++i) {
                        if (!(filterPicker5.triggerPickData.get((int)i).amplitude > d5) || !(filterPicker5.triggerPickData.get((int)i).amplitude < d4)) continue;
                        d5 = filterPicker5.triggerPickData.get((int)i).amplitude;
                        pickDataArray[1] = filterPicker5.triggerPickData.get(i);
                    }
                }
                for (int i = 0; i < pickDataArray.length; ++i) {
                    double d6 = filterPicker5.triggerPickData.get((int)i).amplitude;
                    double[] dArray = filterPicker5.triggerPickData.get((int)i).indices;
                    if (dArray.length != 2) continue;
                    double d7 = this.model.getStart() + (dArray[0] + dArray[1]) / 2.0 / (double)this.samprate;
                    double d8 = (dArray[1] - dArray[0]) / 2.0 / (double)this.samprate;
                    if (i == 0 && n == 0) {
                        LogUtil.info(((Object)((Object)this)).getClass(), (String)("Automatic P pick " + abstractTrace.getStationID() + " " + dArray[0] + " " + dArray[1] + " " + MathUtil.format3Digits((double)d6) + " " + DateTimeUtil.formatDateTimeISOHighPrecision((double)d7)));
                        this.model.setpPick(d7);
                        this.model.setPUncertainty(d8);
                        continue;
                    }
                    if ((n <= 0 || filterPicker5.triggerPickData.size() != 1) && i != 1 || !(d6 > d) || !(d7 - 3.0 * d8 > this.model.getpPick())) continue;
                    LogUtil.info(((Object)((Object)this)).getClass(), (String)("Automatic S pick " + abstractTrace.getStationID() + " " + dArray[0] + " " + dArray[1] + " " + MathUtil.format3Digits((double)d6) + " " + DateTimeUtil.formatDateTimeISOHighPrecision((double)d7)));
                    d = d6;
                    this.model.setsPick(d7);
                    this.model.setSUncertainty(d8);
                }
                if (n == 0 && filterPicker5.triggerPickData.size() >= 2) break;
                ++n;
            }
        }
        this.repaint();
    }

    @Override
    protected void calcPeak2Peak() {
        if (this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE) && this.traceType.equals((Object)this.model.getLastMouseClickTraceType()) && !Double.isNaN(this.model.getMagnitude1Pick()) && !Double.isNaN(this.model.getMagnitude2Pick())) {
            int n = HypoLineUtils.convertTimeToPick(this.model.getMagnitude1Pick(), this.model.getStart(), this.samprate);
            int n2 = HypoLineUtils.convertTimeToPick(this.model.getMagnitude2Pick(), this.model.getStart(), this.samprate);
            if (n < 0 || n2 < 0 || n >= this.deftrace.getSamples().length || n2 >= this.deftrace.getSamples().length) {
                LogUtil.info(((Object)((Object)this)).getClass(), (String)"Magnitude pick outside of range, cannot calculate peak to peak amplitude.");
                this.model.setMagnitudeAmpMy(Float.NaN);
            } else {
                float f;
                float f2 = this.deftrace.getSample(n);
                float f3 = f2 > (f = this.deftrace.getSample(n2)) ? f2 - f : f - f2;
                LogUtil.info(((Object)((Object)this)).getClass(), (String)("peak-to-peak value: " + f3));
                this.model.setMagnitudeAmpMy(f3 / 1000.0f / 2.0f);
            }
        }
    }

    protected void paintComponent(Graphics graphics, boolean bl) {
        super.paintComponent(graphics);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Transparency transparency;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        SuiteTheme suiteTheme = ThemeManager.getInstance().getTheme();
        LogUtil.debug(((Object)((Object)this)).getClass(), (String)("Tracerenderer repaint: " + this.model.getId() + " " + this.repaintCount++));
        double d = (double)this._maxX / (this.sampleLength - 1.0) / 2.0;
        if ((this.model.getRenderMode().equals((Object)StationView.RenderMode.SONOGRAM) || this.model.getRenderMode().equals((Object)StationView.RenderMode.TRACE_SONO)) && this.jDetail.getRenderedSonogramModel() != null) {
            if (this.jDetail.isValidSonogram()) {
                transparency = new BufferedImage(this._maxX - this._minX, this._maxY - this._minY, 2);
                object5 = ((BufferedImage)transparency).createGraphics();
                ((Graphics)object5).drawImage(this.jDetail.getRenderedSonogramModel().getImage(), this._minX, this._minY, this._maxX, this._maxY, null);
                ((Graphics)object5).dispose();
                graphics2D.drawImage((BufferedImage)transparency, null, 0, 0);
            } else {
                graphics2D.setColor(suiteTheme.getHypolineRed());
                graphics2D.drawString("Selected time range too short to calculate sonogram.", this.getWidth() / 20, this.getHeight() / 2);
            }
        }
        if (this.model.getRenderMode().equals((Object)StationView.RenderMode.TRACE) || this.model.getRenderMode().equals((Object)StationView.RenderMode.TRACE_SONO)) {
            if (this.horizontalPlots != null && this.getModel().getSiteRole().equals((Object)Site.SiteRole.CENTER)) {
                transparency = suiteTheme.getHCenterColor();
                for (int i = 0; i < 2; ++i) {
                    if (this.horizontalPlots[i] == null) continue;
                    this.horizontalPlots[i].setExternalScale((double)(1.0f / this.model.getCurrentMaxValue()));
                    this.horizontalPlots[i].setForegroundColor((Color)transparency);
                    this.horizontalPlots[i].draw(graphics2D, (Rectangle2D)new Rectangle2D.Double(this._minX, this._minY, this._maxX, this._maxY));
                }
            }
            if (this.model.getChild() == null && this.horizontalPlots == null && HypoLineManager.INSTANCE.getConfig().isSplineInterpolation()) {
                this.splineplot.setForegroundColor(ThemeManager.getInstance().getTheme().getAxisColor());
                this.splineplot.setExternalScale((double)(1.0f / this.model.getCurrentMaxValue()));
                this.splineplot.draw(graphics2D, (Rectangle2D)new Rectangle2D.Double(this._minX, this._minY, this._maxX, this._maxY));
            }
            if ((transparency = this.traceColor) == null) {
                transparency = this.model.getSiteRole().equals((Object)Site.SiteRole.CENTER) && this.traceType.equals((Object)TraceType.TRACE_Z) ? ThemeManager.getInstance().getTheme().getZCenterColor() : (this.model.getSiteRole().equals((Object)Site.SiteRole.CENTER) && !this.traceType.equals((Object)TraceType.TRACE_Z) ? ThemeManager.getInstance().getTheme().getHCenterColor() : (this.model.getSiteRole().equals((Object)Site.SiteRole.SATELLITE) && this.traceType.equals((Object)TraceType.TRACE_Z) ? ThemeManager.getInstance().getTheme().getZSatteliteColor() : Color.PINK));
            }
            this.plot.setForegroundColor((Color)transparency);
            this.plot.setExternalScale((double)(1.0f / this.model.getCurrentMaxValue()));
            this.plot.draw(graphics2D, (Rectangle2D)new Rectangle2D.Double(this._minX, this._minY, this._maxX, this._maxY));
            if (this.model.getChild() == null && HypoLineManager.INSTANCE.getMasterEventManager().isInitialized()) {
                if (this.plotme.get_model() != null) {
                    this.plotme.setForegroundColor(ThemeManager.getInstance().getTheme().getMEColor());
                    this.plotme.setExternalScale((double)(1.0f / this.model.getCurrentMaxValue()) * HypoLineManager.INSTANCE.getMasterEventManager().getMeAmpFactor());
                    this.plotme.draw(graphics2D, (Rectangle2D)new Rectangle2D.Double(this._minX, this._minY, this._maxX, this._maxY));
                }
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getMEColor());
                this.drawPick(HypoLineUtils.convertTimeToPick(this.model.getMepPick(), this.model.getStart(), this.samprate), graphics2D, d, "ME");
                object5 = graphics2D.getStroke();
                graphics2D.setStroke(this.onsetTimeDrawingStroke);
                this.drawPick(HypoLineUtils.convertTimeToPick(HypoLineManager.INSTANCE.getMasterEventManager().getShiftedStartme(this.model), this.model.getStart(), this.samprate), graphics2D, d, "ME OT");
                graphics2D.setStroke((Stroke)object5);
            }
            graphics2D.setColor(Color.BLACK);
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        double d2 = 0.0;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        double d3 = 0.0;
        int n7 = -1;
        int n8 = -1;
        if (this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
            n = HypoLineUtils.convertTimeToPick(this.model.getpCorr(), this.model.getStart(), this.samprate);
            n4 = HypoLineUtils.convertTimeToPick(this.model.getsCorr(), this.model.getStart(), this.samprate);
            n3 = HypoLineUtils.convertTimeToPick(this.model.getSimulatedpCorr(), this.model.getStart(), this.samprate);
            n6 = HypoLineUtils.convertTimeToPick(this.model.getSimulatedsCorr(), this.model.getStart(), this.samprate);
        } else if (this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
            n = HypoLineUtils.convertTimeToPick(this.model.getMagnitude1Pick(), this.model.getStart(), this.samprate);
            n4 = HypoLineUtils.convertTimeToPick(this.model.getMagnitude2Pick(), this.model.getStart(), this.samprate);
        } else {
            n = HypoLineUtils.convertTimeToPick(this.model.getpPick(), this.model.getStart(), this.samprate);
            n4 = HypoLineUtils.convertTimeToPick(this.model.getsPick(), this.model.getStart(), this.samprate);
            n3 = HypoLineUtils.convertTimeToPick(this.model.getpSimulPick(), this.model.getStart(), this.samprate);
            n6 = HypoLineUtils.convertTimeToPick(this.model.getsSimulPick(), this.model.getStart(), this.samprate);
            d2 = this.model.getPUncertainty() * (double)this.samprate;
            d3 = this.model.getSUncertainty() * (double)this.samprate;
        }
        if (!this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
            n2 = HypoLineUtils.convertTimeToPick(this.model.getpPick(), this.model.getStart(), this.samprate);
            n5 = HypoLineUtils.convertTimeToPick(this.model.getsPick(), this.model.getStart(), this.samprate);
        }
        graphics2D.setFont(new Font("Arial", 0, 11));
        if (this.model.getChild() == null && this.model.getSiteRole().equals((Object)Site.SiteRole.CENTER)) {
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGold());
            this.drawPick(n3, graphics2D, d, this.traceType.equals((Object)TraceType.TRACE_Z) ? "P" : "");
            this.drawPick(n6, graphics2D, d, this.traceType.equals((Object)TraceType.TRACE_Z) ? "S" : "");
        }
        if (this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK) || this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE) || this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
            if (!this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
                graphics2D.setColor(suiteTheme.getAlteredInverse(suiteTheme.getHypolineBlue()));
                this.drawPick(n2, graphics2D, d, this.traceType.equals((Object)TraceType.TRACE_Z) ? "P" : "");
                graphics2D.setColor(suiteTheme.getAlteredInverse(suiteTheme.getHypolineGreen()));
                this.drawPick(n5, graphics2D, d, this.traceType.equals((Object)TraceType.TRACE_Z) ? "S" : "");
            }
            switch (this.config.getHypoLineMode()) {
                case MAGNITUDE: {
                    object4 = "";
                    object3 = "";
                    break;
                }
                case ARRAY: {
                    object4 = "Pcorr";
                    object3 = "Scorr";
                    break;
                }
                default: {
                    object4 = "P";
                    object3 = "S";
                }
            }
            if (!this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGreen());
                n8 = this.drawPick(n4, graphics2D, d, (String)(this.traceType.equals((Object)TraceType.TRACE_Z) ? object3 : ""));
                if ((this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK) || HypoLineManager.INSTANCE.isForensicGridRunning()) && d3 > 0.0) {
                    graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGreen());
                    this.drawPickUncertaintyPure(n4, d3, graphics2D, d);
                }
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineBlue());
                n7 = this.drawPick(n, graphics2D, d, (String)(this.traceType.equals((Object)TraceType.TRACE_Z) ? object4 : ""));
                if ((this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK) || HypoLineManager.INSTANCE.isForensicGridRunning()) && d2 > 0.0) {
                    graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineBlue());
                    this.drawPickUncertaintyPure(n, d2, graphics2D, d);
                }
            } else if (this.model.getChild() == null && this.deftrace.getStationID().equals(this.model.getMagnitudePickTrace())) {
                object2 = graphics2D.getStroke();
                graphics2D.setStroke(ARROW_STROKE);
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineRed());
                n7 = this.drawMagnitudePick(n, graphics2D, d, n4);
                n8 = this.drawMagnitudePick(n4, graphics2D, d, n);
                graphics2D.setStroke((Stroke)object2);
            } else if (this.model.getChild() == null && this.model.getMagnitudePickTrace() == null) {
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineRed());
                n7 = this.drawPick(n, graphics2D, d, "");
                n8 = this.drawPick(n4, graphics2D, d, "");
            }
            if (this.model.getChild() == null) {
                graphics2D.setColor(Color.RED);
                if (this.model.isActiveTrace()) {
                    if (this.model.ispOrSActive()) {
                        if (n7 > 0 && !this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
                            graphics2D.fillRect(n7 + 2, 2, 4, 4);
                            object2 = DateTimeUtil.formatDateTimeISOHighPrecision((long)((long)((this.model.getStart() + (double)n / (double)this.samprate) * 1000.0)));
                            graphics2D.drawString((String)object2, n7 + 3, this.getHeight() - 5);
                        }
                    } else if (n8 > 0 && !this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
                        graphics2D.fillRect(n8 + 2, 2, 4, 4);
                        object2 = DateTimeUtil.formatDateTimeISOHighPrecision((long)((long)((this.model.getStart() + (double)n4 / (double)this.samprate) * 1000.0)));
                        graphics2D.drawString((String)object2, n8 + 3, this.getHeight() - 5);
                    }
                }
            }
        }
        if (this.model.getChild() == null && this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
            object3 = "Wood-Anderson simulation";
            object4 = graphics2D.getFontMetrics().getStringBounds((String)object3, graphics2D);
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGold());
            graphics2D.drawString((String)object3, 8, (int)(((RectangularShape)object4).getHeight() + 2.0));
        }
        if (this.model.getChild() == null && this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
            double d4;
            object3 = "<undef> epidist";
            if (!Double.isNaN(this.model.getEpiDist())) {
                object3 = MathUtil.format2Digits((double)this.model.getEpiDist()) + "[km] epidist";
            }
            object4 = "<undef> by tS-tP";
            if (!Double.isNaN(this.model.getTstpDist())) {
                object4 = MathUtil.format2Digits((double)this.model.getTstpDist()) + "[km] by tS-tP";
            }
            object2 = graphics2D.getFontMetrics().getStringBounds((String)object3, graphics2D);
            object = graphics2D.getFontMetrics().getStringBounds((String)object4, graphics2D);
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGold());
            graphics2D.drawString((String)object3, (int)((double)this.getWidth() - ((RectangularShape)object2).getWidth() - 2.0), (int)((double)this.getHeight() - ((RectangularShape)object).getHeight() - 2.0));
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGreen());
            graphics2D.drawString((String)object4, (int)((double)this.getWidth() - ((RectangularShape)object).getWidth() - 2.0), this.getHeight() - 2);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.onsetTimeDrawingStroke);
            double d5 = HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter().getOnsetTime();
            if (!Double.isNaN(d5)) {
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGold());
                int n9 = HypoLineUtils.convertTimeToPick(d5, this.model.getStart(), this.samprate);
                this.drawPick(n9, graphics2D, d, "OT");
            }
            if (!Double.isNaN(d4 = this.model.getOnsetTimeSP()) && !Double.isNaN(this.model.getsPick())) {
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGreen());
                int n10 = HypoLineUtils.convertTimeToPick(this.model.getpPick(), this.model.getStart(), this.samprate) - (int)(d4 * (double)this.samprate);
                this.drawPick(n10, graphics2D, d, "OT by S-P");
            }
            graphics2D.setStroke(stroke);
        }
        if (this.model.getChild() == null && this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE) && this.model.getThreeComp() != null && !Float.isNaN(this.model.getSimulatedAmplitude())) {
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGold());
            float f = this.model.getSimulatedAmplitude();
            int n11 = this.getWidth() / 2;
            if (n7 > 0) {
                n11 = n7;
            }
            int n12 = (int)MathUtil.convertFromTo((double)f, (double)0.0, (double)this.model.getCurrentMaxValue(), (double)0.0, (double)((double)this.getHeight() / 2.0));
            object = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{4.0f, 4.0f}, 2.0f));
            graphics2D.drawLine(0, this.getHeight() / 2 + n12, this.getWidth(), this.getHeight() / 2 + n12);
            graphics2D.drawLine(0, this.getHeight() / 2 - n12, this.getWidth(), this.getHeight() / 2 - n12);
            graphics2D.setStroke((Stroke)object);
            float f2 = HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter().getSimul_depth();
            graphics2D.drawString("Ml " + MathUtil.format2Digits((double)HypoLineManager.INSTANCE.getMagnitudePanel().getMl()) + " in " + MathUtil.format2Digits((double)Math.sqrt(this.model.getEpiDist() * this.model.getEpiDist() + (double)(f2 * f2))) + " km", n11 + 5, this.getHeight() / 2 - n12 - 5);
        }
        graphics2D.setColor(Color.MAGENTA);
        this.printMarker(graphics2D, this.markerModel.getMarker("1a").getPosition());
        this.printMarker(graphics2D, this.markerModel.getMarker("1b").getPosition());
        graphics2D.dispose();
    }

    private int drawMagnitudePick(int n, Graphics2D graphics2D, double d, int n2) {
        int n3 = -1;
        DefaultTrace defaultTrace = this.getDeftrace();
        if (n > 0 && n < defaultTrace.getLength()) {
            float f;
            int n4;
            int n5;
            float f2 = this.getDeftrace().getSample(n);
            if (n2 <= 0) {
                n5 = 1;
                n4 = f2 >= 0.0f ? 1 : -1;
            } else {
                f = defaultTrace.getSample(n2);
                n5 = n < n2 ? 1 : -1;
                n4 = f2 < f ? -1 : 1;
            }
            n3 = (int)(MathUtil.convertFromTo((double)n, (double)0.0, (double)(this.sampleLength - 1.0), (double)this._minX, (double)(this._maxX + this._minX)) - d);
            f = this.model.getCurrentMaxValue();
            int n6 = (int)((float)this.getHeight() * (0.5f - f2 / (2.0f * f)));
            graphics2D.drawLine(n3 - 10 * n5, n6 - 10 * n4, n3, n6);
            graphics2D.drawLine(n3 - 10 * n5 / 2, n6, n3, n6);
            graphics2D.drawLine(n3, n6 - 10 * n4 / 2, n3, n6);
        }
        return n3;
    }

    private int drawPick(int n, Graphics2D graphics2D, double d, String string) {
        int n2 = n;
        if (n2 > 0) {
            n2 = (int)(MathUtil.convertFromTo((double)n2, (double)0.0, (double)(this.sampleLength - 1.0), (double)this._minX, (double)(this._maxX + this._minX)) - d);
            graphics2D.drawLine(n2, 0, n2, this.getHeight());
            if (this.model.getChild() == null) {
                Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
                graphics2D.drawString(string, n2 + 2, (int)rectangle2D.getHeight() + 3);
            }
        }
        return n2;
    }

    private void drawPickUncertaintyPure(int n, double d, Graphics2D graphics2D, double d2) {
        int n2 = (int)(MathUtil.convertFromTo((double)((double)n - d), (double)0.0, (double)(this.sampleLength - 1.0), (double)this._minX, (double)(this._maxX + this._minX)) - d2);
        int n3 = (int)(MathUtil.convertFromTo((double)((double)n + d), (double)0.0, (double)(this.sampleLength - 1.0), (double)this._minX, (double)(this._maxX + this._minX)) - d2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
        graphics2D.fillRect(n2, 0, n3 - n2, this.getHeight());
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.drawLine(n2, 0, n2, this.getHeight());
        graphics2D.drawLine(n3, 0, n3, this.getHeight());
    }

    private void drawPickUncertainty(int n, double d, Graphics2D graphics2D, double d2, float[] fArray, float f, int n2) {
        int n3 = (int)(MathUtil.convertFromTo((double)((double)n - d), (double)0.0, (double)(this.sampleLength - 1.0), (double)this._minX, (double)(this._maxX + this._minX)) - d2);
        int n4 = (int)(MathUtil.convertFromTo((double)((double)n + d), (double)0.0, (double)(this.sampleLength - 1.0), (double)this._minX, (double)(this._maxX + this._minX)) - d2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
        graphics2D.fillRect(n3, 0, n4 - n3, this.getHeight());
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.drawLine(n3, 0, n3, this.getHeight());
        graphics2D.drawLine(n4, 0, n4, this.getHeight());
        int n5 = n4 - n3;
        int n6 = fArray.length;
        double d3 = (float)n5 / (float)n6;
        graphics2D.setColor(Color.black);
        for (int i = 0; i < n6; ++i) {
            if (i == n2) {
                graphics2D.setColor(Color.orange);
                graphics2D.fillRect((int)((double)n3 + (double)i * d3), (int)((double)this.getHeight() - 0.5 * (double)this.getHeight() * (double)(fArray[i] / f)), (int)d3, (int)(0.5 * (double)this.getHeight() * (double)(fArray[i] / f)));
                graphics2D.setColor(Color.black);
            }
            graphics2D.drawRect((int)((double)n3 + (double)i * d3), (int)((double)this.getHeight() - 0.5 * (double)this.getHeight() * (double)(fArray[i] / f)), (int)d3, (int)(0.5 * (double)this.getHeight() * (double)(fArray[i] / f)));
        }
    }

    private void printMarker(Graphics2D graphics2D, double d) {
        int n = (int)Math.rint(MathUtil.convertToAbsolute((double)d, (int)this._minX, (int)this._maxX));
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(MARKER_STROKE);
        graphics2D.drawLine(n, 0, n, this.getHeight());
        graphics2D.setStroke(stroke);
    }

    public DefaultTrace getDeftrace() {
        return this.deftrace;
    }

    public static enum TraceType {
        TRACE_Z,
        TRACE_EW,
        TRACE_NS;

    }

    class Pick {
        private Color color;
        private int pick;
        private String caption;

        public Pick(Color color, int n, String string) {
            this.color = color;
            this.pick = n;
            this.caption = string;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public int getPick() {
            return this.pick;
        }

        public void setPick(int n) {
            this.pick = n;
        }

        public String getCaption() {
            return this.caption;
        }

        public void setCaption(String string) {
            this.caption = string;
        }
    }
}

