/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.vertical;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class ButtonColumn
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private Action action;
    private int mnemonic;
    private Border originalBorder;
    private Border focusBorder;
    private JButton renderButton;
    private JButton editButton;
    private Object editorValue;
    private boolean isButtonColumnEditor;

    public ButtonColumn(JTable jTable, Action action, int n) {
        this.table = jTable;
        this.action = action;
        this.renderButton = new JButton();
        this.editButton = new JButton();
        this.renderButton.setMargin(new Insets(0, 0, 0, 0));
        this.renderButton.setMargin(new Insets(0, 0, 0, 0));
        this.editButton.setFocusPainted(false);
        this.editButton.addActionListener(this);
        this.originalBorder = this.editButton.getBorder();
        this.setFocusBorder(new LineBorder(Color.BLUE));
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        tableColumnModel.getColumn(n).setCellRenderer(this);
        tableColumnModel.getColumn(n).setCellEditor(this);
        jTable.addMouseListener(this);
    }

    public Border getFocusBorder() {
        return this.focusBorder;
    }

    public void setFocusBorder(Border border) {
        this.focusBorder = border;
        this.editButton.setBorder(border);
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(int n) {
        this.mnemonic = n;
        this.renderButton.setMnemonic(n);
        this.editButton.setMnemonic(n);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object == null) {
            this.editButton.setText("");
            this.editButton.setIcon(null);
        } else if (object instanceof Icon) {
            this.editButton.setText("");
            this.editButton.setIcon((Icon)object);
        } else {
            this.editButton.setText(object.toString());
            this.editButton.setIcon(null);
        }
        this.editorValue = object;
        return this.editButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorValue;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.renderButton.setForeground(jTable.getSelectionForeground());
            this.renderButton.setBackground(jTable.getSelectionBackground());
        } else {
            this.renderButton.setForeground(jTable.getForeground());
            this.renderButton.setBackground(UIManager.getColor("Button.background"));
        }
        if (bl2) {
            this.renderButton.setBorder(this.focusBorder);
        } else {
            this.renderButton.setBorder(this.originalBorder);
        }
        if (object == null) {
            this.renderButton.setText("");
            this.renderButton.setIcon(null);
        } else if (object instanceof Icon) {
            this.renderButton.setText("");
            this.renderButton.setIcon((Icon)object);
        } else {
            this.renderButton.setText(object.toString());
            this.renderButton.setIcon(null);
        }
        return this.renderButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.table.convertRowIndexToModel(this.table.getEditingRow());
        this.fireEditingStopped();
        ActionEvent actionEvent2 = new ActionEvent(this.table, 1001, "" + n);
        this.action.actionPerformed(actionEvent2);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.table.isEditing() && this.table.getCellEditor() == this) {
            this.isButtonColumnEditor = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isButtonColumnEditor && this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.isButtonColumnEditor = false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

