/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.vertical;

import edu.geophys.commons.model.layer.Layer;
import edu.geophys.commons.model.layer.LayerModel;
import edu.geophys.commons.resources.Colors;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.sitecollection.SiteCollectionModel;
import edu.geophys.hypoline.ui.vertical.LayerModelController;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class DepthSection
extends ActivateableComponent {
    private static final long serialVersionUID = 1L;
    protected static final int SKY_PIXELS = 50;
    protected static final int BASELINE_PIXELS = 50;
    protected static final Stroke FAT_STROKE = new BasicStroke(2.0f);
    protected static final Stroke THIN_STROKE = new BasicStroke(1.0f);
    protected static final int LABEL_PADDING = 2;
    protected Rectangle2D.Double geographicBoundsKm = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    protected double verticalPxPerKm = Double.NaN;
    protected double horizontalPxPerVal = Double.NaN;
    protected double verticalKmPerPx = Double.NaN;
    protected double horizontalValPerPx = Double.NaN;

    public DepthSection() {
        this.setLayout(null);
        this.setFocusable(true);
        this.setOpaque(true);
        this.setMinimumSize(new Dimension(50, 5000));
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(graphics2D.getClip());
        this.resetBoundsVertical();
        this.resetBoundsHorizontal();
        this.paintPlot(graphics2D);
        graphics2D.dispose();
    }

    public void paintPlot(Graphics2D graphics2D) {
        this.paintLayerModel(graphics2D, true);
        this.paintStationsSimple(graphics2D);
        this.paintVerticalTicks(graphics2D);
    }

    private int calcDepthTickIncKm(int n) {
        double d = this.geographicBoundsKm.height;
        int n2 = (int)(0.75 + d / (double)n);
        int n3 = 1;
        while (n2 > n) {
            n2 /= 2;
            n3 *= 2;
        }
        return Math.max(n3 * n2, 1);
    }

    public void paintVerticalTicks(Graphics2D graphics2D) {
        int n;
        String string;
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        int n2 = this.getWidth();
        int n3 = 0;
        int n4 = this.calcDepthTickIncKm(Math.max(8, this.getHeight() / 50));
        double d = this.geographicBoundsKm.y;
        while ((double)n3 > d) {
            string = n3 + "km";
            n = (int)this.elevationKmToPx(n3);
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            graphics2D.drawString(string, n2 - 2 - (int)rectangle2D.getWidth(), n - 2);
            graphics2D.drawLine(n2, n, n2 - 20, n);
            n3 -= n4;
        }
        double d2 = this.geographicBoundsKm.y + this.geographicBoundsKm.height;
        n3 = n4;
        while ((double)n3 < d2) {
            string = n3 + "km";
            n = (int)this.elevationKmToPx(n3);
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            graphics2D.drawString(string, n2 - 2 - (int)rectangle2D.getWidth(), n - 2);
            graphics2D.drawLine(n2, n, n2 - 20, n);
            n3 += n4;
        }
    }

    protected void paintStationsSimple(Graphics2D graphics2D) {
        graphics2D.setStroke(FAT_STROKE);
        graphics2D.setColor(Color.RED);
        HypoLineManager hypoLineManager = HypoLineManager.INSTANCE;
        SiteCollectionModel siteCollectionModel = hypoLineManager.getSiteCollectionModel();
        double d = this.getWidth();
        float[] fArray = siteCollectionModel.getZClasses();
        int[] nArray = siteCollectionModel.getSiteZClassByIndex();
        float[] fArray2 = siteCollectionModel.getSiteElevationsKm();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(d * (0.1 + 0.8 * (double)i / (double)n));
            float f = fArray[nArray[i]];
            int n3 = (int)this.elevationKmToPx(f);
            int n4 = (int)this.elevationKmToPx(fArray2[i]);
            graphics2D.drawLine(n2 - 4, n3, n2 + 4, n3);
            graphics2D.drawLine(n2, n3, n2, n4);
            graphics2D.drawString(siteCollectionModel.getSiteByIndex()[i].getId(), n2 + 4, n3 - 2);
        }
    }

    protected void paintLayerModel(Graphics2D graphics2D, boolean bl) {
        double d;
        double d2;
        LayerModelController layerModelController = HypoLineManager.INSTANCE.getLayerModelController();
        LayerModel layerModel = layerModelController.getCurrentLayerModel();
        int n = this.getWidth();
        double d3 = layerModelController.getCorrectedZeroElevation();
        if (!LayerModelController.doubleEqual(d3, d2 = layerModelController.getRawZeroElevation())) {
            double d4 = this.elevationKmToPx(d3);
            d = this.elevationKmToPx(d2);
            Color color = this.getLayerColor((Layer)layerModel.getLayers().get(0));
            Color color2 = color.darker();
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, 20.0f, 20.0f, new float[]{0.5f, 0.50001f}, new Color[]{color, color2}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fillRect(0, (int)d4, n, (int)(d - d4));
            graphics2D.setColor(Color.GRAY);
            graphics2D.drawLine(0, (int)d4, n, (int)d4);
        }
        d3 = d2;
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(THIN_STROKE);
        if (bl) {
            graphics2D.drawString(String.format("%.2f km", d3), 2, (int)this.elevationKmToPx(d3) - 2);
        }
        for (Layer layer : layerModel.getLayers()) {
            d = layer.getD();
            double d5 = d3 - d;
            int n2 = (int)this.elevationKmToPx(d3);
            int n3 = (int)this.elevationKmToPx(d5);
            graphics2D.setColor(Color.BLACK);
            if (bl) {
                graphics2D.drawString(String.format("%.2f km", d3), 2, (int)this.elevationKmToPx(d3) - 2);
            }
            graphics2D.setColor(this.getLayerColor(layer));
            if (d < 0.0) {
                graphics2D.fillRect(0, n2, n, this.getHeight());
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawLine(0, n2, n, n2);
                break;
            }
            graphics2D.fillRect(0, n2, n, n3 - n2);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(0, n2, n, n2);
            d3 = d5;
        }
    }

    protected Color getLayerColor(Layer layer) {
        double d = layer.getVp();
        if (d > 10.0) {
            d = 10.0;
        }
        Color color = Colors.SONOGRAM[(int)MathUtil.convertFromTo((double)d, (double)0.0, (double)10.0, (double)0.0, (double)(Colors.SONOGRAM.length - 1))];
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 50);
    }

    protected void resetBoundsHorizontal() {
        this.horizontalPxPerVal = this.getWidth();
        this.horizontalValPerPx = 1.0 / this.horizontalPxPerVal;
        this.geographicBoundsKm.x = 0.0;
        this.geographicBoundsKm.width = this.horizontalPxPerVal;
    }

    protected void resetBoundsVertical() {
        double d;
        double d2;
        HypoLineManager hypoLineManager = HypoLineManager.INSTANCE;
        if (hypoLineManager == null) {
            return;
        }
        SiteCollectionModel siteCollectionModel = hypoLineManager.getSiteCollectionModel();
        LayerModel layerModel = hypoLineManager.getLayerModelController().getCurrentLayerModel();
        if (layerModel.hasZeroElevation()) {
            d2 = Math.max((double)siteCollectionModel.getHighestZClassElevationKm(), layerModel.getZeroElevation());
            d = Math.min((double)siteCollectionModel.getLowestZClassElevationKm(), layerModel.getUpperBound(layerModel.getLayers().size() - 1));
        } else {
            d2 = Math.max(siteCollectionModel.getHighestZClassElevationKm(), 0.0f);
            d = Math.min((double)siteCollectionModel.getLowestZClassElevationKm(), layerModel.getUpperBound(layerModel.getLayers().size() - 1, (double)siteCollectionModel.getHighestZClassElevationKm()));
        }
        if (d2 - d < 0.5) {
            d = d2 - 0.5;
        }
        this.verticalPxPerKm = (double)(this.getHeight() - 50 - 50) / (d2 - d);
        this.verticalKmPerPx = 1.0 / this.verticalPxPerKm;
        this.geographicBoundsKm.y = d - 50.0 / this.verticalPxPerKm;
        this.geographicBoundsKm.height = d2 + 50.0 / this.verticalPxPerKm - this.geographicBoundsKm.y;
    }

    public double pxToElevationKm(double d) {
        double d2 = (double)this.getHeight() - d;
        return this.geographicBoundsKm.y + d2 * this.verticalKmPerPx;
    }

    public double elevationKmToPx(double d) {
        double d2 = d - this.geographicBoundsKm.y;
        return (double)this.getHeight() - this.verticalPxPerKm * d2;
    }

    public double pxToHorizontal(double d) {
        double d2 = d;
        return this.geographicBoundsKm.x + d2 * this.horizontalValPerPx;
    }

    public double horizontalToPx(double d) {
        double d2 = d - this.geographicBoundsKm.x;
        return this.horizontalPxPerVal * d2;
    }
}

