/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.vertical;

import edu.geophys.commons.model.knowledgebase.LayerKnowledge;
import edu.geophys.commons.model.layer.LayerModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.vertical.LayerModelController;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class LayerModelChooser
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final Border ELEMENT_BORDER = BorderFactory.createTitledBorder("Layer Models:");
    JTable lmTable = null;

    public LayerModelChooser() {
        this.initComponents();
        this.updateLayerModel();
    }

    private void initComponents() {
        LayerModelController layerModelController = HypoLineManager.INSTANCE.getLayerModelController();
        this.setBorder(ELEMENT_BORDER);
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        this.lmTable = new JTable(layerModelController.getLayerModelsTM());
        this.lmTable.getColumnModel().getColumn(0).setMinWidth(40);
        this.lmTable.getColumnModel().getColumn(0).setMaxWidth(40);
        this.lmTable.getColumnModel().getColumn(1).setMinWidth(35);
        this.lmTable.getColumnModel().getColumn(1).setMaxWidth(35);
        this.lmTable.getColumnModel().getColumn(2).setMinWidth(200);
        this.lmTable.getColumnModel().getColumn(2).setMaxWidth(400);
        this.lmTable.getColumnModel().getColumn(3).setMinWidth(50);
        this.lmTable.setCellSelectionEnabled(false);
        this.lmTable.setRowSelectionAllowed(true);
        this.lmTable.setColumnSelectionAllowed(false);
        this.lmTable.setSelectionMode(0);
        this.lmTable.setFillsViewportHeight(true);
        this.lmTable.setPreferredScrollableViewportSize(this.lmTable.getPreferredSize());
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        for (int n : new int[]{0, 1}) {
            this.lmTable.getColumnModel().getColumn(n).setCellRenderer(defaultTableCellRenderer);
        }
        this.lmTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LayerModelController layerModelController;
                int n = LayerModelChooser.this.lmTable.getSelectedRow();
                ArrayList arrayList = SuiteManager.INSTANCE.getKnowledgebase().getLayerKnowledge().getLayerModels();
                if (n < 0 || n >= arrayList.size()) {
                    return;
                }
                LayerModel layerModel = (LayerModel)arrayList.get(n);
                if (layerModel != (layerModelController = HypoLineManager.INSTANCE.getLayerModelController()).getCurrentLayerModel()) {
                    layerModelController.setCurrentLayerModel(layerModel);
                }
            }
        });
        jPanel.setLayout(new FlowLayout(0));
        Object object = new JButton("New");
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayerKnowledge layerKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getLayerKnowledge();
                layerKnowledge.createNewLayermodel();
                ((LayerModelController.LayerModelsTM)LayerModelChooser.this.lmTable.getModel()).updateNewRows();
            }
        });
        jPanel.add((Component)object);
        object = new JButton("Duplicate");
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayerKnowledge layerKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getLayerKnowledge();
                layerKnowledge.cloneLayermodel(LayerModelChooser.this.lmTable.getSelectedRow());
                ((LayerModelController.LayerModelsTM)LayerModelChooser.this.lmTable.getModel()).updateNewRows();
            }
        });
        jPanel.add((Component)object);
        object = new JButton("Save Modified");
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayerKnowledge layerKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getLayerKnowledge();
                layerKnowledge.store(false);
                ((LayerModelController.LayerModelsTM)LayerModelChooser.this.lmTable.getModel()).updateNewRows();
                LayerModelChooser.this.repaint();
            }
        });
        jPanel.add((Component)object);
        object = new JButton("Delete");
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayerModelChooser.this.askDeleteLayer();
            }
        });
        jPanel.add((Component)object);
        this.add(jPanel);
        JScrollPane jScrollPane = new JScrollPane(this.lmTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.add(jScrollPane);
    }

    public void updateLayerModel() {
        LayerModel layerModel = HypoLineManager.INSTANCE.getLayerModelController().getCurrentLayerModel();
        LayerKnowledge layerKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getLayerKnowledge();
        ArrayList arrayList = layerKnowledge.getLayerModels();
        this.lmTable.repaint();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!layerModel.equals(arrayList.get(i))) continue;
            this.lmTable.setRowSelectionInterval(i, i);
            break;
        }
    }

    private void askDeleteLayer() {
        LayerKnowledge layerKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getLayerKnowledge();
        int n = this.lmTable.getSelectedRow();
        int n2 = JOptionPane.showConfirmDialog(HypoLineManager.INSTANCE.getLayerModelEditorFrame(), "Really delete model " + ((LayerModel)layerKnowledge.getLayerModels().get(n)).getName() + "?", "Delete Layer Model", 2);
        if (n2 == 0) {
            layerKnowledge.deleteModel(n);
            ((LayerModelController.LayerModelsTM)this.lmTable.getModel()).updateNewRows();
        }
    }
}

