/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.vertical;

import edu.geophys.commons.model.layer.Layer;
import edu.geophys.commons.model.layer.LayerModel;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.sitecollection.SiteCollectionModel;
import edu.geophys.hypoline.ui.vertical.DepthSection;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;

public class VelocitySection
extends DepthSection {
    private static final long serialVersionUID = 1L;
    private static final int LINEWIDTH = 3;
    private static final double H_OFFSET = 0.5;
    private static final Stroke PLOT_STROKE = new BasicStroke(3.0f, 2, 0);
    private static final Stroke GRID_STROKE = new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{1.0f, 2.0f}, 0.0f);
    private static final int TRIANGLE_SIZE = 8;
    private final GeneralPath triangle = new GeneralPath(0, 3);

    public VelocitySection() {
        this.updateTriangle();
    }

    @Override
    public void paintPlot(Graphics2D graphics2D) {
        super.paintLayerModel(graphics2D, false);
        this.paintHighestStation(graphics2D);
        super.paintVerticalTicks(graphics2D);
        this.paintHorizontalTicks(graphics2D);
        this.paintVpVs(graphics2D);
    }

    private void paintHighestStation(Graphics2D graphics2D) {
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(PLOT_STROKE);
        SiteCollectionModel siteCollectionModel = HypoLineManager.INSTANCE.getSiteCollectionModel();
        double d = siteCollectionModel.getHighestZClassElevationKm();
        String string = siteCollectionModel.getHighestElevationSnsId();
        int n = (int)(0.61804697157 * (double)this.getWidth());
        int n2 = (int)(this.elevationKmToPx(d) - 1.5);
        graphics2D.translate(n, n2);
        graphics2D.draw(this.triangle);
        graphics2D.drawString(string, 4, -4);
        graphics2D.translate(-n, -n2);
    }

    private void paintHorizontalTicks(Graphics2D graphics2D) {
        String string = "km/s";
        double d = graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth() + 4.0;
        double d2 = this.getWidth();
        int n = this.getHeight();
        graphics2D.drawString(string, 2, n - 2);
        double d3 = d2 - 1.5 * d;
        int n2 = 1;
        double d4 = this.horizontalToPx(n2);
        while (d2 / d4 > d) {
            d4 = this.horizontalToPx(++n2);
        }
        double d5 = d4;
        int n3 = n2;
        graphics2D.setStroke(GRID_STROKE);
        while (d5 < d2) {
            graphics2D.setColor(Color.GRAY);
            graphics2D.drawLine((int)d5, n, (int)d5, 0);
            if (d5 < d3) {
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString("" + n3, (int)d5 + 2, n - 2);
            }
            d5 += d4;
            n3 += n2;
        }
    }

    @Override
    protected void resetBoundsHorizontal() {
        double d = 0.0;
        double d2 = 10.0;
        if (HypoLineManager.INSTANCE == null) {
            return;
        }
        double d3 = HypoLineManager.INSTANCE.getLayerModelController().getCurrentLayerModel().getLastLayer().getVp();
        if (d3 > d2) {
            d2 = d3 + 0.5;
        }
        this.horizontalPxPerVal = (double)this.getWidth() / d2;
        this.horizontalValPerPx = 1.0 / this.horizontalPxPerVal;
        this.geographicBoundsKm.x = d;
        this.geographicBoundsKm.width = d2;
    }

    private void paintVpVs(Graphics2D graphics2D) {
        Path2D.Double double_ = new Path2D.Double();
        Path2D.Double double_2 = new Path2D.Double();
        HypoLineManager hypoLineManager = HypoLineManager.INSTANCE;
        LayerModel layerModel = hypoLineManager.getLayerModelController().getCurrentLayerModel();
        double d = layerModel.getUpperBound(0);
        double d2 = hypoLineManager.getSiteCollectionModel().getHighestZClassElevationKm();
        if (Double.isNaN(d)) {
            d = layerModel.getUpperBound(0, d2);
        }
        boolean bl = true;
        for (Layer layer : layerModel.getLayers()) {
            double d3;
            double d4 = layer.getD();
            double d5 = d - d4;
            double d6 = layer.getVp();
            double d7 = layer.hasVs() ? layer.getVs() : d6 / layerModel.getVp2vs();
            double d8 = this.horizontalToPx(d6);
            double d9 = this.horizontalToPx(d7);
            if (bl) {
                d3 = this.elevationKmToPx(Math.max(d, d2));
                ((Path2D)double_).moveTo(d8, d3);
                ((Path2D)double_2).moveTo(d9, d3);
            } else {
                d3 = double_.getCurrentPoint().getY();
                ((Path2D)double_).lineTo(d8, d3 - 0.5);
                ((Path2D)double_2).lineTo(d9, d3 + 0.5);
            }
            double d10 = d4 > 0.0 ? (double)((int)this.elevationKmToPx(d5)) : (double)this.getHeight() + 1.0;
            ((Path2D)double_).lineTo(d8, d10 - 0.5);
            ((Path2D)double_2).lineTo(d9, d10 + 0.5);
            d = d5;
            if (!bl) continue;
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineBlue());
            graphics2D.drawString("vP", (int)d8 + 2, (int)(d3 + Math.min(d10, 15.0)));
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGreen());
            graphics2D.drawString("vS", (int)d9 + 2, (int)(d3 + Math.min(d10, 15.0)));
            bl = false;
        }
        graphics2D.setStroke(PLOT_STROKE);
        graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineBlue());
        graphics2D.draw(double_);
        graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGreen());
        graphics2D.draw(double_2);
    }

    private void updateTriangle() {
        this.triangle.reset();
        this.triangle.moveTo(-4.0, 0.0);
        this.triangle.lineTo(4.0, 0.0);
        this.triangle.lineTo(0.0f, -8.0f);
        this.triangle.closePath();
    }
}

