/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.plot2d.rendering.CanvasAWT;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.legends.Legend;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Renderer2d;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.ViewPort;

public class ChartView
extends View {
    Rectangle zone1 = new Rectangle(0, 0, 0, 0);
    Rectangle zone2 = new Rectangle(0, 0, 0, 0);

    public ChartView(Scene scene, ICanvas canvas, Quality quality) {
        super(scene, canvas, quality);
    }

    public void showLayout() {
        Renderer2d layoutBorder = new Renderer2d(){
            CanvasAWT pencil = null;

            public void paint(Graphics g) {
                if (this.pencil == null) {
                    this.pencil = new CanvasAWT((Graphics2D)g);
                }
                if (ChartView.this.zone1.width > 0) {
                    this.pencil.drawRect(null, ChartView.this.zone1.x, ChartView.this.zone1.y, ChartView.this.zone1.width, ChartView.this.zone1.height, true);
                }
                if (ChartView.this.zone2.width > 0) {
                    this.pencil.drawRect(null, ChartView.this.zone2.x, ChartView.this.zone2.y, ChartView.this.zone2.width, ChartView.this.zone2.height, true);
                }
            }
        };
        this.addRenderer2d(layoutBorder);
    }

    public void render(GL2 gl, GLU glu) {
        List<Legend> list = this.scene.getGraph().getLegends();
        boolean hasMeta = list.size() > 0;
        float screenSeparator = 1.0f;
        if (hasMeta) {
            int minwidth = 0;
            for (Legend data : list) {
                minwidth += data.getMinimumSize().width;
            }
            screenSeparator = (float)(this.canvas.getRendererWidth() - minwidth) / (float)this.canvas.getRendererWidth();
        }
        ViewPort sceneViewPort = ViewPort.slice(this.canvas.getRendererWidth(), this.canvas.getRendererHeight(), 0.0f, screenSeparator);
        ViewPort backgroundViewPort = new ViewPort(this.canvas.getRendererWidth(), this.canvas.getRendererHeight());
        this.renderBackground(gl, glu, backgroundViewPort);
        this.renderScene(gl, glu, sceneViewPort);
        if (hasMeta) {
            this.renderFaces(gl, glu, screenSeparator, 1.0f);
        }
        this.renderOverlay(gl, this.cam.getLastViewPort());
        if (this.dimensionDirty) {
            this.dimensionDirty = false;
        }
    }

    protected void renderFaces(GL2 gl, GLU glu, float left, float right) {
        List<Legend> data = this.scene.getGraph().getLegends();
        float slice = (right - left) / (float)data.size();
        int k = 0;
        for (Legend layer : data) {
            layer.setStretchToFill(true);
            layer.setViewPort(this.canvas.getRendererWidth(), this.canvas.getRendererHeight(), left + slice * (float)k++, left + slice * (float)k);
            layer.render(gl, glu);
        }
    }
}

