/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.keyboard.camera;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.jzy3d.chart.Chart;

public class ScreenshotKeyListener
implements KeyListener {
    protected Chart chart;
    protected String outputFile;
    protected List<IScreenshotEventListener> listeners = new ArrayList<IScreenshotEventListener>(1);

    public ScreenshotKeyListener(Chart chart, String outputFile) {
        this.chart = chart;
        this.outputFile = outputFile;
    }

    public void keyTyped(KeyEvent e) {
        switch (e.getKeyChar()) {
            case 's': {
                try {
                    this.screenshot(this.chart, this.outputFile);
                    this.fireDone(this.outputFile);
                    break;
                }
                catch (IOException e1) {
                    this.fireError(this.outputFile, e1);
                }
            }
        }
    }

    public void screenshot(Chart chart, String filename) throws IOException {
        File output = new File(filename);
        if (!output.getParentFile().exists()) {
            output.mkdirs();
        }
        ImageIO.write((RenderedImage)chart.screenshot(), "png", output);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    protected void fireDone(String file) {
        for (IScreenshotEventListener listener : this.listeners) {
            listener.doneScreenshot(file);
        }
    }

    public void addListener(IScreenshotEventListener listener) {
        this.listeners.add(listener);
    }

    protected void fireError(String file, Exception e) {
        for (IScreenshotEventListener listener : this.listeners) {
            listener.failedScreenshot(file, e);
        }
    }

    public static interface IScreenshotEventListener {
        public void doneScreenshot(String var1);

        public void failedScreenshot(String var1, Exception var2);
    }
}

