/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.mouse;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.mouse.camera.CameraMouseController;
import org.jzy3d.chart.controllers.mouse.selection.AbstractMouseSelector;
import org.jzy3d.chart.controllers.thread.camera.CameraThreadController;
import org.jzy3d.plot3d.rendering.view.Renderer2d;

public class DualModeMouseSelector {
    protected Chart chart;
    protected Renderer2d messageRenderer;
    protected CameraThreadController threadCamera;
    protected CameraMouseController mouseCamera;
    protected AbstractMouseSelector mouseSelection;
    protected boolean displayMessage = true;
    protected String message;
    public static String MESSAGE_SELECTION_MODE = "Current mouse mode: selection (hold 'c' to switch to camera mode)";
    public static String MESSAGE_ROTATION_MODE = "Current mouse mode: camera (release 'c' to switch to selection mode)";

    public DualModeMouseSelector(Chart chart, AbstractMouseSelector alternativeMouse) {
        this.build(chart, alternativeMouse);
    }

    public Chart build(Chart chart, AbstractMouseSelector alternativeMouse) {
        this.chart = chart;
        this.mouseSelection = alternativeMouse;
        this.threadCamera = new CameraThreadController(chart);
        this.mouseCamera = new CameraMouseController(chart);
        this.mouseCamera.addSlaveThreadController(this.threadCamera);
        chart.getCanvas().addKeyListener(this.buildToggleKeyListener(chart));
        this.releaseCam();
        this.message = MESSAGE_SELECTION_MODE;
        this.messageRenderer = this.buildMessageRenderer();
        chart.addRenderer(this.messageRenderer);
        return chart;
    }

    public KeyListener buildToggleKeyListener(final Chart chart) {
        return new KeyListener(){
            protected boolean holding = false;

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case 'c': {
                        DualModeMouseSelector.this.releaseCam();
                        this.holding = false;
                        DualModeMouseSelector.this.message = MESSAGE_SELECTION_MODE;
                        break;
                    }
                }
                chart.render();
            }

            public void keyTyped(KeyEvent e) {
                if (!this.holding) {
                    switch (e.getKeyChar()) {
                        case 'c': {
                            DualModeMouseSelector.this.useCam();
                            DualModeMouseSelector.this.mouseSelection.clearLastSelection();
                            this.holding = true;
                            DualModeMouseSelector.this.message = MESSAGE_ROTATION_MODE;
                            break;
                        }
                    }
                    chart.render();
                }
            }
        };
    }

    public Renderer2d buildMessageRenderer() {
        return new Renderer2d(){

            public void paint(Graphics g) {
                if (DualModeMouseSelector.this.displayMessage && DualModeMouseSelector.this.message != null) {
                    g.setColor(Color.RED);
                    g.drawString(DualModeMouseSelector.this.message, 10, 30);
                }
            }
        };
    }

    protected void useCam() {
        this.mouseSelection.unregister();
        this.chart.addController(this.mouseCamera);
    }

    protected void releaseCam() {
        this.chart.removeController(this.mouseCamera);
        this.mouseSelection.register(this.chart);
    }
}

