/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.mouse.picking;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.camera.AbstractCameraController;
import org.jzy3d.chart.controllers.mouse.MouseUtilities;
import org.jzy3d.chart.controllers.thread.camera.CameraThreadController;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.picking.PickingSupport;
import org.jzy3d.plot3d.rendering.scene.Graph;
import org.jzy3d.plot3d.rendering.view.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MousePickingController<V, E>
extends AbstractCameraController
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected float factor = 1.0f;
    protected float lastInc;
    protected Coord3d mouse3d;
    protected Coord3d prevMouse3d;
    protected PickingSupport picking;
    protected GLU glu = new GLU();
    protected Coord2d prevMouse;
    protected CameraThreadController threadController;

    public MousePickingController() {
        this.picking = new PickingSupport();
    }

    public MousePickingController(Chart chart) {
        super(chart);
        this.picking = new PickingSupport();
    }

    public MousePickingController(Chart chart, int brushSize) {
        super(chart);
        this.picking = new PickingSupport(brushSize);
    }

    public MousePickingController(Chart chart, int brushSize, int bufferSize) {
        super(chart);
        this.picking = new PickingSupport(brushSize, bufferSize);
    }

    @Override
    public void register(Chart chart) {
        super.register(chart);
        this.prevMouse = Coord2d.ORIGIN;
        chart.getCanvas().addMouseListener(this);
        chart.getCanvas().addMouseMotionListener(this);
        chart.getCanvas().addMouseWheelListener(this);
    }

    @Override
    public void dispose() {
        for (Chart c : this.targets) {
            c.getCanvas().removeMouseListener(this);
            c.getCanvas().removeMouseMotionListener(this);
            c.getCanvas().removeMouseWheelListener(this);
        }
        if (this.threadController != null) {
            this.threadController.stop();
        }
        super.dispose();
    }

    public PickingSupport getPickingSupport() {
        return this.picking;
    }

    public void setPickingSupport(PickingSupport picking) {
        this.picking = picking;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.threadController != null) {
            this.threadController.stop();
        }
        System.out.println(e.getWheelRotation());
        float factor = 1.0f + (float)e.getWheelRotation() / 10.0f;
        System.out.println(factor * 100.0f);
        this.zoomX(factor);
        this.zoomY(factor);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.pick(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.handleSlaveThread(e)) {
            return;
        }
        this.pick(e);
    }

    public void pick(MouseEvent e) {
        int yflip = -e.getY() + ((Chart)this.targets.get(0)).getCanvas().getRendererHeight();
        this.prevMouse.x = e.getX();
        this.prevMouse.y = e.getY();
        View view = ((Chart)this.targets.get(0)).getView();
        this.prevMouse3d = view.projectMouse(e.getX(), yflip);
        GL2 gl = this.chart().getView().getCurrentGL();
        Graph graph = this.chart().getScene().getGraph();
        this.picking.pickObjects(gl, this.glu, view, graph, new IntegerCoord2d(e.getX(), yflip));
    }

    public boolean handleSlaveThread(MouseEvent e) {
        if (MouseUtilities.isDoubleClick(e) && this.threadController != null) {
            this.threadController.start();
            return true;
        }
        if (this.threadController != null) {
            this.threadController.stop();
        }
        return false;
    }
}

