/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.mouse.selection;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.jzy3d.chart.Chart;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Renderer2d;
import org.jzy3d.plot3d.rendering.view.View;

public abstract class AbstractMouseSelector
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected Chart chart;
    protected boolean dragging = false;
    protected IntegerCoord2d in = new IntegerCoord2d(-1, -1);
    protected IntegerCoord2d out;
    protected IntegerCoord2d last = new IntegerCoord2d(-1, -1);
    protected Renderer2d selectionRenderer;

    public AbstractMouseSelector() {
        this.out = new IntegerCoord2d(-1, -1);
    }

    public void dispose() {
        this.unregister();
    }

    public void register(Chart chart) {
        this.chart = chart;
        this.chart.getCanvas().addMouseListener(this);
        this.chart.getCanvas().addMouseMotionListener(this);
        this.chart.getCanvas().addMouseWheelListener(this);
        ICanvas c = chart.getCanvas();
        this.selectionRenderer = this.initRenderer2d(c);
        this.chart.getView().addRenderer2d(this.selectionRenderer);
    }

    public void unregister() {
        if (this.chart != null) {
            this.chart.getCanvas().removeMouseListener(this);
            this.chart.getCanvas().removeMouseMotionListener(this);
            this.chart.getCanvas().removeMouseWheelListener(this);
            this.chart.getView().removeRenderer2d(this.selectionRenderer);
        }
    }

    protected Renderer2d initRenderer2d(final ICanvas c) {
        return new Renderer2d(){

            public void paint(Graphics g) {
                AbstractMouseSelector.this.drawSelection((Graphics2D)g, c.getRendererWidth(), c.getRendererHeight());
                AbstractMouseSelector.this.updateLast();
            }
        };
    }

    protected abstract void processSelection(Scene var1, View var2, int var3, int var4);

    protected abstract void drawSelection(Graphics2D var1, int var2, int var3);

    public abstract void clearLastSelection();

    protected boolean matchRectangleSelection(IntegerCoord2d in, IntegerCoord2d out, Coord3d projection, int width, int height) {
        return this.matchRectangleSelection(in, out, projection.x, projection.y, width, height);
    }

    protected boolean matchRectangleSelection(IntegerCoord2d in, IntegerCoord2d out, float px, float py, int width, int height) {
        float flipYProjection = (float)height - py;
        return in.y < out.y ? (in.x < out.x ? (float)in.x <= px && px <= (float)out.x && (float)in.y <= flipYProjection && flipYProjection <= (float)out.y : (float)out.x <= px && px <= (float)in.x && (float)in.y <= flipYProjection && flipYProjection <= (float)out.y) : (in.x < out.x ? (float)in.x <= px && px <= (float)out.x && (float)out.y <= flipYProjection && flipYProjection <= (float)in.y : (float)out.x <= px && px <= (float)in.x && (float)out.y <= flipYProjection && flipYProjection <= (float)in.y);
    }

    protected void drawRectangle(Graphics2D g2d, IntegerCoord2d in, IntegerCoord2d out) {
        g2d.setColor(Color.RED);
        if (in.y < out.y) {
            if (in.x < out.x) {
                g2d.drawRect(in.x, in.y, out.x - in.x, out.y - in.y);
            } else {
                g2d.drawRect(out.x, in.y, in.x - out.x, out.y - in.y);
            }
        } else if (in.x < out.x) {
            g2d.drawRect(in.x, out.y, out.x - in.x, in.y - out.y);
        } else {
            g2d.drawRect(out.x, out.y, in.x - out.x, in.y - out.y);
        }
    }

    protected void startSelection(MouseEvent e) {
        this.in = new IntegerCoord2d(e.getX(), e.getY());
        this.last = new IntegerCoord2d(e.getX(), e.getY());
        this.out = new IntegerCoord2d(e.getX(), e.getY());
    }

    protected void dragSelection(MouseEvent e) {
        this.out.x = e.getX();
        this.out.y = e.getY();
        this.chart.render();
    }

    protected void releaseSelection(MouseEvent e) {
        this.out.x = e.getX();
        this.out.y = e.getY();
        this.processSelection(this.chart.getScene(), this.chart.getView(), this.chart.getCanvas().getRendererWidth(), this.chart.getCanvas().getRendererHeight());
        this.chart.render();
    }

    protected void rollOver(MouseEvent e) {
    }

    protected void updateLast() {
        this.last.x = this.out.x;
        this.last.y = this.out.y;
    }

    public void mousePressed(MouseEvent e) {
        this.dragging = true;
        this.startSelection(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dragging) {
            this.dragSelection(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.dragging) {
            this.releaseSelection(e);
        }
        this.dragging = false;
    }

    public void mouseMoved(MouseEvent e) {
        this.rollOver(e);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

