/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.mouse.selection;

import algorithms.Point2f;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import org.jzy3d.chart.controllers.mouse.selection.AbstractMouseSelector;
import org.jzy3d.maths.ConvexHull;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.selectable.SelectableSphere;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.View;
import utils.Stack;

public class SphereMouseSelector
extends AbstractMouseSelector {
    protected SelectableSphere sphere;
    protected int width;
    protected int height;
    protected List<Coord3d> projection;
    protected Stack<Point2f> hull;

    public SphereMouseSelector(SelectableSphere scatter) {
        this.sphere = scatter;
    }

    protected void processSelection(Scene scene, View view, int width, int height) {
        view.project();
        this.projection = this.sphere.getProjection();
        this.sphere.setHighlighted(false);
        for (Coord3d p : this.projection) {
            if (!this.matchRectangleSelection(this.in, this.out, p, width, height)) continue;
            this.sphere.setHighlighted(true);
        }
    }

    protected void drawSelection(Graphics2D g2d, int width, int height) {
        this.width = width;
        this.height = height;
        if (this.dragging) {
            this.drawRectangle(g2d, this.in, this.out);
        }
        if (this.projection != null && this.sphere.isHighlighted()) {
            this.hull = ConvexHull.build2d(this.projection);
            Point2f prev = (Point2f)this.hull.pop();
            g2d.setColor(Color.GREEN);
            while (!this.hull.empty()) {
                Point2f next = (Point2f)this.hull.pop();
                g2d.drawOval((int)prev.getX() - 4, (int)prev.getY() - 4, 8, 8);
                g2d.drawLine((int)prev.getX(), (int)prev.getY(), (int)next.getX(), (int)next.getY());
                prev = next;
            }
            g2d.setColor(Color.BLUE);
            for (Coord3d c1 : this.projection) {
                g2d.drawOval((int)c1.x - 2, (int)c1.y - 2, 4, 4);
            }
        }
    }

    public void clearLastSelection() {
        this.sphere.setHighlighted(false);
        this.projection = null;
    }
}

