/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.colors;

import org.jzy3d.colors.Color;
import org.jzy3d.colors.IColorMappable;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Range;
import org.jzy3d.maths.Scale;

public class ColorMapper
implements IColorMappable {
    private float zmin;
    private float zmax;
    private IColorMap colormap;
    private Color factor = null;

    public ColorMapper(IColorMap colormap, float zmin, float zmax) {
        this.colormap = colormap;
        this.zmin = zmin;
        this.zmax = zmax;
    }

    public ColorMapper(IColorMap colormap, float zmin, float zmax, Color factor) {
        this.colormap = colormap;
        this.zmin = zmin;
        this.zmax = zmax;
        this.factor = factor;
    }

    public ColorMapper(ColorMapper colormapper, Color factor) {
        this.colormap = colormapper.colormap;
        this.zmin = colormapper.zmin;
        this.zmax = colormapper.zmax;
        this.factor = factor;
    }

    public Color getColor(Coord3d coord) {
        Color out = this.colormap.getColor(this, coord.x, coord.y, coord.z);
        if (this.factor != null) {
            out.mul(this.factor);
        }
        return out;
    }

    public Color getColor(float v) {
        Color out = this.colormap.getColor(this, v);
        if (this.factor != null) {
            out.mul(this.factor);
        }
        return out;
    }

    public IColorMap getColorMap() {
        return this.colormap;
    }

    public float getZMin() {
        return this.zmin;
    }

    public float getZMax() {
        return this.zmax;
    }

    public void setZMin(float value) {
        this.zmin = value;
    }

    public void setZMax(float value) {
        this.zmax = value;
    }

    public void setRange(Range range) {
        this.zmin = (float)range.getMin();
        this.zmax = (float)range.getMax();
    }

    public Range getRange() {
        return new Range(this.zmin, this.zmax);
    }

    public void setScale(Scale range) {
        this.zmin = (float)range.getMin();
        this.zmax = (float)range.getMax();
    }

    public Scale getScale() {
        return new Scale(this.zmin, this.zmax);
    }

    public String toString() {
        return "(ColorMapper)" + this.colormap + " zmin:" + this.zmin + " zmax:" + this.zmax + " factor:" + this.factor;
    }
}

