/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import java.util.List;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundingBox2d {
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;

    public BoundingBox2d() {
        this.reset();
    }

    public BoundingBox2d(List<Coord2d> list) {
        this.reset();
        for (Coord2d c : list) {
            this.add(c);
        }
    }

    public BoundingBox2d(float xmin, float xmax, float ymin, float ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.xmax = xmax;
    }

    public void reset() {
        this.xmin = Float.MAX_VALUE;
        this.xmax = -3.4028235E38f;
        this.ymin = Float.MAX_VALUE;
        this.ymax = -3.4028235E38f;
    }

    public void add(float x, float y) {
        if (x > this.xmax) {
            this.xmax = x;
        }
        if (x < this.xmin) {
            this.xmin = x;
        }
        if (y > this.ymax) {
            this.ymax = y;
        }
        if (y < this.ymin) {
            this.ymin = y;
        }
    }

    public void add(Coord2d p) {
        this.add(p.x, p.y);
    }

    public void add(BoundingBox2d b) {
        this.add(b.xmin, b.ymin);
        this.add(b.xmax, b.ymax);
    }

    public Coord2d getCenter() {
        return new Coord2d((this.xmin + this.xmax) / 2.0f, (this.ymin + this.ymax) / 2.0f);
    }

    public double getRadius() {
        return this.getCenter().distance(new Coord2d(this.xmin, this.ymin));
    }

    public BoundingBox2d scale(Coord3d scale) {
        BoundingBox2d b = new BoundingBox2d();
        b.xmax = this.xmax * scale.x;
        b.xmin = this.xmin * scale.x;
        b.ymax = this.ymax * scale.y;
        b.ymin = this.ymin * scale.y;
        return b;
    }

    public boolean contains(BoundingBox2d b2) {
        return this.xmin <= b2.xmin && b2.xmax <= this.xmax && this.ymin <= b2.ymin && b2.ymax <= this.ymax;
    }

    public boolean contains(Coord2d c) {
        return this.xmin <= c.x && c.x <= this.xmax && this.ymin <= c.y && c.y <= this.ymax;
    }

    public boolean intersect(BoundingBox2d b2) {
        return this.xmin <= b2.xmin && b2.xmin <= this.xmax || this.xmin <= b2.xmax && b2.xmax <= this.xmax || this.ymin <= b2.ymin && b2.ymin <= this.ymax || this.ymin <= b2.ymax && b2.ymax <= this.ymax;
    }

    public float xmin() {
        return this.xmin;
    }

    public float xmax() {
        return this.xmax;
    }

    public float ymin() {
        return this.ymin;
    }

    public float ymax() {
        return this.ymax;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int depth) {
        return Utils.blanks(depth) + "(BoundingBox2d)" + this.xmin + "<=x<=" + this.xmax + " | " + this.ymin + "<=y<=" + this.ymax;
    }
}

