/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import algorithms.Point2f;
import convexhull.ConvexHullFunction;
import convexhull.GrahamScan;
import java.awt.Polygon;
import java.util.List;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.PolygonArray;
import utils.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvexHull {
    protected static ConvexHullFunction f = new GrahamScan();

    public static Polygon hull(List<Coord3d> cell) {
        Polygon out = new Polygon();
        Stack<Point2f> hull = ConvexHull.build2d(cell);
        while (!hull.empty()) {
            Point2f p = (Point2f)hull.pop();
            out.addPoint((int)p.getX(), (int)p.getY());
        }
        return out;
    }

    public static Stack<Point2f> build2d(List<Coord3d> input2d) {
        int np = input2d.size();
        Point2f[] data = new Point2f[np];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ConvexHull.asPoint2f(input2d.get(i));
        }
        return f.getConvexHull(data);
    }

    public static Stack<Point2f> build2d(PolygonArray input2d) {
        int np = input2d.length();
        Point2f[] data = new Point2f[np];
        for (int i = 0; i < np; ++i) {
            data[i] = new Point2f((double)input2d.x[i], (double)input2d.y[i]);
        }
        return f.getConvexHull(data);
    }

    protected static Point2f asPoint2f(Coord3d c) {
        return new Point2f((double)c.x, (double)c.y);
    }
}

