/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import java.util.Arrays;
import java.util.List;
import org.jzy3d.maths.Coord3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coordinates {
    private float[] x;
    private float[] y;
    private float[] z;

    public Coordinates(float[] x, float[] y, float[] z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coordinates(Coord3d[] coords) {
        this(Arrays.asList(coords));
    }

    public Coordinates(Coord3d coord1, Coord3d ... coords) {
        this.x = new float[coords.length + 1];
        this.y = new float[coords.length + 1];
        this.z = new float[coords.length + 1];
        this.x[0] = coord1.x;
        this.y[0] = coord1.y;
        this.z[0] = coord1.z;
        int k = 1;
        for (Coord3d coord : coords) {
            this.x[k] = coord.x;
            this.y[k] = coord.y;
            this.z[k] = coord.z;
            ++k;
        }
    }

    public Coordinates(List<Coord3d> coords) {
        this.x = new float[coords.size()];
        this.y = new float[coords.size()];
        this.z = new float[coords.size()];
        for (int i = 0; i < coords.size(); ++i) {
            this.x[i] = coords.get((int)i).x;
            this.y[i] = coords.get((int)i).y;
            this.z[i] = coords.get((int)i).z;
        }
    }

    public float[] getX() {
        return this.x;
    }

    public float[] getY() {
        return this.y;
    }

    public float[] getZ() {
        return this.z;
    }

    public Coord3d[] toArray() {
        Coord3d[] array = new Coord3d[this.x.length];
        for (int i = 0; i < this.x.length; ++i) {
            array[i] = new Coord3d(this.x[i], this.y[i], this.z[i]);
        }
        return array;
    }

    public String toString() {
        String txt = "";
        for (int i = 0; i < this.x.length; ++i) {
            if (i > 0) {
                txt = txt + "\n";
            }
            txt = txt + "[" + i + "] " + this.x[i] + " | " + this.y[i] + " | " + this.z[i];
        }
        return txt;
    }
}

