/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.IColorMappable;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.maths.Array;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class GridLoader
implements IColorMappable {
    private float colorZmin = Float.NaN;
    private float colorZmax = Float.NaN;
    public float[] x;
    public float[] y;
    public float[][] z;
    private BoundingBox3d bbox = new BoundingBox3d();
    private int findxi;
    private int findyj;

    public GridLoader(float[] x, float[] y, float[] z) {
        this.setData(x, y, z);
    }

    public BoundingBox3d getBoundingBox() {
        return this.bbox;
    }

    protected void setData(float[] x, float[] y, float[] z) {
        if (x.length != y.length || x.length != z.length) {
            throw new IllegalArgumentException("GridLoader: x, y, and z arrays must agree in length.");
        }
        this.bbox.reset();
        this.x = this.unique(x);
        this.y = this.unique(y);
        this.z = new float[this.x.length][this.y.length];
        for (int i = 0; i < this.x.length; ++i) {
            for (int j = 0; j < this.y.length; ++j) {
                this.z[i][j] = Float.NaN;
            }
        }
        for (int p = 0; p < z.length; ++p) {
            boolean found = this.find(this.x, this.y, x[p], y[p]);
            assert (found) : "GridLoader: it seems (x[p],y[p]) has not been properly stored into (this.x,this.y)";
            this.z[this.findxi][this.findyj] = z[p];
            this.bbox.add(this.x[this.findxi], this.y[this.findyj], this.z[this.findxi][this.findyj]);
        }
        this.colorZmin = this.bbox.getZmin();
        this.colorZmax = this.bbox.getZmax();
    }

    private float[] unique(float[] data) {
        float[] copy = Array.clone(data);
        Arrays.sort(copy);
        int nunique = 0;
        float last = Float.NaN;
        for (int i = 0; i < copy.length; ++i) {
            if (Float.isNaN(copy[i]) || copy[i] == last) continue;
            ++nunique;
            last = copy[i];
        }
        float[] result = new float[nunique];
        last = Float.NaN;
        int r = 0;
        for (int d = 0; d < copy.length; ++d) {
            if (Float.isNaN(copy[d]) || copy[d] == last) continue;
            result[r] = copy[d];
            last = copy[d];
            ++r;
        }
        return result;
    }

    private boolean find(float[] x, float[] y, float vx, float vy) {
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < y.length; ++j) {
                if (x[i] != vx || y[j] != vy) continue;
                this.findxi = i;
                this.findyj = j;
                return true;
            }
        }
        return false;
    }

    public Vector<Polygon> getSquarePolygons(IColorMap cmap, Color colorFactor) {
        Vector<Polygon> polygons = new Vector<Polygon>();
        this.bbox.reset();
        for (int xi = 1; xi < this.x.length - 1; ++xi) {
            for (int yi = 1; yi < this.y.length - 1; ++yi) {
                Point[] p = new Point[]{new Point(new Coord3d((this.x[xi - 1] + this.x[xi]) / 2.0f, (this.y[yi + 1] + this.y[yi]) / 2.0f, (this.z[xi - 1][yi + 1] + this.z[xi - 1][yi] + this.z[xi][yi] + this.z[xi][yi + 1]) / 4.0f)), new Point(new Coord3d((this.x[xi - 1] + this.x[xi]) / 2.0f, (this.y[yi - 1] + this.y[yi]) / 2.0f, (this.z[xi - 1][yi] + this.z[xi - 1][yi - 1] + this.z[xi][yi - 1] + this.z[xi][yi]) / 4.0f)), new Point(new Coord3d((this.x[xi + 1] + this.x[xi]) / 2.0f, (this.y[yi - 1] + this.y[yi]) / 2.0f, (this.z[xi][yi] + this.z[xi][yi - 1] + this.z[xi + 1][yi - 1] + this.z[xi + 1][yi]) / 4.0f)), new Point(new Coord3d((this.x[xi + 1] + this.x[xi]) / 2.0f, (this.y[yi + 1] + this.y[yi]) / 2.0f, (this.z[xi][yi + 1] + this.z[xi][yi] + this.z[xi + 1][yi] + this.z[xi + 1][yi + 1]) / 4.0f))};
                p[0].setColor(cmap.getColor(this, p[0].xyz.x, p[0].xyz.y, p[0].xyz.z));
                p[1].setColor(cmap.getColor(this, p[1].xyz.x, p[1].xyz.y, p[1].xyz.z));
                p[2].setColor(cmap.getColor(this, p[2].xyz.x, p[2].xyz.y, p[2].xyz.z));
                p[3].setColor(cmap.getColor(this, p[3].xyz.x, p[3].xyz.y, p[3].xyz.z));
                p[0].rgb.mul(colorFactor);
                p[1].rgb.mul(colorFactor);
                p[2].rgb.mul(colorFactor);
                p[3].rgb.mul(colorFactor);
                float[] radius = new float[p.length];
                for (int i = 0; i < p.length; ++i) {
                    radius[i] = this.radius2d(p[i]);
                }
                boolean[] isIn = this.isInside(p, radius, 0.0f, Float.MAX_VALUE);
                if (!isIn[0] && !isIn[1] && !isIn[2] && !isIn[3] || !isIn[0] || !isIn[1] || !isIn[2] || !isIn[3]) continue;
                Polygon quad = new Polygon();
                for (int pi = 0; pi < p.length; ++pi) {
                    quad.add(p[pi]);
                }
                polygons.add(quad);
                this.bbox.add(quad);
            }
        }
        return polygons;
    }

    public List<Polygon> getExtrapolatedRingPolygons(float ringMax, IColorMap cmap, Color colorFactor) {
        float[] xbackup = this.x;
        float[] ybackup = this.y;
        float[][] zbackup = this.z;
        float step = this.x[1] - this.x[0];
        int nstep = this.x.length;
        int ENLARGE = 2;
        int required = (int)Math.ceil((ringMax * 2.0f - step * (float)nstep) / step);
        int n = required = required < 0 ? ENLARGE : required + ENLARGE;
        if (required > 0) {
            this.extrapolate(required);
        }
        List<Polygon> polygons = this.getInterpolatedRingPolygons(0.0f, ringMax, cmap, colorFactor);
        this.x = xbackup;
        this.y = ybackup;
        this.z = zbackup;
        return polygons;
    }

    public void extrapolate(int n) {
        float[] xnew = new float[this.x.length + n * 2];
        float[] ynew = new float[this.y.length + n * 2];
        float[][] znew = new float[this.x.length + n * 2][this.y.length + n * 2];
        float xmin = this.x[0];
        float xmax = this.x[this.x.length - 1];
        float xgap = this.x[1] - this.x[0];
        float ymin = this.y[0];
        float ymax = this.y[this.y.length - 1];
        float ygap = this.y[1] - this.y[0];
        for (int i = 0; i < xnew.length; ++i) {
            if (i < n) {
                xnew[i] = xmin - (float)(n - i) * xgap;
            } else if (i >= n && i < this.x.length + n) {
                xnew[i] = this.x[i - n];
            } else if (i >= this.x.length + n) {
                xnew[i] = xmax + (float)(i - (this.x.length + n) + 1) * xgap;
            }
            for (int j = 0; j < ynew.length; ++j) {
                if (j < n) {
                    ynew[j] = ymin - (float)(n - j) * ygap;
                    znew[i][j] = Float.NaN;
                    continue;
                }
                if (j >= n && j < this.y.length + n) {
                    ynew[j] = this.y[j - n];
                    if (i >= n && i < this.x.length + n) {
                        znew[i][j] = this.z[i - n][j - n];
                        continue;
                    }
                    znew[i][j] = Float.NaN;
                    continue;
                }
                if (j < this.y.length + n) continue;
                ynew[j] = ymax + (float)(j - (this.y.length + n) + 1) * ygap;
                znew[i][j] = Float.NaN;
            }
        }
        float olddiameter = xgap * (float)this.x.length / 2.0f;
        float newdiameter = xgap * (float)(this.x.length - 1 + n * 2) / 2.0f;
        olddiameter *= olddiameter;
        newdiameter *= newdiameter;
        int xmiddle = (xnew.length - 1) / 2;
        int ymiddle = (ynew.length - 1) / 2;
        for (int i = xmiddle; i < xnew.length; ++i) {
            for (int j = ymiddle; j < ynew.length; ++j) {
                float sqrad = xnew[i] * xnew[i] + ynew[j] * ynew[j];
                if (sqrad < olddiameter) continue;
                if (sqrad < newdiameter && sqrad >= olddiameter) {
                    int xopp = i - 2 * (i - xmiddle);
                    int yopp = j - 2 * (j - ymiddle);
                    znew[i][j] = this.getExtrapolatedZ(znew, i, j);
                    znew[xopp][j] = this.getExtrapolatedZ(znew, xopp, j);
                    znew[i][yopp] = this.getExtrapolatedZ(znew, i, yopp);
                    znew[xopp][yopp] = this.getExtrapolatedZ(znew, xopp, yopp);
                    continue;
                }
                znew[i][j] = Float.NaN;
            }
        }
        this.x = xnew;
        this.y = ynew;
        this.z = znew;
    }

    private float getExtrapolatedZ(float[][] grid, int currentXi, int currentYi) {
        int left = currentXi - 1 > 0 ? currentXi - 1 : currentXi;
        int right = currentXi + 1 < grid.length ? currentXi + 1 : currentXi;
        int bottom = currentYi - 1 > 0 ? currentYi - 1 : currentYi;
        int up = currentYi + 1 < grid[0].length ? currentYi + 1 : currentYi;
        float cumval = 0.0f;
        int nval = 0;
        for (int u = left; u <= right; ++u) {
            for (int v = bottom; v <= up; ++v) {
                if (Float.isNaN(grid[u][v])) continue;
                cumval += grid[u][v];
                ++nval;
            }
        }
        if (nval > 0) {
            return cumval / (float)nval;
        }
        return Float.NaN;
    }

    public List<Polygon> getInterpolatedRingPolygons(float ringMin, float ringMax, IColorMap cmap, Color colorFactor) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        this.bbox.reset();
        for (int xi = 1; xi < this.x.length - 1; ++xi) {
            for (int yi = 1; yi < this.y.length - 1; ++yi) {
                Point[] p = new Point[]{new Point(new Coord3d((this.x[xi - 1] + this.x[xi]) / 2.0f, (this.y[yi + 1] + this.y[yi]) / 2.0f, (this.z[xi - 1][yi + 1] + this.z[xi - 1][yi] + this.z[xi][yi] + this.z[xi][yi + 1]) / 4.0f)), new Point(new Coord3d((this.x[xi - 1] + this.x[xi]) / 2.0f, (this.y[yi - 1] + this.y[yi]) / 2.0f, (this.z[xi - 1][yi] + this.z[xi - 1][yi - 1] + this.z[xi][yi - 1] + this.z[xi][yi]) / 4.0f)), new Point(new Coord3d((this.x[xi + 1] + this.x[xi]) / 2.0f, (this.y[yi - 1] + this.y[yi]) / 2.0f, (this.z[xi][yi] + this.z[xi][yi - 1] + this.z[xi + 1][yi - 1] + this.z[xi + 1][yi]) / 4.0f)), new Point(new Coord3d((this.x[xi + 1] + this.x[xi]) / 2.0f, (this.y[yi + 1] + this.y[yi]) / 2.0f, (this.z[xi][yi + 1] + this.z[xi][yi] + this.z[xi + 1][yi] + this.z[xi + 1][yi + 1]) / 4.0f))};
                p[0].setColor(cmap.getColor(this, p[0].xyz.x, p[0].xyz.y, p[0].xyz.z));
                p[1].setColor(cmap.getColor(this, p[1].xyz.x, p[1].xyz.y, p[1].xyz.z));
                p[2].setColor(cmap.getColor(this, p[2].xyz.x, p[2].xyz.y, p[2].xyz.z));
                p[3].setColor(cmap.getColor(this, p[3].xyz.x, p[3].xyz.y, p[3].xyz.z));
                p[0].rgb.r *= colorFactor.r;
                p[0].rgb.g *= colorFactor.g;
                p[0].rgb.b *= colorFactor.b;
                p[0].rgb.a *= colorFactor.a;
                p[1].rgb.r *= colorFactor.r;
                p[1].rgb.g *= colorFactor.g;
                p[1].rgb.b *= colorFactor.b;
                p[1].rgb.a *= colorFactor.a;
                p[2].rgb.r *= colorFactor.r;
                p[2].rgb.g *= colorFactor.g;
                p[2].rgb.b *= colorFactor.b;
                p[2].rgb.a *= colorFactor.a;
                p[3].rgb.r *= colorFactor.r;
                p[3].rgb.g *= colorFactor.g;
                p[3].rgb.b *= colorFactor.b;
                p[3].rgb.a *= colorFactor.a;
                float[] radius = new float[p.length];
                for (int i = 0; i < p.length; ++i) {
                    radius[i] = this.radius2d(p[i]);
                }
                boolean[] isIn = this.isInside(p, radius, ringMin, ringMax);
                if (!isIn[0] && !isIn[1] && !isIn[2] && !isIn[3]) continue;
                if (isIn[0] && isIn[1] && isIn[2] && isIn[3]) {
                    Polygon quad = new Polygon();
                    for (int pi = 0; pi < p.length; ++pi) {
                        quad.add(p[pi]);
                    }
                    polygons.add(quad);
                    this.bbox.add(quad);
                    continue;
                }
                Polygon polygon = new Polygon();
                int[] seq = new int[]{0, 1, 2, 3, 0};
                boolean[] done = new boolean[4];
                for (int pi = 0; pi < done.length; ++pi) {
                    done[pi] = false;
                }
                for (int s = 0; s < seq.length - 1; ++s) {
                    Point intersection;
                    float ringRadius;
                    if (isIn[seq[s]] && isIn[seq[s + 1]]) {
                        if (!done[seq[s]]) {
                            polygon.add(p[seq[s]]);
                            done[seq[s]] = true;
                        }
                        if (done[seq[s + 1]]) continue;
                        polygon.add(p[seq[s + 1]]);
                        done[seq[s + 1]] = true;
                        continue;
                    }
                    if (isIn[seq[s]] && !isIn[seq[s + 1]]) {
                        if (!done[seq[s]]) {
                            polygon.add(p[seq[s]]);
                            done[seq[s]] = true;
                        }
                        ringRadius = Math.abs(radius[seq[s + 1]] - ringMin) < Math.abs(radius[seq[s + 1]] - ringMax) ? ringMin : ringMax;
                        intersection = this.findPoint(p[seq[s]], p[seq[s + 1]], ringRadius);
                        intersection.setColor(cmap.getColor(this, intersection.xyz.x, intersection.xyz.y, intersection.xyz.z));
                        intersection.rgb.r *= colorFactor.r;
                        intersection.rgb.g *= colorFactor.g;
                        intersection.rgb.b *= colorFactor.b;
                        intersection.rgb.a *= colorFactor.a;
                        polygon.add(intersection);
                        continue;
                    }
                    if (isIn[seq[s]] || !isIn[seq[s + 1]]) continue;
                    ringRadius = Math.abs(radius[seq[s + 1]] - ringMin) < Math.abs(radius[seq[s + 1]] - ringMax) ? ringMin : ringMax;
                    intersection = this.findPoint(p[seq[s]], p[seq[s + 1]], ringRadius);
                    intersection.setColor(cmap.getColor(this, intersection.xyz.x, intersection.xyz.y, intersection.xyz.z));
                    intersection.rgb.r *= colorFactor.r;
                    intersection.rgb.g *= colorFactor.g;
                    intersection.rgb.b *= colorFactor.b;
                    intersection.rgb.a *= colorFactor.a;
                    polygon.add(intersection);
                    if (done[seq[s + 1]]) continue;
                    polygon.add(p[seq[s + 1]]);
                    done[seq[s + 1]] = true;
                }
                polygons.add(polygon);
                this.bbox.add(polygon);
            }
        }
        return polygons;
    }

    private boolean[] isInside(Point[] p, float[] radius, float minRadius, float maxRadius) {
        boolean[] isIn = new boolean[]{!Float.isNaN(p[0].xyz.z) && radius[0] < maxRadius && radius[0] >= minRadius, !Float.isNaN(p[1].xyz.z) && radius[1] < maxRadius && radius[1] >= minRadius, !Float.isNaN(p[2].xyz.z) && radius[2] < maxRadius && radius[2] >= minRadius, !Float.isNaN(p[3].xyz.z) && radius[3] < maxRadius && radius[3] >= minRadius};
        return isIn;
    }

    private float radius2d(Point p) {
        return (float)Math.sqrt(p.xyz.x * p.xyz.x + p.xyz.y * p.xyz.y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Point findPoint(Point p1, Point p2, float ringRadius) {
        float z3;
        float y3;
        float x3;
        if (p1.xyz.x == p2.xyz.x) {
            x3 = p1.xyz.x;
            double alpha = Math.acos(x3 / ringRadius);
            if (p1.xyz.y < 0.0f && p2.xyz.y < 0.0f) {
                y3 = -((float)Math.sin(alpha)) * ringRadius;
            } else if (p1.xyz.y > 0.0f && p2.xyz.y > 0.0f) {
                y3 = (float)Math.sin(alpha) * ringRadius;
            } else {
                if (p1.xyz.y != -p2.xyz.y) throw new ArithmeticException("no alignement between p1(" + p1.xyz.x + "," + p1.xyz.y + "," + p1.xyz.z + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + "," + p2.xyz.z + ")");
                y3 = 0.0f;
            }
            if (!Float.isNaN(p1.xyz.z) && Float.isNaN(p2.xyz.z)) {
                z3 = p1.xyz.z;
                return new Point(new Coord3d(x3, y3, z3));
            } else if (Float.isNaN(p1.xyz.z) && !Float.isNaN(p2.xyz.z)) {
                z3 = p2.xyz.z;
                return new Point(new Coord3d(x3, y3, z3));
            } else {
                if (Float.isNaN(p1.xyz.z) || Float.isNaN(p2.xyz.z)) throw new ArithmeticException("can't compute z3 with p1(" + p1.xyz.x + "," + p1.xyz.y + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + ")");
                float w2 = (float)(Math.sqrt((x3 - p1.xyz.x) * (x3 - p1.xyz.x) + (y3 - p1.xyz.y) * (y3 - p1.xyz.y)) / Math.sqrt((p2.xyz.x - p1.xyz.x) * (p2.xyz.x - p1.xyz.x) + (p2.xyz.y - p1.xyz.y) * (p2.xyz.y - p1.xyz.y)));
                float w1 = 1.0f - w2;
                z3 = w1 * p1.xyz.z + w2 * p2.xyz.z;
            }
            return new Point(new Coord3d(x3, y3, z3));
        } else {
            if (p1.xyz.y != p2.xyz.y) throw new ArithmeticException("no alignement between p1(" + p1.xyz.x + "," + p1.xyz.y + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + ")");
            y3 = p1.xyz.y;
            double alpha = Math.asin(y3 / ringRadius);
            if (p1.xyz.x < 0.0f && p2.xyz.x < 0.0f) {
                x3 = -((float)Math.cos(alpha)) * ringRadius;
            } else if (p1.xyz.x > 0.0f && p2.xyz.x > 0.0f) {
                x3 = (float)Math.cos(alpha) * ringRadius;
            } else {
                if (p1.xyz.x != -p2.xyz.x) throw new ArithmeticException("no alignement between p1(" + p1.xyz.x + "," + p1.xyz.y + "," + p1.xyz.z + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + "," + p2.xyz.z + ")");
                x3 = 0.0f;
            }
            if (!Float.isNaN(p1.xyz.z) && Float.isNaN(p2.xyz.z)) {
                z3 = p1.xyz.z;
                return new Point(new Coord3d(x3, y3, z3));
            } else if (Float.isNaN(p1.xyz.z) && !Float.isNaN(p2.xyz.z)) {
                z3 = p2.xyz.z;
                return new Point(new Coord3d(x3, y3, z3));
            } else {
                if (Float.isNaN(p1.xyz.z) || Float.isNaN(p2.xyz.z)) throw new ArithmeticException("can't compute z3 with p1(" + p1.xyz.x + "," + p1.xyz.y + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + ")");
                float w2 = (float)(Math.sqrt((x3 - p1.xyz.x) * (x3 - p1.xyz.x) + (y3 - p1.xyz.y) * (y3 - p1.xyz.y)) / Math.sqrt((p2.xyz.x - p1.xyz.x) * (p2.xyz.x - p1.xyz.x) + (p2.xyz.y - p1.xyz.y) * (p2.xyz.y - p1.xyz.y)));
                float w1 = 1.0f - w2;
                z3 = w1 * p1.xyz.z + w2 * p2.xyz.z;
            }
        }
        return new Point(new Coord3d(x3, y3, z3));
    }

    @Override
    public float getZMin() {
        return this.colorZmin;
    }

    @Override
    public float getZMax() {
        return this.colorZmax;
    }

    @Override
    public void setZMin(float zmin) {
        this.colorZmin = zmin;
    }

    @Override
    public void setZMax(float zmax) {
        this.colorZmax = zmax;
    }
}

