/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

public class Scale {
    protected double min;
    protected double max;

    public Scale(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public Scale clone() {
        return new Scale(this.min, this.max);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getRange() {
        return this.max - this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public Scale add(double value) {
        return new Scale(this.min + value, this.max + value);
    }

    public boolean contains(double value) {
        return this.min <= value && value <= this.max;
    }

    public boolean isMaxNan() {
        return Double.isNaN(this.max);
    }

    public boolean isMinNan() {
        return Double.isNaN(this.min);
    }

    public boolean valid() {
        return this.min <= this.max;
    }

    public static Scale widest(Scale scale1, Scale scale2) {
        double min = Math.min(scale1.min, scale2.min);
        double max = Math.max(scale1.max, scale2.max);
        return new Scale(min, max);
    }

    public static Scale thinest(Scale scale1, Scale scale2) {
        double min = Math.max(scale1.min, scale2.min);
        double max = Math.min(scale1.max, scale2.max);
        return new Scale(min, max);
    }

    public static Scale enlarge(Scale input, double ratio) {
        double offset = (input.getMax() - input.getMin()) * ratio;
        if (offset == 0.0) {
            offset = 1.0;
        }
        return new Scale(input.getMin() - offset, input.getMax() + offset);
    }

    public String toString() {
        return new String("min=" + this.min + " max=" + this.max);
    }
}

