/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot2d.primitive;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.plot3d.primitives.axes.layout.providers.ITickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.ITickRenderer;

public class ColorbarImageGenerator {
    protected ColorMapper mapper;
    protected ITickProvider provider;
    protected ITickRenderer renderer;
    protected float min;
    protected float max;
    protected boolean hasBackground = false;
    protected Color backgroundColor;
    protected Color foregroundColor = Color.BLACK;
    public static final int MIN_BAR_WIDTH = 100;
    public static final int MIN_BAR_HEIGHT = 100;

    public ColorbarImageGenerator(IColorMap map, float min, float max, ITickProvider provider, ITickRenderer renderer) {
        this.mapper = new ColorMapper(map, min, max);
        this.min = min;
        this.max = max;
        this.provider = provider;
        this.renderer = renderer;
    }

    public ColorbarImageGenerator(ColorMapper mapper, ITickProvider provider, ITickRenderer renderer) {
        this(mapper.getColorMap(), mapper.getZMin(), mapper.getZMax(), provider, renderer);
    }

    public BufferedImage toImage(int width, int height) {
        return this.toImage(width, height, 20);
    }

    public BufferedImage toImage(int width, int height, int barWidth) {
        if (barWidth > width) {
            return null;
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphic = image.createGraphics();
        int txtSize = 12;
        graphic.setFont(new Font("Arial", 0, txtSize));
        if (this.hasBackground) {
            graphic.setColor(this.backgroundColor);
            graphic.fillRect(0, 0, width, height);
        }
        for (int h = txtSize / 2; h <= height - txtSize / 2; ++h) {
            float v = this.min + (this.max - this.min) * (float)h / (float)(height - txtSize);
            org.jzy3d.colors.Color c = this.mapper.getColor(v);
            graphic.setColor(c.awt());
            graphic.drawLine(0, height - h, barWidth, height - h);
        }
        graphic.setColor(this.foregroundColor);
        graphic.drawRect(0, txtSize / 2, barWidth, height - txtSize);
        if (this.provider != null) {
            float[] ticks = this.provider.generateTicks(this.min, this.max);
            for (int t = 0; t < ticks.length; ++t) {
                float ypos = (float)txtSize + ((float)(height - txtSize) - (float)(height - txtSize) * ((ticks[t] - this.min) / (this.max - this.min)));
                String txt = this.renderer.format(ticks[t]);
                graphic.drawString(txt, (float)(barWidth + 1), ypos);
            }
        }
        return image;
    }

    public boolean hasBackground() {
        return this.hasBackground;
    }

    public void setHasBackground(boolean hasBackground) {
        this.hasBackground = hasBackground;
    }

    public org.jzy3d.colors.Color getBackgroundColor() {
        return new org.jzy3d.colors.Color(this.backgroundColor);
    }

    public void setBackgroundColor(org.jzy3d.colors.Color backgroundColor) {
        this.backgroundColor = backgroundColor.awt();
    }

    public org.jzy3d.colors.Color getForegroundColor() {
        return new org.jzy3d.colors.Color(this.foregroundColor);
    }

    public void setForegroundColor(org.jzy3d.colors.Color foregroundColor) {
        this.foregroundColor = foregroundColor.awt();
    }
}

