/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.concrete;

import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.builder.concrete.OrthonormalTessellator;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.primitives.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingTessellator
extends OrthonormalTessellator {
    protected float ringMin;
    protected float ringMax;
    protected ColorMapper cmap;
    protected Color factor;

    public RingTessellator(float ringMin, float ringMax, ColorMapper cmap, Color factor) {
        this.ringMin = ringMin;
        this.ringMax = ringMax;
        this.cmap = cmap;
        this.factor = factor;
    }

    private RingTessellator() {
        throw new RuntimeException("Forbidden constructor!");
    }

    @Override
    public AbstractComposite build(float[] x, float[] y, float[] z) {
        this.setData(x, y, z);
        Shape s = new Shape();
        s.add(this.getInterpolatedRingPolygons());
        return s;
    }

    public List<Polygon> getInterpolatedRingPolygons() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int xi = 0; xi < this.x.length - 1; ++xi) {
            for (int yi = 0; yi < this.y.length - 1; ++yi) {
                Point[] p = this.getRealQuadStandingOnPoint(xi, yi);
                p[0].setColor(this.cmap.getColor(p[0].xyz));
                p[1].setColor(this.cmap.getColor(p[1].xyz));
                p[2].setColor(this.cmap.getColor(p[2].xyz));
                p[3].setColor(this.cmap.getColor(p[3].xyz));
                p[0].rgb.mul(this.factor);
                p[1].rgb.mul(this.factor);
                p[2].rgb.mul(this.factor);
                p[3].rgb.mul(this.factor);
                float[] radius = new float[p.length];
                for (int i = 0; i < p.length; ++i) {
                    radius[i] = this.radius2d(p[i]);
                }
                boolean[] isIn = this.isInside(p, radius, this.ringMin, this.ringMax);
                if (!isIn[0] && !isIn[1] && !isIn[2] && !isIn[3]) continue;
                if (isIn[0] && isIn[1] && isIn[2] && isIn[3]) {
                    Polygon quad = new Polygon();
                    for (int pi = 0; pi < p.length; ++pi) {
                        quad.add(p[pi]);
                    }
                    polygons.add(quad);
                    continue;
                }
                Polygon polygon = new Polygon();
                int[] seq = new int[]{0, 1, 2, 3, 0};
                boolean[] done = new boolean[4];
                for (int pi = 0; pi < done.length; ++pi) {
                    done[pi] = false;
                }
                for (int s = 0; s < seq.length - 1; ++s) {
                    Point intersection;
                    float ringRadius;
                    if (isIn[seq[s]] && isIn[seq[s + 1]]) {
                        if (!done[seq[s]]) {
                            polygon.add(p[seq[s]]);
                            done[seq[s]] = true;
                        }
                        if (done[seq[s + 1]]) continue;
                        polygon.add(p[seq[s + 1]]);
                        done[seq[s + 1]] = true;
                        continue;
                    }
                    if (isIn[seq[s]] && !isIn[seq[s + 1]]) {
                        if (!done[seq[s]]) {
                            polygon.add(p[seq[s]]);
                            done[seq[s]] = true;
                        }
                        ringRadius = Math.abs(radius[seq[s + 1]] - this.ringMin) < Math.abs(radius[seq[s + 1]] - this.ringMax) ? this.ringMin : this.ringMax;
                        intersection = this.findPoint(p[seq[s]], p[seq[s + 1]], ringRadius);
                        intersection.setColor(this.cmap.getColor(intersection.xyz));
                        intersection.rgb.mul(this.factor);
                        polygon.add(intersection);
                        continue;
                    }
                    if (isIn[seq[s]] || !isIn[seq[s + 1]]) continue;
                    ringRadius = Math.abs(radius[seq[s + 1]] - this.ringMin) < Math.abs(radius[seq[s + 1]] - this.ringMax) ? this.ringMin : this.ringMax;
                    intersection = this.findPoint(p[seq[s]], p[seq[s + 1]], ringRadius);
                    intersection.setColor(this.cmap.getColor(intersection.xyz));
                    intersection.rgb.mul(this.factor);
                    polygon.add(intersection);
                    if (done[seq[s + 1]]) continue;
                    polygon.add(p[seq[s + 1]]);
                    done[seq[s + 1]] = true;
                }
                polygons.add(polygon);
            }
        }
        return polygons;
    }

    protected boolean[] isInside(Point[] p, float[] radius, float minRadius, float maxRadius) {
        boolean[] isIn = new boolean[]{!Float.isNaN(p[0].xyz.z) && radius[0] < maxRadius && radius[0] >= minRadius, !Float.isNaN(p[1].xyz.z) && radius[1] < maxRadius && radius[1] >= minRadius, !Float.isNaN(p[2].xyz.z) && radius[2] < maxRadius && radius[2] >= minRadius, !Float.isNaN(p[3].xyz.z) && radius[3] < maxRadius && radius[3] >= minRadius};
        return isIn;
    }

    protected float radius2d(Point p) {
        return (float)Math.sqrt(p.xyz.x * p.xyz.x + p.xyz.y * p.xyz.y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Point findPoint(Point p1, Point p2, float ringRadius) {
        float z3;
        float y3;
        float x3;
        if (p1.xyz.x == p2.xyz.x) {
            x3 = p1.xyz.x;
            double alpha = Math.acos(x3 / ringRadius);
            if (p1.xyz.y < 0.0f && p2.xyz.y < 0.0f) {
                y3 = -((float)Math.sin(alpha)) * ringRadius;
            } else if (p1.xyz.y > 0.0f && p2.xyz.y > 0.0f) {
                y3 = (float)Math.sin(alpha) * ringRadius;
            } else {
                if (p1.xyz.y != -p2.xyz.y) throw new ArithmeticException("no alignement between p1(" + p1.xyz.x + "," + p1.xyz.y + "," + p1.xyz.z + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + "," + p2.xyz.z + ")");
                y3 = 0.0f;
            }
            if (!Float.isNaN(p1.xyz.z) && Float.isNaN(p2.xyz.z)) {
                z3 = p1.xyz.z;
                return new Point(new Coord3d(x3, y3, z3));
            } else if (Float.isNaN(p1.xyz.z) && !Float.isNaN(p2.xyz.z)) {
                z3 = p2.xyz.z;
                return new Point(new Coord3d(x3, y3, z3));
            } else {
                if (Float.isNaN(p1.xyz.z) || Float.isNaN(p2.xyz.z)) throw new ArithmeticException("can't compute z3 with p1(" + p1.xyz.x + "," + p1.xyz.y + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + ")");
                float w2 = (float)(Math.sqrt((x3 - p1.xyz.x) * (x3 - p1.xyz.x) + (y3 - p1.xyz.y) * (y3 - p1.xyz.y)) / Math.sqrt((p2.xyz.x - p1.xyz.x) * (p2.xyz.x - p1.xyz.x) + (p2.xyz.y - p1.xyz.y) * (p2.xyz.y - p1.xyz.y)));
                float w1 = 1.0f - w2;
                z3 = w1 * p1.xyz.z + w2 * p2.xyz.z;
            }
            return new Point(new Coord3d(x3, y3, z3));
        } else {
            if (p1.xyz.y != p2.xyz.y) throw new ArithmeticException("no alignement between p1(" + p1.xyz.x + "," + p1.xyz.y + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + ")");
            y3 = p1.xyz.y;
            double alpha = Math.asin(y3 / ringRadius);
            if (p1.xyz.x < 0.0f && p2.xyz.x < 0.0f) {
                x3 = -((float)Math.cos(alpha)) * ringRadius;
            } else if (p1.xyz.x > 0.0f && p2.xyz.x > 0.0f) {
                x3 = (float)Math.cos(alpha) * ringRadius;
            } else {
                if (p1.xyz.x != -p2.xyz.x) throw new ArithmeticException("no alignement between p1(" + p1.xyz.x + "," + p1.xyz.y + "," + p1.xyz.z + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + "," + p2.xyz.z + ")");
                x3 = 0.0f;
            }
            if (!Float.isNaN(p1.xyz.z) && Float.isNaN(p2.xyz.z)) {
                z3 = p1.xyz.z;
                return new Point(new Coord3d(x3, y3, z3));
            } else if (Float.isNaN(p1.xyz.z) && !Float.isNaN(p2.xyz.z)) {
                z3 = p2.xyz.z;
                return new Point(new Coord3d(x3, y3, z3));
            } else {
                if (Float.isNaN(p1.xyz.z) || Float.isNaN(p2.xyz.z)) throw new ArithmeticException("can't compute z3 with p1(" + p1.xyz.x + "," + p1.xyz.y + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + ")");
                float w2 = (float)(Math.sqrt((x3 - p1.xyz.x) * (x3 - p1.xyz.x) + (y3 - p1.xyz.y) * (y3 - p1.xyz.y)) / Math.sqrt((p2.xyz.x - p1.xyz.x) * (p2.xyz.x - p1.xyz.x) + (p2.xyz.y - p1.xyz.y) * (p2.xyz.y - p1.xyz.y)));
                float w1 = 1.0f - w2;
                z3 = w1 * p1.xyz.z + w2 * p2.xyz.z;
            }
        }
        return new Point(new Coord3d(x3, y3, z3));
    }
}

