/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.delaunay;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.builder.delaunay.CoordinateValidator;
import org.jzy3d.plot3d.builder.delaunay.Triangulation;
import org.jzy3d.plot3d.builder.delaunay.jdt.Point_dt;
import org.jzy3d.plot3d.builder.delaunay.jdt.Triangle_dt;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.primitives.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelaunayTriangulationManager {
    protected float[] x;
    protected float[] y;
    protected float[][] z_as_fxy;
    protected final Triangulation triangulator;

    public DelaunayTriangulationManager(CoordinateValidator cv, Triangulation triangulator) {
        this.triangulator = triangulator;
        this.setX(cv.getX());
        this.setY(cv.getY());
        this.set_Z_as_fxy(cv.get_Z_as_fxy());
    }

    public AbstractDrawable buildDrawable() {
        Shape s = new Shape();
        s.add(this.getFacets());
        return s;
    }

    List<Polygon> getFacets() {
        int xlen = this.x.length;
        for (int i = 0; i < xlen; ++i) {
            Point_dt point_dt = new Point_dt(this.x[i], this.y[i], this.z_as_fxy[i][i]);
            this.triangulator.insertPoint(point_dt);
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(this.triangulator.trianglesSize());
        Iterator<Triangle_dt> trianglesIter = this.triangulator.trianglesIterator();
        while (trianglesIter.hasNext()) {
            Triangle_dt triangle = trianglesIter.next();
            if (triangle.isHalfplane()) continue;
            Polygon newPolygon = this.buildPolygonFrom(triangle);
            polygons.add(newPolygon);
        }
        return polygons;
    }

    private Polygon buildPolygonFrom(Triangle_dt triangle) {
        Coord3d c1 = triangle.p1().getAsCoord3d();
        Coord3d c2 = triangle.p2().getAsCoord3d();
        Coord3d c3 = triangle.p3().getAsCoord3d();
        Polygon polygon = new Polygon();
        polygon.add(new Point(c1));
        polygon.add(new Point(c2));
        polygon.add(new Point(c3));
        return polygon;
    }

    public void setX(float[] x) {
        this.x = x;
    }

    public void setY(float[] y) {
        this.y = y;
    }

    public void set_Z_as_fxy(float[][] z_as_fxy) {
        this.z_as_fxy = z_as_fxy;
    }
}

