/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.delaunay;

import java.util.Arrays;
import org.jzy3d.maths.Array;
import org.jzy3d.maths.Coordinates;
import org.jzy3d.plot3d.builder.delaunay.CoordinateValidator;

public class OrthonormalCoordinateValidator
implements CoordinateValidator {
    protected float[] x;
    protected float[] y;
    protected float[] z;
    protected float[][] z_as_fxy;
    protected int findxi;
    protected int findyj;

    public OrthonormalCoordinateValidator(Coordinates coords) {
        if (coords == null) {
            throw new IllegalArgumentException("got NULL value for parameter coords.");
        }
        if (coords.getX() == null || coords.getY() == null || coords.getZ() == null) {
            throw new IllegalArgumentException("got NULL value after calling: coords.getX()" + coords.getX() + ", coords.getY()" + coords.getY() + ", coord.getZ()" + coords.getZ());
        }
        if (coords.getX().length != coords.getY().length || coords.getX().length != coords.getZ().length) {
            throw new IllegalArgumentException("x, y, and z arrays must agree in length.x.length=" + coords.getX().length + ", y.length=" + coords.getY().length + ", z.length=" + coords.getZ().length);
        }
        this.setData(coords);
    }

    protected void setData(Coordinates coords) {
        this.x = this.makeCoordinatesUnique(coords.getX());
        this.y = this.makeCoordinatesUnique(coords.getY());
        this.z_as_fxy = new float[this.x.length][this.y.length];
        for (int i = 0; i < this.x.length; ++i) {
            for (int j = 0; j < this.y.length; ++j) {
                this.z_as_fxy[i][j] = Float.NaN;
            }
        }
        for (int p = 0; p < coords.getZ().length; ++p) {
            boolean found = this.find(this.x, this.y, coords.getX()[p], coords.getY()[p]);
            if (!found) {
                throw new RuntimeException("it seems (x[p],y[p]) has not been properly stored into (this.x,this.y)");
            }
            this.z_as_fxy[this.findxi][this.findyj] = coords.getZ()[p];
        }
    }

    protected boolean find(float[] x, float[] y, float vx, float vy) {
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < y.length; ++j) {
                if (x[i] != vx || y[j] != vy) continue;
                this.findxi = i;
                this.findyj = j;
                return true;
            }
        }
        return false;
    }

    protected float[] makeCoordinatesUnique(float[] data) {
        float[] copy = Array.clone(data);
        Arrays.sort(copy);
        int nunique = 0;
        float last = Float.NaN;
        for (int i = 0; i < copy.length; ++i) {
            if (Float.isNaN(copy[i]) || copy[i] == last) continue;
            ++nunique;
            last = copy[i];
        }
        float[] result = new float[nunique];
        last = Float.NaN;
        int r = 0;
        for (int d = 0; d < copy.length; ++d) {
            if (Float.isNaN(copy[d]) || copy[d] == last) continue;
            result[r] = copy[d];
            last = copy[d];
            ++r;
        }
        return result;
    }

    public float[][] get_Z_as_fxy() {
        return this.z_as_fxy;
    }

    public float[] getX() {
        return this.x;
    }

    public float[] getY() {
        return this.y;
    }

    public float[] getZ() {
        return this.z;
    }
}

